/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.client.impl;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.document.dto.requestdto.DocSignListReqDTO;
import com.beiming.odr.document.dto.responsedto.SignatureConfirmInfoResDTO;
import com.beiming.odr.document.enums.CaseUserTypeEnum;
import com.beiming.odr.peace.common.enums.ColumnEnums;
import com.beiming.odr.peace.common.utils.WeitingshenUtil;
import com.beiming.odr.peace.domain.dto.requestdto.ClerkConfirmInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DocSignListRequsetDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SignatureConfirmInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ClerkConfirmInfoResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.DocSignListResponseDTO;
import com.beiming.odr.peace.service.MediationMeetingService;
import com.beiming.odr.peace.service.backend.document.ClerkConfirmDubboService;
import com.beiming.odr.peace.service.backend.referee.MediationRoomDubboService;
import com.beiming.odr.peace.service.client.ClerkConfirmService;
import com.beiming.odr.peace.service.convert.ClerkConfirmConvert;
import com.beiming.odr.referee.api.CaseRoomMicroApi;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomUserInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ClerkConfirmServiceImpl
implements ClerkConfirmService {
    @Resource
    private ClerkConfirmDubboService clerkConfirmDubboService;
    @Resource
    private MediationRoomDubboService mediationRoomDubboService;
    @Resource
    private MediationMeetingService mediationMeetingService;
    @Resource
    private CaseRoomMicroApi caseRoomMicroApi;

    @Override
    public List<ClerkConfirmInfoResponseDTO> getAllMediationClerkConfirm(ClerkConfirmInfoRequestDTO requestDTO) {
        List<ClerkConfirmInfoResponseDTO> result = this.clerkConfirmDubboService.getAllMediationClerkConfirm(requestDTO.getDocId());
        if (CollectionUtils.isEmpty(result)) {
            return result;
        }
        for (ClerkConfirmInfoResponseDTO one : result) {
            DubboResult userInfoResult = this.caseRoomMicroApi.selectUserInfo(one.getUserId(), requestDTO.getBizId());
            if (userInfoResult == null || userInfoResult.getData() == null || ((MediationRoomUserInfoResDTO)userInfoResult.getData()).getExpandAttribute() == null) continue;
            String expandAttribute = ((MediationRoomUserInfoResDTO)userInfoResult.getData()).getExpandAttribute();
            JSONObject json = JSONObject.parseObject((String)expandAttribute);
            CaseUserTypeEnum userTypeEnum = CaseUserTypeEnum.valueOf((String)one.getCaseUserType());
            if (CaseUserTypeEnum.APPLICANT.equals((Object)userTypeEnum) || CaseUserTypeEnum.RESPONDENT.equals((Object)userTypeEnum)) {
                Integer litigantType = (Integer)json.get((Object)ColumnEnums.LITIGANT_TYPE.desc());
                String unitName = (String)json.get((Object)ColumnEnums.UNIT_NAME.desc());
                one.setLitigantType(litigantType);
                one.setUnitName(unitName);
                continue;
            }
            Integer isUndertaker = (Integer)json.get((Object)ColumnEnums.IS_UNDERTAKER.desc());
            one.setIsUndertaker(isUndertaker);
        }
        return result;
    }

    @Override
    public String signatureConfirmInfo(SignatureConfirmInfoRequestDTO requestDTO) {
        ArrayList<SignatureConfirmInfoResDTO> list = this.clerkConfirmDubboService.signatureConfirmInfo(requestDTO.getDocumentIds());
        if (CollectionUtils.isEmpty(list) || list.stream().anyMatch(info -> StringUtils.isBlank((String)info.getConfirm()))) {
            return "";
        }
        String agentConfirmPrefix = "_AGENT";
        if (list.stream().noneMatch(info -> info.getConfirm().endsWith(agentConfirmPrefix))) {
            return "\u7b7e\u540d\u6210\u529f";
        }
        StringBuffer sb = new StringBuffer("\u7b7e\u540d\u6210\u529f, \u5176\u4e2d");
        list.forEach(info -> {
            if (info.getConfirm().endsWith(agentConfirmPrefix)) {
                sb.append(info.getDocName());
            }
        });
        sb.append("\u5df2\u88ab\u786e\u8ba4");
        return sb.toString();
    }

    @Override
    public List<DocSignListResponseDTO> signedDocList(@Valid DocSignListRequsetDTO requsetDTO) {
        Long bizId = requsetDTO.getBizId();
        MediationMeetingRoomUserInfoResDTO res = this.mediationMeetingService.getMediationRoomUserInfoList(new CommonIdRequestDTO(bizId));
        DocSignListReqDTO reqDTO = new DocSignListReqDTO();
        reqDTO.setBizId(bizId);
        reqDTO.setBizType(res.getMediationMeetingType());
        reqDTO.setParentId(res.getParentId());
        reqDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        reqDTO.setMeetId(requsetDTO.getMeetId());
        List<Object> resDTO = this.clerkConfirmDubboService.getSignDocList(reqDTO);
        if (!this.mediationRoomDubboService.checkIsWorker(bizId).booleanValue() || WeitingshenUtil.isWeitingshenSeriesAppName().booleanValue()) {
            resDTO = resDTO.stream().filter(o -> o.getStatus() != null && o.getStatus() == false).collect(Collectors.toList());
        }
        return resDTO.stream().map(ClerkConfirmConvert::convertDocSignListResDTO).collect(Collectors.toList());
    }

    @Override
    public List<DocSignListResponseDTO> unsignedDocList(@Valid DocSignListRequsetDTO requsetDTO) {
        Long bizId = requsetDTO.getBizId();
        MediationMeetingRoomUserInfoResDTO res = this.mediationMeetingService.getMediationRoomUserInfoList(new CommonIdRequestDTO(bizId));
        DocSignListReqDTO reqDTO = new DocSignListReqDTO();
        reqDTO.setBizId(bizId);
        reqDTO.setParentId(res.getParentId());
        reqDTO.setBizType(res.getMediationMeetingType());
        reqDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        reqDTO.setMeetId(requsetDTO.getMeetId());
        List<Object> resDTO = this.clerkConfirmDubboService.getSignDocList(reqDTO);
        if (!this.mediationRoomDubboService.checkIsWorker(bizId).booleanValue() || WeitingshenUtil.isWeitingshenSeriesAppName().booleanValue()) {
            resDTO = resDTO.stream().filter(o -> o.getStatus() != null && o.getStatus() != false).collect(Collectors.toList());
        }
        return resDTO.stream().map(ClerkConfirmConvert::convertDocSignListResDTO).collect(Collectors.toList());
    }
}

