/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.convert;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.odr.peace.common.constants.PeaceConst;
import com.beiming.odr.peace.common.enums.ColumnEnums;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomUserMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomUserRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantAgentInfoMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantAgentInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UpdateLitigantTypeRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UpdateMediationRoomPersonRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationRoomAgentInfoResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationRoomPersonInfoResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationRoomPersonResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationRoomUserInfoNewRespDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationRoomUserInfoRespDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationRoomUserInfoResponseDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomMicroReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomUserMicroReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.AgentInfoReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingUseReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingUserInfoReqDTO;
import com.beiming.odr.referee.dto.requestdto.UpdateLitigantTypeReqDTO;
import com.beiming.odr.referee.dto.requestdto.UpdateMediationRoomPersonReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomPersonResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import com.beiming.odr.user.api.dto.responsedto.SearchServicePersonResDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MediationRoomConvert {
    public static AddMediationRoomReqDTO getAddMediationRoomReqDTO(AddMediationRoomRequestDTO dto) {
        AddMediationRoomReqDTO reqDTO = new AddMediationRoomReqDTO();
        reqDTO.setMediationRoomName(dto.getMediationRoomName());
        ArrayList litigantList = Lists.newArrayList();
        List list = dto.getList();
        for (int i = 0; i < list.size(); ++i) {
            LitigantInfoRequestDTO userDto = (LitigantInfoRequestDTO)list.get(i);
            MediationMeetingUserInfoReqDTO userInfoReqDTO = MediationRoomConvert.getMediationMeetingUserInfoReqDTO(userDto);
            userInfoReqDTO.setUserOrder(Integer.valueOf(i + 1));
            litigantList.add(userInfoReqDTO);
        }
        reqDTO.setLitigantList((List)litigantList);
        reqDTO.setAuthFlag(dto.getAuthFlag());
        reqDTO.setCreatorId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        reqDTO.setCreateUser(JWTContextUtil.getCurrentUserName());
        reqDTO.setUpdateUser(JWTContextUtil.getCurrentUserName());
        return reqDTO;
    }

    public static AddMediationRoomMicroReqDTO getAddMediationRoomMicroReqDTO(AddMediationRoomMicroRequestDTO dto) {
        List userAgentListReq = dto.getAgentList();
        ArrayList userListReq = Lists.newArrayList();
        List userList = dto.getLitigantList();
        for (LitigantInfoRequestDTO user : userList) {
            userListReq.add(MediationRoomConvert.getMediationMeetingUseReqDTO(user, userAgentListReq, dto.getCaseType()));
        }
        ArrayList mediatorListReq = Lists.newArrayList();
        List mediatorList = dto.getMediatorList();
        for (LitigantInfoRequestDTO mediator : mediatorList) {
            mediatorListReq.add(MediationRoomConvert.getMediationMeetingUseReqDTO(mediator, null, dto.getCaseType()));
        }
        AddMediationRoomMicroReqDTO reqDTO = new AddMediationRoomMicroReqDTO();
        reqDTO.setMediationRoomName(dto.getMediationRoomName());
        reqDTO.setCauseName(dto.getCauseName());
        reqDTO.setCauseCode(dto.getCauseCode());
        reqDTO.setUserList((List)userListReq);
        reqDTO.setMediatorList((List)mediatorListReq);
        reqDTO.setAuthFlag(dto.getAuthFlag());
        reqDTO.setCreatorId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        reqDTO.setCreateUser(JWTContextUtil.getCurrentUserName());
        reqDTO.setUpdateUser(JWTContextUtil.getCurrentUserName());
        reqDTO.setThirdCaseId(dto.getThirdCaseId());
        if (dto.getUndertakeUser() != null) {
            JSONObject json = new JSONObject();
            json.put(ColumnEnums.CASE_NAME.desc(), (Object)dto.getCaseName());
            json.put(ColumnEnums.CASE_TYPE.desc(), (Object)dto.getCaseType());
            json.put(ColumnEnums.PROCEDURE.desc(), (Object)dto.getProcedure());
            json.put(ColumnEnums.UNDERTAKE_DEPARTMENT.desc(), (Object)dto.getUndertakeDepartment());
            json.put(ColumnEnums.UNDERTAKE_USER.desc(), (Object)dto.getUndertakeUser());
            json.put(ColumnEnums.UNDERTAKE_USER_PHONE.desc(), (Object)dto.getUndertakeUserPhone());
            json.put(ColumnEnums.SUPERVISE_TYPE.desc(), (Object)dto.getSuperviseType());
            json.put(ColumnEnums.SUPERVISE_USER.desc(), (Object)dto.getSuperviseUser());
            json.put(ColumnEnums.SUPERVISE_USER_PHONE.desc(), (Object)dto.getSuperviseUserPhone());
            reqDTO.setExtInfo((String)JSON.parseObject((String)JSON.toJSONString((Object)json), String.class));
        } else {
            reqDTO.setExtInfo(null);
        }
        return reqDTO;
    }

    public static AddMediationRoomMicroReqDTO getAddMediationRoomMicroReqDTOByTdh(AddMediationRoomMicroRequestDTO dto) {
        List userAgentListReq = dto.getAgentList();
        ArrayList userListReq = Lists.newArrayList();
        List userList = dto.getLitigantList();
        for (LitigantInfoRequestDTO user : userList) {
            userListReq.add(MediationRoomConvert.getMediationMeetingUseReqDTO(user, userAgentListReq, dto.getCaseType()));
        }
        ArrayList mediatorListReq = Lists.newArrayList();
        List mediatorList = dto.getMediatorList();
        for (LitigantInfoRequestDTO mediator : mediatorList) {
            mediatorListReq.add(MediationRoomConvert.getMediationMeetingUseReqDTO(mediator, null, dto.getCaseType()));
        }
        AddMediationRoomMicroReqDTO reqDTO = new AddMediationRoomMicroReqDTO();
        reqDTO.setMediationRoomName(dto.getMediationRoomName());
        reqDTO.setCauseName(dto.getCauseName());
        reqDTO.setCauseCode(dto.getCauseCode());
        reqDTO.setUserList((List)userListReq);
        reqDTO.setMediatorList((List)mediatorListReq);
        reqDTO.setAuthFlag(dto.getAuthFlag());
        reqDTO.setThirdCaseId(dto.getThirdCaseId());
        if (dto.getUndertakeUser() != null) {
            JSONObject json = new JSONObject();
            json.put(ColumnEnums.CASE_NAME.desc(), (Object)dto.getCaseName());
            json.put(ColumnEnums.CASE_TYPE.desc(), (Object)dto.getCaseType());
            json.put(ColumnEnums.PROCEDURE.desc(), (Object)dto.getProcedure());
            json.put(ColumnEnums.UNDERTAKE_DEPARTMENT.desc(), (Object)dto.getUndertakeDepartment());
            json.put(ColumnEnums.UNDERTAKE_USER.desc(), (Object)dto.getUndertakeUser());
            json.put(ColumnEnums.UNDERTAKE_USER_PHONE.desc(), (Object)dto.getUndertakeUserPhone());
            json.put(ColumnEnums.SUPERVISE_TYPE.desc(), (Object)dto.getSuperviseType());
            json.put(ColumnEnums.SUPERVISE_USER.desc(), (Object)dto.getSuperviseUser());
            json.put(ColumnEnums.SUPERVISE_USER_PHONE.desc(), (Object)dto.getSuperviseUserPhone());
            reqDTO.setExtInfo((String)JSON.parseObject((String)JSON.toJSONString((Object)json), String.class));
        } else {
            reqDTO.setExtInfo(null);
        }
        return reqDTO;
    }

    public static MediationMeetingUseReqDTO getMediationMeetingUseReqDTO(LitigantInfoRequestDTO dto, List<LitigantAgentInfoMicroRequestDTO> userAgentListReq, String caseType) {
        MediationMeetingUseReqDTO reqDTO = new MediationMeetingUseReqDTO();
        if (null != dto.getMeetingUserType()) {
            reqDTO.setMeetingUserType(dto.getMeetingUserType().name());
        } else {
            reqDTO.setMeetingUserType(MeetingUserTypeEnum.LITIGANT.name());
        }
        if (null != dto.getUserOrder()) {
            reqDTO.setUserOrder(dto.getUserOrder());
        }
        reqDTO.setUserId(dto.getUserId());
        reqDTO.setUserName(dto.getUserName());
        reqDTO.setMobilePhone(dto.getMobilePhone());
        reqDTO.setIdCard(dto.getIdCard());
        reqDTO.setAuthStatus(dto.getAuthStatus());
        reqDTO.setAgentList(MediationRoomConvert.getAgentInfoReqDTO(dto, userAgentListReq));
        reqDTO.setRemark(dto.getUserTempId());
        JSONObject json = new JSONObject();
        if (caseType != null && "MSES".equals(caseType)) {
            json.put(ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc(), (Object)dto.getOriginalLitigationStatus());
        }
        json.put(ColumnEnums.IS_UNDERTAKER.desc(), (Object)dto.getIsUndertaker());
        if (dto.getLitigantType() != null && dto.getLitigantType() != 1) {
            json.put(ColumnEnums.LITIGANT_TYPE.desc(), (Object)dto.getLitigantType());
            json.put(ColumnEnums.UNIT_NAME.desc(), (Object)dto.getUnitName());
            json.put(ColumnEnums.CREDIT_CODE.desc(), (Object)dto.getCreditCode());
            reqDTO.setExtInfo((String)JSON.parseObject((String)JSON.toJSONString((Object)json), String.class));
        } else if (dto.getLitigantType() != null && dto.getLitigantType() == 1) {
            json.put(ColumnEnums.LITIGANT_TYPE.desc(), (Object)dto.getLitigantType());
            reqDTO.setExtInfo((String)JSON.parseObject((String)JSON.toJSONString((Object)json), String.class));
        } else if (dto.getIsUndertaker() != null) {
            json.put(ColumnEnums.IS_UNDERTAKER.desc(), (Object)dto.getIsUndertaker());
            reqDTO.setExtInfo((String)JSON.parseObject((String)JSON.toJSONString((Object)json), String.class));
        } else {
            reqDTO.setExtInfo(null);
        }
        return reqDTO;
    }

    private static List<AgentInfoReqDTO> getAgentInfoReqDTO(LitigantInfoRequestDTO dto, List<LitigantAgentInfoMicroRequestDTO> userAgentListReq) {
        ArrayList agentList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(userAgentListReq)) {
            return agentList;
        }
        for (LitigantAgentInfoMicroRequestDTO agentRequestDTO : userAgentListReq) {
            String agentParentUserTempIdStr = agentRequestDTO.getAgentParentUserTempIdList();
            if (StringUtils.isBlank((CharSequence)agentParentUserTempIdStr)) continue;
            for (String parentUserTempId : agentParentUserTempIdStr.split(",")) {
                String userTempIdStr = dto.getUserTempId();
                if (!userTempIdStr.equals(parentUserTempId)) continue;
                AgentInfoReqDTO reqDTO = new AgentInfoReqDTO();
                reqDTO.setCaseUserType(agentRequestDTO.getMeetingUserType().name());
                reqDTO.setAgentType(agentRequestDTO.getAgentType().name());
                reqDTO.setAgentId(agentRequestDTO.getUserId());
                reqDTO.setAgentName(agentRequestDTO.getUserName());
                reqDTO.setAgentPhone(agentRequestDTO.getMobilePhone());
                reqDTO.setAgentIdCard(agentRequestDTO.getIdCard());
                reqDTO.setAuthStatus(agentRequestDTO.getAuthStatus());
                reqDTO.setUserTempId(agentRequestDTO.getUserTempId());
                agentList.add(reqDTO);
            }
        }
        return agentList;
    }

    public static MediationMeetingUserInfoReqDTO getMediationMeetingUserInfoReqDTO(LitigantInfoRequestDTO dto) {
        MediationMeetingUserInfoReqDTO reqDTO = new MediationMeetingUserInfoReqDTO();
        reqDTO.setMeetingUserType(Objects.toString(dto.getMeetingUserType(), MeetingUserTypeEnum.LITIGANT.name()));
        reqDTO.setUserId(dto.getUserId());
        reqDTO.setUserName(dto.getUserName());
        reqDTO.setMobilePhone(dto.getMobilePhone());
        reqDTO.setIdCard(dto.getIdCard());
        reqDTO.setAuthStatus(dto.getAuthStatus());
        return reqDTO;
    }

    public static MediationMeetingUseReqDTO getMediationMeetingUseReqDTO(LitigantInfoRequestDTO dto) {
        MediationMeetingUseReqDTO reqDTO = new MediationMeetingUseReqDTO();
        reqDTO.setMeetingUserType(Objects.toString(dto.getMeetingUserType()));
        reqDTO.setPersonId(dto.getPersonId());
        reqDTO.setUserId(dto.getUserId());
        reqDTO.setUserName(dto.getUserName());
        reqDTO.setMobilePhone(dto.getMobilePhone());
        reqDTO.setIdCard(dto.getIdCard());
        reqDTO.setAuthStatus(dto.getAuthStatus());
        return reqDTO;
    }

    public static List<MediationRoomUserInfoRespDTO> getMediationRoomUserInfoResponseDTOListNew(ArrayList<MediationRoomUserInfoResDTO> arrayList) {
        ArrayList list = Lists.newArrayList();
        for (MediationRoomUserInfoResDTO mediationRoomUserInfoResDTO : arrayList) {
            MediationRoomUserInfoRespDTO mruir = new MediationRoomUserInfoRespDTO(mediationRoomUserInfoResDTO);
            list.add(mruir);
        }
        return list;
    }

    public static List<MediationRoomUserInfoNewRespDTO> getMediationRoomUserInfoResponseDTOListNew1(ArrayList<MediationRoomUserInfoResDTO> arrayList) {
        MediationRoomUserInfoResDTO dto;
        ArrayList list = Lists.newArrayList();
        HashMap<Long, MediationRoomUserInfoNewRespDTO> noAgentMap = new HashMap<Long, MediationRoomUserInfoNewRespDTO>();
        HashMap<Long, MediationRoomUserInfoNewRespDTO> agentNewMap = new HashMap<Long, MediationRoomUserInfoNewRespDTO>();
        HashMap<Long, MediationRoomUserInfoResDTO> agentMutilMap = new HashMap<Long, MediationRoomUserInfoResDTO>();
        for (MediationRoomUserInfoResDTO resDto : arrayList) {
            MediationRoomUserInfoNewRespDTO mruir = new MediationRoomUserInfoNewRespDTO(resDto);
            String meetingUserType = resDto.getMeetingUserType();
            String aAgent = MeetingUserTypeEnum.APPLICANT_AGENT.name();
            String rAgent = MeetingUserTypeEnum.RESPONDENT_AGENT.name();
            String tAgent = MeetingUserTypeEnum.LITIGANT_THIRD_AGENT.name();
            Long personId = resDto.getPersonId();
            if (!(aAgent.equals(meetingUserType) || rAgent.equals(meetingUserType) || tAgent.equals(meetingUserType))) {
                noAgentMap.put(personId, mruir);
                list.add(mruir);
                continue;
            }
            agentMutilMap.put(personId, resDto);
            agentNewMap.put(resDto.getUserId(), mruir);
        }
        for (Long pId : agentMutilMap.keySet()) {
            dto = (MediationRoomUserInfoResDTO)agentMutilMap.get(pId);
            Long agentParentId = dto.getAgentParentId();
            MediationRoomUserInfoNewRespDTO dto3 = (MediationRoomUserInfoNewRespDTO)noAgentMap.get(agentParentId);
            MediationRoomUserInfoNewRespDTO dto2 = (MediationRoomUserInfoNewRespDTO)agentNewMap.get(dto.getUserId());
            List agentList = dto2.getAgentList();
            if (CollectionUtils.isEmpty((Collection)agentList)) {
                agentList = Lists.newArrayList();
                dto2.setAgentList(agentList);
            }
            if (dto3 == null) continue;
            agentList.add(dto3);
        }
        for (Long userId : agentNewMap.keySet()) {
            dto = (MediationRoomUserInfoNewRespDTO)agentNewMap.get(userId);
            list.add(dto);
        }
        return list;
    }

    public static List<MediationRoomUserInfoResponseDTO> getMediationRoomUserInfoResponseDTOList(ArrayList<MediationRoomUserInfoResDTO> arrayList) {
        ArrayList list = Lists.newArrayList();
        ArrayList applyList = Lists.newArrayList();
        int applyOrder = 1;
        ArrayList resList = Lists.newArrayList();
        int resOrder = 1;
        ArrayList litigantList = Lists.newArrayList();
        int litigantOrder = 1;
        List agentList = arrayList.stream().filter(s -> MeetingUserTypeEnum.APPLICANT_AGENT.name().equals(s.getMeetingUserType()) || MeetingUserTypeEnum.RESPONDENT_AGENT.name().equals(s.getMeetingUserType())).collect(Collectors.toList());
        for (MediationRoomUserInfoResDTO resDTO : arrayList) {
            MediationRoomUserInfoResponseDTO responseDTO = new MediationRoomUserInfoResponseDTO(resDTO);
            if (MeetingUserTypeEnum.LITIGANT.name().equals(resDTO.getMeetingUserType())) {
                responseDTO.setName(MeetingUserTypeEnum.LITIGANT.getName() + litigantOrder++);
                litigantList.add(responseDTO);
                continue;
            }
            for (MediationRoomUserInfoResDTO agentRes : agentList) {
                if (!resDTO.getPersonId().equals(agentRes.getAgentParentId())) continue;
                MediationRoomAgentInfoResponseDTO agent = new MediationRoomAgentInfoResponseDTO(agentRes);
                responseDTO.setAgent(agent);
            }
            if (MeetingUserTypeEnum.APPLICANT.name().equals(resDTO.getMeetingUserType())) {
                responseDTO.setName(MeetingUserTypeEnum.APPLICANT.getName() + applyOrder++);
                applyList.add(responseDTO);
                continue;
            }
            if (!MeetingUserTypeEnum.RESPONDENT.name().equals(resDTO.getMeetingUserType())) continue;
            responseDTO.setName(MeetingUserTypeEnum.RESPONDENT.getName() + resOrder++);
            resList.add(responseDTO);
        }
        list.addAll(applyList);
        list.addAll(resList);
        list.addAll(litigantList);
        return list;
    }

    public static AddMediationRoomUserReqDTO getAddMediationRoomUserReqDTO(AddMediationRoomUserRequestDTO dto) {
        AddMediationRoomUserReqDTO reqDTO = new AddMediationRoomUserReqDTO();
        ArrayList litigantList = Lists.newArrayList();
        List list = dto.getList();
        reqDTO.setMediationRoomId(dto.getMediationRoomId());
        for (int i = 0; i < list.size(); ++i) {
            LitigantInfoRequestDTO userDto = (LitigantInfoRequestDTO)list.get(i);
            MediationMeetingUserInfoReqDTO userInfoReqDTO = MediationRoomConvert.getMediationMeetingUserInfoReqDTO(userDto);
            litigantList.add(userInfoReqDTO);
        }
        reqDTO.setList((List)litigantList);
        reqDTO.setCurrentUserId(JWTContextUtil.getCurrentUserId());
        reqDTO.setCreateUser(JWTContextUtil.getCurrentUserName());
        return reqDTO;
    }

    public static AddMediationRoomUserMicroReqDTO getAddMediationRoomUserMicroReqDTO(AddMediationRoomUserMicroRequestDTO dto) {
        JSONObject json;
        MediationMeetingUseReqDTO reqUser;
        AddMediationRoomUserMicroReqDTO reqDTO = new AddMediationRoomUserMicroReqDTO();
        reqDTO.setMediationRoomId(dto.getMediationRoomId());
        if (!CollectionUtils.isEmpty((Collection)dto.getList())) {
            ArrayList userList = Lists.newArrayList();
            for (LitigantInfoRequestDTO user : dto.getList()) {
                reqUser = MediationRoomConvert.getMediationMeetingUseReqDTO(user);
                reqUser.setAgentList(MediationRoomConvert.getAgentInfoReqDTOMicro(user.getUserAgentList()));
                json = new JSONObject();
                json.put(ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc(), (Object)user.getOriginalLitigationStatus());
                json.put(ColumnEnums.LITIGANT_TYPE.desc(), (Object)user.getLitigantType());
                json.put(ColumnEnums.IS_UNDERTAKER.desc(), (Object)user.getIsUndertaker());
                if (user.getLitigantType() != null && user.getLitigantType() != 1) {
                    json.put(ColumnEnums.UNIT_NAME.desc(), (Object)user.getUnitName());
                    json.put(ColumnEnums.CREDIT_CODE.desc(), (Object)user.getCreditCode());
                    reqUser.setExtInfo((String)JSON.parseObject((String)JSON.toJSONString((Object)json), String.class));
                } else if (user.getLitigantType() != null && user.getLitigantType() == 1) {
                    json.put(ColumnEnums.LITIGANT_TYPE.desc(), (Object)user.getLitigantType());
                    reqUser.setExtInfo((String)JSON.parseObject((String)JSON.toJSONString((Object)json), String.class));
                } else if (user.getIsUndertaker() != null) {
                    json.put(ColumnEnums.IS_UNDERTAKER.desc(), (Object)user.getIsUndertaker());
                    reqUser.setExtInfo((String)JSON.parseObject((String)JSON.toJSONString((Object)json), String.class));
                } else {
                    reqUser.setExtInfo(null);
                }
                userList.add(reqUser);
            }
            reqDTO.setUserList((List)userList);
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getMediatorList())) {
            ArrayList mediatorList = Lists.newArrayList();
            for (LitigantInfoRequestDTO user : dto.getMediatorList()) {
                reqUser = MediationRoomConvert.getMediationMeetingUseReqDTO(user);
                reqUser.setAgentList(MediationRoomConvert.getAgentInfoReqDTOMicro(user.getUserAgentList()));
                json = new JSONObject();
                if (user.getOriginalLitigationStatus() != null) {
                    json.put(ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc(), (Object)user.getOriginalLitigationStatus());
                }
                if (user.getLitigantType() != null) {
                    json.put(ColumnEnums.LITIGANT_TYPE.desc(), (Object)user.getLitigantType());
                }
                if (user.getUnitName() != null) {
                    json.put(ColumnEnums.UNIT_NAME.desc(), (Object)user.getUnitName());
                }
                if (user.getCreditCode() != null) {
                    json.put(ColumnEnums.CREDIT_CODE.desc(), (Object)user.getCreditCode());
                }
                if (user.getIsUndertaker() != null) {
                    json.put(ColumnEnums.IS_UNDERTAKER.desc(), (Object)user.getIsUndertaker());
                }
                reqUser.setExtInfo((String)JSON.parseObject((String)JSON.toJSONString((Object)json), String.class));
                mediatorList.add(reqUser);
            }
            reqDTO.setMediatorList((List)mediatorList);
        }
        reqDTO.setCurrentUserId(JWTContextUtil.getCurrentUserId());
        reqDTO.setCreateUser(JWTContextUtil.getCurrentUserName());
        return reqDTO;
    }

    private static List<AgentInfoReqDTO> getAgentInfoReqDTOMicro(List<LitigantAgentInfoRequestDTO> userAgentListReq) {
        ArrayList agentList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(userAgentListReq)) {
            return agentList;
        }
        for (LitigantAgentInfoRequestDTO agentRequestDTO : userAgentListReq) {
            AgentInfoReqDTO reqDTO = new AgentInfoReqDTO();
            reqDTO.setCaseUserType(agentRequestDTO.getMeetingUserType().name());
            reqDTO.setAgentType(agentRequestDTO.getAgentType().name());
            reqDTO.setAgentId(agentRequestDTO.getUserId());
            reqDTO.setAgentName(agentRequestDTO.getUserName());
            reqDTO.setAgentPhone(agentRequestDTO.getMobilePhone());
            reqDTO.setAgentIdCard(agentRequestDTO.getIdCard());
            reqDTO.setAuthStatus(agentRequestDTO.getAuthStatus());
            agentList.add(reqDTO);
        }
        return agentList;
    }

    public static MediationMeetingUserInfoReqDTO getMediationMeetingUserInfoReqDTO(SearchServicePersonResDTO person) {
        MediationMeetingUserInfoReqDTO mediator = new MediationMeetingUserInfoReqDTO();
        mediator.setUserId(person.getUserId());
        mediator.setUserName(person.getUserName());
        mediator.setMobilePhone(person.getMobilePhone());
        mediator.setIdCard(person.getIdCard());
        mediator.setMeetingUserType(MeetingUserTypeEnum.MEDIATOR.name());
        mediator.setAuthStatus(PeaceConst.AUTH_YES);
        return mediator;
    }

    public static UpdateMediationRoomPersonReqDTO getUpdateMediationRoomPersonReqDTO(UpdateMediationRoomPersonRequestDTO dto) {
        UpdateMediationRoomPersonReqDTO reqDTO = new UpdateMediationRoomPersonReqDTO();
        reqDTO.setMediationRoomId(dto.getId());
        reqDTO.setUpdateUser(JWTContextUtil.getCurrentUserName());
        ArrayList litigantList = Lists.newArrayList();
        List applicantList = dto.getApplicant();
        for (int i = 0; i < applicantList.size(); ++i) {
            UpdateLitigantTypeRequestDTO applicant = (UpdateLitigantTypeRequestDTO)applicantList.get(i);
            UpdateLitigantTypeReqDTO litigant = MediationRoomConvert.getUpdateLitigantTypeReqDTO(applicant, i + 1);
            litigant.setMeetingUserType(MeetingUserTypeEnum.APPLICANT.name());
            litigant.setAgentType(MeetingUserTypeEnum.APPLICANT_AGENT.name());
            litigantList.add(litigant);
        }
        List respondentList = dto.getRespondent();
        for (int i = 0; i < respondentList.size(); ++i) {
            UpdateLitigantTypeRequestDTO respondent = (UpdateLitigantTypeRequestDTO)respondentList.get(i);
            UpdateLitigantTypeReqDTO litigant = MediationRoomConvert.getUpdateLitigantTypeReqDTO(respondent, i + 1);
            litigant.setMeetingUserType(MeetingUserTypeEnum.RESPONDENT.name());
            litigant.setAgentType(MeetingUserTypeEnum.RESPONDENT_AGENT.name());
            litigantList.add(litigant);
        }
        reqDTO.setLitigant((List)litigantList);
        return reqDTO;
    }

    public static UpdateLitigantTypeReqDTO getUpdateLitigantTypeReqDTO(UpdateLitigantTypeRequestDTO person, int userOrder) {
        UpdateLitigantTypeReqDTO litigant = new UpdateLitigantTypeReqDTO();
        litigant.setUserType(person.getUserType());
        litigant.setPersonId(person.getPersonId());
        litigant.setUserId(person.getUserId());
        litigant.setUserOrder(Integer.valueOf(userOrder));
        litigant.setAgentPersonId(person.getAgentPersonId());
        litigant.setAgentId(person.getAgentId());
        return litigant;
    }

    public static MediationRoomPersonInfoResponseDTO getMediationRoomPersonType(ArrayList<MediationRoomPersonResDTO> list) {
        MediationRoomPersonInfoResponseDTO result = new MediationRoomPersonInfoResponseDTO();
        ArrayList applicantList = Lists.newArrayList();
        ArrayList respondentList = Lists.newArrayList();
        ArrayList otherList = Lists.newArrayList();
        List agentList = list.stream().filter(s -> MeetingUserTypeEnum.APPLICANT_AGENT.name().equals(s.getMeetingUserType()) || MeetingUserTypeEnum.RESPONDENT_AGENT.name().equals(s.getMeetingUserType())).collect(Collectors.toList());
        for (MediationRoomPersonResDTO person : list) {
            MediationRoomPersonResponseDTO response = new MediationRoomPersonResponseDTO();
            response.setPersonId(person.getPersonId());
            response.setUserId(person.getUserId());
            response.setUserName(person.getUserName());
            response.setMeetingUserType(person.getMeetingUserType());
            response.setUserType(person.getUserType());
            response.setUserOrder(person.getUserOrder());
            if (MeetingUserTypeEnum.LITIGANT.name().equals(person.getMeetingUserType())) {
                otherList.add(response);
                continue;
            }
            for (MediationRoomPersonResDTO agentRes : agentList) {
                if (!person.getPersonId().equals(agentRes.getAgentParentId())) continue;
                response.setAgentPersonId(agentRes.getPersonId());
                response.setAgentId(agentRes.getUserId());
                response.setAgentName(agentRes.getUserName());
            }
            if (MeetingUserTypeEnum.APPLICANT.name().equals(person.getMeetingUserType())) {
                applicantList.add(response);
            }
            if (!MeetingUserTypeEnum.RESPONDENT.name().equals(person.getMeetingUserType())) continue;
            respondentList.add(response);
        }
        result.setApplicantList((List)applicantList);
        result.setRespondentList((List)respondentList);
        result.setOtherList((List)otherList);
        return result;
    }
}

