/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.beiming.odr.peace.domain.dto.requestdto.IntranetCommonRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.IntranetGetLitigantInfoResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.JiangBeiGetLitigantInfoResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.JiangBeiGetRoomAndUserIdsResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.RoomAndUserIdsResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.RoomMemberListResponseDTO;
import com.beiming.odr.peace.service.IntranetJiangBeiService;
import com.beiming.odr.peace.service.JiangBeiIntranetService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IntranetJiangBeiServiceImpl
implements IntranetJiangBeiService {
    private static final Logger log = LoggerFactory.getLogger(IntranetJiangBeiServiceImpl.class);
    @Resource
    JiangBeiIntranetService jiangBeiIntranetService;

    @Override
    public boolean ifJangBeiByCaseCode(String courtCode, String caseNumber) {
        JiangBeiGetRoomAndUserIdsResponseDTO courtRoomIdsAndUserIds = this.jiangBeiIntranetService.getCourtRoomIdsAndUserIds(caseNumber);
        if (courtRoomIdsAndUserIds == null) {
            return false;
        }
        List list = courtRoomIdsAndUserIds.getList();
        String roomId = ((RoomAndUserIdsResponseDTO)list.get(list.size() - 1)).getRoomId();
        String caseNumberCode = roomId.substring(0, roomId.indexOf("_"));
        if (caseNumberCode.length() != 18) {
            return false;
        }
        String court = caseNumberCode.substring(0, 4);
        String caseType = caseNumberCode.substring(8, 10);
        return courtCode.equals("5049") && court.equals("5049") && caseType.equals("04");
    }

    @Override
    public List<IntranetGetLitigantInfoResponseDTO> getLitigantInfo(IntranetCommonRequestDTO dto) {
        String caseNumber = dto.getCaseNumberCode();
        JiangBeiGetRoomAndUserIdsResponseDTO courtRoomIdsAndUserIds = this.jiangBeiIntranetService.getCourtRoomIdsAndUserIds(caseNumber);
        List list = courtRoomIdsAndUserIds.getList();
        String roomId = ((RoomAndUserIdsResponseDTO)list.get(list.size() - 1)).getRoomId();
        JiangBeiGetLitigantInfoResponseDTO litigantInfo = this.jiangBeiIntranetService.getLitigantInfo(roomId);
        List memberList = litigantInfo.getList();
        ArrayList<IntranetGetLitigantInfoResponseDTO> responseDTO = new ArrayList<IntranetGetLitigantInfoResponseDTO>();
        if (memberList != null && memberList.size() > 0) {
            for (RoomMemberListResponseDTO roomMember : memberList) {
                IntranetGetLitigantInfoResponseDTO intranetGetLitigantInfoResponseDTO = new IntranetGetLitigantInfoResponseDTO();
                intranetGetLitigantInfoResponseDTO.setUserName(roomMember.getUserName());
                intranetGetLitigantInfoResponseDTO.setStatus(roomMember.getStatus());
                responseDTO.add(intranetGetLitigantInfoResponseDTO);
            }
        }
        return responseDTO;
    }
}

