/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.common.constants.PeaceConst;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.utils.WeitingshenUtil;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomUserMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomUserRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CourtInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantAgentInfoMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantAgentInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.TdhPushMediationRoomMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UpdateMediationRoomPersonRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.CourtPaymentResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationRoomPersonInfoResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationRoomUserInfoNewRespDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationRoomUserInfoRespDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationRoomUserInfoResponseDTO;
import com.beiming.odr.peace.im.api.UnreadMessageApi;
import com.beiming.odr.peace.service.BackstageUserService;
import com.beiming.odr.peace.service.MediationMeetingService;
import com.beiming.odr.peace.service.MediationRoomService;
import com.beiming.odr.peace.service.PeaceSmsService;
import com.beiming.odr.peace.service.PersonalService;
import com.beiming.odr.peace.service.backend.referee.MediationRoomDubboService;
import com.beiming.odr.peace.service.backend.trial.TrialDubboApiService;
import com.beiming.odr.peace.service.backend.user.UserBackendService;
import com.beiming.odr.peace.service.convert.DTOCheckFieldConvert;
import com.beiming.odr.peace.service.convert.MediationMeetingConvert;
import com.beiming.odr.peace.service.convert.MediationRoomConvert;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomMicroReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomUserMicroReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.CloseMediationRoomReqDTO;
import com.beiming.odr.referee.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingRoomMoreReqDto;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingUserInfoReqDTO;
import com.beiming.odr.referee.dto.requestdto.UpdateMediationRoomPersonReqDTO;
import com.beiming.odr.referee.dto.responsedto.AddMediationRoomResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomResponseDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserVideoQualityRespDTO;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import com.beiming.odr.trial.api.TrialApi;
import com.beiming.odr.trial.api.dto.request.UpdateCaseKtfsRequestDTO;
import com.beiming.odr.user.api.DataStatisticsCourtApi;
import com.beiming.odr.user.api.OrganizationServiceApi;
import com.beiming.odr.user.api.UserServiceSecondApi;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrganizationResDTO;
import com.beust.jcommander.internal.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class MediationRoomServiceImpl
implements MediationRoomService {
    private static final Logger log = LoggerFactory.getLogger(MediationRoomServiceImpl.class);
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Resource
    private UnreadMessageApi unreadMessageApi;
    @Resource
    private UserBackendService userBackendService;
    @Resource
    private UserServiceSecondApi userServiceSecondApi;
    @Resource
    private PeaceSmsService peaceSmsService;
    @Resource
    private MediationRoomDubboService mediationRoomDubboService;
    @Resource
    private BackstageUserService backstageUserService;
    private RedisTemplate redisTemplate;
    @Resource
    private RedisService redisService;
    @Resource
    private TrialApi trialApi;
    @Resource
    private TrialDubboApiService trialDubboApiService;
    @Resource
    private DataStatisticsCourtApi dataStatisticsCourtApi;
    @Resource
    private PersonalService personalService;
    @Resource
    private MediationMeetingService mediationMeetingService;
    @Resource
    private OrganizationServiceApi organizationServiceApi;

    @Override
    public void updateCaseKtfs(String ahdm, String ktfs) {
        try {
            if (StringUtils.isNotBlank((CharSequence)ahdm)) {
                UpdateCaseKtfsRequestDTO req = new UpdateCaseKtfsRequestDTO(ahdm, ktfs);
                this.trialApi.updateCaseKtfs(req);
            }
        }
        catch (Exception e) {
            log.error("error: {},{}", new Object[]{ahdm, ktfs, e});
        }
    }

    @Override
    public void addMediationRoom(AddMediationRoomRequestDTO dto) {
        List litigantList = dto.getList();
        this.registerLitigant(litigantList);
        AddMediationRoomReqDTO reqDTO = MediationRoomConvert.getAddMediationRoomReqDTO(dto);
        MediationMeetingUserInfoReqDTO mediator = this.userBackendService.getMediatorInfo(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        CourtInfoRequestDTO reqDtO = new CourtInfoRequestDTO();
        reqDtO.setCourtCode(mediator.getOrgId().toString());
        reqDtO.setUserId(JWTContextUtil.getCurrentUserId());
        CourtPaymentResponseDTO courtPaymentResponseDTO = this.personalService.getCourtPayment(reqDtO);
        AssertUtils.assertTrue((boolean)courtPaymentResponseDTO.getCanCreateMeeting(), (ResultCode)ErrorCode.ACCESS_DENIED, (String)"\u60a8\u7684\u4e92\u8054\u7f51\u5ead\u5ba1\u670d\u52a1\u5df2\u5230\u671f");
        reqDTO.setMediator(mediator);
        DubboResult result = this.mediationRoomApi.addMediationRoom(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        AddMediationRoomResDTO resDTO = (AddMediationRoomResDTO)result.getData();
        this.peaceSmsService.sendMediationRoomSms(litigantList, resDTO.getMediationRoomId(), dto.getMediationRoomName(), resDTO.getRoomId(), mediator.getUserName(), dto.getAuthFlag());
    }

    @Override
    public AddMediationRoomResDTO addMediationRoomMicro(AddMediationRoomMicroRequestDTO dto) {
        DTOCheckFieldConvert.checkLitigantInfoRequestDTO(dto.getLitigantList());
        log.info("MediationRoomServiceImpl.addMediationRoomMicro @AddMediationRoomMicroRequestDTO {}", (Object)dto);
        List litigantList = dto.getLitigantList();
        List agentList = dto.getAgentList();
        List mediatorList = dto.getMediatorList();
        String currentUserId = JWTContextUtil.getCurrentUserId();
        UserRoleInfoDTO roleInfo = this.backstageUserService.searchBackstageUserOrgId(currentUserId);
        CourtInfoRequestDTO reqDtO = new CourtInfoRequestDTO();
        reqDtO.setCourtCode(roleInfo.getOrganizationId().toString());
        reqDtO.setUserId(currentUserId);
        CourtPaymentResponseDTO courtPaymentResponseDTO = this.personalService.getCourtPayment(reqDtO);
        AssertUtils.assertTrue((boolean)courtPaymentResponseDTO.getCanCreateMeeting(), (ResultCode)ErrorCode.ACCESS_DENIED, (String)"\u60a8\u7684\u4e92\u8054\u7f51\u5ead\u5ba1\u670d\u52a1\u5df2\u5230\u671f");
        APIResult apiResult = MediationMeetingConvert.getAllPersontListCountIgnorePhoneNoIs1111(litigantList, mediatorList, agentList);
        AssertUtils.assertTrue((apiResult.getCode() == 1000 ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)apiResult.getMessage());
        List litigantListNew = Lists.newArrayList();
        litigantListNew.addAll(litigantList);
        litigantListNew.addAll(mediatorList);
        this.registerLitigant(litigantList);
        this.registerAgentInfo(agentList);
        AddMediationRoomMicroReqDTO reqDTO = MediationRoomConvert.getAddMediationRoomMicroReqDTO(dto);
        reqDTO.setOrgId(roleInfo.getOrganizationId());
        reqDTO.setOrgName(roleInfo.getOrganizationName());
        if (dto.getScheduleId() != null) {
            reqDTO.setScheduleId(dto.getScheduleId());
        }
        if (reqDTO.getThirdCaseId() != null) {
            reqDTO.setScheduleId(this.trialDubboApiService.getScheduleId(reqDTO.getThirdCaseId()));
        }
        log.info("request_referee {}", (Object)reqDTO);
        DubboResult result = this.mediationRoomApi.addMediationRoomMicro(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        AddMediationRoomResDTO resDTO = (AddMediationRoomResDTO)result.getData();
        this.updateCaseKtfs(reqDTO.getThirdCaseId(), "CASE_SPACE");
        List<LitigantInfoRequestDTO> mediatorCurrentList = mediatorList.stream().filter(o -> !o.getUserId().equals(Long.valueOf(JWTContextUtil.getCurrentUserId()))).collect(Collectors.toList());
        this.peaceSmsService.sendStaffSms(mediatorCurrentList, null, dto.getMediationRoomName());
        String userName = JWTContextUtil.getCurrentUserName();
        this.peaceSmsService.sendMediationRoomSms(litigantList, resDTO.getMediationRoomId(), dto.getMediationRoomName(), resDTO.getRoomId(), userName, dto.getAuthFlag());
        this.peaceSmsService.sendMediationRoomSmsForAgent(agentList, resDTO.getMediationRoomId(), resDTO.getRoomId(), dto.getMediationRoomName(), userName, dto.getAuthFlag());
        return resDTO;
    }

    @Override
    public AddMediationRoomResDTO tdhPushMediationRoomMicro(TdhPushMediationRoomMicroRequestDTO microRequestDTO) {
        AddMediationRoomMicroRequestDTO dto = new AddMediationRoomMicroRequestDTO(microRequestDTO);
        DTOCheckFieldConvert.checkLitigantInfoRequestDTO(dto.getLitigantList());
        log.info("MediationRoomServiceImpl.addMediationRoomMicro @AddMediationRoomMicroRequestDTO {} , orgName {} ", (Object)dto, (Object)microRequestDTO.getOrganizationName());
        List litigantList = dto.getLitigantList();
        List agentList = dto.getAgentList();
        List mediatorList = dto.getMediatorList();
        Long mediatorId = 0L;
        String userName = null;
        for (LitigantInfoRequestDTO info : mediatorList) {
            if ("1111".equals(info.getMobilePhone()) || StringUtils.isBlank((CharSequence)info.getMobilePhone()) || StringUtils.isBlank((CharSequence)info.getUserName()) || StringUtils.isBlank((CharSequence)info.getMobilePhone())) continue;
            DubboResult result = null;
            try {
                DubboResult orgByName = this.organizationServiceApi.findOrgByName(microRequestDTO.getOrganizationName());
                Long orgId = ((OrganizationResDTO)orgByName.getData()).getId() == null ? 0L : ((OrganizationResDTO)orgByName.getData()).getId();
                log.info("orgByName.getData() " + orgByName.getData() + " orgId " + orgId);
                result = this.userServiceSecondApi.searchAndRegisterByMobileCommonByTDHPushData(info.getMobilePhone(), info.getUserName(), info.getMeetingUserType().toString(), microRequestDTO.getOrganizationName(), orgId, info.getMeetingUserType().toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage());
            }
            log.info("@@@@@@@@@@@@@@@@ == " + result.isSuccess() + " == " + result.getMessage() + " == " + result.getData());
            AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
            info.setUserId(((UserInfoDTO)result.getData()).getUserId());
            if (!"MEDIATOR".equals(info.getMeetingUserType().toString())) continue;
            mediatorId = ((UserInfoDTO)result.getData()).getUserId();
            userName = ((UserInfoDTO)result.getData()).getUserName();
        }
        log.info("=============mediatorId===================" + mediatorId);
        String currentUserId = String.valueOf(mediatorId);
        UserRoleInfoDTO roleInfo = this.backstageUserService.searchBackstageUserOrgId(currentUserId);
        CourtInfoRequestDTO reqDtO = new CourtInfoRequestDTO();
        reqDtO.setCourtCode(roleInfo.getOrganizationId().toString());
        reqDtO.setUserId(currentUserId);
        CourtPaymentResponseDTO courtPaymentResponseDTO = this.personalService.getCourtPayment(reqDtO);
        AssertUtils.assertTrue((boolean)courtPaymentResponseDTO.getCanCreateMeeting(), (ResultCode)ErrorCode.ACCESS_DENIED, (String)"\u60a8\u7684\u4e92\u8054\u7f51\u5ead\u5ba1\u670d\u52a1\u5df2\u5230\u671f");
        APIResult apiResult = MediationMeetingConvert.getAllPersontListCountIgnorePhoneNoIs1111(litigantList, mediatorList, agentList);
        AssertUtils.assertTrue((apiResult.getCode() == 1000 ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)apiResult.getMessage());
        List litigantListNew = Lists.newArrayList();
        litigantListNew.addAll(litigantList);
        litigantListNew.addAll(mediatorList);
        this.registerLitigant(litigantList);
        this.registerAgentInfo(agentList);
        AddMediationRoomMicroReqDTO reqDTO = MediationRoomConvert.getAddMediationRoomMicroReqDTOByTdh(dto);
        reqDTO.setOrgId(roleInfo.getOrganizationId());
        reqDTO.setOrgName(roleInfo.getOrganizationName());
        if (dto.getScheduleId() != null) {
            reqDTO.setScheduleId(dto.getScheduleId());
        }
        if (reqDTO.getThirdCaseId() != null) {
            reqDTO.setScheduleId(this.trialDubboApiService.getScheduleId(reqDTO.getThirdCaseId()));
        }
        reqDTO.setCreatorType("TDH_YAOHAO");
        log.info("request_referee {}", (Object)reqDTO);
        DubboResult result = this.mediationRoomApi.addMediationRoomMicro(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        AddMediationRoomResDTO resDTO = (AddMediationRoomResDTO)result.getData();
        this.updateCaseKtfs(reqDTO.getThirdCaseId(), "CASE_SPACE");
        Long userId = mediatorId;
        List<LitigantInfoRequestDTO> mediatorCurrentList = mediatorList.stream().filter(o -> !o.getUserId().equals(userId)).collect(Collectors.toList());
        this.peaceSmsService.sendStaffSms(mediatorCurrentList, null, dto.getMediationRoomName());
        this.peaceSmsService.sendMediationRoomSms(litigantList, resDTO.getMediationRoomId(), dto.getMediationRoomName(), resDTO.getRoomId(), userName, dto.getAuthFlag());
        this.peaceSmsService.sendMediationRoomSmsForAgent(agentList, resDTO.getMediationRoomId(), resDTO.getRoomId(), dto.getMediationRoomName(), userName, dto.getAuthFlag());
        AddMediationMeetingMicroRequestDTO requestDTO = new AddMediationMeetingMicroRequestDTO();
        requestDTO.setAuthFlag(Integer.valueOf(1));
        requestDTO.setCauseCode(dto.getCauseCode());
        requestDTO.setCaseName(dto.getCauseName());
        requestDTO.setMediationRoomName(dto.getMediationRoomName());
        requestDTO.setMediationRoomId(resDTO.getMediationRoomId());
        requestDTO.setOrderTime(microRequestDTO.getOrderTime());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String endTime = sdf.format(microRequestDTO.getOrderEndTime());
        requestDTO.setOrderEndTime(endTime.substring(13, 18));
        requestDTO.setScheduleId("1");
        requestDTO.setAgentList(microRequestDTO.getAgentList());
        requestDTO.setLitigantList(microRequestDTO.getLitigantList());
        requestDTO.setMediatorList(microRequestDTO.getMediatorList());
        this.mediationMeetingService.createMediationMeetingMicroByTdh(requestDTO, mediatorId);
        return resDTO;
    }

    @Override
    public LitigantInfoRequestDTO checkMdiator(List<LitigantInfoRequestDTO> mediatorList) {
        List mediatorUserIdEmptyList = mediatorList.stream().filter(o -> ObjectUtils.isEmpty((Object)o.getUserId()) || o.getUserId() != 0L).collect(Collectors.toList());
        AssertUtils.assertFalse((boolean)CollectionUtils.isEmpty(mediatorUserIdEmptyList), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u6cd5\u5b98\u4eba\u5458ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        DubboResult result = this.dataStatisticsCourtApi.userLoginInfo(JWTContextUtil.getCurrentUserId());
        LoginInfoResDTO loginInfoRes = (LoginInfoResDTO)result.getData();
        List mediatorCurrentList = mediatorList.stream().filter(o -> o.getUserId().equals(Long.valueOf(JWTContextUtil.getCurrentUserId()))).collect(Collectors.toList());
        if (loginInfoRes.getCourtSchedules() != null && loginInfoRes.getCourtSchedules() == 0) {
            AssertUtils.assertFalse((boolean)CollectionUtils.isEmpty(mediatorCurrentList), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u5f53\u524d\u7528\u6237\u5fc5\u987b\u4f5c\u4e3a\u6cd5\u5b98\u4eba\u5458");
            for (LitigantInfoRequestDTO m : mediatorCurrentList) {
                MediationMeetingUserInfoReqDTO mediator = this.userBackendService.getMediatorInfo(m.getUserId());
                AssertUtils.assertTrue((boolean)mediator.getUserName().equals(m.getUserName()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)(m.getUserName() + "\u7684\u59d3\u540d\u4fe1\u606f\u4e0d\u5339\u914d"));
                AssertUtils.assertTrue((boolean)mediator.getMobilePhone().equals(m.getMobilePhone()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)(m.getUserName() + "\u7684\u624b\u673a\u53f7\u4fe1\u606f\u4e0d\u5339\u914d"));
                m.setAuthStatus(mediator.getAuthStatus());
                m.setIdCard(mediator.getIdCard());
            }
            return (LitigantInfoRequestDTO)mediatorCurrentList.get(0);
        }
        return new LitigantInfoRequestDTO();
    }

    @Override
    public void addMediationRoomUser(AddMediationRoomUserRequestDTO dto) {
        List litigantList = dto.getList();
        this.registerLitigant(litigantList);
        AddMediationRoomUserReqDTO reqDTO = MediationRoomConvert.getAddMediationRoomUserReqDTO(dto);
        MediationMeetingUserInfoReqDTO mediator = this.userBackendService.getMediatorInfo(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        reqDTO.setMediator(mediator);
        DubboResult result = this.mediationRoomApi.addMediationRoomUser(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        DubboResult mediationResult = this.mediationRoomApi.getMediationMeetingRoomInfo(new CommonIdReqDTO(reqDTO.getMediationRoomId()));
        AssertUtils.assertTrue((mediationResult.isSuccess() && mediationResult.getData() != null ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        this.peaceSmsService.sendMediationRoomSms(litigantList, dto.getMediationRoomId(), ((MediationMeetingRoomInfoResDTO)mediationResult.getData()).getName(), (String)((Object)result.getData()), JWTContextUtil.getCurrentUserName(), 1);
    }

    @Override
    public void addMediationRoomUserMicro(AddMediationRoomUserMicroRequestDTO dto) {
        if (dto.getList() != null && dto.getList().size() > 0) {
            DTOCheckFieldConvert.checkLitigantInfoRequestDTO(dto.getList());
        }
        log.info("addMediationRoomUserMicro dto1: " + JSONObject.toJSONString((Object)dto));
        AssertUtils.assertFalse((CollectionUtils.isEmpty((Collection)dto.getMediatorList()) && CollectionUtils.isEmpty((Collection)dto.getList()) ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u65b0\u52a0\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a!");
        List addUserPhoneList = Lists.newArrayList();
        List allUserPhoneList = Lists.newArrayList();
        List agentPhoneList = Lists.newArrayList();
        List userList = Lists.newArrayList();
        List agentUserList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getMediatorList())) {
            List phones = dto.getMediatorList().stream().map(LitigantInfoRequestDTO::getMobilePhone).collect(Collectors.toList());
            addUserPhoneList.addAll(phones);
            allUserPhoneList.addAll(phones);
            userList.addAll(dto.getMediatorList());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getList())) {
            for (LitigantInfoRequestDTO u2 : dto.getList()) {
                if (Objects.isNull(u2.getPersonId())) {
                    addUserPhoneList.add(u2.getMobilePhone());
                    userList.add(u2);
                }
                if (!"1111".equals(u2.getMobilePhone()) && !StringUtils.isBlank((CharSequence)u2.getMobilePhone())) {
                    allUserPhoneList.add(u2.getMobilePhone());
                }
                if (Objects.isNull(u2.getUserAgentList())) continue;
                for (LitigantAgentInfoRequestDTO agent : u2.getUserAgentList()) {
                    if (agentPhoneList.contains(agent.getMobilePhone())) continue;
                    addUserPhoneList.add(agent.getMobilePhone());
                    allUserPhoneList.add(agent.getMobilePhone());
                    agentUserList.add(agent);
                    agentPhoneList.add(agent.getMobilePhone());
                }
            }
            AssertUtils.assertFalse((boolean)allUserPhoneList.stream().anyMatch(phone -> !Pattern.matches("^1[3-9]\\d{9}$", phone)), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u624b\u673a\u53f7\u7801\u683c\u5f0f\u6709\u8bef!");
            this.registerLitigantMicro(dto.getList());
        }
        log.info("addMediationRoomUserMicro dto2: " + JSONObject.toJSONString((Object)dto));
        log.info("addUserPhoneList: " + JSONObject.toJSONString((Object)addUserPhoneList));
        AssertUtils.assertTrue((addUserPhoneList.size() > 0 ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u8bf7\u6dfb\u52a0\u4eba\u5458!");
        HashSet allPhoneSet = new HashSet(allUserPhoneList);
        log.info("allPhoneSet: " + allPhoneSet);
        AssertUtils.assertTrue((allUserPhoneList.size() == allPhoneSet.size() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u6dfb\u52a0\u4eba\u5458\u624b\u673a\u53f7\u4e0d\u80fd\u91cd\u590d!");
        List<MediationRoomUserInfoRespDTO> roomUserInfoAllList = this.getMediationRoomUserInfoAllList(new CommonIdRequestDTO(dto.getMediationRoomId()));
        List oldPhoneList = roomUserInfoAllList.stream().map(MediationRoomUserInfoRespDTO::getMobilePhone).collect(Collectors.toList());
        List oldAgentPhoneList = roomUserInfoAllList.stream().filter(u -> u.getMeetingUserType().endsWith("_AGENT")).map(MediationRoomUserInfoRespDTO::getMobilePhone).collect(Collectors.toList());
        log.info("oldPhoneList: " + oldPhoneList);
        for (String phone2 : addUserPhoneList) {
            if ("1111".equals(phone2) || agentPhoneList.contains(phone2) && oldAgentPhoneList.contains(phone2)) continue;
            AssertUtils.assertFalse((boolean)oldPhoneList.contains(phone2), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)String.join((CharSequence)"", "\u624b\u673a\u53f7", phone2, "\u5728\u8be5\u6848\u4ef6\u7a7a\u95f4\u5df2\u5b58\u5728!"));
        }
        AddMediationRoomUserMicroReqDTO reqDTO = MediationRoomConvert.getAddMediationRoomUserMicroReqDTO(dto);
        MediationMeetingUserInfoReqDTO mediator = this.userBackendService.getMediatorInfo(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        reqDTO.setMediator(mediator);
        log.info("addMediationRoomUserMicro reqDTO: " + JSONObject.toJSONString((Object)reqDTO));
        DubboResult result = this.mediationRoomApi.addMediationRoomUserMicro(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        MediationMeetingRoomInfoResDTO meetingRoomInfo = this.mediationRoomDubboService.getMediationMeetingRoomInfo(dto.getMediationRoomId());
        if (CollectionUtils.isNotEmpty((Collection)dto.getMediatorList())) {
            this.peaceSmsService.sendStaffSms(dto.getMediatorList(), null, meetingRoomInfo.getName());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getList())) {
            if (CollectionUtils.isNotEmpty((Collection)agentUserList)) {
                List<LitigantInfoRequestDTO> agents = agentUserList.stream().map(a -> new LitigantInfoRequestDTO(a.getUserName(), a.getMobilePhone())).collect(Collectors.toList());
                this.peaceSmsService.sendMediationRoomSms(agents, dto.getMediationRoomId(), meetingRoomInfo.getName(), (String)((Object)result.getData()), JWTContextUtil.getCurrentUserName(), 1);
            }
            this.peaceSmsService.sendMediationRoomSms(userList, dto.getMediationRoomId(), meetingRoomInfo.getName(), (String)((Object)result.getData()), JWTContextUtil.getCurrentUserName(), 1);
        }
    }

    @Override
    public void closeMediationRoom(Long mediationRoomId) {
        CloseMediationRoomReqDTO reqDTO = new CloseMediationRoomReqDTO();
        reqDTO.setMediationRoomId(mediationRoomId);
        reqDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        reqDTO.setUserName(JWTContextUtil.getCurrentUserName());
        DubboResult result = this.mediationRoomApi.closeMediationRoom(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        this.unreadMessageApi.closeChatRoom((String)((Object)result.getData()));
        this.deleteVerificationCodes(mediationRoomId);
    }

    @Override
    public List<MediationRoomUserInfoResponseDTO> getMediationRoomUserInfoList(Long mediationRoomId) {
        DubboResult result = this.mediationRoomApi.getMediationRoomUserInfoList(mediationRoomId);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return MediationRoomConvert.getMediationRoomUserInfoResponseDTOList((ArrayList)result.getData());
    }

    @Override
    public MediationRoomPersonInfoResponseDTO getMediationRoomPerson(Long mediationRoomId) {
        DubboResult result = this.mediationRoomApi.getMediationRoomPerson(mediationRoomId);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        MediationRoomPersonInfoResponseDTO res = MediationRoomConvert.getMediationRoomPersonType((ArrayList)result.getData());
        return res;
    }

    @Override
    public void updateMediationRoomPersonType(UpdateMediationRoomPersonRequestDTO dto) {
        UpdateMediationRoomPersonReqDTO reqDTO = MediationRoomConvert.getUpdateMediationRoomPersonReqDTO(dto);
        DubboResult result = this.mediationRoomApi.updateMediationRoomPersonType(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
    }

    private void checkPhoneRepeat(List<LitigantInfoRequestDTO> litigantList, List<LitigantAgentInfoMicroRequestDTO> agentList) {
        List newList = Lists.newArrayList();
        int personCount = 0;
        if (litigantList != null) {
            newList.addAll(litigantList);
        }
        personCount = newList.size();
        Set collect = newList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getMobilePhone()) && !"1111".equals(a.getMobilePhone())).map(LitigantInfoRequestDTO::getMobilePhone).collect(Collectors.toSet());
        Set collect1 = new HashSet();
        if (agentList != null) {
            personCount += agentList.size();
            collect1 = agentList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getMobilePhone())).map(LitigantAgentInfoMicroRequestDTO::getMobilePhone).collect(Collectors.toSet());
        }
        collect1.addAll(collect);
        AssertUtils.assertTrue((personCount == collect1.size() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u6848\u4ef6\u4eba\u5458\u624b\u673a\u53f7\u91cd\u590d");
    }

    private void registerLitigant(List<LitigantInfoRequestDTO> litigantList) {
        for (LitigantInfoRequestDTO litigantInfo : litigantList) {
            if (!"1111".equals(litigantInfo.getMobilePhone()) && !StringUtils.isBlank((CharSequence)litigantInfo.getMobilePhone())) {
                this.registerLitigantInfo(litigantInfo);
            }
            if (CollectionUtils.isEmpty((Collection)litigantInfo.getUserAgentList())) continue;
            for (LitigantAgentInfoRequestDTO agentInfo : litigantInfo.getUserAgentList()) {
                this.registerLitigantAgentInfo(agentInfo);
            }
        }
    }

    private void registerLitigantMicro(List<LitigantInfoRequestDTO> litigantList) {
        for (LitigantInfoRequestDTO litigantInfo : litigantList) {
            if (!"1111".equals(litigantInfo.getMobilePhone()) && !StringUtils.isBlank((CharSequence)litigantInfo.getMobilePhone())) {
                this.registerLitigantInfo(litigantInfo);
            }
            if (CollectionUtils.isEmpty((Collection)litigantInfo.getUserAgentList())) continue;
            for (LitigantAgentInfoRequestDTO agentInfo : litigantInfo.getUserAgentList()) {
                this.registerLitigantAgentInfo(agentInfo);
            }
        }
    }

    private void registerLitigantInfo(LitigantInfoRequestDTO info) {
        MeetingUserTypeEnum userType = info.getMeetingUserType();
        String phone = info.getMobilePhone();
        if (WeitingshenUtil.getLitigatSet().contains(userType) && "1111".equals(phone)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)info.getUserName()) || StringUtils.isBlank((CharSequence)info.getMobilePhone())) {
            return;
        }
        DubboResult result = this.userServiceSecondApi.searchAndRegisterByMobileCommon(info.getMobilePhone(), info.getUserName());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        UserInfoDTO userInfo = (UserInfoDTO)result.getData();
        if (userInfo == null) {
            return;
        }
        info.setUserId(userInfo.getUserId());
        String errorMsg = "\u624b\u673a\u53f7:" + info.getMobilePhone() + "\u5df2\u5b9e\u540d,\u5b9e\u540d\u59d3\u540d\u4e0e\u8f93\u5165\u59d3\u540d\u4e0d\u7b26\u3002";
        AssertUtils.assertTrue((boolean)info.getUserName().equals(userInfo.getUserName()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)errorMsg);
        info.setUserName(userInfo.getUserName() == null ? info.getUserName() : userInfo.getUserName());
        info.setIdCard(userInfo.getIdCard());
        if (userInfo.getIsRealName().booleanValue() && userInfo.getIsFacialVerify().booleanValue()) {
            info.setAuthStatus(PeaceConst.AUTH_YES);
        } else {
            info.setAuthStatus(PeaceConst.AUTH_NO);
        }
    }

    private void registerAgentInfo(List<LitigantAgentInfoMicroRequestDTO> agentInfoList) {
        if (agentInfoList == null) {
            return;
        }
        for (LitigantAgentInfoMicroRequestDTO info : agentInfoList) {
            DubboResult result = this.userServiceSecondApi.searchAndRegisterByMobileCommon(info.getMobilePhone(), info.getUserName());
            AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
            UserInfoDTO userInfo = (UserInfoDTO)result.getData();
            info.setUserId(userInfo.getUserId());
            String errorMsg = "\u624b\u673a\u53f7:" + info.getMobilePhone() + "\u5df2\u5b9e\u540d,\u5b9e\u540d\u59d3\u540d\u4e0e\u8f93\u5165\u59d3\u540d\u4e0d\u7b26\u3002";
            AssertUtils.assertTrue((boolean)info.getUserName().equals(userInfo.getUserName()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)errorMsg);
            info.setUserName(StringUtils.isEmpty((CharSequence)userInfo.getUserName()) ? info.getUserName() : userInfo.getUserName());
            info.setIdCard(userInfo.getIdCard());
            if (userInfo.getIsRealName().booleanValue() && userInfo.getIsFacialVerify().booleanValue()) {
                info.setAuthStatus(PeaceConst.AUTH_YES);
                continue;
            }
            info.setAuthStatus(PeaceConst.AUTH_NO);
        }
    }

    private void registerLitigantAgentInfo(LitigantAgentInfoRequestDTO info) {
        DubboResult result = this.userServiceSecondApi.searchAndRegisterByMobileCommon(info.getMobilePhone(), info.getUserName());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        UserInfoDTO userInfo = (UserInfoDTO)result.getData();
        info.setUserId(userInfo.getUserId());
        String errorMsg = "\u624b\u673a\u53f7:" + info.getMobilePhone() + "\u5df2\u5b9e\u540d,\u5b9e\u540d\u59d3\u540d\u4e0e\u8f93\u5165\u59d3\u540d\u4e0d\u7b26\u3002";
        AssertUtils.assertTrue((boolean)info.getUserName().equals(userInfo.getUserName()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)errorMsg);
        info.setUserName(StringUtils.isEmpty((CharSequence)userInfo.getUserName()) ? info.getUserName() : userInfo.getUserName());
        info.setIdCard(userInfo.getIdCard());
        if (userInfo.getIsRealName().booleanValue() && userInfo.getIsFacialVerify().booleanValue()) {
            info.setAuthStatus(PeaceConst.AUTH_YES);
        } else {
            info.setAuthStatus(PeaceConst.AUTH_NO);
        }
    }

    @Override
    public List<MediationRoomUserInfoRespDTO> getMediationRoomUserInfoAllList(@Valid CommonIdRequestDTO dto) {
        String appName;
        DubboResult result = this.mediationRoomApi.getMediationRoomUserInfoAllList(dto.getId());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        List<MediationRoomUserInfoRespDTO> list = MediationRoomConvert.getMediationRoomUserInfoResponseDTOListNew((ArrayList)result.getData());
        String personType = JWTContextUtil.getPersonType();
        if (!"STAFF".equals(personType)) {
            return list;
        }
        this.redisTemplate = this.redisService.getRedisTemplate();
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        for (MediationRoomUserInfoRespDTO one : list) {
            String verificationCode = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_RELATION.name() + dto.getId() + "_" + one.getMobilePhone()));
            if (verificationCode == null) continue;
            one.setVerificationCode(verificationCode);
        }
        return list;
    }

    @Override
    public List<MediationRoomUserInfoNewRespDTO> getMediationRoomUserInfoAllListNew(@Valid CommonIdRequestDTO dto) {
        String appName;
        DubboResult result = this.mediationRoomApi.getMediationRoomUserInfoAllList(dto.getId());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        List<MediationRoomUserInfoNewRespDTO> list = MediationRoomConvert.getMediationRoomUserInfoResponseDTOListNew1((ArrayList)result.getData());
        String personType = JWTContextUtil.getPersonType();
        if (!"STAFF".equals(personType)) {
            return list;
        }
        this.redisTemplate = this.redisService.getRedisTemplate();
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        for (MediationRoomUserInfoNewRespDTO one : list) {
            String verificationCode = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_RELATION.name() + dto.getId() + "_" + one.getMobilePhone()));
            if (verificationCode == null) continue;
            one.setVerificationCode(verificationCode);
        }
        return list;
    }

    @Override
    public void deleteVerificationCodes(Long mediationRoomId) {
        String[] verificationCodeList;
        String appName;
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        this.redisTemplate = this.redisService.getRedisTemplate();
        String verificationCodes = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId));
        if (StringUtils.isBlank((CharSequence)verificationCodes)) {
            return;
        }
        for (String verificationCode : verificationCodeList = verificationCodes.split(",")) {
            this.redisTemplate.delete((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode));
        }
        this.redisTemplate.delete((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId));
    }

    @Override
    public List<MediationMeetingRoomResponseDTO> getMediationRoomMeetingList(@Valid CommonIdRequestDTO dto) {
        DubboResult dataRes = this.mediationRoomApi.getMediationRoomMeetingList(dto.getId());
        return (List)((Object)dataRes.getData());
    }

    @Override
    public MediationMeetingRoomResponseDTO getMediationRoomMeeting(Long id) {
        DubboResult dataRes = this.mediationRoomApi.getMediationRoomMeeting(id);
        AssertUtils.assertTrue((boolean)dataRes.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)dataRes.getMessage());
        return (MediationMeetingRoomResponseDTO)dataRes.getData();
    }

    @Override
    public void insertMediationRoomMore(MediationMeetingRoomMoreReqDto reqDto) {
        log.info("MediationMeetingRoomMoreReqDto :{}", (Object)JSON.toJSONString((Object)reqDto));
        DubboResult dataRes = this.mediationRoomApi.insertMediationRoomMore(reqDto);
        AssertUtils.assertTrue((boolean)dataRes.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)dataRes.getMessage());
    }

    @Override
    public void updateMediationRoomMore(Long mediationId, String orderTime, String orderEndTime, Integer leadTime, String courtRoomCode, String courtRoomName) {
        DubboResult dataRes = this.mediationRoomApi.updateMediationRoomMore(mediationId, orderTime, orderEndTime, leadTime, courtRoomCode, courtRoomName);
        AssertUtils.assertTrue((boolean)dataRes.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)dataRes.getMessage());
    }

    @Override
    public List<MediationRoomUserVideoQualityRespDTO> getUserVideoQuality(CommonIdRequestDTO dto) {
        List userVideoQuality = this.mediationRoomApi.getUserVideoQuality(dto.getId());
        if (CollectionUtils.isNotEmpty((Collection)userVideoQuality)) {
            for (MediationRoomUserVideoQualityRespDTO respDTO : userVideoQuality) {
                respDTO.setUserTypeAndName(MediationRoomServiceImpl.getUserIdentity(respDTO.getUserType()).concat("-").concat(respDTO.getUserName()));
            }
        }
        return userVideoQuality;
    }

    public static String getUserIdentity(String value) {
        switch (value) {
            case "CLERK": {
                return "\u4e66\u8bb0\u5458";
            }
            case "JUROR": {
                return "\u966a\u5ba1\u5458";
            }
            case "MEDIATOR": {
                return "\u5ba1\u5224\u5458";
            }
            case "MEDIATOR_HELP_TEMPORARY": {
                return "\u534f\u52a9\u6cd5\u5b98";
            }
            case "MEDIATOR_HELP": {
                return "\u534f\u52a9\u6cd5\u5b98";
            }
            case "ASSISTANT_JUDGE": {
                return "\u6cd5\u5b98\u52a9\u7406";
            }
            case "APPLICANT": {
                return "\u539f\u544a";
            }
            case "RESPONDENT": {
                return "\u88ab\u544a";
            }
            case "LITIGANT_THIRD": {
                return "\u7b2c\u4e09\u4eba";
            }
            case "APPLICANT_AGENT": {
                return "\u539f\u544a\u4ee3\u7406\u4eba";
            }
            case "RESPONDENT_AGENT": {
                return "\u88ab\u544a\u4ee3\u7406\u4eba";
            }
            case "PETITION_AGENT": {
                return "\u4fe1\u8bbf\u4ee3\u7406\u4eba";
            }
            case "LITIGANT": {
                return "\u5f53\u4e8b\u4eba";
            }
            case "LITIGANT_WITNESS": {
                return "\u8bc1\u4eba";
            }
            case "SECOND_APPLICANT": {
                return "\u4e0a\u8bc9\u4eba";
            }
            case "SECOND_RESPONDENT": {
                return "\u88ab\u4e0a\u8bc9\u4eba";
            }
            case "LITIGANT_SURVEYOR": {
                return "\u9274\u5b9a\u4eba";
            }
            case "LITIGANT_TRANSLATOR": {
                return "\u7ffb\u8bd1\u5458";
            }
            case "LITIGANT_THIRD_AGENT": {
                return "\u7b2c\u4e09\u4eba\u4ee3\u7406\u4eba";
            }
            case "OTHER": {
                return "\u4e34\u65f6\u5165\u4f1a\u4eba\u5458";
            }
        }
        return "";
    }
}

