/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beiming.basic.chat.api.RoomMediationApi;
import com.beiming.basic.chat.api.dto.request.CountRoomReqDTO;
import com.beiming.basic.chat.api.dto.request.ListUserRoomReqDTO;
import com.beiming.basic.chat.api.dto.response.MemberResDTO;
import com.beiming.basic.chat.api.dto.response.RoomInfoResDTO;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.enums.CTypeEnums;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.constants.MeetingUserTypeConst;
import com.beiming.odr.peace.common.constants.PeaceConst;
import com.beiming.odr.peace.common.enums.ColumnEnums;
import com.beiming.odr.peace.domain.dto.MeetingUserDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CourtInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.MyMediationRoomPageListRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.MyVideoMeetingPageListRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.RescheduleDto;
import com.beiming.odr.peace.domain.dto.requestdto.WaitHandlePageListRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.CourtPaymentResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationAndVideoCountResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MyMediationRoomPageListResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MyVideoMeetingPageListResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.VideoAndMediationRoomStatisticsResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.WaitHandlePageListResponseDTO;
import com.beiming.odr.peace.im.api.UnreadMessageApi;
import com.beiming.odr.peace.im.api.dto.response.SubjectUnreadCountResponseDTO;
import com.beiming.odr.peace.service.PersonalService;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.referee.api.CaseRoomMicroApi;
import com.beiming.odr.referee.api.MediationMeetingRoomApi;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.api.StatisticsApi;
import com.beiming.odr.referee.dto.requestdto.CaseListRoomReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingRoomListReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseRoomInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.LastMeetingByParentIdResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomUserInfoLeadResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingStayResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomStatisticsResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.referee.enums.ChatTypeEnum;
import com.beiming.odr.referee.enums.MediationMeetingRoomStatusEnum;
import com.beiming.odr.referee.enums.MediationMeetingTypeEnum;
import com.beiming.odr.referee.enums.RoomStatusEnums;
import com.beiming.odr.trial.api.TrialApi;
import com.beiming.odr.trial.api.dto.response.CaseInfoResponseDTO;
import com.beiming.odr.trial.api.dto.response.CaseOrderResponseDTO;
import com.beiming.odr.user.api.DictionaryServiceApi;
import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import com.beiming.odr.user.api.common.utils.Java8DateUtil;
import com.beiming.odr.user.api.dto.DictionaryInfoDTO;
import com.beiming.odr.user.api.dto.responsedto.CourtPaymentResDTO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.mortbay.log.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PersonalServiceImpl
implements PersonalService {
    private static final Logger log = LoggerFactory.getLogger(PersonalServiceImpl.class);
    @Resource
    private RoomMediationApi roomMediationApi;
    @Resource
    private UnreadMessageApi unreadMessageApi;
    @Resource
    private StatisticsApi statisticsApi;
    @Resource
    private TrialApi infoApi;
    @Resource
    private MediationMeetingRoomApi mediationMeetingRoomApi;
    @Resource
    private CaseRoomMicroApi caseRoomMicroApi;
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Resource
    private DictionaryServiceApi dictionaryServiceApi;
    @Resource
    private RedisService redisService;
    public static long timeout = 24L;
    public static TimeUnit unit = TimeUnit.HOURS;
    private static final String MEMBER_ROLE_TYPE_MASTER = "MASTER";
    private static final String MEMBER_ROLE_TYPE_NORMAL = "NORMAL";

    @Override
    public VideoAndMediationRoomStatisticsResponseDTO getVideoAndMediationRoomStatistics(String userId) {
        VideoAndMediationRoomStatisticsResponseDTO responseDTO = new VideoAndMediationRoomStatisticsResponseDTO();
        DubboResult mediationResult = this.statisticsApi.mediationRoomStatistics(Long.valueOf(userId));
        AssertUtils.assertTrue((boolean)mediationResult.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)mediationResult.getMessage());
        MediationRoomStatisticsResDTO mediationRoomStatisticsResDTO = (MediationRoomStatisticsResDTO)mediationResult.getData();
        if (mediationRoomStatisticsResDTO != null) {
            responseDTO.setMediationRoomAllCreateNum(Integer.valueOf(mediationRoomStatisticsResDTO.getAllCreateNum() == null ? 0 : mediationRoomStatisticsResDTO.getAllCreateNum()));
            responseDTO.setMediationRoomCloseNum(Integer.valueOf(mediationRoomStatisticsResDTO.getCloseNum() == null ? 0 : mediationRoomStatisticsResDTO.getCloseNum()));
            responseDTO.setMediationRoomCurrentMonthCloseNum(Integer.valueOf(mediationRoomStatisticsResDTO.getCurrentMonthCloseNum() == null ? 0 : mediationRoomStatisticsResDTO.getCurrentMonthCloseNum()));
            responseDTO.setMediationRoomCurrentMonthCreateNum(Integer.valueOf(mediationRoomStatisticsResDTO.getCurrentMonthCreateNum() == null ? 0 : mediationRoomStatisticsResDTO.getCurrentMonthCreateNum()));
            responseDTO.setMediationRoomCurrentWeekCloseNum(Integer.valueOf(mediationRoomStatisticsResDTO.getCurrentWeekCloseNum() == null ? 0 : mediationRoomStatisticsResDTO.getCurrentWeekCloseNum()));
            responseDTO.setMediationRoomCurrentWeekCreateNum(Integer.valueOf(mediationRoomStatisticsResDTO.getCurrentWeekCreateNum() == null ? 0 : mediationRoomStatisticsResDTO.getCurrentWeekCreateNum()));
            responseDTO.setMediationRoomStartNum(Integer.valueOf(mediationRoomStatisticsResDTO.getStartNum() == null ? 0 : mediationRoomStatisticsResDTO.getStartNum()));
        } else {
            responseDTO.setMediationRoomAllCreateNum(Integer.valueOf(0));
            responseDTO.setMediationRoomCloseNum(Integer.valueOf(0));
            responseDTO.setMediationRoomCurrentMonthCloseNum(Integer.valueOf(0));
            responseDTO.setMediationRoomCurrentMonthCreateNum(Integer.valueOf(0));
            responseDTO.setMediationRoomCurrentWeekCloseNum(Integer.valueOf(0));
            responseDTO.setMediationRoomCurrentWeekCreateNum(Integer.valueOf(0));
            responseDTO.setMediationRoomStartNum(Integer.valueOf(0));
        }
        DubboResult videoResult = this.statisticsApi.mediationMeetingStatistics(Long.valueOf(userId));
        AssertUtils.assertTrue((boolean)videoResult.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)videoResult.getMessage());
        MediationRoomStatisticsResDTO videoStatisticsResDTO = (MediationRoomStatisticsResDTO)videoResult.getData();
        if (videoStatisticsResDTO != null) {
            responseDTO.setVideoAllCreateNum(Integer.valueOf(videoStatisticsResDTO.getAllCreateNum() == null ? 0 : videoStatisticsResDTO.getAllCreateNum()));
            responseDTO.setVideoCloseNum(Integer.valueOf(videoStatisticsResDTO.getCloseNum() == null ? 0 : videoStatisticsResDTO.getCloseNum()));
            responseDTO.setVideoCurrentMonthCloseNum(Integer.valueOf(videoStatisticsResDTO.getCurrentMonthCloseNum() == null ? 0 : videoStatisticsResDTO.getCurrentMonthCloseNum()));
            responseDTO.setVideoCurrentMonthCreateNum(Integer.valueOf(videoStatisticsResDTO.getCurrentMonthCreateNum() == null ? 0 : videoStatisticsResDTO.getCurrentMonthCreateNum()));
            responseDTO.setVideoCurrentWeekCloseNum(Integer.valueOf(videoStatisticsResDTO.getCurrentWeekCloseNum() == null ? 0 : videoStatisticsResDTO.getCurrentWeekCloseNum()));
            responseDTO.setVideoCurrentWeekCreateNum(Integer.valueOf(videoStatisticsResDTO.getCurrentWeekCreateNum() == null ? 0 : videoStatisticsResDTO.getCurrentWeekCreateNum()));
            responseDTO.setVideoStartNum(Integer.valueOf(videoStatisticsResDTO.getStartNum() == null ? 0 : videoStatisticsResDTO.getStartNum()));
        } else {
            responseDTO.setVideoAllCreateNum(Integer.valueOf(0));
            responseDTO.setVideoCloseNum(Integer.valueOf(0));
            responseDTO.setVideoCurrentMonthCloseNum(Integer.valueOf(0));
            responseDTO.setVideoCurrentMonthCreateNum(Integer.valueOf(0));
            responseDTO.setVideoCurrentWeekCloseNum(Integer.valueOf(0));
            responseDTO.setVideoCurrentWeekCreateNum(Integer.valueOf(0));
            responseDTO.setVideoStartNum(Integer.valueOf(0));
        }
        return responseDTO;
    }

    @Override
    public List<MyMediationRoomPageListResponseDTO> getMyMediationRoomPageList(MyMediationRoomPageListRequestDTO listRequestDTO, String userId, String roleType) {
        List roomInfos;
        ArrayList<MyMediationRoomPageListResponseDTO> responseDTOs = new ArrayList<MyMediationRoomPageListResponseDTO>();
        CaseListRoomReqDTO reqDTO = new CaseListRoomReqDTO();
        reqDTO.setMemberId(userId);
        reqDTO.setMemberName(listRequestDTO.getMemberName());
        reqDTO.setCreatorType(listRequestDTO.getCreatorType());
        reqDTO.setBusinessRoomType(MediationMeetingTypeEnum.MEDIATION_ROOM.name());
        if (listRequestDTO.getRoomStatus().equals(RoomStatusEnums.RUNNING.name())) {
            reqDTO.setRoomStatus(MediationMeetingRoomStatusEnum.START.name());
        } else if (listRequestDTO.getRoomStatus().equals(RoomStatusEnums.END.name())) {
            reqDTO.setRoomStatus(MediationMeetingRoomStatusEnum.CLOSE.name());
        } else {
            reqDTO.setRoomStatus(listRequestDTO.getRoomStatus());
        }
        Log.info((String)"------------listRoom--------------------");
        DubboResult result = this.mediationMeetingRoomApi.listRoom(reqDTO);
        Log.info((String)"------------listRoom--------------------{}", (Object)result);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)result.getMessage());
        List list = roomInfos = result.getData() == null ? new ArrayList() : (List)((Object)result.getData());
        if (result.getData() == null) {
            Log.info((String)"------------result.getData() == null--------------------{}", (Object)result);
            return responseDTOs;
        }
        for (CaseRoomInfoResDTO roomInfo : roomInfos) {
            DubboResult caseInfo;
            MyMediationRoomPageListResponseDTO response = new MyMediationRoomPageListResponseDTO(roomInfo);
            if ("TDH_CASE".equals(roomInfo.getCreatorType())) {
                response.setCreatorType("\u5185\u7f51\u6848\u4ef6");
            } else if ("SYS_PLATFORM".equals(roomInfo.getCreatorType())) {
                response.setCreatorType("\u5e73\u53f0\u65b0\u5efa");
            }
            if (!StringUtils.isBlank((String)roomInfo.getThirdCaseId()) && (caseInfo = this.infoApi.selectCaseInfoByCaseId(roomInfo.getThirdCaseId())).getData() != null && !CollectionUtils.isEmpty((Collection)((CaseInfoResponseDTO)caseInfo.getData()).getCaseOrder())) {
                CaseOrderResponseDTO caseOrder = (CaseOrderResponseDTO)((CaseInfoResponseDTO)caseInfo.getData()).getCaseOrder().get(0);
                response.setHoldCourt(caseOrder.getDd());
            }
            if (!"END".equals(roomInfo.getRoomStatus())) {
                this.buildCaseRoomInfoResDTO(roomInfo.getBizRoomId(), response);
            }
            responseDTOs.add(response);
            System.out.println("caseRoomInfoRes.isReadNotification:=" + response.isReadNotification());
        }
        Log.info((String)"------------unreadCountResult--------------------");
        DubboResult unreadCountResult = this.unreadMessageApi.getUnreadCountByUserId(userId);
        Log.info((String)("------------unreadCountResult--------------------" + unreadCountResult));
        AssertUtils.assertTrue((boolean)unreadCountResult.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)unreadCountResult.getMessage());
        ArrayList unreadCounts = (ArrayList)unreadCountResult.getData();
        for (MyMediationRoomPageListResponseDTO response : responseDTOs) {
            for (SubjectUnreadCountResponseDTO unreadCount : unreadCounts) {
                if (!response.getBizRoomId().equals(unreadCount.getSubjectId())) continue;
                response.setUnreadMessageCount(Integer.valueOf(unreadCount.getUnreadCount()));
            }
            if (response.getUnreadMessageCount() != null) continue;
            response.setUnreadMessageCount(Integer.valueOf(0));
        }
        Log.info((String)"\u7ed3\u675f\u67e5\u8be2\u6570\u636e");
        return responseDTOs;
    }

    @Override
    public PageInfo<MyMediationRoomPageListResponseDTO> getMyMediationRoomPageInfo(MyMediationRoomPageListRequestDTO listRequestDTO, String userId, String roleType) {
        ArrayList<MyMediationRoomPageListResponseDTO> responseDTOs = new ArrayList<MyMediationRoomPageListResponseDTO>();
        CaseListRoomReqDTO reqDTO = new CaseListRoomReqDTO();
        reqDTO.setPageIndex(listRequestDTO.getPageIndex());
        reqDTO.setPageSize(listRequestDTO.getPageSize());
        reqDTO.setMemberId(userId);
        reqDTO.setMemberName(listRequestDTO.getMemberName());
        reqDTO.setCreatorType(listRequestDTO.getCreatorType());
        reqDTO.setBusinessRoomType(MediationMeetingTypeEnum.MEDIATION_ROOM.name());
        if (listRequestDTO.getRoomStatus().equals(RoomStatusEnums.RUNNING.name())) {
            reqDTO.setRoomStatus(MediationMeetingRoomStatusEnum.START.name());
        } else if (listRequestDTO.getRoomStatus().equals(RoomStatusEnums.END.name())) {
            reqDTO.setRoomStatus(MediationMeetingRoomStatusEnum.CLOSE.name());
        } else {
            reqDTO.setRoomStatus(listRequestDTO.getRoomStatus());
        }
        Log.info((String)"------------listRoom--------------------");
        DubboResult result = this.mediationMeetingRoomApi.pageInfoRoom(reqDTO);
        Log.info((String)"------------listRoom--------------------{}", (Object)result);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)result.getMessage());
        List roomInfos = ((PageInfo)result.getData()).getList();
        for (CaseRoomInfoResDTO roomInfo : roomInfos) {
            DubboResult caseInfo;
            MyMediationRoomPageListResponseDTO response = new MyMediationRoomPageListResponseDTO(roomInfo);
            if ("TDH_CASE".equals(roomInfo.getCreatorType())) {
                response.setCreatorType("\u5185\u7f51\u6848\u4ef6");
            } else if ("SYS_PLATFORM".equals(roomInfo.getCreatorType())) {
                response.setCreatorType("\u5e73\u53f0\u65b0\u5efa");
            }
            if (!StringUtils.isBlank((String)roomInfo.getThirdCaseId()) && (caseInfo = this.infoApi.selectCaseInfoByCaseId(roomInfo.getThirdCaseId())).getData() != null && !CollectionUtils.isEmpty((Collection)((CaseInfoResponseDTO)caseInfo.getData()).getCaseOrder())) {
                CaseOrderResponseDTO caseOrder = (CaseOrderResponseDTO)((CaseInfoResponseDTO)caseInfo.getData()).getCaseOrder().get(0);
                response.setHoldCourt(caseOrder.getDd());
            }
            if (!"END".equals(roomInfo.getRoomStatus())) {
                this.buildCaseRoomInfoResDTO(roomInfo.getBizRoomId(), response);
            }
            responseDTOs.add(response);
            System.out.println("caseRoomInfoRes.isReadNotification:=" + response.isReadNotification());
        }
        Log.info((String)"------------unreadCountResult--------------------");
        DubboResult unreadCountResult = this.unreadMessageApi.getUnreadCountByUserId(userId);
        Log.info((String)("------------unreadCountResult--------------------" + unreadCountResult));
        AssertUtils.assertTrue((boolean)unreadCountResult.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)unreadCountResult.getMessage());
        ArrayList unreadCounts = (ArrayList)unreadCountResult.getData();
        for (MyMediationRoomPageListResponseDTO response : responseDTOs) {
            for (SubjectUnreadCountResponseDTO unreadCount : unreadCounts) {
                if (!response.getBizRoomId().equals(unreadCount.getSubjectId())) continue;
                response.setUnreadMessageCount(Integer.valueOf(unreadCount.getUnreadCount()));
            }
            if (response.getUnreadMessageCount() != null) continue;
            response.setUnreadMessageCount(Integer.valueOf(0));
        }
        Log.info((String)"\u7ed3\u675f\u67e5\u8be2\u6570\u636e");
        return new PageInfo(responseDTOs, ((PageInfo)result.getData()).getTotalRows(), ((PageInfo)result.getData()).getPageIndex(), ((PageInfo)result.getData()).getPageSize());
    }

    void handleLeadTime(String appName, MyVideoMeetingPageListResponseDTO response, MediationMeetingRoomUserInfoLeadResDTO resDTO) {
        if (resDTO.getLeadTime() == null) {
            if (appName.contains("weitingshenhubei")) {
                response.setLeadTime(Integer.valueOf(30));
            } else {
                response.setLeadTime(Integer.valueOf(10));
            }
        } else {
            response.setLeadTime(resDTO.getLeadTime());
        }
    }

    @Override
    public List<MyVideoMeetingPageListResponseDTO> getMyVideoMeetingList(MyVideoMeetingPageListRequestDTO listRequestDTO, Long userId) {
        ArrayList<MyVideoMeetingPageListResponseDTO> responseDTOs = new ArrayList<MyVideoMeetingPageListResponseDTO>();
        MediationMeetingRoomListReqDTO mediationMeetingRoomListReqDTO = this.getMediationMeetingRoomListReqDTO(listRequestDTO, userId);
        DubboResult result = this.mediationMeetingRoomApi.getMediationMeetingRoomLeadList(mediationMeetingRoomListReqDTO);
        Log.info((String)("----------result---------" + JSON.toJSONString((Object)result.getData())));
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)result.getMessage());
        if (result.getData() == null) {
            return responseDTOs;
        }
        String appName = AppNameContextHolder.getAppName();
        for (MediationMeetingRoomUserInfoLeadResDTO resDTO : (ArrayList)result.getData()) {
            DubboResult caseInfo;
            MyVideoMeetingPageListResponseDTO response = new MyVideoMeetingPageListResponseDTO();
            this.handleLeadTime(appName, response, resDTO);
            response.setBizRoomId(resDTO.getId().toString());
            response.setRoomId(resDTO.getRoomId());
            response.setParentId(resDTO.getParentId());
            response.setRoomName(resDTO.getName());
            response.setRoomStatus(resDTO.getMediationStatus());
            response.setLastMessageTime(resDTO.getOrderTime());
            response.setCauseName(resDTO.getCauseName());
            if (resDTO.getAuthFlag() == PeaceConst.AUTH_YES.intValue()) {
                response.setAuthFlag(Boolean.valueOf(true));
            } else {
                response.setAuthFlag(Boolean.valueOf(false));
            }
            if (resDTO.getParentId() == null) {
                response.setInitiatingEntrance("\u5728\u7ebf\u5ead\u5ba1");
            } else {
                response.setInitiatingEntrance("\u6848\u4ef6\u7a7a\u95f4");
            }
            List userInfos = resDTO.getList();
            if (!CollectionUtils.isEmpty((Collection)userInfos)) {
                MeetingUserDTO meetingUser = this.setMediationRoomUser(userInfos);
                response.setJoinUserId(meetingUser.getJoinUserId());
                response.setJoinUserName(meetingUser.getJoinUserName());
                response.setJoinUserNumber(meetingUser.getJoinUserNumber());
                response.setStaff(meetingUser.getStaff());
                response.setLitigant(meetingUser.getLitigant());
            }
            if (resDTO.getExpandAttribute() != null) {
                String extInfo = resDTO.getExpandAttribute();
                JSONObject json = JSONObject.parseObject((String)extInfo);
                response.setCaseType(json.getString(ColumnEnums.CASE_TYPE.desc()));
                String caseName = StringUtils.isNotBlank((CharSequence)json.getString(ColumnEnums.CASE_NAME.desc())) ? json.getString(ColumnEnums.CASE_NAME.desc()) : resDTO.getName();
                response.setCaseName(caseName);
                response.setProcedure(json.getString(ColumnEnums.PROCEDURE.desc()));
                response.setUndertakeUser(json.getString(ColumnEnums.UNDERTAKE_USER.desc()));
                response.setUndertakeDepartment(json.getString(ColumnEnums.UNDERTAKE_DEPARTMENT.desc()));
                response.setUndertakeUserPhone(json.getString(ColumnEnums.UNDERTAKE_USER_PHONE.desc()));
                response.setSuperviseType(json.getString(ColumnEnums.SUPERVISE_TYPE.desc()));
                response.setSuperviseUser(json.getString(ColumnEnums.SUPERVISE_USER.desc()));
                response.setSuperviseUserPhone(json.getString(ColumnEnums.SUPERVISE_USER_PHONE.desc()));
            }
            if ("TDH_CASE".equals(resDTO.getCreatorType())) {
                response.setCreatorType("\u5185\u7f51\u6848\u4ef6");
            } else if ("SYS_PLATFORM".equals(resDTO.getCreatorType())) {
                response.setCreatorType("\u5e73\u53f0\u65b0\u5efa");
            } else if ("TDH_YAOHAO".equals(resDTO.getCreatorType())) {
                response.setCreatorType("TDH_YAOHAO");
            }
            if (resDTO.getOrderTime() != null) {
                response.setHoldCourtTime(resDTO.getOrderTime());
            }
            if (resDTO.getStartTime() != null) {
                response.setHoldCourtTime(resDTO.getStartTime());
            }
            if (resDTO.getCreatorId() != null && userId.toString().equals(resDTO.getCreatorId().toString())) {
                if (response.getRoomStatus().equals("END") || response.getRoomStatus().equals("INIT")) {
                    response.setIsMine(Boolean.valueOf(true));
                } else {
                    response.setIsMine(Boolean.valueOf(false));
                }
            } else {
                response.setIsMine(Boolean.valueOf(false));
            }
            response.setHoldCourtNum(resDTO.getScheduleId());
            if (!StringUtils.isBlank((String)resDTO.getThirdCaseId()) && (caseInfo = this.infoApi.selectCaseInfoByCaseId(resDTO.getThirdCaseId())).getData() != null && !CollectionUtils.isEmpty((Collection)((CaseInfoResponseDTO)caseInfo.getData()).getCaseOrder())) {
                CaseOrderResponseDTO caseOrder = (CaseOrderResponseDTO)((CaseInfoResponseDTO)caseInfo.getData()).getCaseOrder().get(0);
                response.setHoldCourt(caseOrder.getDd());
            }
            responseDTOs.add(response);
        }
        return responseDTOs;
    }

    private MediationMeetingRoomListReqDTO getMediationMeetingRoomListReqDTO(MyVideoMeetingPageListRequestDTO listRequestDTO, Long userId) {
        MediationMeetingRoomListReqDTO mediationMeetingRoomListReqDTO = new MediationMeetingRoomListReqDTO();
        if (listRequestDTO.getStartTime() != null && listRequestDTO.getEndTime() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat sdfEnd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            mediationMeetingRoomListReqDTO.setStartTime(sdf.format(listRequestDTO.getStartTime()));
            mediationMeetingRoomListReqDTO.setEndTime(sdfEnd.format(listRequestDTO.getEndTime()));
        }
        mediationMeetingRoomListReqDTO.setKeyword(listRequestDTO.getMemberName());
        mediationMeetingRoomListReqDTO.setMediationStatus(listRequestDTO.getRoomStatus());
        mediationMeetingRoomListReqDTO.setUserId(userId);
        mediationMeetingRoomListReqDTO.setCreatorType(listRequestDTO.getCreatorType());
        mediationMeetingRoomListReqDTO.setInitiatingEntrance(listRequestDTO.getInitiatingEntrance());
        return mediationMeetingRoomListReqDTO;
    }

    @Override
    public PageInfo<MyVideoMeetingPageListResponseDTO> getMyVideoMeetingPageList(MyVideoMeetingPageListRequestDTO listRequestDTO, Long userId) {
        ArrayList<MyVideoMeetingPageListResponseDTO> responseDTOs = new ArrayList<MyVideoMeetingPageListResponseDTO>();
        MediationMeetingRoomListReqDTO mediationMeetingRoomListReqDTO = new MediationMeetingRoomListReqDTO();
        if (listRequestDTO.getStartTime() != null && listRequestDTO.getEndTime() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat sdfEnd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            mediationMeetingRoomListReqDTO.setStartTime(sdf.format(listRequestDTO.getStartTime()));
            mediationMeetingRoomListReqDTO.setEndTime(sdfEnd.format(listRequestDTO.getEndTime()));
        }
        mediationMeetingRoomListReqDTO.setPageIndex(listRequestDTO.getPageIndex());
        mediationMeetingRoomListReqDTO.setPageSize(listRequestDTO.getPageSize());
        mediationMeetingRoomListReqDTO.setKeyword(listRequestDTO.getMemberName());
        mediationMeetingRoomListReqDTO.setMediationStatus(listRequestDTO.getRoomStatus());
        mediationMeetingRoomListReqDTO.setUserId(userId);
        mediationMeetingRoomListReqDTO.setCreatorType(listRequestDTO.getCreatorType());
        mediationMeetingRoomListReqDTO.setInitiatingEntrance(listRequestDTO.getInitiatingEntrance());
        mediationMeetingRoomListReqDTO.setRoleCodeList(listRequestDTO.getRoleCodeList());
        DubboResult result = this.mediationMeetingRoomApi.getMediationMeetingRoomPageInfoList(mediationMeetingRoomListReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)result.getMessage());
        if (result.getData() == null) {
            return new PageInfo(responseDTOs, 0, listRequestDTO.getPageIndex().intValue(), listRequestDTO.getPageSize().intValue());
        }
        String appName = AppNameContextHolder.getAppName();
        for (MediationMeetingRoomUserInfoLeadResDTO resDTO : ((PageInfo)result.getData()).getList()) {
            MyVideoMeetingPageListResponseDTO response = new MyVideoMeetingPageListResponseDTO();
            this.handleLeadTime(appName, response, resDTO);
            response.setBizRoomId(resDTO.getId().toString());
            response.setRoomId(resDTO.getRoomId());
            response.setParentId(resDTO.getParentId());
            response.setRoomName(resDTO.getName());
            response.setRoomStatus(resDTO.getMediationStatus());
            response.setLastMessageTime(resDTO.getOrderTime());
            if (resDTO.getStartTime() != null) {
                response.setOrderTime(Java8DateUtil.formatter((Date)resDTO.getStartTime(), (String)"yyyy-MM-dd HH:mm"));
            }
            response.setCauseName(resDTO.getCauseName());
            if (resDTO.getAuthFlag() == PeaceConst.AUTH_YES.intValue()) {
                response.setAuthFlag(Boolean.valueOf(true));
            } else {
                response.setAuthFlag(Boolean.valueOf(false));
            }
            if (resDTO.getParentId() == null) {
                response.setInitiatingEntrance("\u5728\u7ebf\u5ead\u5ba1");
            } else {
                response.setInitiatingEntrance("\u6848\u4ef6\u7a7a\u95f4");
            }
            List userInfos = resDTO.getList();
            if (!CollectionUtils.isEmpty((Collection)userInfos)) {
                MeetingUserDTO meetingUser = this.setMediationRoomUser(userInfos);
                response.setJoinUserId(meetingUser.getJoinUserId());
                response.setJoinUserName(meetingUser.getJoinUserName());
                response.setJoinUserNumber(meetingUser.getJoinUserNumber());
                response.setStaff(meetingUser.getStaff());
                response.setLitigant(meetingUser.getLitigant());
            }
            if (resDTO.getExpandAttribute() != null) {
                String extInfo = resDTO.getExpandAttribute();
                JSONObject json = JSONObject.parseObject((String)extInfo);
                response.setCaseType(json.getString(ColumnEnums.CASE_TYPE.desc()));
                String caseName = StringUtils.isNotBlank((CharSequence)json.getString(ColumnEnums.CASE_NAME.desc())) ? json.getString(ColumnEnums.CASE_NAME.desc()) : resDTO.getName();
                response.setCaseName(caseName);
                response.setProcedure(json.getString(ColumnEnums.PROCEDURE.desc()));
                response.setUndertakeUser(json.getString(ColumnEnums.UNDERTAKE_USER.desc()));
                response.setUndertakeDepartment(json.getString(ColumnEnums.UNDERTAKE_DEPARTMENT.desc()));
                response.setUndertakeUserPhone(json.getString(ColumnEnums.UNDERTAKE_USER_PHONE.desc()));
                response.setSuperviseType(json.getString(ColumnEnums.SUPERVISE_TYPE.desc()));
                response.setSuperviseUser(json.getString(ColumnEnums.SUPERVISE_USER.desc()));
                response.setSuperviseUserPhone(json.getString(ColumnEnums.SUPERVISE_USER_PHONE.desc()));
            }
            if ("TDH_CASE".equals(resDTO.getCreatorType())) {
                response.setCreatorType("\u5185\u7f51\u6848\u4ef6");
            } else if ("SYS_PLATFORM".equals(resDTO.getCreatorType())) {
                response.setCreatorType("\u5e73\u53f0\u65b0\u5efa");
            } else if ("TDH_YAOHAO".equals(resDTO.getCreatorType())) {
                response.setCreatorType("TDH_YAOHAO");
            }
            if (resDTO.getOrderTime() != null) {
                response.setHoldCourtTime(resDTO.getOrderTime());
            }
            if (resDTO.getStartTime() != null) {
                response.setHoldCourtTime(resDTO.getStartTime());
            }
            response.setMoreThan4Hours(resDTO.isMoreThan4Hours());
            if (resDTO.getCreatorId() != null && userId.toString().equals(resDTO.getCreatorId().toString())) {
                if (response.getRoomStatus().equals("END") || response.getRoomStatus().equals("INIT")) {
                    response.setIsMine(Boolean.valueOf(true));
                } else {
                    response.setIsMine(Boolean.valueOf(false));
                }
            } else {
                response.setIsMine(Boolean.valueOf(false));
            }
            response.setHoldCourtNum(resDTO.getScheduleId());
            this.getMoreThan4HoursList(userId, resDTO, response);
            responseDTOs.add(response);
        }
        return new PageInfo(responseDTOs, ((PageInfo)result.getData()).getTotalRows(), ((PageInfo)result.getData()).getPageIndex(), ((PageInfo)result.getData()).getPageSize());
    }

    private void getMoreThan4HoursList(Long userId, MediationMeetingRoomUserInfoLeadResDTO resDTO, MyVideoMeetingPageListResponseDTO response) {
        DubboResult caseInfo;
        if (!StringUtils.isBlank((String)resDTO.getThirdCaseId()) && (caseInfo = this.infoApi.selectCaseInfoByCaseId(resDTO.getThirdCaseId())).getData() != null && !CollectionUtils.isEmpty((Collection)((CaseInfoResponseDTO)caseInfo.getData()).getCaseOrder())) {
            CaseOrderResponseDTO caseOrder = (CaseOrderResponseDTO)((CaseInfoResponseDTO)caseInfo.getData()).getCaseOrder().get(0);
            response.setHoldCourt(caseOrder.getDd());
        }
        if (resDTO.isMoreThan4Hours()) {
            DubboResult moreThan4Hours = this.mediationMeetingRoomApi.getMeetingRoomListMoreThan4Hours(String.valueOf(userId), resDTO.getParentId());
            response.setMoreThan4HoursList((List)((Object)moreThan4Hours.getData()));
        }
    }

    public MeetingUserDTO setMediationRoomUser(List<MediationRoomUserInfoResDTO> list) {
        MeetingUserDTO result = new MeetingUserDTO();
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        ArrayList<Long> userIdList = new ArrayList<Long>();
        String staff = null;
        String litigant = null;
        String joinUserId = null;
        String joinUserName = null;
        String meetingUserType = null;
        String userName = null;
        for (MediationRoomUserInfoResDTO userInfo : list) {
            if (userIdList.contains(userInfo.getUserId())) continue;
            JSONObject json = new JSONObject();
            String unitNames = null;
            String creditCodes = null;
            if (userInfo.getExpandAttribute() != null) {
                json = JSONObject.parseObject((String)userInfo.getExpandAttribute());
                unitNames = json.getString(ColumnEnums.UNIT_NAME.desc());
                creditCodes = json.getString(ColumnEnums.CREDIT_CODE.desc());
            }
            if (unitNames != null && StringUtils.isNotEmpty(unitNames)) {
                joinUserId = (StringUtils.isBlank(joinUserId) ? "" : joinUserId + ",") + creditCodes;
                joinUserName = (StringUtils.isBlank(joinUserName) ? "" : joinUserName + ",") + unitNames;
            } else {
                joinUserId = (StringUtils.isBlank(joinUserId) ? "" : joinUserId + ",") + userInfo.getUserId();
                joinUserName = (StringUtils.isBlank(joinUserName) ? "" : joinUserName + ",") + userInfo.getUserName();
            }
            meetingUserType = userInfo.getMeetingUserType();
            if (!StringUtils.isBlank((String)meetingUserType)) {
                userName = unitNames != null ? unitNames + "\uff08" + MeetingUserTypeConst.getUserIdentity((String)this.getType(meetingUserType, json)) + "\uff09" : ("OTHER".equals(meetingUserType) ? userInfo.getUserName() : userInfo.getUserName() + "\uff08" + MeetingUserTypeConst.getUserIdentity((String)this.getType(meetingUserType, json)) + "\uff09");
                if (MeetingUserTypeConst.getUserTypeIsStaff((String)meetingUserType)) {
                    staff = (StringUtils.isBlank(staff) ? "" : staff + "\uff0c") + userName;
                } else {
                    litigant = (StringUtils.isBlank(litigant) ? "" : litigant + "\uff0c") + userName;
                }
            }
            userIdList.add(userInfo.getUserId());
        }
        result.setStaff(staff);
        result.setLitigant(litigant);
        result.setJoinUserId(joinUserId);
        result.setJoinUserName(joinUserName);
        result.setJoinUserNumber(Integer.valueOf(userIdList.size()));
        return result;
    }

    @Override
    public MediationAndVideoCountResponseDTO getMediationAndVideoCount(String userId, String roleType) {
        MediationAndVideoCountResponseDTO dto = new MediationAndVideoCountResponseDTO();
        CountRoomReqDTO countRoomReqDTO = new CountRoomReqDTO();
        countRoomReqDTO.setMemberId(userId);
        countRoomReqDTO.setBusinessRoomType(ChatTypeEnum.GROUP_CHAT.name());
        DubboResult mediationRoomCountResult = this.roomMediationApi.countRoom(countRoomReqDTO);
        AssertUtils.assertTrue((boolean)mediationRoomCountResult.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)mediationRoomCountResult.getMessage());
        dto.setMediationRoomCount(Integer.valueOf(mediationRoomCountResult.getData() == null ? 0 : (Integer)mediationRoomCountResult.getData()));
        DubboResult videoResult = this.statisticsApi.userMediationMeetingCount(Long.valueOf(userId));
        AssertUtils.assertTrue((boolean)videoResult.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)videoResult.getMessage());
        dto.setVideoMeetingCount(Integer.valueOf(videoResult.getData() == null ? 0 : (Integer)videoResult.getData()));
        return dto;
    }

    @Override
    public List<WaitHandlePageListResponseDTO> getWaitHandlePageList(WaitHandlePageListRequestDTO requestDTO, String cType, String userId, String roleType) {
        ArrayList<WaitHandlePageListResponseDTO> responseDTOs = new ArrayList<WaitHandlePageListResponseDTO>();
        if (CTypeEnums.PC.name().equals(cType)) {
            if (MediationMeetingTypeEnum.MEDIATION_MEETING.name().equalsIgnoreCase(requestDTO.getMediationMeetingType())) {
                return this.getVideoMeetingWaitHandlePageList(userId);
            }
            if (MediationMeetingTypeEnum.MEDIATION_ROOM.name().equalsIgnoreCase(requestDTO.getMediationMeetingType())) {
                return this.getMediationRoomWaitHandlePageList(userId, roleType);
            }
        } else {
            List<WaitHandlePageListResponseDTO> mediationRooms = this.getMediationRoomWaitHandlePageList(userId, roleType);
            List<WaitHandlePageListResponseDTO> videoMeetings = this.getVideoMeetingWaitHandlePageList(userId);
            responseDTOs.addAll(mediationRooms);
            responseDTOs.addAll(videoMeetings);
            responseDTOs.sort(Comparator.comparing(WaitHandlePageListResponseDTO::getLastMessageTime).reversed());
        }
        return responseDTOs;
    }

    private List<WaitHandlePageListResponseDTO> getMediationRoomWaitHandlePageList(String userId, String roleType) {
        ArrayList<WaitHandlePageListResponseDTO> responseDTOs = new ArrayList<WaitHandlePageListResponseDTO>();
        ListUserRoomReqDTO listUserRoomReqDTO = new ListUserRoomReqDTO();
        listUserRoomReqDTO.setMemberId(userId);
        if (RoleTypeEnum.MEDIATOR.name().equals(roleType) || RoleTypeEnum.SUPER_ADMIN.name().equals(roleType)) {
            listUserRoomReqDTO.setMemberRoleType(MEMBER_ROLE_TYPE_MASTER);
        } else {
            listUserRoomReqDTO.setMemberRoleType(MEMBER_ROLE_TYPE_NORMAL);
        }
        DubboResult result = this.roomMediationApi.userRoomStayList(listUserRoomReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)result.getMessage());
        ArrayList roomInfos = (ArrayList)result.getData();
        if (!CollectionUtils.isEmpty((Collection)roomInfos)) {
            for (RoomInfoResDTO roomInfo : roomInfos) {
                this.buildMembers(roomInfo);
                WaitHandlePageListResponseDTO response = new WaitHandlePageListResponseDTO(roomInfo);
                responseDTOs.add(response);
            }
        }
        return responseDTOs;
    }

    private List<WaitHandlePageListResponseDTO> getVideoMeetingWaitHandlePageList(String userId) {
        ArrayList<WaitHandlePageListResponseDTO> responseDTOs = new ArrayList<WaitHandlePageListResponseDTO>();
        DubboResult result = this.mediationMeetingRoomApi.userMeetingStayList(Long.valueOf(userId));
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)result.getMessage());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)result.getMessage());
        ArrayList mediationMeetingStayResDTOs = (ArrayList)result.getData();
        if (!CollectionUtils.isEmpty((Collection)mediationMeetingStayResDTOs)) {
            for (MediationMeetingStayResDTO mediationMeetingStayResDTO : mediationMeetingStayResDTOs) {
                WaitHandlePageListResponseDTO response = new WaitHandlePageListResponseDTO(mediationMeetingStayResDTO);
                responseDTOs.add(response);
            }
        }
        return responseDTOs;
    }

    public void buildMembers(RoomInfoResDTO roomInfo) {
        Long bizRoomId = Long.valueOf(roomInfo.getBizRoomId());
        DubboResult dubbboResult = this.mediationRoomApi.getMediationRoomUserInfoAllList(bizRoomId);
        ArrayList memberList = (ArrayList)dubbboResult.getData();
        if (dubbboResult == null || CollectionUtils.isEmpty((Collection)memberList)) {
            return;
        }
        HashSet<Long> userIds = new HashSet<Long>();
        ArrayList<MemberResDTO> members = new ArrayList<MemberResDTO>();
        MemberResDTO memberResDTO = null;
        for (MediationRoomUserInfoResDTO one : memberList) {
            JSONObject json;
            String unitName;
            if (one.getUserId() != null) {
                if (userIds.contains(one.getUserId())) continue;
                userIds.add(one.getUserId());
            }
            memberResDTO = new MemberResDTO();
            String expandAttribute = one.getExpandAttribute();
            String memberName = one.getUserName();
            if (!StringUtils.isBlank((String)expandAttribute) && !StringUtils.isBlank((String)(unitName = (json = JSONObject.parseObject((String)expandAttribute)).getString(ColumnEnums.UNIT_NAME.desc())))) {
                memberName = unitName;
            }
            if (one.getUserId() != null) {
                memberResDTO.setMemberId(one.getUserId().toString());
            }
            memberResDTO.setMemberName(memberName);
            members.add(memberResDTO);
        }
        if (members.size() > 0) {
            roomInfo.setMembers(members);
        }
    }

    public String getType(String type, JSONObject json) {
        if (json.get((Object)ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc()) != null && "APPLICANT".equals(type)) {
            type = "SECOND_APPLICANT";
        }
        if (json.get((Object)ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc()) != null && "RESPONDENT".equals(type)) {
            type = "SECOND_RESPONDENT";
        }
        return type;
    }

    public void buildCaseRoomInfoResDTO(String bizRoomId, MyMediationRoomPageListResponseDTO responseDTO) {
        if (bizRoomId == null || ((Boolean)responseDTO.getCanItEnd()).booleanValue()) {
            return;
        }
        DubboResult dubboResult = this.caseRoomMicroApi.getLastMeetingByParentId(Long.valueOf(bizRoomId));
        if (dubboResult == null || dubboResult.getData() == null) {
            return;
        }
        SimpleDateFormat startFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        LastMeetingByParentIdResDTO lastMeetingByParentIdResDTO = (LastMeetingByParentIdResDTO)dubboResult.getData();
        responseDTO.setHoldCourtNum(lastMeetingByParentIdResDTO.getScheduleId());
        String orderTime = "";
        if (lastMeetingByParentIdResDTO.getOrderTime() != null) {
            orderTime = startFormat.format(lastMeetingByParentIdResDTO.getOrderTime());
        }
        responseDTO.setHoldCourtTime(orderTime);
    }

    @Override
    public CourtPaymentResponseDTO getCourtPayment(CourtInfoRequestDTO reqDtO) {
        DubboResult dubboResult = this.dictionaryServiceApi.getDictionaryInfoByCode("COURT_PAYMENT_INFO");
        DictionaryInfoDTO dictionaryInfo = (DictionaryInfoDTO)dubboResult.getData();
        int num = Integer.parseInt(dictionaryInfo.getImgUrl());
        String popupBak = (String)this.redisService.get((RedisKey)RedisKeyEnums.USER_FIRST_POPUP_ERROR, reqDtO.getUserId() + reqDtO.getCourtCode());
        Boolean popupType = true;
        if (!StringUtils.isEmpty((String)popupBak)) {
            int count;
            int n = count = this.redisService.get((RedisKey)RedisKeyEnums.USER_FIRST_POPUP_COUNT, reqDtO.getUserId() + reqDtO.getCourtCode()) == null ? 0 : (Integer)this.redisService.get((RedisKey)RedisKeyEnums.USER_FIRST_POPUP_COUNT, reqDtO.getUserId() + reqDtO.getCourtCode());
            if (count >= num) {
                popupType = false;
            }
        }
        CourtPaymentResponseDTO courtPaymentResponse = new CourtPaymentResponseDTO();
        courtPaymentResponse.setCourtCode(reqDtO.getCourtCode());
        DubboResult dubbo = this.dictionaryServiceApi.getCourtPaymentInfo(reqDtO.getCourtCode());
        if (dubbo.getData() != null) {
            int dayNum = Integer.parseInt(dictionaryInfo.getRemark());
            CourtPaymentResDTO courtPaymentRes = (CourtPaymentResDTO)dubbo.getData();
            Date deadline = courtPaymentRes.getDeadline();
            Date date = new Date();
            courtPaymentResponse.setDeadline(deadline);
            if (date.getTime() > deadline.getTime()) {
                courtPaymentResponse.setRemindOrNot(Boolean.valueOf(true));
                courtPaymentResponse.setCanCreateMeeting(Boolean.valueOf(false));
                courtPaymentResponse.setContent(dictionaryInfo.getContent());
            } else if (PersonalServiceImpl.getDayDiff(date, deadline) < (long)dayNum && popupType.booleanValue()) {
                courtPaymentResponse.setRemindOrNot(Boolean.valueOf(true));
                courtPaymentResponse.setCanCreateMeeting(Boolean.valueOf(true));
                String value = dictionaryInfo.getValue();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
                String deadlineStr = sdf.format(deadline);
                courtPaymentResponse.setContent(value.replace("#date#", deadlineStr));
            } else {
                courtPaymentResponse.setRemindOrNot(Boolean.valueOf(false));
                courtPaymentResponse.setCanCreateMeeting(Boolean.valueOf(true));
                courtPaymentResponse.setContent(null);
            }
        } else {
            courtPaymentResponse.setRemindOrNot(Boolean.valueOf(false));
            courtPaymentResponse.setDeadline(null);
            courtPaymentResponse.setCanCreateMeeting(Boolean.valueOf(true));
            courtPaymentResponse.setContent(null);
        }
        if (courtPaymentResponse.getRemindOrNot().booleanValue()) {
            this.saveUserLoginErrorCount(reqDtO.getUserId(), reqDtO.getCourtCode());
        }
        return courtPaymentResponse;
    }

    @Override
    public String readNotification(Long caseId, String userId) {
        DubboResult stringDubboResult = this.mediationMeetingRoomApi.readNotification(caseId, userId);
        return (String)((Object)stringDubboResult.getData());
    }

    @Override
    public void closePopUupReminder(RescheduleDto dto) {
        this.mediationMeetingRoomApi.closePopUupReminder(dto.getIdList());
    }

    public static long getDayDiff(Date startDate, Date endDate) {
        long diff = endDate.getTime() - startDate.getTime();
        long day = diff / 1000L / 60L / 60L / 24L;
        return day;
    }

    public void saveUserLoginErrorCount(String userId, String courtCode) {
        String mobileBak = (String)this.redisService.get((RedisKey)RedisKeyEnums.USER_FIRST_POPUP_ERROR, userId + courtCode);
        if (StringUtils.isEmpty((String)mobileBak)) {
            this.redisService.set((RedisKey)RedisKeyEnums.USER_FIRST_POPUP_ERROR, userId + courtCode, (Object)userId, timeout, unit);
            this.redisService.set((RedisKey)RedisKeyEnums.USER_FIRST_POPUP_COUNT, userId + courtCode, (Object)1);
        } else {
            int count = this.redisService.get((RedisKey)RedisKeyEnums.USER_FIRST_POPUP_COUNT, userId + courtCode) == null ? 0 : (Integer)this.redisService.get((RedisKey)RedisKeyEnums.USER_FIRST_POPUP_COUNT, userId + courtCode);
            this.redisService.set((RedisKey)RedisKeyEnums.USER_FIRST_POPUP_COUNT, userId + courtCode, (Object)(++count));
        }
    }
}

