/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.beiming.basic.chat.api.RoomMediationApi;
import com.beiming.basic.chat.api.dto.response.OnLineMemberInfoResDTO;
import com.beiming.basic.chat.api.dto.response.ThirdPartyRoomMemberResDTO;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.context.DataSourceContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.framework.util.UUIDUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.utils.AESUtil;
import com.beiming.odr.peace.common.utils.SHAUtil;
import com.beiming.odr.peace.common.utils.sm4.SM4Utils;
import com.beiming.odr.peace.domain.dto.requestdto.ThirdCertificateRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ThirdPartyGetUserIdEequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ThirdPartyJoinRoomRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ThirdPartyLitigantRtcInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ThirdPartyRTCInfoResquestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ThirdPartyThirdCaseIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ThirdPatryCommonRoomIdRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.LoginTokenResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ThirdPartyGetRoomIdResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ThirdPartyGetUserIdResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ThirdPartyPlayUrlResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ThirdPartyRTCInfoResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ThirdPartyRoomMemberResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ThirdPartyUserPlayUrlResponseDTO;
import com.beiming.odr.peace.im.api.ThirdPartyRTCInfoApi;
import com.beiming.odr.peace.im.api.dto.request.RecordLiveRequestDTO;
import com.beiming.odr.peace.im.api.dto.response.ThirdPartyRTCInfoRespDTO;
import com.beiming.odr.peace.service.ThirdPartyService;
import com.beiming.odr.peace.service.UserService;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.peace.service.util.LoginErrorCountUtil;
import com.beiming.odr.peace.service.util.RTCPalyUrlUtils;
import com.beiming.odr.peace.service.util.TokenGeneratorParse;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingCreatorIdReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.ThirdPartyRoomInfoResDTO;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import com.beiming.odr.user.api.UserServiceApi;
import com.beiming.odr.user.api.UserServiceSecondApi;
import com.beiming.odr.user.api.UserServiceThirdApi;
import com.beiming.odr.user.api.common.enums.UserLoginTypeEnum;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.GetStaffPersonReqDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ThirdPartyServiceImpl
implements ThirdPartyService {
    private static final Logger log = Logger.getLogger(ThirdPartyServiceImpl.class);
    @Resource
    private UserService userService;
    @Resource
    private LoginErrorCountUtil loginErrorCountUtil;
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Resource
    private ThirdPartyRTCInfoApi thirdPartyRTCInfoApi;
    @Resource
    private RoomMediationApi roomMediationApi;
    @Resource
    private RedisService redisService;
    @Resource
    private UserServiceSecondApi userServiceSecondApi;
    @Resource
    private UserServiceThirdApi userServiceThirdApi;
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private TokenGeneratorParse tokenGeneratorParse;
    public static long timeout = 12L;
    public static TimeUnit unit = TimeUnit.HOURS;

    @Override
    public ThirdPartyGetRoomIdResponseDTO thirdPartyGetRoomId(String ah) {
        DubboResult roomIdResult = this.mediationRoomApi.thirdPartyGetRoomId(ah);
        AssertUtils.assertNotNull((Object)roomIdResult.getData(), (ResultCode)ErrorCode.THIRD_PARTY_IS_NULL, (String)ErrorCode.THIRD_PARTY_IS_NULL.desc());
        ThirdPartyGetRoomIdResponseDTO dto = new ThirdPartyGetRoomIdResponseDTO();
        dto.setRoomId((String)((Object)roomIdResult.getData()));
        return dto;
    }

    @Override
    public ThirdPartyRTCInfoResponseDTO thirdPartyRTCInfo(ThirdPartyRTCInfoResquestDTO dto) {
        ThirdPartyRTCInfoResponseDTO result = new ThirdPartyRTCInfoResponseDTO();
        DubboResult roomInfoResult = this.mediationRoomApi.thirdPartyGetRoom(dto.getAh(), "TDH_CASE");
        AssertUtils.assertNotNull((Object)roomInfoResult.getData(), (ResultCode)ErrorCode.THIRD_PARTY_IS_NULL, (String)ErrorCode.THIRD_PARTY_IS_NULL.desc());
        ThirdPartyRoomInfoResDTO roomInfo = (ThirdPartyRoomInfoResDTO)roomInfoResult.getData();
        result.setUserId(roomInfo.getUserId());
        DubboResult realRoomIdDubbo = this.roomMediationApi.getRealRoomId(roomInfo.getRoomId());
        AssertUtils.assertNotNull((Object)realRoomIdDubbo.getData(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        result.setRoomId((String)((Object)realRoomIdDubbo.getData()));
        DubboResult rtcInfoResult = this.thirdPartyRTCInfoApi.rtcInfo(roomInfo.getUserId(), (String)((Object)realRoomIdDubbo.getData()));
        AssertUtils.assertNotNull((Object)rtcInfoResult.getData(), (ResultCode)ErrorCode.THIRD_RTC_IS_NULL, (String)ErrorCode.THIRD_RTC_IS_NULL.desc());
        ThirdPartyRTCInfoRespDTO rtcInfo = (ThirdPartyRTCInfoRespDTO)rtcInfoResult.getData();
        result.setUserSig(rtcInfo.getUserSig());
        result.setSdkAppId(rtcInfo.getSdkAppId());
        result.setPrivateMapKey(rtcInfo.getPrivateMapKey());
        result.setAccountType(rtcInfo.getAccountType());
        return result;
    }

    @Override
    public ThirdPartyRoomMemberResponseDTO thirdPartygetUsers(ThirdPatryCommonRoomIdRequestDTO dto) {
        DubboResult realRoomIdDubbo = this.roomMediationApi.getRealRoomId(dto.getRoomId());
        AssertUtils.assertNotNull((Object)realRoomIdDubbo.getData(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        String realRoomId = (String)((Object)realRoomIdDubbo.getData());
        log.info((Object)("realRoomId:{}" + realRoomId));
        dto.setRoomId(realRoomId);
        ThirdPartyRoomMemberResponseDTO result = this.thirdPartyGetRoomMembers(dto);
        return result;
    }

    @Override
    public ThirdPartyRoomMemberResponseDTO thirdPartyGetRoomMembers(ThirdPatryCommonRoomIdRequestDTO dto) {
        DubboResult memebersDubbo = this.roomMediationApi.thirdPartyGetRoomInfo(dto.getRoomId());
        AssertUtils.assertNotNull((Object)memebersDubbo.getData(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        ThirdPartyRoomMemberResponseDTO result = ThirdPartyRoomMemberResponseDTO.copyMethod((ThirdPartyRoomMemberResDTO)((ThirdPartyRoomMemberResDTO)memebersDubbo.getData()));
        result.setRoomId(dto.getRoomId());
        return result;
    }

    @Override
    public ThirdPartyPlayUrlResponseDTO thirdPartyLiveUrl(ThirdPartyThirdCaseIdRequestDTO dto) {
        DubboResult meetingDubbo = this.mediationRoomApi.getMeetingCreatorId(dto.getThirdCaseId());
        AssertUtils.assertNotNull((Object)meetingDubbo.getData(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        ThirdPartyPlayUrlResponseDTO result = new ThirdPartyPlayUrlResponseDTO();
        ArrayList<ThirdPartyUserPlayUrlResponseDTO> livePlayUrls = new ArrayList<ThirdPartyUserPlayUrlResponseDTO>();
        MediationMeetingCreatorIdReqDTO meetingInfo = (MediationMeetingCreatorIdReqDTO)meetingDubbo.getData();
        result.setRoomId(meetingInfo.getRoomId());
        DubboResult roomUsers = this.mediationRoomApi.getMediationRoomUserInfoAllList(meetingInfo.getBizRoomId());
        if (!CollectionUtils.isEmpty((Collection)((Collection)((Object)roomUsers.getData())))) {
            ThirdPartyUserPlayUrlResponseDTO userPlayUrl = null;
            String userStreamName = null;
            boolean master = false;
            for (MediationRoomUserInfoResDTO roomUser : (ArrayList)roomUsers.getData()) {
                userStreamName = meetingInfo.getRoomId() + "_" + roomUser.getUserId();
                if (meetingInfo.getCreatorId().toString().equals(roomUser.getUserId().toString())) {
                    master = true;
                }
                if (dto.getMobilePhone().equals(roomUser.getMobilePhone())) {
                    String livePushUrl = "rtmp://livepusher.court.tutnet.com/live/" + userStreamName + "?" + RTCPalyUrlUtils.getSafeUrl(userStreamName);
                    result.setLivePushUrl(livePushUrl);
                    result.setName(roomUser.getUserName());
                    result.setUserId(roomUser.getUserId());
                    result.setIdentityId(roomUser.getIdCard());
                    result.setPositionName(this.meetingUserTypeStr(roomUser.getMeetingUserType()));
                    result.setMaster(Boolean.valueOf(master));
                    continue;
                }
                userPlayUrl = new ThirdPartyUserPlayUrlResponseDTO();
                userPlayUrl.setName(roomUser.getUserName());
                userPlayUrl.setIdentityId(roomUser.getIdCard());
                String liveUrl = "rtmp://liveplayer.court.tutnet.com/live/" + userStreamName;
                userPlayUrl.setLiveUrl(liveUrl);
                userPlayUrl.setPositionName(this.meetingUserTypeStr(roomUser.getMeetingUserType()));
                userPlayUrl.setUserId(roomUser.getUserId());
                userPlayUrl.setMaster(Boolean.valueOf(master));
                livePlayUrls.add(userPlayUrl);
            }
            result.setLivePlayUrls(livePlayUrls);
        }
        return result;
    }

    public String meetingUserTypeStr(String type) {
        if (MeetingUserTypeEnum.LITIGANT.toString().equals(type)) {
            return MeetingUserTypeEnum.LITIGANT.getName();
        }
        if (MeetingUserTypeEnum.MEDIATOR.toString().equals(type)) {
            return MeetingUserTypeEnum.MEDIATOR.getName();
        }
        if (MeetingUserTypeEnum.APPLICANT.toString().equals(type)) {
            return MeetingUserTypeEnum.APPLICANT.getName();
        }
        if (MeetingUserTypeEnum.RESPONDENT.toString().equals(type)) {
            return MeetingUserTypeEnum.RESPONDENT.getName();
        }
        if (MeetingUserTypeEnum.APPLICANT_AGENT.toString().equals(type)) {
            return MeetingUserTypeEnum.APPLICANT_AGENT.getName();
        }
        if (MeetingUserTypeEnum.RESPONDENT_AGENT.toString().equals(type)) {
            return MeetingUserTypeEnum.RESPONDENT_AGENT.getName();
        }
        if (MeetingUserTypeEnum.JUROR.toString().equals(type)) {
            return MeetingUserTypeEnum.JUROR.getName();
        }
        if (MeetingUserTypeEnum.LITIGANT_WITNESS.toString().equals(type)) {
            return MeetingUserTypeEnum.LITIGANT_WITNESS.getName();
        }
        if (MeetingUserTypeEnum.LITIGANT_THIRD.toString().equals(type)) {
            return MeetingUserTypeEnum.LITIGANT_THIRD.getName();
        }
        if (MeetingUserTypeEnum.JUDGE.toString().equals(type)) {
            return MeetingUserTypeEnum.JUDGE.getName();
        }
        if (MeetingUserTypeEnum.ASSISTANT_JUDGE.toString().equals(type)) {
            return MeetingUserTypeEnum.ASSISTANT_JUDGE.getName();
        }
        if (MeetingUserTypeEnum.CLERK.toString().equals(type)) {
            return MeetingUserTypeEnum.CLERK.getName();
        }
        return "";
    }

    @Override
    public List<OnLineMemberInfoResDTO> getOnLineMember(ThirdPatryCommonRoomIdRequestDTO dto) {
        ArrayList<OnLineMemberInfoResDTO> result = new ArrayList<OnLineMemberInfoResDTO>();
        DubboResult dubboResult = this.roomMediationApi.getOnLineMember(dto.getRoomId());
        AssertUtils.assertFalse((boolean)CollectionUtils.isEmpty((Collection)((Collection)((Object)dubboResult.getData()))), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        for (OnLineMemberInfoResDTO one : (ArrayList)dubboResult.getData()) {
            String roomId = dto.getRoomId();
            Long userId = one.getUserId();
            String redisKey = (String)this.redisService.get((RedisKey)RedisKeyEnums.THIRD_PARTY_KEY, roomId + userId);
            if (org.springframework.util.StringUtils.isEmpty((Object)redisKey)) continue;
            result.add(one);
        }
        return result;
    }

    @Override
    public void joinRoom(ThirdPartyJoinRoomRequestDTO dto) {
        String roomId = dto.getRoomId();
        Long userId = dto.getUserId();
        this.redisService.set((RedisKey)RedisKeyEnums.THIRD_PARTY_KEY, roomId + userId, (Object)userId.toString(), timeout, unit);
    }

    @Override
    public String startMixedFlow(RecordLiveRequestDTO dto) {
        DubboResult dubboResult = this.thirdPartyRTCInfoApi.startRecordLive(dto);
        return (String)((Object)dubboResult.getData());
    }

    @Override
    public ThirdPartyGetUserIdResponseDTO thirdPartyGetUserId(ThirdPartyGetUserIdEequestDTO dto) {
        DubboResult dubboResult = this.userServiceSecondApi.searchUserByMobile(dto.getMobilePhone());
        AssertUtils.assertFalse((boolean)CollectionUtils.isEmpty((Collection)((Collection)((Object)dubboResult.getData()))), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        ThirdPartyGetUserIdResponseDTO result = new ThirdPartyGetUserIdResponseDTO();
        for (UserInfoDTO userInfo : (ArrayList)dubboResult.getData()) {
            if (!"COMMON".equals(userInfo.getPersonType())) continue;
            result.setUserId(userInfo.getUserId());
        }
        return result;
    }

    @Override
    public ThirdPartyRTCInfoResponseDTO thirdPartyLitigantRtcInfo(ThirdPartyLitigantRtcInfoRequestDTO dto) {
        ThirdPartyRTCInfoResponseDTO result = new ThirdPartyRTCInfoResponseDTO();
        DubboResult rtcInfoResult = this.thirdPartyRTCInfoApi.rtcInfo(dto.getUserId(), dto.getRoomId());
        AssertUtils.assertNotNull((Object)rtcInfoResult.getData(), (ResultCode)ErrorCode.THIRD_RTC_IS_NULL, (String)ErrorCode.THIRD_RTC_IS_NULL.desc());
        ThirdPartyRTCInfoRespDTO rtcInfo = (ThirdPartyRTCInfoRespDTO)rtcInfoResult.getData();
        result.setUserSig(rtcInfo.getUserSig());
        result.setSdkAppId(rtcInfo.getSdkAppId());
        result.setPrivateMapKey(rtcInfo.getPrivateMapKey());
        result.setAccountType(rtcInfo.getAccountType());
        result.setUserId(dto.getUserId());
        result.setRoomId(dto.getRoomId());
        return result;
    }

    @Override
    public void sendBackRecordDoc() {
    }

    @Override
    public String getToken(String appId) {
        StringBuffer sb = new StringBuffer();
        sb.append(appId).append(UUIDUtils.uuidWithoutSeparator());
        String token = SHAUtil.getSHA256Str((String)sb.toString());
        this.redisService.getRedisTemplate().opsForValue().set((Object)("THIRD_PARTY_TOKEN_" + appId), (Object)token, 30L, TimeUnit.MINUTES);
        log.info((Object)("===============token=========================" + token));
        return token;
    }

    @Override
    public String obtainCertificate(String params, HttpServletRequest request) {
        log.info((Object)("===============params=========================" + params));
        String token = request.getHeader("token");
        log.info((Object)("===============token=========================" + token));
        Object jwtToken = null;
        params = params.replace(' ', '+');
        ThirdCertificateRequestDTO thirdCertificateRequestDTO = (ThirdCertificateRequestDTO)JSON.parseObject((String)AESUtil.decrypt((String)params, (String)"hngs@*HLWKT#2024"), ThirdCertificateRequestDTO.class);
        this.checkThirdCertificate(thirdCertificateRequestDTO);
        GetStaffPersonReqDTO getStaffPersonReqDTO = new GetStaffPersonReqDTO();
        getStaffPersonReqDTO.setUsername(thirdCertificateRequestDTO.getUserName());
        getStaffPersonReqDTO.setMobilePhone(thirdCertificateRequestDTO.getMobilePhone());
        getStaffPersonReqDTO.setPersonType(thirdCertificateRequestDTO.getPersonType());
        AppNameContextHolder.setAppName((String)"weitingshenhubei");
        DataSourceContextHolder.setDBByAppName((String)"weitingshenhubei");
        DubboResult personDubboResult = this.userServiceApi.selectUserByNameAndPhone(getStaffPersonReqDTO);
        AssertUtils.assertTrue((boolean)personDubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)personDubboResult.getMessage());
        ArrayList data = (ArrayList)personDubboResult.getData();
        if (Objects.isNull(data) || data.size() == 0) {
            DubboResult dubboResult = this.userServiceApi.selectMobilePhoneAndPersonType(thirdCertificateRequestDTO.getMobilePhone(), thirdCertificateRequestDTO.getPersonType());
            System.out.println((Integer)dubboResult.getData() > 0);
            AssertUtils.assertTrue((dubboResult.isSuccess() && (Integer)dubboResult.getData() == 0 ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u8be5\u624b\u673a\u53f7\u7801\u5df2\u88ab\u4ed6\u4eba\u5728\u4e92\u8054\u7f51\u5f00\u5ead\u5e73\u53f0\u6ce8\u518c\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\u6838\u67e5\u662f\u5426\u624b\u673a\u53f7\u4e3a\u672c\u4eba");
            DubboResult result = this.userServiceThirdApi.thirdRegisterByMobile(thirdCertificateRequestDTO.getPersonType(), thirdCertificateRequestDTO.getMobilePhone(), thirdCertificateRequestDTO.getUserName(), "HAINAN_THIRD_DOCK", thirdCertificateRequestDTO.getOrgId(), thirdCertificateRequestDTO.getOrgName());
            AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u4eba\u5458\u5bf9\u63a5\u65b0\u589e\u5931\u8d25");
        }
        UserLoginTypeEnum loginType = "STAFF".equals(thirdCertificateRequestDTO.getPersonType()) ? UserLoginTypeEnum.WORK_USER_LOGIN_TYPE : UserLoginTypeEnum.COMMON_USER_LOGIN_TYPE;
        DubboResult loginInfoResult = this.userServiceApi.userLoginByMobileAndType(thirdCertificateRequestDTO.getMobilePhone(), loginType);
        AssertUtils.assertTrue((boolean)loginInfoResult.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)loginInfoResult.getMessage());
        LoginTokenResponseDTO responseDTO = this.tokenGeneratorParse.generateLoginToken((LoginInfoResDTO)loginInfoResult.getData(), request.getHeader("cType"), null);
        JSONObject json = new JSONObject();
        json.put("token", (Object)responseDTO.getAuthToken());
        responseDTO.setAuthToken("");
        responseDTO.setRefreshToken("");
        String jsonString = JSON.toJSONString((Object)responseDTO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        JSON.toJSONString((Object)jsonString, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        json.put("info", (Object)SM4Utils.encryptDataCbc((String)jsonString));
        return json.toJSONString();
    }

    @Override
    public LoginTokenResponseDTO obtainCertificateWeChat(String params, HttpServletRequest request) {
        log.info((Object)("===============params=========================" + params));
        String token = request.getHeader("token");
        log.info((Object)("===============token=========================" + token));
        Object jwtToken = null;
        params = params.replace(' ', '+');
        ThirdCertificateRequestDTO thirdCertificateRequestDTO = (ThirdCertificateRequestDTO)JSON.parseObject((String)AESUtil.decrypt((String)params, (String)"hngs@*HLWKT#2024"), ThirdCertificateRequestDTO.class);
        this.checkThirdCertificate(thirdCertificateRequestDTO);
        GetStaffPersonReqDTO getStaffPersonReqDTO = new GetStaffPersonReqDTO();
        getStaffPersonReqDTO.setUsername(thirdCertificateRequestDTO.getUserName());
        getStaffPersonReqDTO.setMobilePhone(thirdCertificateRequestDTO.getMobilePhone());
        getStaffPersonReqDTO.setPersonType(thirdCertificateRequestDTO.getPersonType());
        AppNameContextHolder.setAppName((String)"weitingshenhubei");
        DataSourceContextHolder.setDBByAppName((String)"weitingshenhubei");
        DubboResult personDubboResult = this.userServiceApi.selectUserByNameAndPhone(getStaffPersonReqDTO);
        AssertUtils.assertTrue((boolean)personDubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)personDubboResult.getMessage());
        ArrayList data = (ArrayList)personDubboResult.getData();
        if (Objects.isNull(data) || data.size() == 0) {
            DubboResult dubboResult = this.userServiceApi.selectMobilePhoneAndPersonType(thirdCertificateRequestDTO.getMobilePhone(), thirdCertificateRequestDTO.getPersonType());
            System.out.println((Integer)dubboResult.getData() > 0);
            AssertUtils.assertTrue((dubboResult.isSuccess() && (Integer)dubboResult.getData() == 0 ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u8be5\u624b\u673a\u53f7\u7801\u5df2\u88ab\u4ed6\u4eba\u5728\u4e92\u8054\u7f51\u5f00\u5ead\u5e73\u53f0\u6ce8\u518c\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\u6838\u67e5\u662f\u5426\u624b\u673a\u53f7\u4e3a\u672c\u4eba");
            DubboResult result = this.userServiceThirdApi.thirdRegisterByMobile(thirdCertificateRequestDTO.getPersonType(), thirdCertificateRequestDTO.getMobilePhone(), thirdCertificateRequestDTO.getUserName(), "HAINAN_THIRD_DOCK", thirdCertificateRequestDTO.getOrgId(), thirdCertificateRequestDTO.getOrgName());
            AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u4eba\u5458\u5bf9\u63a5\u65b0\u589e\u5931\u8d25");
        }
        UserLoginTypeEnum loginType = "STAFF".equals(thirdCertificateRequestDTO.getPersonType()) ? UserLoginTypeEnum.WORK_USER_LOGIN_TYPE : UserLoginTypeEnum.COMMON_USER_LOGIN_TYPE;
        DubboResult loginInfoResult = this.userServiceApi.userLoginByMobileAndType(thirdCertificateRequestDTO.getMobilePhone(), loginType);
        AssertUtils.assertTrue((boolean)loginInfoResult.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)loginInfoResult.getMessage());
        LoginInfoResDTO loginInfoResDTO = (LoginInfoResDTO)loginInfoResult.getData();
        LoginTokenResponseDTO responseDTO = this.tokenGeneratorParse.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), null);
        Long orgId = ((UserRoleInfoDTO)loginInfoResDTO.getUserRoles().get(0)).getOrganizationId();
        Long userId = loginInfoResDTO.getUserInfo().getUserId();
        responseDTO.setShowInnerCaseFlag(Boolean.valueOf(this.userService.isShowInnerCase(orgId, userId)));
        if (responseDTO != null) {
            this.checkLoginOk(thirdCertificateRequestDTO.getMobilePhone(), loginType.name());
        }
        responseDTO.setScreenLayout(this.userService.screenLayout(orgId));
        return responseDTO;
    }

    private void checkThirdCertificate(ThirdCertificateRequestDTO thirdCertificateRequestDTO) {
        ArrayList<String> errorList = new ArrayList<String>();
        String userName = thirdCertificateRequestDTO.getUserName();
        String mobilePhone = thirdCertificateRequestDTO.getMobilePhone();
        String sex = thirdCertificateRequestDTO.getSex();
        String orgId = thirdCertificateRequestDTO.getOrgId();
        String orgName = thirdCertificateRequestDTO.getOrgName();
        String personType = thirdCertificateRequestDTO.getPersonType();
        if (StringUtils.isBlank((String)userName)) {
            errorList.add("\u5f53\u4e8b\u4eba\u6216\u8005\u6cd5\u5b98\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)mobilePhone)) {
            errorList.add("\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            String regex = "^1[3-9]\\d{9}$";
            if (!mobilePhone.matches(regex)) {
                errorList.add("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42");
            }
        }
        if (StringUtils.isBlank((String)personType)) {
            errorList.add("\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        } else if ("STAFF".equals(personType)) {
            if (StringUtils.isBlank((String)orgId)) {
                errorList.add("\u5de5\u4f5c\u4eba\u5458\u7684\u6cd5\u9662\u56db\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)orgName)) {
                errorList.add("\u5de5\u4f5c\u4eba\u5458\u7684\u6cd5\u9662\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        AssertUtils.assertTrue((errorList.size() == 0 ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)Joiner.on((String)",").join(errorList));
    }

    public void checkLoginOk(String mobile, String loginType) {
        int count;
        String mobileBak = (String)this.redisService.get((RedisKey)RedisKeyEnums.USER_FIRST_LOGIN_ERROR, mobile + loginType);
        int n = count = this.redisService.get((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType) == null ? 0 : (Integer)this.redisService.get((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)mobileBak) && count < 5) {
            this.loginErrorCountUtil.deleteUserLoginErrorCount(mobile, loginType);
        }
    }
}

