/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.document.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.document.api.AttachmentApi;
import com.beiming.odr.document.api.DocRecordApi;
import com.beiming.odr.document.dto.requestdto.AttachmentListReqDTO;
import com.beiming.odr.document.dto.requestdto.DelFileReqDTO;
import com.beiming.odr.document.dto.requestdto.IdReqDTO;
import com.beiming.odr.document.dto.requestdto.ObjectBizRoomReqDTO;
import com.beiming.odr.document.dto.requestdto.ObjectReqDTO;
import com.beiming.odr.document.dto.responsedto.DocAttachmentResDTO;
import com.beiming.odr.document.enums.ObjectTypeEnum;
import com.beiming.odr.peace.common.enums.AttachmentEnum;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.utils.HttpClientUtils;
import com.beiming.odr.peace.domain.dto.requestdto.CommonFileInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DelAttachmentRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DocumentRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.QueryAttachmentListReqDTO;
import com.beiming.odr.peace.domain.dto.responsedto.DocumentResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.IntranetDocumentResponseDTO;
import com.beiming.odr.peace.service.backend.document.AttachmentDubboService;
import com.beiming.odr.peace.service.convert.AttachmentConvert;
import com.beiming.odr.peace.service.convert.ReprotConvert;
import com.beiming.odr.referee.api.MediationInfoApi;
import com.beiming.odr.referee.api.MediationRoomApi;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class AttachmentDubboServiceImpl
implements AttachmentDubboService {
    private static final Logger log = LoggerFactory.getLogger(AttachmentDubboServiceImpl.class);
    @Resource
    private AttachmentApi attachmentApi;
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Value(value="${evaluate.context}")
    private String evaluateContext;
    @Value(value="${evaluate.userName}")
    private String evaluateUserName;
    @Value(value="${evaluate.password}")
    private String evaluatePassword;
    @Value(value="${fileInfo.systemId}")
    private String systemId;
    @Value(value="${fileInfo.tdhyhId}")
    private String tdhyhId;
    @Resource
    private MediationInfoApi mediationInfoApi;
    @Resource
    private DocRecordApi docRecordApi;
    private static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();
    private static String encoding = "UTF-8";

    @Override
    public DocAttachmentResDTO getAttachment(CommonFileInfoRequestDTO commonFileInfoRequestDTO) {
        IdReqDTO docIdReqDTO = new IdReqDTO(commonFileInfoRequestDTO.getId());
        DubboResult result = this.attachmentApi.getAttachment(docIdReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (DocAttachmentResDTO)result.getData();
    }

    @Override
    @Transactional
    public void delAttachment(CommonIdRequestDTO commonIdRequestDTO) {
        DelFileReqDTO delFileReqDTO = new DelFileReqDTO();
        delFileReqDTO.setAttachId(commonIdRequestDTO.getId());
        delFileReqDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        IdReqDTO idReqDTO = new IdReqDTO();
        idReqDTO.setId(commonIdRequestDTO.getId());
        DubboResult attachment = this.attachmentApi.getAttachmentById(commonIdRequestDTO.getId());
        AssertUtils.assertTrue((boolean)attachment.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)attachment.getMessage());
        AssertUtils.assertTrue((boolean)attachment.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)attachment.getMessage());
        DocAttachmentResDTO data = (DocAttachmentResDTO)attachment.getData();
        if ("weitingshenhubei".equals(AppNameContextHolder.getAppName())) {
            if (data != null) {
                this.attachmentApi.delAttachment(delFileReqDTO);
            }
            if (data != null && "INTRANET_MATERIALS".equals(((DocAttachmentResDTO)attachment.getData()).getObjectType())) {
                DubboResult integerDubboResult = this.mediationRoomApi.updateIntranetAttachment(commonIdRequestDTO.getId(), AttachmentEnum.INTERNET.name());
                AssertUtils.assertTrue((boolean)integerDubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)integerDubboResult.getMessage());
            } else {
                DubboResult integerDubboResult = this.mediationRoomApi.updateIntranetAttachment(commonIdRequestDTO.getId(), AttachmentEnum.INTRANET.name());
                AssertUtils.assertTrue((boolean)integerDubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)integerDubboResult.getMessage());
            }
        } else if (data != null) {
            this.attachmentApi.delAttachment(delFileReqDTO);
        } else {
            AssertUtils.assertTrue((data != null ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u8d44\u6e90\u672a\u627e\u5230");
        }
    }

    @Override
    public void delIntranetAttachment(DelAttachmentRequestDTO dto) {
        if (AttachmentEnum.INTERNET.name().equals(dto.getFlag())) {
            DelFileReqDTO delFileReqDTO = new DelFileReqDTO();
            delFileReqDTO.setAttachId(dto.getId());
            this.attachmentApi.delAttachment(delFileReqDTO);
        }
        this.mediationRoomApi.updateIntranetAttachment(dto.getId(), dto.getFlag());
    }

    @Override
    public ArrayList<DocumentResponseDTO> queryAttachmentList(DocumentRequestDTO requestDTO) {
        AttachmentListReqDTO reqDTO = new AttachmentListReqDTO();
        reqDTO.setObjectId(requestDTO.getBizId());
        reqDTO.setObjectType(null);
        reqDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        reqDTO.setCategoryBigTypeEnum(ObjectUtils.isEmpty((Object)requestDTO.getCategoryBigTypeEnum()) ? null : requestDTO.getCategoryBigTypeEnum().name());
        reqDTO.setCategoryMiddleTypeEnum(ObjectUtils.isEmpty((Object)requestDTO.getCategoryMiddleTypeEnum()) ? null : requestDTO.getCategoryMiddleTypeEnum().name());
        DubboResult result = this.attachmentApi.queryAttachmentList((ObjectReqDTO)reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        ArrayList res = (ArrayList)result.getData();
        ArrayList responseLstDTO = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)res)) {
            responseLstDTO = res.stream().map(AttachmentConvert::convertDocAttachmentResDTO).collect(Collectors.toCollection(ArrayList::new));
        }
        return responseLstDTO;
    }

    @Override
    public DocumentResponseDTO getTemplate(Long bizRoomId) {
        DocumentResponseDTO documentResponseDTO = new DocumentResponseDTO();
        DubboResult result2 = this.mediationRoomApi.judgeCaseTdhyh(bizRoomId);
        AssertUtils.assertTrue((boolean)result2.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result2.getMessage());
        if (!((Boolean)result2.getData()).booleanValue()) {
            documentResponseDTO.setDocId(null);
            documentResponseDTO.setDocFileId(this.systemId);
            documentResponseDTO.setDocName("\u5e73\u53f0\u521b\u5efa\u6848\u4ef6\u6a21\u677f.docx");
        } else {
            documentResponseDTO.setDocId(null);
            documentResponseDTO.setDocFileId(this.tdhyhId);
            documentResponseDTO.setDocName("\u901a\u8fbe\u6d77\u6447\u53f7\u6848\u4ef6\u6a21\u677f.docx");
        }
        return documentResponseDTO;
    }

    @Override
    public ArrayList<DocumentResponseDTO> queryAttachmentList(QueryAttachmentListReqDTO dto, HttpServletRequest request) {
        ArrayList<Object> outList = new ArrayList<Object>();
        DubboResult result = null;
        String sign = dto.getSign();
        if ("1".equals(sign)) {
            ObjectBizRoomReqDTO bizRoomReqDTO = new ObjectBizRoomReqDTO();
            bizRoomReqDTO.setObjectId(dto.getId());
            bizRoomReqDTO.setBizRoomId(dto.getBizRoomId());
            bizRoomReqDTO.setObjectType(ObjectTypeEnum.MEDIATION.name());
            result = this.attachmentApi.queryAllAttachmentList(bizRoomReqDTO);
            AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        } else {
            ObjectReqDTO objectReqDTO = new ObjectReqDTO();
            objectReqDTO.setObjectId(dto.getId());
            objectReqDTO.setObjectType(ObjectTypeEnum.MEDIATION.name());
            objectReqDTO.setFlag(dto.getFlag());
            result = this.attachmentApi.queryAttachmentList(objectReqDTO);
            AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        }
        ArrayList responseLstDTO = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)((Collection)((Object)result.getData())))) {
            responseLstDTO = ((ArrayList)result.getData()).stream().map(AttachmentConvert::getDocumentListResponseDTO).collect(Collectors.toCollection(ArrayList::new));
        }
        DocumentResponseDTO documentResponseDTO = new DocumentResponseDTO();
        DubboResult result2 = this.mediationRoomApi.judgeCaseTdhyh(dto.getBizRoomId());
        AssertUtils.assertTrue((boolean)result2.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result2.getMessage());
        if ("1".equals(sign)) {
            if (!((Boolean)result2.getData()).booleanValue()) {
                ArrayList responseLstDTOInternet = new ArrayList();
                ObjectReqDTO objectReqDTO = new ObjectReqDTO();
                objectReqDTO.setObjectId(dto.getId());
                objectReqDTO.setObjectType(ObjectTypeEnum.MEDIATION.name());
                DubboResult resultInternet = this.attachmentApi.queryAttachmentList(objectReqDTO);
                if (CollectionUtils.isEmpty((Collection)((Collection)((Object)resultInternet.getData())))) {
                    return responseLstDTOInternet;
                }
                responseLstDTOInternet = ((ArrayList)resultInternet.getData()).stream().map(AttachmentConvert::getDocumentListResponseDTO).collect(Collectors.toCollection(ArrayList::new));
                return responseLstDTOInternet;
            }
            DubboResult scheduleResult = this.mediationInfoApi.getAllMeetingSchedule(dto.getBizRoomId());
            AssertUtils.assertTrue((boolean)scheduleResult.isSuccess(), (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)"referee\u5ead\u6b21\u8c03\u7528\u51fa\u9519!");
            ArrayList data = (ArrayList)scheduleResult.getData();
            block0: for (DocumentResponseDTO document : responseLstDTO) {
                String roomId = document.getRoomId();
                String docName = document.getDocName();
                for (Map map : data) {
                    if (roomId.equals(MapUtil.getStr((Map)map, (Object)"id")) && StringUtils.isBlank((String)MapUtil.getStr((Map)map, (Object)"schedule_id"))) {
                        docName = "\u6848\u4ef6\u7a7a\u95f4-\u7b14\u5f55.docx";
                        document.setDocName(docName);
                        outList.add(document);
                        continue block0;
                    }
                    if (!roomId.equals(MapUtil.getStr((Map)map, (Object)"id"))) continue;
                    StringBuilder name = new StringBuilder("\u9274\u5b9a\u673a\u6784-\u7b14\u5f55-\u5ead\u6b21");
                    docName = name.append(MapUtil.getStr((Map)map, (Object)"schedule_id")).append(".docx").toString();
                    document.setDocName(docName);
                    outList.add(document);
                    continue block0;
                }
            }
        } else {
            outList.addAll(responseLstDTO);
        }
        if (StringUtils.isBlank((String)sign)) {
            DubboResult report = this.docRecordApi.getReport(dto.getId());
            AssertUtils.assertTrue((boolean)report.isSuccess(), (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)"\u8d28\u8bc1\u62a5\u544a\u6216\u8005\u7535\u5b50\u9001\u8fbe\u62a5\u544a\u8c03\u7528\u51fa\u9519!");
            ArrayList reportResDTOS = (ArrayList)report.getData();
            if (reportResDTOS.size() > 0) {
                List reportList = reportResDTOS.stream().map(ReprotConvert::convertReportResDTO).collect(Collectors.toList());
                outList.addAll(reportList);
            }
        }
        ArrayList<DocumentResponseDTO> dataList = new ArrayList<DocumentResponseDTO>();
        String appName = request.getHeader("appname");
        System.out.println("----------------" + request.getHeader("appname"));
        if (outList.size() > 0 && ("weitingshenhubei".equals(appName) || "weitingshenhubeizz".equals(appName))) {
            List pdfList = outList.stream().map(ReprotConvert::convertPdfResDTO).collect(Collectors.toList());
            dataList.addAll(pdfList);
        } else {
            dataList.addAll(outList);
        }
        return dataList;
    }

    @Override
    public ArrayList<IntranetDocumentResponseDTO> queryIntranetAttachmentList(CommonIdRequestDTO dto, HttpServletRequest request) {
        List roles = JWTContextUtil.getRoles();
        boolean isCommon = false;
        if (!CollectionUtils.isEmpty((Collection)roles)) {
            for (String role : roles) {
                if (!"COMMON".equals(role)) continue;
                isCommon = true;
                break;
            }
        }
        DubboResult result = null;
        ObjectReqDTO objectReqDTO = new ObjectReqDTO();
        objectReqDTO.setObjectId(dto.getId());
        objectReqDTO.setFlag("1");
        objectReqDTO.setObjectType(ObjectTypeEnum.INTRANET_MATERIALS.name());
        result = this.attachmentApi.queryAttachmentList(objectReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        ArrayList intranetList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)((Collection)((Object)result.getData())))) {
            intranetList = ((ArrayList)result.getData()).stream().map(AttachmentConvert::getIntranetDocumentListResponseDTO).collect(Collectors.toCollection(ArrayList::new));
        }
        DubboResult result2 = this.mediationRoomApi.getIntranetAttachment(dto.getId());
        AssertUtils.assertTrue((boolean)result2.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        ArrayList internetList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)((Collection)((Object)result2.getData())))) {
            internetList = ((ArrayList)result2.getData()).stream().map(AttachmentConvert::getInternetDocumentListResponseDTO).collect(Collectors.toCollection(ArrayList::new));
        }
        ArrayList<IntranetDocumentResponseDTO> outList = new ArrayList<IntranetDocumentResponseDTO>();
        outList.addAll(intranetList);
        outList.addAll(internetList);
        if (isCommon) {
            ArrayList<IntranetDocumentResponseDTO> out2List = new ArrayList<IntranetDocumentResponseDTO>();
            if (!CollectionUtils.isEmpty(outList)) {
                for (IntranetDocumentResponseDTO intranetDocumentResponseDTO : outList) {
                    if (StringUtils.isEmpty((String)intranetDocumentResponseDTO.getExamineFlag()) || !intranetDocumentResponseDTO.getExamineFlag().equals("1")) continue;
                    out2List.add(intranetDocumentResponseDTO);
                }
            }
            return out2List;
        }
        return outList;
    }

    @Override
    public JSONObject sendHttpPostFile(InputStream is, String fileName, String token) {
        if (StringUtils.isBlank((String)token)) {
            token = this.evaluateLogin();
        }
        String result = "";
        try {
            HttpPost httpPost = new HttpPost(this.evaluateContext + "filepreview/getDoctoPdf");
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("token", token);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(Charset.forName("UTF-8"));
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addBinaryBody("files", is, ContentType.MULTIPART_FORM_DATA, fileName);
            ContentType contentType = ContentType.create((String)"application/json", (Charset)Charset.forName("UTF-8"));
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            result = AttachmentDubboServiceImpl.sendHttpPost(httpPost);
        }
        catch (Exception e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)e.getMessage());
            e.printStackTrace();
        }
        return JSONObject.parseObject((String)result);
    }

    public String evaluateLogin() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("userName", (Object)this.evaluateUserName);
        jsonObject.put("password", (Object)this.evaluatePassword);
        String loginStr = null;
        try {
            loginStr = HttpClientUtils.sendHttpPost((String)(this.evaluateContext + "login/signIn"), (String)jsonObject.toString());
        }
        catch (IOException e) {
            log.error("sendHttpPost error {} ", (Throwable)e);
        }
        JSONObject loginObj = JSONObject.parseObject(loginStr);
        String token = "";
        if ("200".equals(loginObj.getString("code"))) {
            token = loginObj.getJSONObject("result").getString("token");
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendHttpPost(HttpPost httpPost) throws IOException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            httpClient = HttpClients.createDefault();
            httpPost.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpPost);
            entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)encoding);
        }
        catch (Exception e) {
            log.error("HttpClientUtils sendHttpPost error {}", (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return responseContent;
    }
}

