/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.document.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.document.api.DocMediationBookApi;
import com.beiming.odr.document.dto.requestdto.DocPersonReqDTO;
import com.beiming.odr.document.dto.requestdto.SaveMediationBookReqDTO;
import com.beiming.odr.document.dto.responsedto.MediationBookResDTO;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.SaveProtocolBookRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ProtocolBookResponseDTO;
import com.beiming.odr.peace.service.backend.document.DocMediationBookDubboService;
import com.beiming.odr.peace.service.backend.referee.MediationRoomDubboService;
import com.beiming.odr.peace.service.convert.DocumentConvert;
import com.beiming.odr.referee.dto.responsedto.MediationRoomPersonResDTO;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DocMediationBookDubboServiceImpl
implements DocMediationBookDubboService {
    @Resource
    private DocMediationBookApi docMediationBookApi;
    @Resource
    private MediationRoomDubboService mediationRoomDubboService;

    @Override
    public ProtocolBookResponseDTO getMediationBookByMediator(Long objId) {
        DubboResult result = this.docMediationBookApi.getMediationBookByMediator(objId);
        AssertUtils.assertTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        MediationBookResDTO resDTO = (MediationBookResDTO)result.getData();
        ProtocolBookResponseDTO mediationBook = DocumentConvert.convertMediationBookResDTO(resDTO);
        return mediationBook;
    }

    @Override
    public ProtocolBookResponseDTO getMediationBookByUser(Long objId) {
        DubboResult result = this.docMediationBookApi.getMediationBookByUser(objId);
        AssertUtils.assertTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        MediationBookResDTO resDTO = (MediationBookResDTO)result.getData();
        ProtocolBookResponseDTO mediationBook = DocumentConvert.convertMediationBookResDTO(resDTO);
        return mediationBook;
    }

    @Override
    public Long saveMediationBook(SaveProtocolBookRequestDTO dto) {
        SaveMediationBookReqDTO reqDTO = DocumentConvert.convertSaveMediationBookReqDTO(dto);
        MediationRoomPersonResDTO mediator = this.mediationRoomDubboService.getMediationRoomMediator(dto.getMediationRoomId());
        DocPersonReqDTO proPerson = DocumentConvert.getDocPersonReqDTO(mediator);
        reqDTO.getMediationBookPersonList().add(proPerson);
        DubboResult result = this.docMediationBookApi.saveMediationBook(reqDTO);
        AssertUtils.assertTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (Long)result.getData();
    }
}

