/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.convert;

import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.document.dto.requestdto.AgentInfoReqDTO;
import com.beiming.odr.document.dto.requestdto.DocPersonReqDTO;
import com.beiming.odr.document.dto.requestdto.SaveMediationBookReqDTO;
import com.beiming.odr.document.dto.requestdto.SaveMediationSchemeReqDTO;
import com.beiming.odr.document.dto.requestdto.SavePromiseBookReqDTO;
import com.beiming.odr.document.dto.requestdto.SaveUndisputedFactReqDTO;
import com.beiming.odr.document.dto.responsedto.AgentInfoResDTO;
import com.beiming.odr.document.dto.responsedto.DocPersonConfirmResDTO;
import com.beiming.odr.document.dto.responsedto.DocPersonResDTO;
import com.beiming.odr.document.dto.responsedto.MediationBookResDTO;
import com.beiming.odr.document.dto.responsedto.MediationSchemeResDTO;
import com.beiming.odr.document.dto.responsedto.UndisputedFactResDTO;
import com.beiming.odr.document.enums.CaseUserTypeEnum;
import com.beiming.odr.document.enums.DocumentTypeEnum;
import com.beiming.odr.document.enums.ObjectTypeEnum;
import com.beiming.odr.document.enums.UserTypeEnum;
import com.beiming.odr.peace.domain.dto.requestdto.AgentInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ProtocolPersonRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SavePromiseBookRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SaveProtocolBookRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.AgentInfoResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ProtocolBookResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ProtocolConfirmResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ProtocolPersonResponseDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomPersonResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.referee.enums.AgentTypeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DocumentConvert {
    public static ProtocolBookResponseDTO convertMediationBookResDTO(MediationBookResDTO resDTO) {
        ProtocolBookResponseDTO result = new ProtocolBookResponseDTO();
        result.setProtocolId(resDTO.getMediationBookId());
        result.setOrgId(resDTO.getOrgId());
        result.setOrgName(resDTO.getOrgName());
        result.setDisputeType(resDTO.getDisputeType());
        result.setDocumentType(DocumentTypeEnum.MEDIATION_BOOK.name());
        result.setMediationRoomId(resDTO.getObjectId());
        result.setCaseNo(resDTO.getCaseNo());
        result.setContent(resDTO.getDisputeContent());
        result.setExtendJson(resDTO.getMediationContent());
        result.setSendStatus(resDTO.getSendStatus());
        if (resDTO.getMediationBookId() != null) {
            List<ProtocolPersonResponseDTO> applicantList = DocumentConvert.convertDocPersonResDTO(resDTO.getApplicantList());
            result.setApplicantList(applicantList);
            List<ProtocolPersonResponseDTO> respondentList = DocumentConvert.convertDocPersonResDTO(resDTO.getRespondentList());
            result.setRespondentList(respondentList);
            List<ProtocolConfirmResponseDTO> confirmList = DocumentConvert.convertDocPersonConfirmResDTO(resDTO.getConfirmList());
            result.setConfirmList(confirmList);
        }
        return result;
    }

    public static ProtocolBookResponseDTO convertMediationSchemeResDTO(MediationSchemeResDTO resDTO) {
        ProtocolBookResponseDTO result = new ProtocolBookResponseDTO();
        result.setProtocolId(resDTO.getMediationSchemeId());
        result.setOrgId(resDTO.getOrgId());
        result.setOrgName(resDTO.getOrgName());
        result.setDisputeType(resDTO.getDisputeType());
        result.setDocumentType(DocumentTypeEnum.NO_DISSENT_MEDIATION_SCHEME.name());
        result.setMediationRoomId(resDTO.getObjectId());
        result.setCaseNo(resDTO.getCaseNo());
        result.setContent(resDTO.getMediationScheme());
        result.setExtendJson(resDTO.getMediationNeeds());
        result.setSendStatus(resDTO.getSendStatus());
        if (resDTO.getMediationSchemeId() != null) {
            List<ProtocolPersonResponseDTO> applicantList = DocumentConvert.convertDocPersonResDTO(resDTO.getApplicantList());
            result.setApplicantList(applicantList);
            List<ProtocolPersonResponseDTO> respondentList = DocumentConvert.convertDocPersonResDTO(resDTO.getRespondentList());
            result.setRespondentList(respondentList);
            List<ProtocolConfirmResponseDTO> confirmList = DocumentConvert.convertDocPersonConfirmResDTO(resDTO.getConfirmList());
            result.setConfirmList(confirmList);
        }
        return result;
    }

    public static ProtocolBookResponseDTO convertUndisputedFactResDTO(UndisputedFactResDTO resDTO) {
        ProtocolBookResponseDTO result = new ProtocolBookResponseDTO();
        result.setProtocolId(resDTO.getUndisputedFactId());
        result.setOrgId(resDTO.getOrgId());
        result.setOrgName(resDTO.getOrgName());
        result.setDisputeType(resDTO.getDisputeType());
        result.setDocumentType(DocumentTypeEnum.UNDISPUTED_FACT.name());
        result.setMediationRoomId(resDTO.getObjectId());
        result.setCaseNo(resDTO.getCaseNo());
        result.setContent(resDTO.getMediationProcess());
        result.setExtendJson(resDTO.getUndisputedFactContent());
        result.setSendStatus(resDTO.getSendStatus());
        if (resDTO.getUndisputedFactId() != null) {
            List<ProtocolPersonResponseDTO> applicantList = DocumentConvert.convertDocPersonResDTO(resDTO.getApplicantList());
            result.setApplicantList(applicantList);
            List<ProtocolPersonResponseDTO> respondentList = DocumentConvert.convertDocPersonResDTO(resDTO.getRespondentList());
            result.setRespondentList(respondentList);
            List<ProtocolConfirmResponseDTO> confirmList = DocumentConvert.convertDocPersonConfirmResDTO(resDTO.getConfirmList());
            result.setConfirmList(confirmList);
        }
        return result;
    }

    public static List<ProtocolPersonResponseDTO> convertDocPersonResDTO(List<DocPersonResDTO> list) {
        ArrayList result = Lists.newArrayList();
        for (DocPersonResDTO resDTO : list) {
            ProtocolPersonResponseDTO response = new ProtocolPersonResponseDTO();
            response.setPersonId(resDTO.getPersonId());
            response.setUserId(resDTO.getUserId());
            response.setUserName(resDTO.getUserName());
            response.setMeetingUserType(resDTO.getCaseUserType());
            response.setUserType(resDTO.getUserType());
            response.setSex(resDTO.getSex());
            response.setPhone(resDTO.getPhone());
            response.setIdCard(resDTO.getIdCard());
            response.setCreditCode(resDTO.getCreditCode());
            response.setCorporation(resDTO.getCorporation());
            response.setProvCode(resDTO.getProvCode());
            response.setProvName(resDTO.getProvName());
            response.setCityCode(resDTO.getCityCode());
            response.setCityName(resDTO.getCityName());
            response.setAreaCode(resDTO.getAreaCode());
            response.setAreaName(resDTO.getAreaName());
            response.setStreetCode(resDTO.getStreetCode());
            response.setStreetName(resDTO.getStreetName());
            response.setAddress(resDTO.getAddress());
            ArrayList areaList = Lists.newArrayList();
            if (StringUtils.isNotBlank((CharSequence)resDTO.getProvCode())) {
                areaList.add(resDTO.getProvCode());
                areaList.add(resDTO.getCityCode());
                areaList.add(resDTO.getAreaCode());
                areaList.add(resDTO.getStreetCode());
            }
            response.setAreaList((List)areaList);
            response.setUserOrder(resDTO.getUserOrder());
            AgentInfoResDTO agentRes = resDTO.getAgent();
            if (Objects.nonNull(agentRes)) {
                AgentInfoResponseDTO agent = new AgentInfoResponseDTO();
                agent.setAgentPersonId(agentRes.getAgentPersonId());
                agent.setAgentId(agentRes.getAgentId());
                agent.setAgentType(agentRes.getAgentType());
                agent.setAgentName(agentRes.getAgentName());
                agent.setAgentSex(agentRes.getAgentSex());
                agent.setAgentPhone(agentRes.getAgentPhone());
                agent.setAgentIdCard(agentRes.getAgentIdCard());
                response.setAgent(agent);
            }
            result.add(response);
        }
        return result;
    }

    public static List<ProtocolConfirmResponseDTO> convertDocPersonConfirmResDTO(List<DocPersonConfirmResDTO> list) {
        ArrayList confirmList = Lists.newArrayList();
        for (DocPersonConfirmResDTO resDTO : list) {
            ProtocolConfirmResponseDTO dto = new ProtocolConfirmResponseDTO();
            dto.setUserId(resDTO.getUserId());
            dto.setUserName(resDTO.getUserName());
            dto.setUserType(resDTO.getUserType());
            dto.setConfirmStatus(resDTO.getConfirmStatus());
            confirmList.add(dto);
        }
        return confirmList;
    }

    public static SaveMediationBookReqDTO convertSaveMediationBookReqDTO(SaveProtocolBookRequestDTO dto) {
        SaveMediationBookReqDTO reqDTO = new SaveMediationBookReqDTO();
        reqDTO.setMediationBookId(dto.getProtocolId());
        reqDTO.setObjectId(dto.getMediationRoomId());
        reqDTO.setObjectType(ObjectTypeEnum.MEDIATION.name());
        reqDTO.setCaseNo(dto.getCaseNo());
        reqDTO.setOrgId(dto.getOrgId());
        reqDTO.setOrgName(dto.getOrgName());
        reqDTO.setDisputeType(dto.getDisputeType());
        ArrayList mediationBookPersonList = Lists.newArrayList();
        List<DocPersonReqDTO> applicantList = DocumentConvert.getDocApplicantList(dto.getApplicantList());
        mediationBookPersonList.addAll(applicantList);
        List<DocPersonReqDTO> respondentList = DocumentConvert.getDocRespondent(dto.getRespondentList());
        mediationBookPersonList.addAll(respondentList);
        reqDTO.setMediationBookPersonList((List)mediationBookPersonList);
        reqDTO.setDisputeContent(dto.getContent());
        reqDTO.setMediationContent(dto.getExtendJson());
        reqDTO.setCreateUser(JWTContextUtil.getCurrentUserName());
        reqDTO.setUpdateUser(JWTContextUtil.getCurrentUserName());
        return reqDTO;
    }

    public static SaveUndisputedFactReqDTO convertSaveUndisputedFactReqDTO(SaveProtocolBookRequestDTO dto) {
        SaveUndisputedFactReqDTO reqDTO = new SaveUndisputedFactReqDTO();
        reqDTO.setUndisputedFactId(dto.getProtocolId());
        reqDTO.setObjectId(dto.getMediationRoomId());
        reqDTO.setObjectType(ObjectTypeEnum.MEDIATION.name());
        reqDTO.setCaseNo(dto.getCaseNo());
        reqDTO.setOrgId(dto.getOrgId());
        reqDTO.setOrgName(dto.getOrgName());
        reqDTO.setDisputeType(dto.getDisputeType());
        ArrayList undisputedFactPersonList = Lists.newArrayList();
        List<DocPersonReqDTO> applicantList = DocumentConvert.getDocApplicantList(dto.getApplicantList());
        undisputedFactPersonList.addAll(applicantList);
        List<DocPersonReqDTO> respondentList = DocumentConvert.getDocRespondent(dto.getRespondentList());
        undisputedFactPersonList.addAll(respondentList);
        reqDTO.setUndisputedFactPersonList((List)undisputedFactPersonList);
        reqDTO.setMediationProcess(dto.getContent());
        reqDTO.setUndisputedFactContent(dto.getExtendJson());
        reqDTO.setCreateUser(JWTContextUtil.getCurrentUserName());
        reqDTO.setUpdateUser(JWTContextUtil.getCurrentUserName());
        return reqDTO;
    }

    public static SaveMediationSchemeReqDTO convertSaveMediationSchemeReqDTO(SaveProtocolBookRequestDTO dto) {
        SaveMediationSchemeReqDTO reqDTO = new SaveMediationSchemeReqDTO();
        reqDTO.setMediationSchemeId(dto.getProtocolId());
        reqDTO.setObjectId(dto.getMediationRoomId());
        reqDTO.setObjectType(ObjectTypeEnum.MEDIATION.name());
        reqDTO.setCaseNo(dto.getCaseNo());
        reqDTO.setOrgId(dto.getOrgId());
        reqDTO.setOrgName(dto.getOrgName());
        reqDTO.setDisputeType(dto.getDisputeType());
        ArrayList mediationSchemePersonList = Lists.newArrayList();
        List<DocPersonReqDTO> applicantList = DocumentConvert.getDocApplicantList(dto.getApplicantList());
        mediationSchemePersonList.addAll(applicantList);
        List<DocPersonReqDTO> respondentList = DocumentConvert.getDocRespondent(dto.getRespondentList());
        mediationSchemePersonList.addAll(respondentList);
        reqDTO.setMediationSchemePersonList((List)mediationSchemePersonList);
        reqDTO.setMediationScheme(dto.getContent());
        reqDTO.setMediationNeeds(dto.getExtendJson());
        reqDTO.setCreateUser(JWTContextUtil.getCurrentUserName());
        reqDTO.setUpdateUser(JWTContextUtil.getCurrentUserName());
        return reqDTO;
    }

    public static DocPersonReqDTO getDocPersonReqDTO(ProtocolPersonRequestDTO person) {
        DocPersonReqDTO reqDTO = new DocPersonReqDTO();
        reqDTO.setPersonId(person.getPersonId());
        reqDTO.setUserId(person.getUserId());
        reqDTO.setUserType(person.getUserType());
        reqDTO.setUserName(person.getUserName());
        reqDTO.setSex(person.getSex());
        reqDTO.setPhone(person.getPhone());
        reqDTO.setIdCard(person.getIdCard());
        reqDTO.setCreditCode(person.getCreditCode());
        reqDTO.setCorporation(person.getCorporation());
        reqDTO.setProvCode(person.getProvCode());
        reqDTO.setProvName(person.getProvName());
        reqDTO.setCityCode(person.getCityCode());
        reqDTO.setCityName(person.getCityName());
        reqDTO.setAreaCode(person.getAreaCode());
        reqDTO.setAreaName(person.getAreaName());
        reqDTO.setStreetCode(person.getStreetCode());
        reqDTO.setStreetName(person.getStreetName());
        reqDTO.setAddress(person.getAddress());
        return reqDTO;
    }

    public static AgentInfoReqDTO getDocPersonReqDTO(AgentInfoRequestDTO agent) {
        AgentInfoReqDTO reqDTO = new AgentInfoReqDTO();
        reqDTO.setAgentPersonId(agent.getAgentPersonId());
        reqDTO.setAgentId(agent.getAgentId());
        reqDTO.setAgentType(agent.getAgentType() == null ? AgentTypeEnum.GENERAL_AGENT.name() : agent.getAgentType().name());
        reqDTO.setAgentName(agent.getAgentName());
        reqDTO.setAgentSex(agent.getAgentSex());
        reqDTO.setAgentPhone(agent.getAgentPhone());
        reqDTO.setAgentIdCard(agent.getAgentIdCard());
        return reqDTO;
    }

    public static DocPersonReqDTO getDocPersonReqDTO(MediationRoomPersonResDTO mediator) {
        DocPersonReqDTO docPersonReqDTO = new DocPersonReqDTO();
        docPersonReqDTO.setUserId(mediator.getUserId());
        docPersonReqDTO.setUserName(mediator.getUserName());
        docPersonReqDTO.setCaseUserType(mediator.getMeetingUserType());
        docPersonReqDTO.setUserType(UserTypeEnum.NATURAL_PERSON.name());
        docPersonReqDTO.setPhone(mediator.getPhone());
        docPersonReqDTO.setIdCard(mediator.getIdCard());
        return docPersonReqDTO;
    }

    public static List<DocPersonReqDTO> getDocApplicantList(List<ProtocolPersonRequestDTO> applicantList) {
        ArrayList docPersonList = Lists.newArrayList();
        for (int i = 0; i < applicantList.size(); ++i) {
            ProtocolPersonRequestDTO applicant = applicantList.get(i);
            DocPersonReqDTO docPersonReqDTO = DocumentConvert.getDocPersonReqDTO(applicant);
            docPersonReqDTO.setCaseUserType(CaseUserTypeEnum.APPLICANT.name());
            docPersonReqDTO.setUserOrder(Integer.valueOf(i + 1));
            if (applicant.getAgent() != null) {
                AgentInfoRequestDTO agent = applicant.getAgent();
                AgentInfoReqDTO agentInfoResDTO = DocumentConvert.getDocPersonReqDTO(agent);
                agentInfoResDTO.setCaseUserType(CaseUserTypeEnum.APPLICANT_AGENT.name());
                docPersonReqDTO.setAgent(agentInfoResDTO);
            }
            docPersonList.add(docPersonReqDTO);
        }
        return docPersonList;
    }

    public static List<DocPersonReqDTO> getDocRespondent(List<ProtocolPersonRequestDTO> respondentList) {
        ArrayList docPersonList = Lists.newArrayList();
        for (int i = 0; i < respondentList.size(); ++i) {
            ProtocolPersonRequestDTO respondent = respondentList.get(i);
            DocPersonReqDTO docPersonReqDTO = DocumentConvert.getDocPersonReqDTO(respondent);
            docPersonReqDTO.setCaseUserType(CaseUserTypeEnum.RESPONDENT.name());
            docPersonReqDTO.setUserOrder(Integer.valueOf(i + 1));
            if (respondent.getAgent() != null) {
                AgentInfoRequestDTO agent = respondent.getAgent();
                AgentInfoReqDTO agentInfoResDTO = DocumentConvert.getDocPersonReqDTO(agent);
                agentInfoResDTO.setCaseUserType(CaseUserTypeEnum.RESPONDENT_AGENT.name());
                docPersonReqDTO.setAgent(agentInfoResDTO);
            }
            docPersonList.add(docPersonReqDTO);
        }
        return docPersonList;
    }

    public static SavePromiseBookReqDTO convertSavePromiseBookReqDTO(SavePromiseBookRequestDTO dto, ArrayList<MediationRoomUserInfoResDTO> list) {
        SavePromiseBookReqDTO reqDTO = new SavePromiseBookReqDTO();
        reqDTO.setObjectId(dto.getMediationRoomId());
        reqDTO.setObjectType(ObjectTypeEnum.MEDIATION.name());
        reqDTO.setOrgId(dto.getOrgId());
        reqDTO.setOrgName(dto.getOrgName());
        reqDTO.setDisputeType(dto.getDisputeType());
        reqDTO.setApplicantContent(dto.getApplicantContent());
        reqDTO.setRespondentContent(dto.getRespondentContent());
        reqDTO.setCreateUser(JWTContextUtil.getCurrentUserName());
        reqDTO.setUpdateUser(JWTContextUtil.getCurrentUserName());
        ArrayList personList = Lists.newArrayList();
        for (MediationRoomUserInfoResDTO userInfoResDTO : list) {
            if (!CaseUserTypeEnum.APPLICANT.name().equals(userInfoResDTO.getMeetingUserType()) && !CaseUserTypeEnum.RESPONDENT.name().equals(userInfoResDTO.getMeetingUserType())) continue;
            DocPersonReqDTO person = new DocPersonReqDTO();
            person.setCaseUserType(userInfoResDTO.getMeetingUserType());
            person.setUserId(userInfoResDTO.getUserId());
            person.setUserName(userInfoResDTO.getUserName());
            person.setPhone(userInfoResDTO.getMobilePhone());
            person.setSex(userInfoResDTO.getUserSex());
            person.setIdCard(userInfoResDTO.getIdCard());
            personList.add(person);
        }
        reqDTO.setPersonList((List)personList);
        return reqDTO;
    }
}

