/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.demonstration.impl;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.Java8DateUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.constants.PeaceConst;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.PreviewUserDTO;
import com.beiming.odr.peace.domain.dto.PreviewUserLoginInfoDTO;
import com.beiming.odr.peace.domain.dto.RedisMediationRoomInfoDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MyVideoMeetingPageListResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.PreviewCreateMeetingResponseDTO;
import com.beiming.odr.peace.service.backend.user.DictionaryService;
import com.beiming.odr.peace.service.convert.PreviewConvert;
import com.beiming.odr.peace.service.demonstration.DemonstrationUtil;
import com.beiming.odr.peace.service.demonstration.PreviewService;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.peace.service.util.PasswordHandleUtil;
import com.beiming.odr.peace.service.util.WechatBindingUtil;
import com.beiming.odr.referee.api.MediationMeetingRoomApi;
import com.beiming.odr.referee.dto.requestdto.AddMediationMeetingRoomReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingUserInfoReqDTO;
import com.beiming.odr.referee.dto.responsedto.AddMediationMeetingResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomUserInfoResDTO;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import com.beiming.odr.referee.enums.RoomStatusEnums;
import com.beiming.odr.user.api.UserServiceApi;
import com.beiming.odr.user.api.common.enums.PasswordFormatTypeEnum;
import com.beiming.odr.user.api.common.enums.UserLoginTypeEnum;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CommonUserSearchResDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PreviewServiceImpl
implements PreviewService {
    @Resource
    private MediationMeetingRoomApi mediationMeetingRoomApi;
    @Resource
    private RedisService redisService;
    @Resource
    private DictionaryService dictionaryService;
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private PasswordHandleUtil passwordHandleUtil;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private DemonstrationUtil demonstrationUtil;
    @Resource
    private WechatBindingUtil wechatBindingUtil;

    @Override
    public PreviewCreateMeetingResponseDTO createMeeting() {
        DubboResult meetingStatus;
        PreviewCreateMeetingResponseDTO result = (PreviewCreateMeetingResponseDTO)this.redisTemplate.opsForValue().get((Object)RedisKeyEnums.PREVIEW_MEETING_INFO);
        if (result != null && !((Boolean)(meetingStatus = this.mediationMeetingRoomApi.checkMeetingCloseFlag(result.getMeetingId())).getData()).booleanValue()) {
            return result;
        }
        String value = this.dictionaryService.getDictionaryValue("PREVIEW_MEDIATOR_CODE");
        PreviewUserDTO previewUserDTO = (PreviewUserDTO)JSONObject.parseObject((String)value, PreviewUserDTO.class);
        MediationMeetingUserInfoReqDTO mediator = PreviewConvert.convertMediator(previewUserDTO);
        AddMediationMeetingRoomReqDTO reqDTO = new AddMediationMeetingRoomReqDTO();
        String dateStr = Java8DateUtils.formatter((Date)new Date(), (String)"yyyyMMddHHmmss");
        reqDTO.setMediationMeetingRoomName("\u5e38\u5c71\u5927\u5c4f\u6f14\u793a\u4f1a\u8bae" + dateStr);
        reqDTO.setMediator(mediator);
        reqDTO.setLitigantList((List)Lists.newArrayList());
        reqDTO.setOrderTime(new Date());
        reqDTO.setCreatorId(mediator.getUserId());
        reqDTO.setCreateUser(mediator.getUserName());
        reqDTO.setUpdateUser(mediator.getUserName());
        DubboResult dubboResult = this.mediationMeetingRoomApi.addMediationMeeting(reqDTO);
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboResult.getMessage());
        AddMediationMeetingResDTO resDTO = (AddMediationMeetingResDTO)dubboResult.getData();
        result = new PreviewCreateMeetingResponseDTO();
        result.setMeetingId(resDTO.getMediationRoomId());
        result.setRoomId(resDTO.getRoomId());
        this.redisTemplate.opsForValue().set((Object)RedisKeyEnums.PREVIEW_MEETING_INFO, (Object)result);
        return result;
    }

    @Override
    public LoginInfoResDTO mediatorLogin() {
        String value = this.dictionaryService.getDictionaryValue("PREVIEW_MEDIATOR_CODE");
        PreviewUserDTO mediator = (PreviewUserDTO)JSONObject.parseObject((String)value, PreviewUserDTO.class);
        UserLoginTypeEnum loginType = UserLoginTypeEnum.WORK_USER_LOGIN_TYPE;
        String password = this.passwordHandleUtil.decryptPassword(PasswordFormatTypeEnum.USER_LOGIN, null, mediator.getPassword(), "\u5bc6\u7801\u683c\u5f0f\u9519\u8bef");
        DubboResult result = this.userServiceApi.userLogin(mediator.getMobilePhone(), password, mediator.getUserName(), loginType);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (LoginInfoResDTO)result.getData();
    }

    @Override
    public PreviewUserLoginInfoDTO userLogin(String nickname, String code) {
        PreviewCreateMeetingResponseDTO previewMeeting = (PreviewCreateMeetingResponseDTO)this.redisTemplate.opsForValue().get((Object)RedisKeyEnums.PREVIEW_MEETING_INFO);
        if (previewMeeting != null) {
            DubboResult meetingStatus = this.mediationMeetingRoomApi.checkMeetingCloseFlag(previewMeeting.getMeetingId());
            AssertUtils.assertFalse((boolean)((Boolean)meetingStatus.getData()), (ResultCode)ErrorCode.MEETING_ROOM_IS_CLOSE, (String)"\u89c6\u9891\u5df2\u5173\u95ed");
        }
        AssertUtils.assertNotNull((Object)previewMeeting, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u89c6\u9891\u4e0d\u5b58\u5728");
        String openId = this.wechatBindingUtil.getOpenIdByCode(code, null);
        String suffix = openId + "_" + previewMeeting.getMeetingId();
        PreviewUserLoginInfoDTO result = (PreviewUserLoginInfoDTO)this.redisService.get((RedisKey)RedisKeyEnums.PREVIEW_USER_LOGIN_INFO, suffix);
        if (null != result) {
            return result;
        }
        DubboResult dubboResult = this.mediationMeetingRoomApi.getMediationRoomUserInfoList(previewMeeting.getMeetingId());
        MediationMeetingRoomUserInfoResDTO data = (MediationMeetingRoomUserInfoResDTO)dubboResult.getData();
        List meetingUserList = data.getList();
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboResult.getMessage());
        AssertUtils.assertFalse((meetingUserList.size() > 7 ? 1 : 0) != 0, (ResultCode)ErrorCode.MEETING_ROOM_USER_IS_FULL, (String)ErrorCode.MEETING_ROOM_USER_IS_FULL.desc());
        String litigantIdStr = this.dictionaryService.getDictionary("PREVIEW_LITIGANT_CODE").getValue();
        String[] litigantIdArr = litigantIdStr.split(",");
        Long userId = null;
        for (String litigantId : litigantIdArr) {
            boolean flag = meetingUserList.stream().anyMatch(e -> e.getUserId().equals(Long.valueOf(litigantId)));
            if (flag) continue;
            userId = Long.valueOf(litigantId);
            break;
        }
        CommonIdReqDTO commonIdReqDTO = new CommonIdReqDTO();
        commonIdReqDTO.setId(userId);
        DubboResult userResult = this.userServiceApi.searchCommonUser(commonIdReqDTO);
        CommonUserSearchResDTO userInfo = (CommonUserSearchResDTO)userResult.getData();
        AssertUtils.assertTrue((boolean)userResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        nickname = DemonstrationUtil.filterEmoji(nickname);
        if (StringUtils.isBlank((String)nickname)) {
            nickname = MeetingUserTypeEnum.LITIGANT.getName();
        }
        AddMediationRoomUserReqDTO reqDTO = PreviewConvert.covertAddMediationRoomUserReqDTO(previewMeeting.getMeetingId(), userId, nickname, meetingUserList, userInfo);
        DubboResult addUserDubboResult = this.mediationMeetingRoomApi.addMediationMeetingRoomUser(reqDTO);
        AssertUtils.assertTrue((boolean)addUserDubboResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)addUserDubboResult.getMessage());
        String verificationCode = this.demonstrationUtil.createVerificationCode(previewMeeting.getMeetingId(), previewMeeting.getRoomId(), userInfo.getMobilePhone(), userId);
        RedisMediationRoomInfoDTO mediationRoomInfo = (RedisMediationRoomInfoDTO)this.redisService.get((RedisKey)RedisKeyEnums.VERIFICATION_CODE, verificationCode);
        result = new PreviewUserLoginInfoDTO(verificationCode, mediationRoomInfo);
        this.redisService.set((RedisKey)RedisKeyEnums.PREVIEW_USER_LOGIN_INFO, suffix, (Object)result);
        return result;
    }

    @Override
    public void userLeaveMeeting(String roomId, String userId) {
        String verificationCode = (String)this.redisTemplate.opsForHash().get((Object)this.redisService.getRealKey("", (RedisKey)RedisKeyEnums.MEETING_CODE_USE, roomId), (Object)userId);
        if (StringUtils.isNotBlank((CharSequence)verificationCode)) {
            Object[] member = new String[]{verificationCode};
            this.redisTemplate.opsForSet().add((Object)this.redisService.getRealKey("", (RedisKey)RedisKeyEnums.MEETING_CODE, roomId), member);
            this.redisTemplate.opsForHash().delete((Object)this.redisService.getRealKey("", (RedisKey)RedisKeyEnums.MEETING_CODE_USE, roomId), new Object[]{userId});
        }
    }

    @Override
    public ArrayList<MyVideoMeetingPageListResponseDTO> meetingList() {
        ArrayList result = Lists.newArrayList();
        PreviewCreateMeetingResponseDTO meetingInfo = (PreviewCreateMeetingResponseDTO)this.redisTemplate.opsForValue().get((Object)RedisKeyEnums.PREVIEW_MEETING_INFO);
        if (null == meetingInfo) {
            return result;
        }
        DubboResult dubboResult = this.mediationMeetingRoomApi.getMediationRoomUserInfoList(meetingInfo.getMeetingId());
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboResult.getMessage());
        MediationMeetingRoomUserInfoResDTO resDTO = (MediationMeetingRoomUserInfoResDTO)dubboResult.getData();
        if (RoomStatusEnums.END.equals((Object)RoomStatusEnums.valueOf((String)resDTO.getMediationStatus()))) {
            return result;
        }
        MyVideoMeetingPageListResponseDTO response = new MyVideoMeetingPageListResponseDTO();
        response.setBizRoomId(resDTO.getId().toString());
        response.setRoomId(resDTO.getRoomId());
        response.setParentId(resDTO.getParentId());
        response.setRoomName(resDTO.getName());
        if (resDTO.getEndTime() == null && new Date().getTime() >= resDTO.getOrderTime().getTime()) {
            resDTO.setMediationStatus(RoomStatusEnums.RUNNING.name());
        }
        if (resDTO.getEndTime() != null && new Date().getTime() >= resDTO.getOrderTime().getTime() && new Date().getTime() <= resDTO.getEndTime().getTime()) {
            resDTO.setMediationStatus(RoomStatusEnums.RUNNING.name());
        }
        response.setLastMessageTime(resDTO.getOrderTime());
        if (resDTO.getAuthFlag() == PeaceConst.AUTH_YES.intValue()) {
            response.setAuthFlag(Boolean.valueOf(true));
        } else {
            response.setAuthFlag(Boolean.valueOf(false));
        }
        List userInfoList = resDTO.getList();
        if (!CollectionUtils.isEmpty((Collection)userInfoList)) {
            DemonstrationUtil.setMeetingPageListResponse(userInfoList, response);
        }
        result.add(response);
        return result;
    }
}

