/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beiming.basic.chat.api.RoomApi;
import com.beiming.basic.chat.api.RoomMediationApi;
import com.beiming.basic.chat.api.dto.request.SendTextMessageReqDTO;
import com.beiming.basic.chat.api.dto.response.MemberResDTO;
import com.beiming.basic.chat.api.dto.response.MessageResDTO;
import com.beiming.basic.chat.api.enums.CategoryBigEnums;
import com.beiming.basic.chat.api.enums.MessageResourceEnums;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.DubboResultBuilder;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.common.enums.ClientEventEnums;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.enums.ServerEventEnums;
import com.beiming.odr.peace.domain.dto.entity.PeaceImEventMqEntity;
import com.beiming.odr.peace.domain.dto.imres.MessageResponseDTO;
import com.beiming.odr.peace.domain.dto.imres.WebSocketResponseDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingUserRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingUserRequestMicroDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomMeetingRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomMeetingUserRequstDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CaseNameRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CloseMediationMeetingRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CourtInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DeleteMediationMeetingMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.GetCaseInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantAgentInfoMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.MediationMeetingListRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.AddMediationRoomMeetingResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.CourtPaymentResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.GetCaseInfoResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationRoomUserInfoRespDTO;
import com.beiming.odr.peace.im.api.IntranetPeaceImApi;
import com.beiming.odr.peace.im.api.dto.request.InvitationVideoSendTextRequestDTO;
import com.beiming.odr.peace.im.api.dto.request.MediationMeetingUsersInfoReqDTO;
import com.beiming.odr.peace.service.BackstageUserService;
import com.beiming.odr.peace.service.MediationMeetingService;
import com.beiming.odr.peace.service.MediationRoomService;
import com.beiming.odr.peace.service.PeaceSmsService;
import com.beiming.odr.peace.service.PersonalService;
import com.beiming.odr.peace.service.SMSHubeiService;
import com.beiming.odr.peace.service.SMSHubeiZzService;
import com.beiming.odr.peace.service.UnreadMessageService;
import com.beiming.odr.peace.service.backend.trial.TrialDubboApiService;
import com.beiming.odr.peace.service.backend.user.UserBackendService;
import com.beiming.odr.peace.service.convert.DTOCheckFieldConvert;
import com.beiming.odr.peace.service.convert.MediationMeetingConvert;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.peace.service.sender.SenderService;
import com.beiming.odr.peace.service.util.SendMsgUtils;
import com.beiming.odr.referee.api.CaseRoomMicroApi;
import com.beiming.odr.referee.api.CloseMediationMeetingRoomApi;
import com.beiming.odr.referee.api.MediationMeetingRoomApi;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.requestdto.AddMediationMeetingRoomMicroReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationMeetingRoomReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationMeetingRoomUserMicroReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomMeetingUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingUserInfoReqDTO;
import com.beiming.odr.referee.dto.responsedto.AddMediationMeetingResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseListMicroResponseDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingRoomInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomUserInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingVideoResDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingVoiceResDTO;
import com.beiming.odr.referee.enums.MediationMeetingRoomStatusEnum;
import com.beiming.odr.referee.enums.MediationMeetingTypeEnum;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import com.beiming.odr.trial.api.TrialApi;
import com.beiming.odr.trial.api.dto.response.CaseInfoResponseDTO;
import com.beiming.odr.user.api.DictionaryServiceApi;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beust.jcommander.internal.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MediationMeetingServiceImpl
implements MediationMeetingService {
    private static final Logger log = Logger.getLogger(MediationMeetingServiceImpl.class);
    @Resource
    private MediationMeetingRoomApi mediationMeetingRoomApi;
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Resource
    private MediationRoomService mediationRoomService;
    @Resource
    private UserBackendService userService;
    @Resource
    private PeaceSmsService peaceSmsService;
    @Resource
    private RoomMediationApi roomMediationApi;
    @Resource
    private BackstageUserService backstageUserService;
    @Resource
    private CloseMediationMeetingRoomApi closeMediationMeetingRoomApi;
    @Resource
    private TrialApi trialApi;
    @Value(value="${peace.meetingNum}")
    private Long meetingNum;
    private RedisTemplate redisTemplate;
    @Resource
    private RedisService redisService;
    @Resource
    private DictionaryServiceApi dictionaryServiceApi;
    @Resource
    private TrialDubboApiService trialDubboApiService;
    @Resource
    private SMSHubeiService smsHubeiService;
    @Resource
    private SMSHubeiZzService smsHubeiZzService;
    @Resource
    private CaseRoomMicroApi caseRoomMicroApi;
    @Resource
    private IntranetPeaceImApi intranetPeaceImApi;
    @Resource
    private PersonalService personalService;
    @Resource
    protected RoomApi roomApi;
    @Resource
    protected SendMsgUtils sendMsgUtils;
    @Resource
    protected SenderService senderService;
    @Resource
    protected UnreadMessageService unreadMessageService;

    @Override
    public void createMediationMeeting(AddMediationMeetingRequestDTO dto) {
        AssertUtils.assertFalse(((long)dto.getList().size() >= this.meetingNum - 1L ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u6dfb\u52a0\u53c2\u4f1a\u4eba\u5458\u8d85\u8fc7\u4e0a\u9650");
        List<LitigantInfoRequestDTO> litigantList = dto.getList();
        litigantList = this.userService.registerLitigant(litigantList);
        AddMediationMeetingRoomReqDTO reqDTO = MediationMeetingConvert.getAddMediationMeetingRoomReqDTO(dto);
        MediationMeetingUserInfoReqDTO mediator = this.userService.getMediatorInfo(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        CourtInfoRequestDTO reqDtO = new CourtInfoRequestDTO();
        reqDtO.setCourtCode(mediator.getOrgId().toString());
        reqDtO.setUserId(JWTContextUtil.getCurrentUserId());
        CourtPaymentResponseDTO courtPaymentResponseDTO = this.personalService.getCourtPayment(reqDtO);
        AssertUtils.assertTrue((boolean)courtPaymentResponseDTO.getCanCreateMeeting(), (ResultCode)ErrorCode.ACCESS_DENIED, (String)"\u60a8\u7684\u4e92\u8054\u7f51\u5ead\u5ba1\u670d\u52a1\u5df2\u5230\u671f");
        reqDTO.setMediator(mediator);
        DubboResult result = this.mediationMeetingRoomApi.addMediationMeeting(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        AddMediationMeetingResDTO resDTO = (AddMediationMeetingResDTO)result.getData();
        Integer authFlag = dto.getAuthFlag();
        this.peaceSmsService.sendMediationMeetingSms(litigantList, resDTO.getMediationRoomId(), resDTO.getRoomId(), mediator.getUserName(), resDTO.getOrderTime(), authFlag);
    }

    @Override
    public void addMediationMeetingUser(AddMediationMeetingUserRequestDTO addMediationMeetingUserRequestDTO) {
        List<LitigantInfoRequestDTO> litigantList = addMediationMeetingUserRequestDTO.getList();
        this.checkMeetingNum(litigantList.size(), addMediationMeetingUserRequestDTO.getMediationRoomId());
        litigantList = this.userService.registerLitigant(litigantList);
        AddMediationRoomUserReqDTO addMediationRoomUserReqDTO = MediationMeetingConvert.gerAddMediationRoomUserReqDTO(addMediationMeetingUserRequestDTO);
        DubboResult result = this.mediationMeetingRoomApi.addMediationMeetingRoomUser(addMediationRoomUserReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        this.peaceSmsService.sendMediationMeetingSms(litigantList, ((AddMediationMeetingResDTO)result.getData()).getMediationRoomId(), ((AddMediationMeetingResDTO)result.getData()).getRoomId(), JWTContextUtil.getCurrentUserName(), ((AddMediationMeetingResDTO)result.getData()).getOrderTime(), 1);
    }

    public void checkMeetingNum(int newPersonCount, Long mediationId) {
        DubboResult result = this.mediationMeetingRoomApi.queryMediationUserList(mediationId);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        AssertUtils.assertFalse(((long)(newPersonCount + (Integer)result.getData()) >= this.meetingNum ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u6dfb\u52a0\u53c2\u4f1a\u4eba\u5458\u8d85\u8fc7\u4e0a\u9650");
    }

    void deleteMeetingVerificationCodes(Long mediationRoomId) {
        String[] verificationCodeList;
        String appName;
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        this.redisTemplate = this.redisService.getRedisTemplate();
        String verificationCodes = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId));
        if (StringUtils.isBlank((CharSequence)verificationCodes)) {
            return;
        }
        for (String verificationCode : verificationCodeList = verificationCodes.split(",")) {
            this.redisTemplate.delete((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode));
        }
        this.redisTemplate.delete((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId));
    }

    @Override
    public void closeMediationMeeting(CloseMediationMeetingRequestDTO closeMediationMeetingReqDTO) {
        DubboResult result = this.closeMediationMeetingRoomApi.closeMediationMeetingRoom(MediationMeetingConvert.getCloseMediationRoomReqDTO(closeMediationMeetingReqDTO));
        this.deleteMeetingVerificationCodes(closeMediationMeetingReqDTO.getMediationRoomId());
    }

    @Override
    public ArrayList<MediationMeetingRoomUserInfoResDTO> getMediationMeetingList(MediationMeetingListRequestDTO mediationMeetingListRequestDTO) {
        DubboResult result = this.mediationMeetingRoomApi.getMediationMeetingRoomList(MediationMeetingConvert.getMediationMeetingRoomListReqDTO(mediationMeetingListRequestDTO));
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (ArrayList)result.getData();
    }

    @Override
    public MediationMeetingRoomUserInfoResDTO getMediationRoomUserInfoList(CommonIdRequestDTO commonIdRequestDTO) {
        DubboResult result = this.mediationMeetingRoomApi.getMediationRoomUserInfoList(commonIdRequestDTO.getId());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        log.info((Object)("result: " + JSONObject.toJSONString((Object)result.getData())));
        return MediationMeetingConvert.getMediationMeetingRoomUserExtInfo((MediationMeetingRoomUserInfoResDTO)result.getData());
    }

    @Override
    public AddMediationRoomMeetingResponseDTO addMediationRoomMeeting(AddMediationRoomMeetingRequestDTO addMediationRoomMeetingRequestDTO) {
        DubboResult result = this.mediationMeetingRoomApi.addMediationRoomMeeting(MediationMeetingConvert.getAddMediationRoomMeetingReqDTO(addMediationRoomMeetingRequestDTO));
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        Long mediationRoomId = ((AddMediationMeetingResDTO)result.getData()).getMediationRoomId();
        String roomId = ((AddMediationMeetingResDTO)result.getData()).getRoomId();
        List infoList = ((AddMediationMeetingResDTO)result.getData()).getLitigantList();
        Date orderTime = ((AddMediationMeetingResDTO)result.getData()).getOrderTime();
        List<LitigantInfoRequestDTO> litigantInfo = MediationMeetingConvert.getLitigantInfoRequestDTOList(infoList);
        this.peaceSmsService.sendMediationMeetingSms(litigantInfo, mediationRoomId, roomId, JWTContextUtil.getCurrentUserName(), orderTime, 1);
        return new AddMediationRoomMeetingResponseDTO(roomId, mediationRoomId);
    }

    @Override
    public void addMediationRoomMeetingUser(AddMediationRoomMeetingUserRequstDTO dto) {
        List<LitigantInfoRequestDTO> litigantList = dto.getList();
        this.checkMeetingNum(litigantList.size(), dto.getMediationRoomId());
        litigantList = this.userService.registerLitigant(litigantList);
        AddMediationRoomMeetingUserReqDTO addMediationRoomMeetingUserReqDTO = MediationMeetingConvert.getAddMediationRoomMeetingUserReqDTO(dto);
        DubboResult result = this.mediationMeetingRoomApi.addMediationRoomMeetingUser(addMediationRoomMeetingUserReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        this.peaceSmsService.sendMediationMeetingSms(litigantList, dto.getMeetingId(), ((AddMediationMeetingResDTO)result.getData()).getRoomId(), JWTContextUtil.getCurrentUserName(), ((AddMediationMeetingResDTO)result.getData()).getOrderTime(), 1);
    }

    @Override
    public ArrayList<MeetingVideoResDTO> getVideoList(CommonIdRequestDTO dto) {
        String personType = JWTContextUtil.getPersonType();
        if (!"STAFF".equals(personType)) {
            ArrayList<MeetingVideoResDTO> list = new ArrayList<MeetingVideoResDTO>();
            return list;
        }
        DubboResult result = this.mediationMeetingRoomApi.getVideoList(dto.getId());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (ArrayList)result.getData();
    }

    @Override
    public ArrayList<MeetingVoiceResDTO> getVoiceList(CommonIdRequestDTO dto) {
        String personType = JWTContextUtil.getPersonType();
        if (!"STAFF".equals(personType)) {
            ArrayList<MeetingVoiceResDTO> list = new ArrayList<MeetingVoiceResDTO>();
            return list;
        }
        DubboResult result = this.mediationMeetingRoomApi.getVoiceList(dto.getId());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (ArrayList)result.getData();
    }

    @Override
    public AddMediationRoomMeetingResponseDTO createMediationMeetingMicro(AddMediationMeetingMicroRequestDTO dto) {
        List agentList;
        List mediatorList;
        List<LitigantInfoRequestDTO> litigantList;
        APIResult apiResult;
        DTOCheckFieldConvert.checkLitigantInfoRequestDTO(dto.getLitigantList());
        log.info((Object)"\u521b\u5efa\u5728\u7ebf\u5ead\u5ba1\u5f00\u59cb");
        Long mediationRoomId = dto.getMediationRoomId();
        DubboResult parentRoom = null;
        String currentUserId = JWTContextUtil.getCurrentUserId();
        UserRoleInfoDTO roleInfo = this.backstageUserService.searchBackstageUserOrgId(currentUserId);
        CourtInfoRequestDTO reqDtO = new CourtInfoRequestDTO();
        reqDtO.setCourtCode(roleInfo.getOrganizationId().toString());
        reqDtO.setUserId(currentUserId);
        CourtPaymentResponseDTO courtPaymentResponseDTO = this.personalService.getCourtPayment(reqDtO);
        AssertUtils.assertTrue((boolean)courtPaymentResponseDTO.getCanCreateMeeting(), (ResultCode)ErrorCode.ACCESS_DENIED, (String)"\u60a8\u7684\u4e92\u8054\u7f51\u5ead\u5ba1\u670d\u52a1\u5df2\u5230\u671f");
        String expandAttribute = null;
        Long userId = null;
        if (mediationRoomId == null) {
            userId = Long.valueOf(JWTContextUtil.getCurrentUserId());
            AssertUtils.assertHasText((String)dto.getCauseName(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u6848\u7531\u5fc5\u987b\u8f93\u5165");
        } else {
            CommonIdReqDTO commonIdReqDTO = new CommonIdReqDTO();
            commonIdReqDTO.setId(mediationRoomId);
            parentRoom = this.mediationRoomApi.getMediationMeetingRoomInfo(commonIdReqDTO);
            AssertUtils.assertTrue((boolean)parentRoom.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)parentRoom.getMessage());
            AssertUtils.assertNotNull((Object)parentRoom.getData(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u6848\u4ef6\u7a7a\u95f4\u4e0d\u5b58\u5728!");
            AssertUtils.assertFalse((boolean)MediationMeetingRoomStatusEnum.CLOSE.name().equals(((MediationMeetingRoomInfoResDTO)parentRoom.getData()).getMediationStatus()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u6848\u4ef6\u7a7a\u95f4\u5df2\u7ed3\u675f,\u4e0d\u80fd\u53d1\u8d77\u5728\u7ebf\u5ead\u5ba1!");
            userId = ((MediationMeetingRoomInfoResDTO)parentRoom.getData()).getCreatorId();
            expandAttribute = ((MediationMeetingRoomInfoResDTO)parentRoom.getData()).getExpandAttribute();
        }
        Date orderTime = dto.getOrderTime();
        if (orderTime == null) {
            dto.setOrderTime(new Date());
        }
        AssertUtils.assertTrue(((apiResult = MediationMeetingConvert.getAllPersontListCountIgnorePhoneNoIs1111(litigantList = dto.getLitigantList(), mediatorList = dto.getMediatorList(), agentList = dto.getAgentList())).getCode() == 1000 ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)apiResult.getMessage());
        int personCount = (Integer)apiResult.getData();
        AssertUtils.assertFalse((personCount < 2 ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u81f3\u5c11\u9700\u89812\u4eba\u624d\u53ef\u4ee5\u53d1\u8d77\u5728\u7ebf\u5ead\u5ba1");
        MediationMeetingConvert.checkMeetingUserNum(personCount);
        List newList = Lists.newArrayList();
        List agentList1 = Lists.newArrayList();
        if (litigantList != null) {
            newList.addAll(litigantList);
        }
        newList.addAll(mediatorList);
        if (agentList != null) {
            agentList1.addAll(agentList);
        }
        litigantList = this.userService.registerLitigant(litigantList);
        this.userService.registerAgentLitigant(agentList);
        AddMediationMeetingRoomMicroReqDTO reqDTO = MediationMeetingConvert.getAddMediationMeetingRoomMicroReqDTO(dto, expandAttribute, (MediationMeetingRoomInfoResDTO)parentRoom.getData());
        reqDTO.setOrgId(roleInfo.getOrganizationId());
        reqDTO.setOrgName(roleInfo.getOrganizationName());
        if (dto.getScheduleId() != null) {
            reqDTO.setScheduleId(dto.getScheduleId());
        }
        if (reqDTO.getThirdCaseId() != null) {
            reqDTO.setScheduleId(this.trialDubboApiService.getScheduleId(reqDTO.getThirdCaseId()));
        }
        LitigantInfoRequestDTO checkMdiator = this.mediationRoomService.checkMdiator(mediatorList);
        this.checkAndQueryMediatorInfo(mediatorList);
        log.info((Object)("==============------userId---------===================" + userId));
        MediationMeetingUserInfoReqDTO mediator = this.userService.getMediatorInfo(userId);
        DubboResult result = this.mediationMeetingRoomApi.addMediationMeetingMicro(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        this.mediationRoomService.updateCaseKtfs(reqDTO.getThirdCaseId(), "ON_LINE");
        AddMediationMeetingResDTO resDTO = (AddMediationMeetingResDTO)result.getData();
        String appName = AppNameContextHolder.getAppName();
        ArrayList<MediationMeetingUserInfoReqDTO> userList = new ArrayList<MediationMeetingUserInfoReqDTO>();
        List<String> phoneList = this.getSendUserPhoneForCreateOnlineMeeting(reqDTO);
        this.sendSms(appName, phoneList, resDTO, dto, mediator, userList, reqDTO);
        List mediatorNewList = Lists.newArrayList();
        for (LitigantInfoRequestDTO medi : mediatorList) {
            if (currentUserId.equals(String.valueOf(medi.getUserId())) || checkMdiator.getMobilePhone() != null && checkMdiator.getMobilePhone().equals(medi.getMobilePhone())) continue;
            mediatorNewList.add(medi);
        }
        this.peaceSmsService.sendStaffSms(mediatorNewList, dto.getOrderTime(), dto.getMediationRoomName());
        AddMediationRoomMeetingResponseDTO resp = new AddMediationRoomMeetingResponseDTO(resDTO.getRoomId(), resDTO.getMediationRoomId());
        log.info((Object)("\u521b\u5efa\u5728\u7ebf\u5ead\u5ba1\u7ed3\u675f:" + resp.getMediationRoomId()));
        if (mediationRoomId != null) {
            userList.add(mediator);
            List<MediationMeetingUsersInfoReqDTO> usersInfoList = this.handle(userList);
            log.info((Object)"MediationMeetingUsersInfoReqDTO userList is:");
            System.out.println(userList);
            System.out.println(usersInfoList);
            this.sendTextInvitationVideo(MediationMeetingConvert.getInvitationVideoSendText(mediationRoomId, resp, (MediationMeetingRoomInfoResDTO)parentRoom.getData(), reqDTO), usersInfoList);
        }
        return resp;
    }

    public DubboResult<String> sendTextInvitationVideo(InvitationVideoSendTextRequestDTO dto, List<MediationMeetingUsersInfoReqDTO> userList) {
        List<MemberResDTO> members = userList.stream().filter(x -> x.getUserId() != null).map(this::getMemberResDTO).collect(Collectors.toList());
        String readUserIds = this.sendMsgUtils.findReadUserIdsByUserList(members, dto.getRoomId());
        SendTextMessageReqDTO messageResDTO = new SendTextMessageReqDTO(dto.getRoomId(), dto.getMemberId(), dto.getReceiverId(), dto.getContent(), new MessageResourceEnums[]{MessageResourceEnums.INVITATION_VIDEO});
        String str = "\u5ba1\u5224\u5458#{name}\u5411 #{users} \u53d1\u8d77\u4e86\u5728\u7ebf\u5ead\u5ba1\u4f1a\u8bae\uff0c\u8bf7\u53ca\u65f6\u8fdb\u5165";
        String mediator = userList.stream().filter(x -> "MEDIATOR".equals(x.getMeetingUserType())).map(e -> e.getUserName().toString()).collect(Collectors.joining("\u3001"));
        String users = userList.stream().filter(x -> !"MEDIATOR".equals(x.getMeetingUserType())).map(e -> " @".concat(e.getUserName().toString())).collect(Collectors.joining("\u3001"));
        str = str.replace("#{name}", mediator).replace("#{users}", users);
        messageResDTO.setSearchContent(str);
        messageResDTO.setReadUserIds(readUserIds);
        DubboResult res = this.roomApi.sendTextMessage(messageResDTO);
        MessageResponseDTO messageResponseDTO = new MessageResponseDTO((MessageResDTO)res.getData(), MessageResourceEnums.INVITATION_VIDEO, dto.getRoomId());
        messageResponseDTO.setBizRoomId(dto.getBizRoomId());
        this.sendMsgUtils.getReadStatus(Arrays.asList(readUserIds.split(",")), members, messageResponseDTO);
        WebSocketResponseDTO resData = new WebSocketResponseDTO(ServerEventEnums.BROADCAST_MESSAGE, (Object)messageResponseDTO);
        String memberId = dto.getMemberId();
        String[] receivers = null;
        receivers = members.stream().map(MemberResDTO::getMemberId).collect(Collectors.joining(",")).split(",");
        String roomId = dto.getRoomId();
        PeaceImEventMqEntity sendDTO = new PeaceImEventMqEntity(roomId, memberId, receivers, ClientEventEnums.SEND_TEXT, resData);
        this.senderService.sendMessage(sendDTO);
        this.unreadMessageService.incrUnreadCountCache(memberId, dto.getBizRoomId(), roomId, dto.getContent(), CategoryBigEnums.TEXT.name(), MessageResourceEnums.INVITATION_VIDEO.name());
        log.info((Object)("TextMessageProcessorPoint:" + JSON.toJSON((Object)sendDTO)));
        return DubboResultBuilder.success((Serializable)((Object)""));
    }

    private MemberResDTO getMemberResDTO(MediationMeetingUsersInfoReqDTO x) {
        MemberResDTO memberResDTO = new MemberResDTO();
        memberResDTO.setMemberId(String.valueOf(x.getUserId()));
        memberResDTO.setMemberName(x.getUserName());
        memberResDTO.setMemberType(x.getMeetingUserType());
        return memberResDTO;
    }

    private void sendSms(String appName, List<String> phoneList, AddMediationMeetingResDTO resDTO, AddMediationMeetingMicroRequestDTO dto, MediationMeetingUserInfoReqDTO mediator, List<MediationMeetingUserInfoReqDTO> userList, AddMediationMeetingRoomMicroReqDTO reqDTO) {
        if (!"weitingshenhubei".equals(appName) && !"weitingshenhubeizz".equals(appName)) {
            this.peaceSmsService.sendMediationMeetingSmsByPhoneList(phoneList, resDTO.getMediationRoomId(), dto.getMediationRoomName(), resDTO.getRoomId(), mediator.getUserName(), resDTO.getOrderTime(), dto.getAuthFlag());
        } else if ("weitingshenhubeizz".equals(appName)) {
            userList.addAll(MediationMeetingConvert.getUserList(reqDTO.getLitigantList(), reqDTO.getAgentList()));
            this.smsHubeiZzService.sendMediationMeetingSmsByDTO(userList, resDTO.getMediationRoomId(), dto.getMediationRoomName(), resDTO.getRoomId(), mediator.getUserName(), resDTO.getOrderTime(), dto.getAuthFlag());
            this.smsHubeiZzService.sendMediationMeetingDiscipline(phoneList);
        } else {
            userList.addAll(MediationMeetingConvert.getUserList(reqDTO.getLitigantList(), reqDTO.getAgentList()));
            this.smsHubeiService.sendMediationMeetingSmsByDTO(userList, resDTO.getMediationRoomId(), dto.getMediationRoomName(), resDTO.getRoomId(), mediator.getUserName(), resDTO.getOrderTime(), dto.getAuthFlag());
            this.smsHubeiService.sendMediationMeetingDiscipline(phoneList);
        }
    }

    private List<MediationMeetingUsersInfoReqDTO> handle(List<MediationMeetingUserInfoReqDTO> userList) {
        List<Object> usersInfoList = new ArrayList<MediationMeetingUsersInfoReqDTO>();
        if (userList.size() > 0) {
            usersInfoList = userList.stream().map(userInfoReqDTO -> {
                MediationMeetingUsersInfoReqDTO usersInfo = new MediationMeetingUsersInfoReqDTO();
                BeanUtils.copyProperties((Object)userInfoReqDTO, (Object)usersInfo);
                return usersInfo;
            }).collect(Collectors.toList());
        }
        return usersInfoList;
    }

    @Override
    public AddMediationRoomMeetingResponseDTO createMediationMeetingMicroByTdh(AddMediationMeetingMicroRequestDTO dto, Long uId) {
        List agentList;
        List mediatorList;
        List<LitigantInfoRequestDTO> litigantList;
        APIResult apiResult;
        DTOCheckFieldConvert.checkLitigantInfoRequestDTO(dto.getLitigantList());
        log.info((Object)"\u521b\u5efa\u5728\u7ebf\u5ead\u5ba1\u5f00\u59cb");
        Long mediationRoomId = dto.getMediationRoomId();
        DubboResult parentRoom = null;
        String currentUserId = String.valueOf(uId);
        UserRoleInfoDTO roleInfo = this.backstageUserService.searchBackstageUserOrgId(currentUserId);
        CourtInfoRequestDTO reqDtO = new CourtInfoRequestDTO();
        reqDtO.setCourtCode(roleInfo.getOrganizationId().toString());
        reqDtO.setUserId(currentUserId);
        CourtPaymentResponseDTO courtPaymentResponseDTO = this.personalService.getCourtPayment(reqDtO);
        AssertUtils.assertTrue((boolean)courtPaymentResponseDTO.getCanCreateMeeting(), (ResultCode)ErrorCode.ACCESS_DENIED, (String)"\u60a8\u7684\u4e92\u8054\u7f51\u5ead\u5ba1\u670d\u52a1\u5df2\u5230\u671f");
        String expandAttribute = null;
        Long userId = null;
        if (mediationRoomId == null) {
            userId = Long.valueOf(JWTContextUtil.getCurrentUserId());
            AssertUtils.assertHasText((String)dto.getCauseName(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u6848\u7531\u5fc5\u987b\u8f93\u5165");
        } else {
            CommonIdReqDTO commonIdReqDTO = new CommonIdReqDTO();
            commonIdReqDTO.setId(mediationRoomId);
            parentRoom = this.mediationRoomApi.getMediationMeetingRoomInfo(commonIdReqDTO);
            AssertUtils.assertTrue((boolean)parentRoom.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)parentRoom.getMessage());
            AssertUtils.assertNotNull((Object)parentRoom.getData(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u6848\u4ef6\u7a7a\u95f4\u4e0d\u5b58\u5728!");
            AssertUtils.assertFalse((boolean)MediationMeetingRoomStatusEnum.CLOSE.name().equals(((MediationMeetingRoomInfoResDTO)parentRoom.getData()).getMediationStatus()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u6848\u4ef6\u7a7a\u95f4\u5df2\u7ed3\u675f,\u4e0d\u80fd\u53d1\u8d77\u5728\u7ebf\u5ead\u5ba1!");
            userId = ((MediationMeetingRoomInfoResDTO)parentRoom.getData()).getCreatorId();
            expandAttribute = ((MediationMeetingRoomInfoResDTO)parentRoom.getData()).getExpandAttribute();
        }
        Date orderTime = dto.getOrderTime();
        if (orderTime == null) {
            dto.setOrderTime(new Date());
        }
        AssertUtils.assertTrue(((apiResult = MediationMeetingConvert.getAllPersontListCountIgnorePhoneNoIs1111(litigantList = dto.getLitigantList(), mediatorList = dto.getMediatorList(), agentList = dto.getAgentList())).getCode() == 1000 ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)apiResult.getMessage());
        int personCount = (Integer)apiResult.getData();
        AssertUtils.assertFalse((personCount < 2 ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u81f3\u5c11\u9700\u89812\u4eba\u624d\u53ef\u4ee5\u53d1\u8d77\u5728\u7ebf\u5ead\u5ba1");
        MediationMeetingConvert.checkMeetingUserNum(personCount);
        List newList = Lists.newArrayList();
        List agentList1 = Lists.newArrayList();
        if (litigantList != null) {
            newList.addAll(litigantList);
        }
        newList.addAll(mediatorList);
        if (agentList != null) {
            agentList1.addAll(agentList);
        }
        litigantList = this.userService.registerLitigant(litigantList);
        this.userService.registerAgentLitigant(agentList);
        AddMediationMeetingRoomMicroReqDTO reqDTO = MediationMeetingConvert.getAddMediationMeetingRoomMicroReqDTO(dto, expandAttribute, (MediationMeetingRoomInfoResDTO)parentRoom.getData());
        reqDTO.setOrgId(roleInfo.getOrganizationId());
        reqDTO.setOrgName(roleInfo.getOrganizationName());
        if (dto.getScheduleId() != null) {
            reqDTO.setScheduleId(dto.getScheduleId());
        }
        if (reqDTO.getThirdCaseId() != null) {
            reqDTO.setScheduleId(this.trialDubboApiService.getScheduleId(reqDTO.getThirdCaseId()));
        }
        this.checkAndQueryMediatorInfo(mediatorList);
        MediationMeetingUserInfoReqDTO mediator = this.userService.getMediatorInfo(uId);
        ArrayList<MediationMeetingUserInfoReqDTO> userList = new ArrayList();
        DubboResult result = this.mediationMeetingRoomApi.addMediationMeetingMicro(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        this.mediationRoomService.updateCaseKtfs(reqDTO.getThirdCaseId(), "ON_LINE");
        AddMediationMeetingResDTO resDTO = (AddMediationMeetingResDTO)result.getData();
        String appName = AppNameContextHolder.getAppName();
        List<String> phoneList = this.getSendUserPhoneForCreateOnlineMeeting(reqDTO);
        if (!"weitingshenhubei".equals(appName)) {
            this.peaceSmsService.sendMediationMeetingSmsByPhoneList(phoneList, resDTO.getMediationRoomId(), dto.getMediationRoomName(), resDTO.getRoomId(), mediator.getUserName(), resDTO.getOrderTime(), dto.getAuthFlag());
        } else {
            userList = MediationMeetingConvert.getUserList(reqDTO.getLitigantList(), reqDTO.getAgentList());
            this.smsHubeiService.sendMediationMeetingSmsByDTO(userList, resDTO.getMediationRoomId(), dto.getMediationRoomName(), resDTO.getRoomId(), mediator.getUserName(), resDTO.getOrderTime(), dto.getAuthFlag());
            this.smsHubeiService.sendMediationMeetingDiscipline(phoneList);
        }
        List mediatorNewList = Lists.newArrayList();
        for (LitigantInfoRequestDTO medi : mediatorList) {
            if (uId.equals(String.valueOf(medi.getUserId()))) continue;
            mediatorNewList.add(medi);
        }
        this.peaceSmsService.sendStaffSms(mediatorNewList, dto.getOrderTime(), dto.getMediationRoomName());
        AddMediationRoomMeetingResponseDTO resp = new AddMediationRoomMeetingResponseDTO(resDTO.getRoomId(), resDTO.getMediationRoomId());
        log.info((Object)("\u521b\u5efa\u5728\u7ebf\u5ead\u5ba1\u7ed3\u675f:" + resp.getMediationRoomId()));
        if (mediationRoomId != null) {
            userList.add(mediator);
            ArrayList<MediationMeetingUsersInfoReqDTO> usersInfoList = new ArrayList();
            if (!CollectionUtils.isEmpty(userList)) {
                usersInfoList = userList.stream().map(userInfoReqDTO -> {
                    MediationMeetingUsersInfoReqDTO usersInfo = new MediationMeetingUsersInfoReqDTO();
                    BeanUtils.copyProperties((Object)userInfoReqDTO, (Object)usersInfo);
                    return usersInfo;
                }).collect(Collectors.toList());
            }
            this.sendTextInvitationVideo(MediationMeetingConvert.getInvitationVideoSendTextByTdh(mediationRoomId, resp, (MediationMeetingRoomInfoResDTO)parentRoom.getData(), reqDTO, uId), usersInfoList);
        }
        return resp;
    }

    private List<String> getSendUserPhoneForCreateOnlineMeeting(AddMediationMeetingRoomMicroReqDTO reqDTO) {
        List litigantList;
        List allUser = Lists.newArrayList();
        List agentList = reqDTO.getAgentList();
        if (agentList != null) {
            allUser.addAll(agentList);
        }
        if ((litigantList = reqDTO.getLitigantList()) != null) {
            for (MediationMeetingUserInfoReqDTO litigant : litigantList) {
                if (StringUtils.isEmpty((CharSequence)litigant.getMobilePhone())) continue;
                allUser.add(litigant);
            }
        }
        Set phoneSet = allUser.stream().map(MediationMeetingUserInfoReqDTO::getMobilePhone).collect(Collectors.toSet());
        phoneSet.remove("1111");
        return new ArrayList<String>(phoneSet);
    }

    @Override
    public void addMediationMeetingUserMicro(AddMediationMeetingUserRequestMicroDTO reqDTO) {
        if (reqDTO.getLitigantList() != null && reqDTO.getLitigantList().size() > 0) {
            DTOCheckFieldConvert.checkLitigantInfoRequestDTO(reqDTO.getLitigantList());
        }
        this.checkRepeatUser(reqDTO);
        List<LitigantInfoRequestDTO> litigantList = reqDTO.getLitigantList();
        List mediatorList = reqDTO.getMediatorList();
        litigantList = litigantList == null ? Lists.newArrayList() : litigantList;
        litigantList = this.userService.registerLitigant(litigantList);
        List<MediationMeetingUserInfoReqDTO> mList = Lists.newArrayList();
        if (mediatorList != null) {
            mList = this.checkAndQueryMediatorInfo(mediatorList);
        }
        AddMediationMeetingRoomUserMicroReqDTO dubboReqDto = MediationMeetingConvert.gerAddMediationMeetingRoomUserMicroReqDTO(reqDTO);
        dubboReqDto.setMediatorList(mList);
        List agentList = MediationMeetingConvert.getAgentList(reqDTO);
        if (agentList != null) {
            this.userService.registerAgentLitigant(agentList);
        } else {
            agentList = Lists.newArrayList();
        }
        List agentListReq = Lists.newArrayList();
        for (LitigantAgentInfoMicroRequestDTO agentUser : agentList) {
            List<MediationMeetingUserInfoReqDTO> oneAgentUserList = MediationMeetingConvert.getMediationMeetingUserInfoMicroReq(agentUser);
            agentListReq.addAll(oneAgentUserList);
        }
        dubboReqDto.setAgentList(agentListReq);
        DubboResult result = this.mediationMeetingRoomApi.addMediationMeetingRoomUserMicro(dubboReqDto);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        List sendUserList = ((AddMediationMeetingResDTO)result.getData()).getLitigantList();
        List<String> commonPhoneList = this.getCommonPhoneList(sendUserList);
        List<LitigantInfoRequestDTO> mediationList = this.getStaffList(sendUserList);
        String appName = AppNameContextHolder.getAppName();
        if (!"weitingshenhubei".equals(appName)) {
            this.peaceSmsService.sendMediationMeetingSmsByPhoneList(commonPhoneList, ((AddMediationMeetingResDTO)result.getData()).getMediationRoomId(), ((AddMediationMeetingResDTO)result.getData()).getName(), ((AddMediationMeetingResDTO)result.getData()).getRoomId(), JWTContextUtil.getCurrentUserName(), ((AddMediationMeetingResDTO)result.getData()).getOrderTime(), 1);
        } else {
            List<MediationMeetingUserInfoReqDTO> userList = MediationMeetingConvert.getUserList(sendUserList, null);
            this.smsHubeiService.sendMediationMeetingSmsByDTO(userList, ((AddMediationMeetingResDTO)result.getData()).getMediationRoomId(), ((AddMediationMeetingResDTO)result.getData()).getName(), ((AddMediationMeetingResDTO)result.getData()).getRoomId(), JWTContextUtil.getCurrentUserName(), ((AddMediationMeetingResDTO)result.getData()).getOrderTime(), 1);
            this.smsHubeiService.sendMediationMeetingDiscipline(commonPhoneList);
        }
        this.peaceSmsService.sendStaffSms(mediationList, ((AddMediationMeetingResDTO)result.getData()).getOrderTime(), ((AddMediationMeetingResDTO)result.getData()).getName());
    }

    private List<LitigantInfoRequestDTO> getStaffList(List<MediationMeetingUserInfoReqDTO> sendUserList) {
        Set<String> staffSet = this.getStaffSet();
        List staffList = Lists.newArrayList();
        for (MediationMeetingUserInfoReqDTO dto : sendUserList) {
            if (!staffSet.contains(dto.getMeetingUserType())) continue;
            LitigantInfoRequestDTO rDto = new LitigantInfoRequestDTO();
            rDto.setUserName(dto.getUserName());
            rDto.setMobilePhone(dto.getMobilePhone());
            staffList.add(rDto);
        }
        return staffList;
    }

    private List<String> getCommonPhoneList(List<MediationMeetingUserInfoReqDTO> sendUserList) {
        Set<String> staffSet = this.getStaffSet();
        List<String> commonPhoneList = sendUserList.stream().filter(o -> !staffSet.contains(o.getMeetingUserType()) && o.getMobilePhone() != null).map(MediationMeetingUserInfoReqDTO::getMobilePhone).collect(Collectors.toList());
        return commonPhoneList;
    }

    private Set<String> getStaffSet() {
        HashSet<String> staffSet = new HashSet<String>();
        staffSet.add("MEDIATOR");
        staffSet.add("JUROR");
        staffSet.add("ASSISTANT_JUDGE");
        staffSet.add("CLERK");
        staffSet.add("JUDGE");
        return staffSet;
    }

    private List<MediationMeetingUserInfoReqDTO> checkAndQueryMediatorInfo(List<LitigantInfoRequestDTO> mediatorList) {
        List mList = Lists.newArrayList();
        for (LitigantInfoRequestDTO req : mediatorList) {
            MediationMeetingUserInfoReqDTO mediatorInfo = this.userService.getMediatorInfo(req.getUserId());
            mediatorInfo.setMeetingUserType(req.getMeetingUserType().name());
            mediatorInfo.setExpandAttribute(MediationMeetingConvert.buildMediatorJsonInfo(req));
            mList.add(mediatorInfo);
        }
        return mList;
    }

    @Override
    public void deleteMediationRoomMeeting(DeleteMediationMeetingMicroRequestDTO dto) {
        DubboResult caseMeetingDubbo = this.mediationRoomApi.mediationRoomById(Long.valueOf(dto.getBizRoomId()));
        AssertUtils.assertNotNull((Object)caseMeetingDubbo.getData(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        CaseMeetingInfoResDTO caseMeeting = (CaseMeetingInfoResDTO)caseMeetingDubbo.getData();
        if (MediationMeetingTypeEnum.MEDIATION_ROOM.name().equals(caseMeeting.getMediationMeetingType())) {
            this.commonDeleteRoomMeeting(dto.getBizRoomId(), dto.getUserName());
            this.mediationRoomService.deleteVerificationCodes(Long.valueOf(dto.getBizRoomId()));
            DubboResult caseMeetingsDubbo = this.mediationRoomApi.mediationRoomByParentId(caseMeeting.getId());
            if (!CollectionUtils.isEmpty((Collection)((Collection)((Object)caseMeetingsDubbo.getData())))) {
                for (CaseMeetingInfoResDTO one : (ArrayList)caseMeetingsDubbo.getData()) {
                    this.commonDeleteRoomMeeting(one.getId().toString(), dto.getUserName());
                    this.deleteMeetingVerificationCodes(one.getId());
                }
            }
        } else if (MediationMeetingTypeEnum.MEDIATION_MEETING.name().equals(caseMeeting.getMediationMeetingType())) {
            this.commonDeleteRoomMeeting(dto.getBizRoomId(), dto.getUserName());
            this.deleteMeetingVerificationCodes(Long.valueOf(dto.getBizRoomId()));
        }
    }

    public void commonDeleteRoomMeeting(String bizRoomId, String userName) {
        DubboResult mediationRoomDelResult = this.mediationRoomApi.deleteMediationRoom(Long.valueOf(bizRoomId), userName);
        DubboResult roomDelresult = this.roomMediationApi.deleteRoom(bizRoomId, userName);
        AssertUtils.assertTrue((mediationRoomDelResult.isSuccess() && roomDelresult.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.UNEXCEPTED, (String)ErrorCode.UNEXCEPTED.name());
    }

    @Override
    public GetCaseInfoResponseDTO getCaseInfo(GetCaseInfoRequestDTO dto) {
        DubboResult meetingDubbo;
        DubboResult meetingInfo = this.mediationRoomApi.selectCaseMeetingInfo(dto.getBizRoomId());
        AssertUtils.assertNotNull((Object)meetingInfo.getData(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        GetCaseInfoResponseDTO result = new GetCaseInfoResponseDTO((CaseMeetingRoomInfoResDTO)meetingInfo.getData());
        String holdCourt = "";
        holdCourt = ((CaseMeetingRoomInfoResDTO)meetingInfo.getData()).getStartTime() != null && ((CaseMeetingRoomInfoResDTO)meetingInfo.getData()).getEndTime() != null ? ((CaseMeetingRoomInfoResDTO)meetingInfo.getData()).getStartTime().substring(0, 16) + "\u2014\u2014" + ((CaseMeetingRoomInfoResDTO)meetingInfo.getData()).getEndTime().substring(11, 16) : (((CaseMeetingRoomInfoResDTO)meetingInfo.getData()).getStartTime() != null ? ((CaseMeetingRoomInfoResDTO)meetingInfo.getData()).getStartTime().substring(0, 16) : ((CaseMeetingRoomInfoResDTO)meetingInfo.getData()).getOrderTime().substring(0, 16));
        result.setHoldCourt(holdCourt);
        String thirdCaseId = ((CaseMeetingRoomInfoResDTO)meetingInfo.getData()).getThirdCaseId();
        if (StringUtils.isNotBlank((CharSequence)thirdCaseId)) {
            DubboResult caseInfoResult = this.trialApi.selectCaseInfoByCaseId(thirdCaseId);
            AssertUtils.assertTrue((boolean)caseInfoResult.isSuccess(), (ResultCode)ErrorCode.UNEXCEPTED, (String)ErrorCode.UNEXCEPTED.desc());
            if (caseInfoResult.getData() != null) {
                result.setSchedulingInfo(GetCaseInfoResponseDTO.toGetCaseOrders((CaseInfoResponseDTO)((CaseInfoResponseDTO)caseInfoResult.getData())));
            }
        }
        if ((meetingDubbo = this.caseRoomMicroApi.getLastMediationMeeting(dto.getBizRoomId())).isSuccess() && meetingDubbo.getData() != null) {
            CaseListMicroResponseDTO caseListMicroRes = (CaseListMicroResponseDTO)meetingDubbo.getData();
            result.setLastMediationStatus(caseListMicroRes.getMediationStatus());
            result.setLastOrderTime(caseListMicroRes.getOrderTime());
        }
        if (StringUtils.isNotBlank((CharSequence)((CaseMeetingRoomInfoResDTO)meetingInfo.getData()).getMediationType())) {
            DubboResult courtRoomNameDubbo = this.trialApi.getCourtRoomName(((CaseMeetingRoomInfoResDTO)meetingInfo.getData()).getMediationType());
            result.setCourtRoomName((String)((Object)courtRoomNameDubbo.getData()));
        }
        return result;
    }

    @Override
    public String queryEwm(String appName) {
        String code = "PEACE_SMALL_PROGRAM_URL_" + appName.toUpperCase();
        String url = this.dictionaryServiceApi.getQueryEwm(code);
        return url;
    }

    public void checkRepeatUser(AddMediationMeetingUserRequestMicroDTO reqDTO) {
        List<MediationRoomUserInfoRespDTO> roomUserInfoAllList = this.mediationRoomService.getMediationRoomUserInfoAllList(new CommonIdRequestDTO(reqDTO.getMediationRoomId()));
        List oldPhoneList = roomUserInfoAllList.stream().map(MediationRoomUserInfoRespDTO::getMobilePhone).collect(Collectors.toList());
        List allUserPhoneList = Lists.newArrayList();
        List agentPhoneList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqDTO.getLitigantList())) {
            for (LitigantInfoRequestDTO one : reqDTO.getLitigantList()) {
                if (MeetingUserTypeEnum.APPLICANT.equals((Object)one.getMeetingUserType())) {
                    AssertUtils.assertTrue((!StringUtils.isEmpty((CharSequence)one.getMobilePhone()) ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u539f\u544a\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.isNotEmpty((CharSequence)one.getMobilePhone()) || one.getPersonId() != null) continue;
                allUserPhoneList.add(one.getMobilePhone());
                agentPhoneList.add(one.getMobilePhone());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqDTO.getMediatorList())) {
            for (LitigantInfoRequestDTO one : reqDTO.getMediatorList()) {
                allUserPhoneList.add(one.getMobilePhone());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqDTO.getAgentList())) {
            for (LitigantInfoRequestDTO one : reqDTO.getAgentList()) {
                allUserPhoneList.add(one.getMobilePhone());
                String[] agentParentPhones = one.getAgentParentPhoneList().split(",");
                List<String> agentParentPhoneList = Arrays.asList(agentParentPhones);
                agentParentPhoneList.forEach(phone -> {
                    if (oldPhoneList.contains(phone)) {
                        allUserPhoneList.remove(phone);
                    }
                });
            }
        }
        for (String phone2 : allUserPhoneList) {
            if ("1111".equals(phone2) || !oldPhoneList.contains(phone2)) continue;
            AssertUtils.assertFalse((boolean)oldPhoneList.contains(phone2), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)String.join((CharSequence)"", "\u624b\u673a\u53f7", phone2, "\u5728\u8be5\u5728\u7ebf\u5ead\u5ba1\u5df2\u5b58\u5728!"));
        }
    }

    @Override
    public Integer getRoomName(@Valid CaseNameRequestDTO requestDTO, String userId) {
        Integer typeId = requestDTO.getTypeId();
        String type = null;
        String roomName = requestDTO.getRoomName();
        type = typeId != 0 && typeId.equals(1) ? MediationMeetingTypeEnum.MEDIATION_ROOM.name() : MediationMeetingTypeEnum.MEDIATION_MEETING.name();
        DubboResult roommNameResult = this.mediationRoomApi.getRoomName(roomName, type, userId);
        Integer name = (Integer)roommNameResult.getData();
        return name;
    }
}

