/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beiming.basic.chat.api.RoomMediationApi;
import com.beiming.basic.chat.api.dto.response.MemberResDTO;
import com.beiming.basic.storage.api.dto.response.FileInfoResponseDTO;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.DubboResultBuilder;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.Java8DateUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.document.api.DocDossierApi;
import com.beiming.odr.document.dto.requestdto.MemberRequestDTO;
import com.beiming.odr.document.dto.responsedto.DocIdResDTO;
import com.beiming.odr.peace.api.PeaceIntranetApi;
import com.beiming.odr.peace.api.dto.requestdto.PeaceIntranetCloseRoomRequestDTO;
import com.beiming.odr.peace.common.constants.PeaceConst;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.enums.SMSTypeEnums;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingUserRequestMicroDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMeetingIntranetRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ChatMsgRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CloseMediationMeetingRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CourtInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DossierRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantAgentInfoMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SuspectReportRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.CourtPaymentResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MessageResponseDTO;
import com.beiming.odr.peace.service.BackstageUserService;
import com.beiming.odr.peace.service.PeaceSmsService;
import com.beiming.odr.peace.service.PersonalService;
import com.beiming.odr.peace.service.SMSHubeiService;
import com.beiming.odr.peace.service.backend.document.DocDossierDubboService;
import com.beiming.odr.peace.service.backend.storage.StorageDubboService;
import com.beiming.odr.peace.service.backend.user.DictionaryService;
import com.beiming.odr.peace.service.backend.user.UserBackendService;
import com.beiming.odr.peace.service.client.ClerkRecordService;
import com.beiming.odr.peace.service.convert.DTOCheckFieldConvert;
import com.beiming.odr.peace.service.convert.IntranetMediationMeetingConvert;
import com.beiming.odr.peace.service.convert.MediationMeetingConvert;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.peace.service.impl.ChatServiceImpl;
import com.beiming.odr.peace.service.util.Base64Utils;
import com.beiming.odr.peace.service.util.SMSUtil;
import com.beiming.odr.referee.api.CloseMediationMeetingRoomApi;
import com.beiming.odr.referee.api.MediationMeetingApi;
import com.beiming.odr.referee.api.MediationMeetingRoomApi;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.requestdto.AddMediationMeetingRoomMicroReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationMeetingRoomUserMicroReqDTO;
import com.beiming.odr.referee.dto.requestdto.CloseMediationRoomReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingUserInfoReqDTO;
import com.beiming.odr.referee.dto.responsedto.AddMediationMeetingResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingRoomInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomUserInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingMoreThan4HoursResDTO;
import com.beiming.odr.user.api.BackstageUserMicroServiceApi;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beust.jcommander.internal.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PeaceIntranetApiImpl
implements PeaceIntranetApi {
    private static final Logger log = LoggerFactory.getLogger(PeaceIntranetApiImpl.class);
    @Resource
    private CloseMediationMeetingRoomApi closeMediationMeetingRoomApi;
    @Resource
    private RedisService redisService;
    @Resource
    private ChatServiceImpl chatService;
    @Resource
    private RoomMediationApi roomMediationApi;
    @Resource
    private StorageDubboService storageDubboService;
    @Resource
    private UserBackendService userBackendService;
    @Resource
    private BackstageUserService backstageUserService;
    @Resource
    private MediationMeetingRoomApi mediationMeetingRoomApi;
    @Resource
    private MediationMeetingApi mediationMeetingApi;
    @Resource
    private PeaceSmsService peaceSmsService;
    @Resource
    private BackstageUserMicroServiceApi backstageUserMicroServiceApi;
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Resource
    private DocDossierApi docDossierApi;
    @Resource
    private DictionaryService dictionaryService;
    @Resource
    private SMSUtil smsUtil;
    @Resource
    private UserBackendService userService;
    @Resource
    private SMSHubeiService smsHubeiService;
    private RedisTemplate redisTemplate;
    @Value(value="${peace.meetingNum}")
    private Long meetingNum;
    @Resource
    private PersonalService personalService;
    @Resource
    private ClerkRecordService clerkRecordService;
    @Resource
    private DocDossierDubboService docDossierDubboService;
    public static final String[] TEST_ALLOW_LIST = new String[]{"15930680504", "18434360144"};

    public DubboResult<String> closeRoom(PeaceIntranetCloseRoomRequestDTO dto) {
        AssertUtils.assertTrue((dto.getBizRoomId() != null ? 1 : 0) != 0, (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        CloseMediationRoomReqDTO closeMediationRoomReqDTO = new CloseMediationRoomReqDTO();
        closeMediationRoomReqDTO.setMediationRoomId(dto.getBizRoomId());
        closeMediationRoomReqDTO.setUserId(dto.getUserId());
        closeMediationRoomReqDTO.setUserName(dto.getUserName());
        DubboResult result = this.closeMediationMeetingRoomApi.closeMediationMeetingRoom(closeMediationRoomReqDTO);
        this.deleteMeetingVerificationCodes(dto.getBizRoomId());
        return DubboResultBuilder.success((Serializable)((Object)result.getMessage()));
    }

    public void closeMediationMeeting(CloseMediationMeetingRequestDTO closeMediationMeetingReqDTO) {
        AppNameContextHolder.setAppName((String)"weitingshen");
        DubboResult result = this.closeMediationMeetingRoomApi.closeMediationMeetingRoomTwo(MediationMeetingConvert.getCloseMediationRoomReqDTOTwo(closeMediationMeetingReqDTO));
        log.info("result={}", (Object)JSON.toJSONString((Object)result));
        AppNameContextHolder.setAppName((String)"weitingshen");
        this.deleteMeetingVerificationCodes(closeMediationMeetingReqDTO.getMediationRoomId());
    }

    public PageInfo<MessageResponseDTO> listAllMessage(ChatMsgRequestDTO dto) {
        return this.chatService.listAllMessage(dto);
    }

    public ArrayList<MeetingMoreThan4HoursResDTO> closedCourtroomPopUpReminder(String userId) {
        DubboResult dubboResult = this.mediationMeetingRoomApi.getMeetingRoomListMoreThan4Hours(userId, null);
        return dubboResult.getData() != null ? (ArrayList)dubboResult.getData() : new ArrayList<MeetingMoreThan4HoursResDTO>();
    }

    public ArrayList<MediationMeetingRoomUserInfoResDTO> queryAllCanCloseMediationMeetingList() {
        DubboResult result = this.mediationMeetingRoomApi.queryAllCanCloseMediationMeetingList();
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (ArrayList)result.getData();
    }

    public String getRealRoomId(String roomId) {
        DubboResult result = this.roomMediationApi.getRealRoomId(roomId);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (String)((Object)result.getData());
    }

    public DubboResult<String> closeRoomHuBei(PeaceIntranetCloseRoomRequestDTO dto) {
        AssertUtils.assertTrue((dto.getBizRoomId() != null ? 1 : 0) != 0, (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        CloseMediationRoomReqDTO closeMediationRoomReqDTO = new CloseMediationRoomReqDTO();
        closeMediationRoomReqDTO.setMediationRoomId(dto.getBizRoomId());
        closeMediationRoomReqDTO.setUserId(dto.getUserId());
        closeMediationRoomReqDTO.setUserName(dto.getUserName());
        DubboResult result = this.closeMediationMeetingRoomApi.deleteMediationMeetingRoom(closeMediationRoomReqDTO);
        this.deleteMeetingVerificationCodes(dto.getBizRoomId());
        return DubboResultBuilder.success((Serializable)((Object)result.getMessage()));
    }

    void deleteMeetingVerificationCodes(Long mediationRoomId) {
        String[] verificationCodeList;
        String appName;
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        this.redisTemplate = this.redisService.getRedisTemplate();
        String verificationCodes = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId));
        if (StringUtils.isBlank((String)verificationCodes)) {
            return;
        }
        for (String verificationCode : verificationCodeList = verificationCodes.split(",")) {
            this.redisTemplate.delete((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode));
        }
        this.redisTemplate.delete((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId));
    }

    public DubboResult<String> getFileBase64Bytes(String fileId) {
        String fileBase64Bytes = null;
        FileInfoResponseDTO fileData = this.storageDubboService.getFileInfo(fileId);
        if (fileData != null) {
            fileBase64Bytes = Base64Utils.encodeBase64String(fileData.getFileByte());
        }
        return DubboResultBuilder.success(fileBase64Bytes);
    }

    public DubboResult<String> createMedationMeeting(AddMeetingIntranetRequestDTO dto) {
        Date orderTime;
        log.info("\u5f00\u59cb\u6253\u5370\u81ea\u52a8\u521b\u5efa\u6392\u671f\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        CourtInfoRequestDTO reqDtO = new CourtInfoRequestDTO();
        reqDtO.setCourtCode(dto.getCourtCode());
        reqDtO.setUserId(dto.getStaffUserId().toString());
        CourtPaymentResponseDTO courtPaymentResponseDTO = this.personalService.getCourtPayment(reqDtO);
        AssertUtils.assertTrue((boolean)courtPaymentResponseDTO.getCanCreateMeeting(), (ResultCode)ErrorCode.ACCESS_DENIED, (String)"\u60a8\u7684\u4e92\u8054\u7f51\u5ead\u5ba1\u670d\u52a1\u5df2\u5230\u671f");
        if (StringUtils.isBlank((String)dto.getRowUuid())) {
            DTOCheckFieldConvert.buildIntranetTempId(dto);
        }
        DTOCheckFieldConvert.checkIntranetAddMeetingDTO(dto);
        if (StringUtils.isBlank((String)dto.getRowUuid())) {
            DTOCheckFieldConvert.buildIntranetTempId(dto);
        }
        AssertUtils.assertTrue(((orderTime = dto.getOrderTime()) != null ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u9884\u7ea6\u65f6\u95f4\u4e3a\u7a7a");
        List<LitigantInfoRequestDTO> litigantList = dto.getLitigantList();
        List mediatorList = dto.getMediatorList();
        List agentList = dto.getAgentList();
        APIResult apiResult = MediationMeetingConvert.getAllPersontListCountIgnorePhoneNoIs1111(litigantList, mediatorList, agentList);
        AssertUtils.assertTrue((apiResult.getCode() == 1000 ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)apiResult.getMessage());
        int personCount = (Integer)apiResult.getData();
        AssertUtils.assertFalse((personCount < 2 ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u81f3\u5c11\u9700\u89812\u4eba\u624d\u53ef\u4ee5\u53d1\u8d77\u5728\u7ebf\u5ead\u5ba1");
        MediationMeetingConvert.checkMeetingUserNum(personCount);
        List newList = Lists.newArrayList();
        List agentList1 = Lists.newArrayList();
        if (litigantList != null) {
            newList.addAll(litigantList);
        }
        newList.addAll(mediatorList);
        if (agentList != null) {
            agentList1.addAll(agentList);
        }
        litigantList = this.userBackendService.registerLitigant(litigantList);
        this.authentication(litigantList);
        this.userBackendService.registerAgentLitigant(agentList);
        AddMediationMeetingRoomMicroReqDTO reqDTO = IntranetMediationMeetingConvert.getAddMediationMeetingRoomMicroReqDTO(dto);
        LitigantInfoRequestDTO mediator = (LitigantInfoRequestDTO)mediatorList.get(0);
        reqDTO.setCreatorId(mediator.getUserId());
        reqDTO.setCreateUser(mediator.getUserName());
        reqDTO.setUpdateUser(mediator.getUserName());
        UserRoleInfoDTO roleInfo = this.backstageUserService.searchBackstageUserOrgId(mediator.getUserId().toString());
        reqDTO.setOrgId(Long.valueOf(dto.getCourtCode()));
        reqDTO.setOrgName(roleInfo.getOrganizationName());
        reqDTO.setThirdCaseId(dto.getRowUuid());
        DubboResult result = this.mediationMeetingRoomApi.addMediationMeetingMicro(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u4fdd\u5b58\u81ea\u52a8\u6392\u671f\u6570\u636e\u5931\u8d25");
        AddMediationMeetingResDTO resDTO = (AddMediationMeetingResDTO)result.getData();
        List<String> phoneList = this.getSendUserPhoneForCreateOnlineMeeting(reqDTO);
        String caseName = dto.getCaseNumberCode();
        String appName = AppNameContextHolder.getAppName();
        if (!"weitingshenah".equals(appName) && !dto.getCaseNumberCode().contains("\u7696")) {
            if (!"weitingshenhubei".equals(appName)) {
                this.peaceSmsService.sendMediationMeetingSmsByPhoneList(phoneList, resDTO.getMediationRoomId(), caseName, resDTO.getRoomId(), dto.getStaffName(), resDTO.getOrderTime(), 1);
            } else {
                List<MediationMeetingUserInfoReqDTO> userList = MediationMeetingConvert.getUserList(reqDTO.getLitigantList(), reqDTO.getAgentList());
                this.smsHubeiService.sendMediationMeetingSmsByDTO(userList, resDTO.getMediationRoomId(), caseName, resDTO.getRoomId(), dto.getStaffName(), resDTO.getOrderTime(), 1);
                this.smsHubeiService.sendMediationMeetingDiscipline(phoneList);
            }
        }
        log.info("=====\u81ea\u52a8\u6392\u671f\u5df2\u5b8c\u6210=====");
        return DubboResultBuilder.success();
    }

    private List<String> getSendUserPhoneForCreateOnlineMeeting(AddMediationMeetingRoomMicroReqDTO reqDTO) {
        List litigantList;
        List allUser = Lists.newArrayList();
        List agentList = reqDTO.getAgentList();
        if (agentList != null) {
            allUser.addAll(agentList);
        }
        if ((litigantList = reqDTO.getLitigantList()) != null) {
            for (MediationMeetingUserInfoReqDTO litigant : litigantList) {
                if (StringUtils.isEmpty((String)litigant.getMobilePhone())) continue;
                allUser.add(litigant);
            }
        }
        Set phoneSet = allUser.stream().map(MediationMeetingUserInfoReqDTO::getMobilePhone).collect(Collectors.toSet());
        phoneSet.remove("1111");
        return new ArrayList<String>(phoneSet);
    }

    private void authentication(List<LitigantInfoRequestDTO> litigantList) {
        if (CollectionUtils.isEmpty(litigantList)) {
            return;
        }
        for (LitigantInfoRequestDTO litigant : litigantList) {
            Integer authStatus = litigant.getAuthStatus();
            if (authStatus != null && "1".equals(authStatus.toString())) {
                log.info("\u7528\u6237{}\u5df2\u5b9e\u540d", (Object)litigant.getUserName());
                continue;
            }
            Integer litigantType = litigant.getLitigantType();
            if (litigantType == null || "1".equals(litigantType.toString())) continue;
            this.backstageUserMicroServiceApi.authentication(litigant.getUserId());
        }
    }

    public DubboResult<String> updateMeetingOrderTime(AddMeetingIntranetRequestDTO dto) {
        log.info("=====\u66f4\u65b0\u5ead\u5ba1\u9884\u7ea6\u65f6\u95f4=====");
        AddMediationMeetingRoomMicroReqDTO reqDTO = new AddMediationMeetingRoomMicroReqDTO();
        reqDTO.setThirdCaseId(dto.getRowUuid());
        reqDTO.setOrderTime(dto.getOrderTime());
        DubboResult result = this.mediationMeetingApi.updateMeetingOrderTime(reqDTO);
        log.info("=====\u66f4\u65b0\u5ead\u5ba1\u9884\u7ea6\u65f6\u95f4\u5df2\u5b8c\u6210=====");
        return result;
    }

    public DubboResult<String> updateMeetingCreateUser(Long meetingId, LitigantInfoRequestDTO mediator) {
        log.info("=====\u66f4\u65b0\u5ead\u5ba1\u521b\u5efa\u4eba=====");
        AddMediationMeetingRoomMicroReqDTO reqDTO = new AddMediationMeetingRoomMicroReqDTO();
        reqDTO.setMeetingId(meetingId);
        reqDTO.setCreateUser(mediator.getUserName());
        reqDTO.setCreatorId(mediator.getUserId());
        DubboResult result = this.mediationMeetingApi.updateMeetingCreateUser(reqDTO);
        log.info("=====\u66f4\u65b0\u5ead\u5ba1\u521b\u5efa\u4eba\u5df2\u5b8c\u6210=====");
        return result;
    }

    public DubboResult<String> sendSmsAgain(Long meetingId, Date orderTime) {
        String appName;
        DubboResult mediationRoomResult = this.mediationRoomApi.selectCaseMeetingInfo(meetingId);
        if (mediationRoomResult == null || mediationRoomResult.getData() == null) {
            log.error("\u83b7\u53d6\u5ead\u5ba1\u4fe1\u606f\u5931\u8d25");
            return DubboResultBuilder.error((String)"\u83b7\u53d6\u5ead\u5ba1\u4fe1\u606f\u5931\u8d25");
        }
        DubboResult userListResult = this.mediationRoomApi.getMediationRoomUserInfoList(meetingId);
        if (userListResult == null || userListResult.getData() == null) {
            log.error("\u83b7\u53d6\u53c2\u4e0e\u4eba\u4fe1\u606f\u5931\u8d25");
            return DubboResultBuilder.error((String)"\u83b7\u53d6\u53c2\u4e0e\u4eba\u4fe1\u606f\u5931\u8d25");
        }
        CaseMeetingRoomInfoResDTO meetingInfo = (CaseMeetingRoomInfoResDTO)mediationRoomResult.getData();
        ArrayList userList = (ArrayList)userListResult.getData();
        this.redisTemplate = this.redisService.getRedisTemplate();
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        String url = this.dictionaryService.getDictionaryValue("PEACE_SMALL_PROGRAM_URL_" + appName.toUpperCase());
        List<String> userTypeList = Arrays.asList(PeaceConst.LITIGANT_USER_TYPE);
        String caseName = meetingInfo.getName();
        if (caseName != null && "\u53f7".equals(caseName.substring(caseName.length() - 1, caseName.length()))) {
            caseName = caseName.substring(0, caseName.length() - 1);
        }
        for (MediationRoomUserInfoResDTO user : userList) {
            String userType = user.getMeetingUserType();
            if (userType == null || !userTypeList.contains(userType)) continue;
            String mobilePhone = user.getMobilePhone();
            String verificationCode = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_RELATION.name() + meetingId + "_" + mobilePhone));
            if (StringUtils.isBlank((String)verificationCode)) continue;
            HashMap data = Maps.newHashMap();
            data.put("mediator", meetingInfo.getCreateUser());
            data.put("name", caseName);
            data.put("orderTime", Java8DateUtils.formatter((Date)orderTime, (String)"yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206"));
            data.put("url", url);
            data.put("verificationCode", verificationCode);
            this.smsUtil.sendSms(mobilePhone, SMSTypeEnums.SMS_MEDIATION_MEETING_LITIGANT.name() + "_" + appName.toUpperCase(), data);
        }
        return DubboResultBuilder.success();
    }

    public DubboResult<String> deleteVerificationCode(Long meetingId, Long userId, String mobilePhone) {
        String appName;
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        this.redisTemplate = this.redisService.getRedisTemplate();
        String verificationCodeKey = suffix + RedisKeyEnums.VERIFICATION_RELATION.name() + meetingId + "_" + mobilePhone;
        String verificationCode = (String)this.redisTemplate.opsForValue().get((Object)verificationCodeKey);
        this.redisTemplate.delete((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode));
        this.redisTemplate.delete((Object)verificationCodeKey);
        return DubboResultBuilder.success();
    }

    public DubboResult<String> addMediationMeetingUser(AddMediationMeetingUserRequestMicroDTO reqDTO) {
        log.info("\u6dfb\u52a0\u4eba\u5458\uff1a{}", (Object)reqDTO.toString());
        if (reqDTO.getLitigantList() != null && reqDTO.getLitigantList().size() > 0) {
            DTOCheckFieldConvert.checkLitigantInfoRequestDTO(reqDTO.getLitigantList());
        }
        List oldUserList = null;
        if (!CollectionUtils.isEmpty((Collection)reqDTO.getAgentList())) {
            DubboResult oldUserDubbo = this.mediationRoomApi.getMediationRoomAllUserInfoList(reqDTO.getMediationRoomId());
            if (oldUserDubbo == null || CollectionUtils.isEmpty((Collection)((Collection)((Object)oldUserDubbo.getData())))) {
                return DubboResultBuilder.error((String)"\u83b7\u53d6\u53c2\u4e0e\u4eba\u5931\u8d25");
            }
            oldUserList = (List)((Object)oldUserDubbo.getData());
        }
        DTOCheckFieldConvert.buildIntranetAddUserTempId(reqDTO, oldUserList);
        String checkErrorMessage = this.checkRepeatUser(reqDTO);
        log.info("\u6821\u9a8c\uff1a{}", (Object)checkErrorMessage);
        if (StringUtils.isNotBlank((CharSequence)checkErrorMessage)) {
            return DubboResultBuilder.error((String)checkErrorMessage);
        }
        List<LitigantInfoRequestDTO> litigantList = reqDTO.getLitigantList();
        litigantList = litigantList == null ? Lists.newArrayList() : litigantList;
        log.info("\u6ce8\u518c\u5f53\u4e8b\u4eba\uff1a{}", (Object)litigantList.toString());
        litigantList = this.userService.registerLitigant(litigantList);
        List mList = Lists.newArrayList();
        AddMediationMeetingRoomUserMicroReqDTO dubboReqDto = MediationMeetingConvert.intranetAddMediationMeetingUserReqDTO(reqDTO);
        dubboReqDto.setMediatorList(mList);
        List agentList = reqDTO.getAgentList();
        if (agentList != null) {
            this.userService.registerAgentLitigant(agentList);
        } else {
            agentList = Lists.newArrayList();
        }
        List agentListReq = Lists.newArrayList();
        for (LitigantAgentInfoMicroRequestDTO agentUser : agentList) {
            List<MediationMeetingUserInfoReqDTO> oneAgentUserList = MediationMeetingConvert.getMediationMeetingUserInfoMicroReq(agentUser);
            agentListReq.addAll(oneAgentUserList);
        }
        dubboReqDto.setAgentList(agentListReq);
        log.info("\u5f53\u4e8b\u4eba\u4fe1\u606f\uff1a{}", (Object)dubboReqDto.toString());
        DubboResult result = this.mediationMeetingRoomApi.addMediationMeetingRoomUserMicro(dubboReqDto);
        if (result == null || result.getData() == null) {
            return DubboResultBuilder.error((String)"\u65b0\u589e\u53c2\u4e0e\u4eba\u5931\u8d25");
        }
        String mediatorName = reqDTO.getMediatorName();
        if (StringUtils.isBlank((String)mediatorName)) {
            return DubboResultBuilder.success();
        }
        List sendUserList = ((AddMediationMeetingResDTO)result.getData()).getLitigantList();
        List<String> commonPhoneList = this.getCommonPhoneList(sendUserList);
        log.info("\u53d1\u9001\u77ed\u4fe1\uff1a{}", (Object)commonPhoneList.toString());
        this.peaceSmsService.sendMediationMeetingSmsByPhoneList(commonPhoneList, ((AddMediationMeetingResDTO)result.getData()).getMediationRoomId(), ((AddMediationMeetingResDTO)result.getData()).getName(), ((AddMediationMeetingResDTO)result.getData()).getRoomId(), mediatorName, ((AddMediationMeetingResDTO)result.getData()).getOrderTime(), 1);
        return DubboResultBuilder.success();
    }

    public void addSuspectReport(SuspectReportRequestDTO reqDTO, String jwtToken) {
        this.clerkRecordService.createSuspectReport(reqDTO, jwtToken);
    }

    public void uploadDossier(DossierRequestDTO dossierRequestDTO) {
        this.docDossierDubboService.saveDossier(dossierRequestDTO);
    }

    @Transactional
    public void insertElectronicDoc(String subjectId, List<MemberResDTO> signUserIds) {
        ArrayList<MemberRequestDTO> requestDTOList = new ArrayList<MemberRequestDTO>();
        for (MemberResDTO signUser : signUserIds) {
            MemberRequestDTO memberRequestDTO = new MemberRequestDTO();
            BeanUtils.copyProperties((Object)signUser, (Object)memberRequestDTO);
            requestDTOList.add(memberRequestDTO);
        }
        boolean result = this.docDossierApi.insertElectronicDoc(subjectId, requestDTOList);
        if (result) {
            SuspectReportRequestDTO requestDTO = new SuspectReportRequestDTO();
            requestDTO.setMeetId(Long.valueOf(subjectId));
            requestDTO.setBizId(Long.valueOf(subjectId));
            requestDTO.setAddUser(true);
            log.info("subjectId is:{}", (Object)subjectId);
            DocIdResDTO docIdResDTO = this.clerkRecordService.createElectronicReport(requestDTO);
        }
    }

    public String checkRepeatUser(AddMediationMeetingUserRequestMicroDTO reqDTO) {
        String errorMessage = null;
        DubboResult result = this.mediationRoomApi.getMediationRoomUserInfoAllList(reqDTO.getMediationRoomId());
        if (result == null || CollectionUtils.isEmpty((Collection)((Collection)((Object)result.getData())))) {
            errorMessage = "\u83b7\u53d6\u5f53\u4e8b\u4eba\u4e3a\u7a7a";
            log.error(errorMessage);
            return errorMessage;
        }
        List roomUserInfoAllList = (List)((Object)result.getData());
        List oldPhoneList = roomUserInfoAllList.stream().map(MediationRoomUserInfoResDTO::getMobilePhone).collect(Collectors.toList());
        List allUserPhoneList = Lists.newArrayList();
        List agentPhoneList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqDTO.getLitigantList())) {
            for (LitigantInfoRequestDTO one : reqDTO.getLitigantList()) {
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)one.getMobilePhone()) || one.getPersonId() != null) continue;
                allUserPhoneList.add(one.getMobilePhone());
                agentPhoneList.add(one.getMobilePhone());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqDTO.getMediatorList())) {
            for (LitigantInfoRequestDTO one : reqDTO.getMediatorList()) {
                allUserPhoneList.add(one.getMobilePhone());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqDTO.getAgentList())) {
            for (LitigantInfoRequestDTO one : reqDTO.getAgentList()) {
                allUserPhoneList.add(one.getMobilePhone());
                String[] agentParentPhones = null;
                List<Object> agentParentPhoneList = new ArrayList();
                if (!StringUtils.isNotBlank((CharSequence)one.getAgentParentPhoneList())) break;
                agentParentPhones = one.getAgentParentPhoneList().split(",");
                agentParentPhoneList = Arrays.asList(agentParentPhones);
                agentParentPhoneList.forEach(phone -> {
                    if (oldPhoneList.contains(phone)) {
                        allUserPhoneList.remove(phone);
                    }
                });
            }
        }
        for (String phone2 : allUserPhoneList) {
            if ("1111".equals(phone2) || !oldPhoneList.contains(phone2)) continue;
            errorMessage = "\u624b\u673a\u53f7" + phone2 + "\u624b\u673a\u53f7\u91cd\u590d";
            log.error(errorMessage);
            return errorMessage;
        }
        return null;
    }

    private List<String> getCommonPhoneList(List<MediationMeetingUserInfoReqDTO> sendUserList) {
        HashSet<String> staffSet = new HashSet<String>();
        staffSet.add("MEDIATOR");
        staffSet.add("CLERK");
        staffSet.add("JUROR");
        staffSet.add("ASSISTANT_JUDGE");
        staffSet.add("JUDGE");
        List<String> commonPhoneList = sendUserList.stream().filter(o -> !staffSet.contains(o.getMeetingUserType()) && o.getMobilePhone() != null).map(MediationMeetingUserInfoReqDTO::getMobilePhone).collect(Collectors.toList());
        return commonPhoneList;
    }
}

