/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.domain.dto.requestdto.MediateOrganizationListRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.OrganizationListRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediateOrganizationListResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.OrganizationResponseDTO;
import com.beiming.odr.peace.service.OrganizationService;
import com.beiming.odr.user.api.OrganizationServiceApi;
import com.beiming.odr.user.api.dto.requestdto.OrganizationListReqDTO;
import com.beiming.odr.user.api.dto.responsedto.OrganizationResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OrganizationServiceImpl
implements OrganizationService {
    @Resource
    private OrganizationServiceApi organizationServiceApi;

    @Override
    public PageInfo<OrganizationResponseDTO> getOrganizationList(OrganizationListRequestDTO organizationListRequestDTO, String currentUserId) {
        OrganizationListReqDTO organizationListReqDTO = new OrganizationListReqDTO();
        organizationListReqDTO.setOrgName(organizationListRequestDTO.getOrgName());
        if (organizationListRequestDTO.getMediateCode() != null) {
            organizationListReqDTO.setMediateCode(organizationListRequestDTO.getMediateCode().name());
        }
        organizationListReqDTO.setServiceAreaCode(organizationListRequestDTO.getServiceAreaCode());
        organizationListReqDTO.setPageIndex(organizationListRequestDTO.getPageIndex());
        organizationListReqDTO.setPageSize(organizationListRequestDTO.getPageSize());
        organizationListReqDTO.setCurrentUserId(currentUserId);
        DubboResult result = this.organizationServiceApi.getOrganizationListPage(organizationListReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)APIResultCodeEnums.UNEXCEPTED.desc());
        AssertUtils.assertTrue((result.getData() != null ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.RESULT_EMPTY, (String)APIResultCodeEnums.RESULT_EMPTY.desc());
        PageInfo pageInfo = (PageInfo)result.getData();
        ArrayList<OrganizationResponseDTO> responseDTOs = new ArrayList<OrganizationResponseDTO>();
        for (OrganizationResDTO organizationResDTO : pageInfo.getList()) {
            OrganizationResponseDTO responseDTO = new OrganizationResponseDTO(organizationResDTO);
            responseDTOs.add(responseDTO);
        }
        return new PageInfo(responseDTOs, pageInfo.getTotalRows(), pageInfo.getPageIndex(), pageInfo.getPageSize());
    }

    @Override
    public PageInfo<MediateOrganizationListResponseDTO> getMediateOrganizationList(MediateOrganizationListRequestDTO mediateOrganizationListRequestDTO, String currentUserId) {
        OrganizationListReqDTO organizationListReqDTO = new OrganizationListReqDTO();
        organizationListReqDTO.setOrgName(mediateOrganizationListRequestDTO.getOrgName());
        if (mediateOrganizationListRequestDTO.getMediateCode() != null) {
            organizationListReqDTO.setMediateCode(mediateOrganizationListRequestDTO.getMediateCode().name());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mediateOrganizationListRequestDTO.getDisputeTypeCode()}) && !mediateOrganizationListRequestDTO.getDisputeTypeCode().startsWith("PETITION_")) {
            organizationListReqDTO.setDisputeTypeCode(mediateOrganizationListRequestDTO.getDisputeTypeCode());
        }
        organizationListReqDTO.setDisputeAreaCode(mediateOrganizationListRequestDTO.getDisputeAreaCode());
        organizationListReqDTO.setExcludeOrgId(mediateOrganizationListRequestDTO.getExcludeOrgId());
        organizationListReqDTO.setPageIndex(mediateOrganizationListRequestDTO.getPageIndex());
        organizationListReqDTO.setPageSize(mediateOrganizationListRequestDTO.getPageSize());
        organizationListReqDTO.setCurrentUserId(currentUserId);
        organizationListReqDTO.setOrgIds(mediateOrganizationListRequestDTO.getOrgIds());
        DubboResult result = this.organizationServiceApi.getMediateOrganizationListPage(organizationListReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)APIResultCodeEnums.UNEXCEPTED.desc());
        AssertUtils.assertTrue((result.getData() != null ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.RESULT_EMPTY, (String)APIResultCodeEnums.RESULT_EMPTY.desc());
        PageInfo pageInfo = (PageInfo)result.getData();
        List organizationResDTOs = pageInfo.getList();
        ArrayList<MediateOrganizationListResponseDTO> responseDTOs = new ArrayList<MediateOrganizationListResponseDTO>();
        for (OrganizationResDTO organizationResDTO : organizationResDTOs) {
            MediateOrganizationListResponseDTO responseDTO = new MediateOrganizationListResponseDTO(organizationResDTO);
            responseDTOs.add(responseDTO);
        }
        return new PageInfo(responseDTOs, pageInfo.getTotalRows(), pageInfo.getPageIndex(), pageInfo.getPageSize());
    }
}

