/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.beiming.basic.chat.api.enums.MemberStatusEnums;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.DubboResultBuilder;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.enums.PeaceImRedisKeyEnums;
import com.beiming.odr.peace.service.UnreadMessageService;
import com.google.common.base.Joiner;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UnreadMessageServiceImpl
implements UnreadMessageService {
    private static final Logger log = LoggerFactory.getLogger(UnreadMessageServiceImpl.class);
    @Resource
    RedisService redisService;

    @Override
    public DubboResult incrUnreadCountCache(String userId, String subjectId, String roomId, String messageContent, String messageType, String messageResource) {
        String userIdRoomIdList = this.redisService.getRealKey("", (RedisKey)PeaceImRedisKeyEnums.USERID_ROOMID_LIST, roomId);
        Map userIdRoomIdMap = this.redisService.getRedisTemplate().opsForHash().entries((Object)userIdRoomIdList);
        if (userIdRoomIdMap.size() > 0 && userIdRoomIdMap.containsKey(userId)) {
            userIdRoomIdMap.forEach((k, v) -> {
                log.info("incrUnreadCountCache userId:{}, k:{}, v:{}", new Object[]{userId, k, v});
                if (v.equals(MemberStatusEnums.OFFLINE.name())) {
                    String userRoomUnreadCount = this.redisService.getRealKey(k.toString(), (RedisKey)PeaceImRedisKeyEnums.USER_ROOM_UNREAD_COUNT, subjectId);
                    String userUnreadDetail = this.redisService.getRealKey(k.toString(), (RedisKey)PeaceImRedisKeyEnums.USER_UNREAD_DETAIL, subjectId);
                    String userSubjectUnreadDetail = this.redisService.getRealKey(k.toString(), (RedisKey)PeaceImRedisKeyEnums.USER_SUBJECT_UNREAD_DETAIL, subjectId);
                    String userSubjectUnreadCount = this.redisService.getRealKey(k.toString(), (RedisKey)PeaceImRedisKeyEnums.USER_SUBJECT_UNREAD_COUNT, "");
                    String userIdSubjectIdRelationList = this.redisService.getRealKey(k.toString(), (RedisKey)PeaceImRedisKeyEnums.USERID_SUBJECTID_RELATION_LIST, "");
                    String messageStr = Joiner.on((String)"|").join((Object)messageContent, (Object)new Date().getTime(), new Object[]{messageType});
                    messageStr = StringUtils.isNotBlank((CharSequence)messageResource) ? Joiner.on((String)"|").join((Object)messageStr, (Object)messageResource, new Object[0]) : messageStr;
                    this.redisService.getRedisTemplate().opsForHash().increment((Object)userRoomUnreadCount, (Object)roomId, 1L);
                    this.redisService.getRedisTemplate().opsForHash().put((Object)userSubjectUnreadDetail, (Object)subjectId, (Object)messageStr);
                    this.redisService.getRedisTemplate().opsForHash().put((Object)userUnreadDetail, (Object)roomId, (Object)messageStr);
                    this.redisService.getRedisTemplate().opsForHash().put((Object)userIdSubjectIdRelationList, (Object)subjectId, (Object)subjectId);
                    this.redisService.getRedisTemplate().opsForHash().increment((Object)userSubjectUnreadCount, (Object)subjectId, 1L);
                }
            });
        }
        return DubboResultBuilder.success();
    }
}

