/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.util;

import com.beiming.basic.chat.api.dto.response.MemberResDTO;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.utils.BasicUtils;
import com.beiming.odr.peace.domain.dto.imres.MessageResponseDTO;
import com.beiming.odr.peace.service.helper.RoomServiceImplHander;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.netty.util.internal.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;

@Component
public class SendMsgUtils {
    private static final Logger log = LoggerFactory.getLogger(SendMsgUtils.class);
    private static Map<String, Map<String, WebSocketSession>> memberSessionMap = new ConcurrentHashMap();

    public String findReadUserIdsByUserList(List<MemberResDTO> members, String roomId) {
        ArrayList<String> userIds = new ArrayList<String>();
        for (MemberResDTO member : members) {
            String appNameMemberId = BasicUtils.setAppNamePrefix((String)member.getMemberId());
            List<String> roomIdList = RoomServiceImplHander.getTheLastRoomTheUserEntered(appNameMemberId, memberSessionMap);
            if (!roomIdList.contains(roomId)) continue;
            userIds.add(member.getMemberId());
        }
        String redaUserIds = StringUtils.join(userIds, (String)",");
        log.info("findReadUserIdsByUserList is :{}, roomId is: {}", (Object)redaUserIds, (Object)roomId);
        return redaUserIds;
    }

    public void getReadStatus(List<String> readUserIds, List<MemberResDTO> members, MessageResponseDTO res) {
        members = members.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getMemberName())).collect(Collectors.toList());
        if (readUserIds.size() == members.size()) {
            res.setAllRead(Boolean.valueOf(true));
        } else {
            List unReadUsers = members.stream().filter(x -> !readUserIds.contains(x.getMemberId())).collect(Collectors.toList());
            res.setUnReadNum(Integer.valueOf(unReadUsers.size()));
            res.setUnReadUsers(unReadUsers);
            List readUsers = members.stream().filter(x -> readUserIds.contains(x.getMemberId()) && !res.getSender().getMemberId().equals(x.getMemberId())).collect(Collectors.toList());
            res.setReadNum(Integer.valueOf(members.size() - unReadUsers.size() - 1));
            res.setReadUsers(readUsers);
        }
    }
}

