/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.statistics.common.utils;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DateUtil {
    public static Map<String, Object> setTime(Integer timeType) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        SimpleDateFormat sdfEnd = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        if (timeType == 1) {
            map.put("startTime", sdf.format(DateUtil.getDateStartTime()));
        } else if (timeType == 2) {
            map.put("startTime", sdf.format(DateUtil.getYesterdayTime()));
        } else if (timeType == 3) {
            map.put("startTime", sdf.format(DateUtil.getPastDate(7)));
        } else if (timeType == 4) {
            map.put("startTime", sdf.format(DateUtil.getPastDate(30)));
        }
        map.put("endTime", sdfEnd.format(DateUtil.getDateEndTime()));
        return map;
    }

    public static Date getDateStartTime() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getYesterdayTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        Date date = calendar.getTime();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getDateEndTime() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date getPastDate(int past) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, calendar.get(6) - past);
        Date date = calendar.getTime();
        return date;
    }

    public static Date tomorrowDateStr() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        date = calendar.getTime();
        return date;
    }

    public static String getStartTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00");
        String s = sdf.format(new Date());
        return s;
    }

    public static String getEndTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm");
        String s = sdf.format(new Date());
        return s;
    }

    public static String getAttendanceTime(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd " + time);
        String s = sdf.format(new Date());
        return s;
    }

    public static Date stringToDate(Date oldTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            String s = sdf.format(oldTime);
            date = sdf.parse(s);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String getNewISO8601Zero(Date startTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        if (null == startTime) {
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd'T'00:00:00XXX");
            return sdf2.format(new Date());
        }
        return sdf.format(startTime);
    }

    public static String getDateZero(Date startTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        String s = sdf.format(startTime);
        return s;
    }

    public static String getNewEndTime(Date startTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        String s = sdf.format(startTime);
        return s;
    }

    public static String getNewISO8601Date() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        String s = sdf.format(new Date());
        return s;
    }

    public static String findSatOrSun() {
        Date bdate = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(bdate);
        if (cal.get(7) == 7) {
            return "sat";
        }
        if (cal.get(7) == 1) {
            return "sun";
        }
        return "work";
    }

    public static boolean belongCalendar(Date nowTime, Date beginTime, Date endTime) {
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static Date getMonthStartTime() {
        Date date = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getMonthEndTime() {
        Date date = new Date();
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, ca.getActualMaximum(5));
        ca.set(11, 23);
        ca.set(12, 59);
        ca.set(13, 59);
        ca.set(14, 999);
        return ca.getTime();
    }

    public static Date getYearStartTime() {
        Date now = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        c.set(6, 1);
        return c.getTime();
    }

    public static Date getYearEndTime() {
        Date now = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        c.add(1, 1);
        c.set(6, -1);
        return c.getTime();
    }

    public static Date theFirstDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        cal.set(7, 2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date date = cal.getTime();
        return date;
    }

    public static Date theLastDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        cal.set(7, 2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.add(7, 6);
        Date end = cal.getTime();
        return end;
    }

    public static List<Date> getDays(String bigtimeStr, String endTimeStr) throws ParseException {
        Date bigtime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(bigtimeStr + " 00:00:00");
        Date endtime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endTimeStr + " 00:00:00");
        ArrayList<Date> lDate = new ArrayList<Date>();
        lDate.add(bigtime);
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(bigtime);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(endtime);
        while (endtime.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            lDate.add(calBegin.getTime());
        }
        return lDate;
    }

    public static List<Date> getMonthBetween(String minDate, String maxDate) {
        ArrayList<Date> result = new ArrayList<Date>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        try {
            min.setTime(sdf.parse(minDate));
            max.setTime(sdf.parse(maxDate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        min.set(min.get(1), min.get(2), 1);
        max.set(max.get(1), max.get(2), 2);
        Calendar curr = min;
        while (curr.before(max)) {
            result.add(curr.getTime());
            curr.add(2, 1);
        }
        return result;
    }

    public static List<String> listRemoval(List<String> list) {
        HashSet<String> h = new HashSet<String>(list);
        list.clear();
        list.addAll(h);
        return list;
    }

    public static Date getDateStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getDateEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date getMonthStart(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getMonthEnd(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, ca.getActualMaximum(5));
        ca.set(11, 23);
        ca.set(12, 59);
        ca.set(13, 59);
        ca.set(14, 999);
        return ca.getTime();
    }

    public static Date getLastMonthToday() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) - 1);
        date = calendar.getTime();
        return date;
    }

    public static Double getTimeNum(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Integer hour = cal.get(11);
        Integer min = cal.get(12);
        DecimalFormat df = new DecimalFormat("0.00");
        Double num = (double)hour.intValue() + Double.valueOf(df.format((float)min.intValue() / 60.0f));
        return num;
    }

    public static void main(String[] args) throws ParseException {
        Map<String, Object> map1 = DateUtil.setTime(1);
        System.out.println(map1);
        Map<String, Object> map2 = DateUtil.setTime(2);
        System.out.println(map2);
        Map<String, Object> map3 = DateUtil.setTime(3);
        System.out.println(map3);
        Map<String, Object> map4 = DateUtil.setTime(4);
        System.out.println(map4);
    }
}

