/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.statistics.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";

    public static Workbook getWorkbok(File file) throws IOException {
        HSSFWorkbook wb = null;
        FileInputStream in = new FileInputStream(file);
        if (file.getName().endsWith(EXCEL_XLS)) {
            wb = new HSSFWorkbook((InputStream)in);
        } else if (file.getName().endsWith(EXCEL_XLSX)) {
            wb = new XSSFWorkbook((InputStream)in);
        }
        return wb;
    }

    public static Workbook setSheet1(Workbook workbok, List<String> firstSheetOne, List<Object> firstSheetTwo) {
        Sheet sheet1 = workbok.getSheetAt(0);
        Row row0 = sheet1.getRow(0);
        CellStyle styleCell0 = row0.getCell(2).getCellStyle();
        Row row1 = sheet1.getRow(1);
        CellStyle styleCell = row1.getCell(0).getCellStyle();
        row1.getCell(0).setCellValue(firstSheetOne.get(0).toString());
        row1.getCell(1).setCellValue(firstSheetOne.get(1).toString());
        int k = 0;
        for (int i = 0; i < firstSheetTwo.size(); ++i) {
            Row row;
            List list = (List)firstSheetTwo.get(i);
            if (i != 0) {
                row = sheet1.createRow(k + 1);
                row.setHeight(row1.getHeight());
                row.createCell(0).setCellStyle(styleCell);
                row.createCell(1).setCellStyle(styleCell);
                row.createCell(2).setCellStyle(styleCell);
                row.createCell(3).setCellStyle(styleCell);
                row.getCell(2).setCellValue(list.get(0).toString());
                row.getCell(3).setCellValue(list.get(1).toString());
            } else {
                row = sheet1.getRow(k + 1);
                row.getCell(2).setCellValue(list.get(0).toString());
                row.getCell(3).setCellValue(list.get(1).toString());
            }
            if (list.size() > 2) {
                row0.createCell(4).setCellStyle(styleCell0);
                row0.getCell(4).setCellValue(row0.getCell(2).getStringCellValue());
                row0.createCell(5).setCellStyle(styleCell0);
                row0.getCell(5).setCellValue(row0.getCell(3).getStringCellValue());
                List childList = (List)list.get(2);
                for (int j = 0; j < childList.size(); ++j) {
                    Row rowChild;
                    List listData = (List)childList.get(j);
                    if (j != 0) {
                        rowChild = sheet1.createRow(k + 1);
                        rowChild.setHeight(row1.getHeight());
                        rowChild.createCell(0).setCellStyle(styleCell);
                        rowChild.createCell(1).setCellStyle(styleCell);
                        rowChild.createCell(2).setCellStyle(styleCell);
                        rowChild.createCell(3).setCellStyle(styleCell);
                        rowChild.createCell(4).setCellStyle(styleCell);
                        rowChild.getCell(4).setCellValue(((String)listData.get(0)).toString());
                        rowChild.createCell(5).setCellStyle(styleCell);
                        rowChild.getCell(5).setCellValue(((String)listData.get(1)).toString());
                    } else {
                        rowChild = sheet1.getRow(k + 1);
                        rowChild.createCell(4).setCellStyle(styleCell);
                        rowChild.getCell(4).setCellValue(((String)listData.get(0)).toString());
                        rowChild.createCell(5).setCellStyle(styleCell);
                        rowChild.getCell(5).setCellValue(((String)listData.get(1)).toString());
                    }
                    ++k;
                }
                if (childList.size() <= 1) continue;
                sheet1.addMergedRegion(new CellRangeAddress(k - childList.size() + 1, k, 2, 2));
                sheet1.addMergedRegion(new CellRangeAddress(k - childList.size() + 1, k, 3, 3));
                continue;
            }
            ++k;
        }
        if (k > 2) {
            sheet1.addMergedRegion(new CellRangeAddress(1, k, 0, 0));
            sheet1.addMergedRegion(new CellRangeAddress(1, k, 1, 1));
        }
        sheet1.setForceFormulaRecalculation(true);
        sheet1.autoSizeColumn(4);
        sheet1.autoSizeColumn(5);
        return workbok;
    }
}

