/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.statistics.common.utils;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.springframework.web.multipart.MultipartFile;

public class JavaFileUtil {
    public static String getMethodName() {
        StackTraceElement traceElement = new Exception().getStackTrace()[1];
        return traceElement.getMethodName();
    }

    public static byte[] rotateImg(byte[] fileByte, int degree, Color bgcolor) throws IOException {
        ByteArrayInputStream imageIn = new ByteArrayInputStream(fileByte);
        BufferedImage image = ImageIO.read(imageIn);
        int iw = image.getWidth();
        int ih = image.getHeight();
        int w = 0;
        int h = 0;
        int x = 0;
        int y = 0;
        degree = (degree %= 360) < 0 ? 360 + degree : degree;
        double ang = Math.toRadians(degree);
        if (degree == 180 || degree == 0 || degree == 360) {
            w = iw;
            h = ih;
        } else if (degree == 90 || degree == 270) {
            w = ih;
            h = iw;
        } else {
            int d = iw + ih;
            w = (int)((double)d * Math.abs(Math.cos(ang)));
            h = (int)((double)d * Math.abs(Math.sin(ang)));
        }
        x = w / 2 - iw / 2;
        y = h / 2 - ih / 2;
        BufferedImage rotatedImage = new BufferedImage(w, h, image.getType());
        Graphics2D gs = (Graphics2D)rotatedImage.getGraphics();
        if (bgcolor == null) {
            rotatedImage = gs.getDeviceConfiguration().createCompatibleImage(w, h, 2);
        } else {
            gs.setColor(bgcolor);
            gs.fillRect(0, 0, w, h);
        }
        AffineTransform at = new AffineTransform();
        at.rotate(ang, w / 2, h / 2);
        at.translate(x, y);
        AffineTransformOp op = new AffineTransformOp(at, 3);
        op.filter(image, rotatedImage);
        image = rotatedImage;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ImageOutputStream iamgeOut = ImageIO.createImageOutputStream(byteOut);
        ImageIO.write((RenderedImage)image, "png", iamgeOut);
        return byteOut.toByteArray();
    }

    public static String getExtensionName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(".")) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return null;
    }

    public static Boolean isPicture(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        String fileExtension = "";
        fileExtension = fileName.substring(fileName.lastIndexOf("."));
        return ".jpg".equals(fileExtension.toLowerCase()) || ".png".equals(fileExtension.toLowerCase()) || ".jpeg".equals(fileExtension.toLowerCase()) || ".gif".equals(fileExtension.toLowerCase());
    }

    public static Boolean isPictureExt(String fileName) {
        String fileExtension = "";
        fileExtension = fileName.substring(fileName.lastIndexOf("."));
        return ".jpg".equals(fileExtension.toLowerCase()) || ".png".equals(fileExtension.toLowerCase()) || ".jpeg".equals(fileExtension.toLowerCase()) || ".gif".equals(fileExtension.toLowerCase());
    }
}

