/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.statistics.common.utils;

import com.beiming.odr.referee.dto.responsedto.CourtNumResponseDTO;
import com.beiming.odr.referee.dto.responsedto.JudgeNumResponseDTO;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortUtil {
    private static final Logger log = LoggerFactory.getLogger(SortUtil.class);

    public static List<JudgeNumResponseDTO> sortJudge(String type, List<JudgeNumResponseDTO> judgeNumList) {
        if ("desc".equals(type)) {
            Collections.sort(judgeNumList, new Comparator<JudgeNumResponseDTO>(){

                @Override
                public int compare(JudgeNumResponseDTO o1, JudgeNumResponseDTO o2) {
                    if (o1.getCourtNum() > o2.getCourtNum()) {
                        return -1;
                    }
                    if (o1.getCourtNum() == o2.getCourtNum()) {
                        return 0;
                    }
                    return 1;
                }
            });
        } else if ("asc".equals(type)) {
            Collections.sort(judgeNumList, new Comparator<JudgeNumResponseDTO>(){

                @Override
                public int compare(JudgeNumResponseDTO o1, JudgeNumResponseDTO o2) {
                    if (o1.getCourtNum() > o2.getCourtNum()) {
                        return 1;
                    }
                    if (o1.getCourtNum() == o2.getCourtNum()) {
                        return 0;
                    }
                    return -1;
                }
            });
        }
        return judgeNumList;
    }

    public static List<CourtNumResponseDTO> sort(String type, List<CourtNumResponseDTO> courtNumResponseDtoList) {
        if ("desc".equals(type)) {
            Collections.sort(courtNumResponseDtoList, new Comparator<CourtNumResponseDTO>(){

                @Override
                public int compare(CourtNumResponseDTO o1, CourtNumResponseDTO o2) {
                    if (o1.getCourtNum() > o2.getCourtNum()) {
                        return -1;
                    }
                    if (o1.getCourtNum() == o2.getCourtNum()) {
                        return 0;
                    }
                    return 1;
                }
            });
        } else if ("asc".equals(type)) {
            Collections.sort(courtNumResponseDtoList, new Comparator<CourtNumResponseDTO>(){

                @Override
                public int compare(CourtNumResponseDTO o1, CourtNumResponseDTO o2) {
                    if (o1.getCourtNum() > o2.getCourtNum()) {
                        return 1;
                    }
                    if (o1.getCourtNum() == o2.getCourtNum()) {
                        return 0;
                    }
                    return -1;
                }
            });
        }
        return courtNumResponseDtoList;
    }

    public static <T> void sortList(List<T> list, final String property, String sort) {
        if (StringUtils.isBlank((CharSequence)sort)) {
            sort = "desc";
        }
        final String tempSort = sort;
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                try {
                    Field field1 = o1.getClass().getDeclaredField(property);
                    field1.setAccessible(true);
                    Integer i1 = Integer.parseInt(SortUtil.getNumber(field1.get(o1).toString()));
                    Field field2 = o2.getClass().getDeclaredField(property);
                    field2.setAccessible(true);
                    Integer i2 = Integer.parseInt(SortUtil.getNumber(field2.get(o2).toString()));
                    if ("desc".equals(tempSort)) {
                        return i2.compareTo(i1);
                    }
                    if ("asc".equals(tempSort)) {
                        return i1.compareTo(i2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return 0;
            }
        });
    }

    public static <T> void sortDoubleDataList(List<T> list, final String property, String sort) {
        if (StringUtils.isBlank((CharSequence)sort)) {
            sort = "desc";
        }
        final String tempSort = sort;
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                try {
                    Field field1 = o1.getClass().getDeclaredField(property);
                    field1.setAccessible(true);
                    Double i1 = Double.parseDouble(SortUtil.getNumber(field1.get(o1).toString()));
                    Field field2 = o2.getClass().getDeclaredField(property);
                    field2.setAccessible(true);
                    Double i2 = Double.parseDouble(SortUtil.getNumber(field2.get(o2).toString()));
                    if ("desc".equals(tempSort)) {
                        return i2.compareTo(i1);
                    }
                    if ("asc".equals(tempSort)) {
                        return i1.compareTo(i2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return 0;
            }
        });
    }

    public static String getNumber(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "0";
        }
        String rexp = "[^0-9]";
        Pattern pattern = Pattern.compile(rexp);
        Matcher matcher = pattern.matcher(str);
        return matcher.replaceAll("").trim();
    }
}

