/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.statistics.service.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.peace.domain.dto.requestdto.DataStatisticsRequestDto;
import com.beiming.odr.peace.statistics.common.utils.DateUtil;
import com.beiming.odr.peace.statistics.common.utils.ExcelUtil;
import com.beiming.odr.peace.statistics.common.utils.SortUtil;
import com.beiming.odr.peace.statistics.service.DataStatisticsService;
import com.beiming.odr.referee.api.DataStatisticsServiceApi;
import com.beiming.odr.referee.dto.responsedto.CourtDurationResponseDTO;
import com.beiming.odr.referee.dto.responsedto.CourtNumResponseDTO;
import com.beiming.odr.referee.dto.responsedto.JudgeNumResponseDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingResponseDTO;
import com.beiming.odr.user.api.DataStatisticsCourtApi;
import com.beiming.odr.user.api.auth.dto.responsedto.CourtInfoResDTO;
import com.beiming.odr.user.api.auth.dto.responsedto.JudgeInfoResDTO;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataStatisticsServiceImpl
implements DataStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(DataStatisticsServiceImpl.class);
    @Resource
    private DataStatisticsServiceApi dataStatisticsServiceApi;
    @Resource
    private DataStatisticsCourtApi dataStatisticsCourtApi;

    @Override
    public CourtNumResponseDTO getNumOfCourtSessions(DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        DubboResult dubbo = this.dataStatisticsServiceApi.getNumOfCourtSessions(params);
        CourtNumResponseDTO courtNumResponseDto = (CourtNumResponseDTO)dubbo.getData();
        if (dataStatisticsRequestDto.getOrgName() != null) {
            courtNumResponseDto.setOrgName(dataStatisticsRequestDto.getOrgName());
        }
        return courtNumResponseDto;
    }

    @Override
    public List<CourtNumResponseDTO> getCourtNumList(DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        log.info("param is {}", (Object)dataStatisticsRequestDto);
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        DubboResult dubbo = this.dataStatisticsCourtApi.findCourtsByParentId(dataStatisticsRequestDto.getOrgId().toString());
        ArrayList courtsList = (ArrayList)dubbo.getData();
        List<Object> courtNumResponseDtoList = new ArrayList<CourtNumResponseDTO>();
        if (courtsList != null && courtsList.size() > 0) {
            for (CourtInfoResDTO courtInfoResDTO : courtsList) {
                params.put("orgId", courtInfoResDTO.getOrgId());
                DubboResult dubbo2 = this.dataStatisticsServiceApi.getCourtNumList(params);
                CourtNumResponseDTO courtNumResponseDTO = (CourtNumResponseDTO)dubbo2.getData();
                if (courtNumResponseDTO.getOrgId() == null && courtNumResponseDTO.getOrgName() == null) {
                    courtNumResponseDTO.setOrgId(courtInfoResDTO.getOrgId());
                    courtNumResponseDTO.setOrgName(courtInfoResDTO.getOrgName());
                }
                courtNumResponseDtoList.add(courtNumResponseDTO);
            }
        }
        for (CourtNumResponseDTO courtNumResponseDTO : courtNumResponseDtoList) {
            DubboResult dubboChild = this.dataStatisticsCourtApi.findCourtsByParentId(courtNumResponseDTO.getOrgId());
            if (dubboChild.getCode() != 200) continue;
            ArrayList list = (ArrayList)dubboChild.getData();
            ArrayList<String> orgIds = new ArrayList<String>();
            for (CourtInfoResDTO courtsInfoResDto : list) {
                orgIds.add(courtsInfoResDto.getOrgId());
            }
            if (orgIds != null && orgIds.size() > 0) {
                params.put("orgId", null);
                params.put("courts", orgIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
                Integer childCourtNum = (Integer)this.dataStatisticsServiceApi.getChildCourtsNum(params).getData();
                courtNumResponseDTO.setChildCourtNum(childCourtNum);
                courtNumResponseDTO.setHaveChildCourt(Integer.valueOf(1));
                continue;
            }
            courtNumResponseDTO.setChildCourtNum(Integer.valueOf(0));
            courtNumResponseDTO.setHaveChildCourt(Integer.valueOf(0));
        }
        if (dataStatisticsRequestDto.getSortType() != null) {
            courtNumResponseDtoList = SortUtil.sort((String)dataStatisticsRequestDto.getSortType(), courtNumResponseDtoList);
        }
        return courtNumResponseDtoList;
    }

    @Override
    public CourtNumResponseDTO getCourtsNum(DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        DubboResult dubbo = this.dataStatisticsServiceApi.getCourtsNum(params);
        CourtNumResponseDTO courtNumResponseDTO = (CourtNumResponseDTO)dubbo.getData();
        return courtNumResponseDTO;
    }

    @Override
    public CourtDurationResponseDTO getCourtDuration(DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        DubboResult dubbo = this.dataStatisticsServiceApi.getCourtDuration(params);
        CourtDurationResponseDTO courtDurationResponseDTO = new CourtDurationResponseDTO();
        if (dubbo.getCode() == 200) {
            courtDurationResponseDTO = (CourtDurationResponseDTO)dubbo.getData();
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        if (courtDurationResponseDTO.getCourtDuration() != null) {
            courtDurationResponseDTO.setCourtDuration(Double.valueOf(df.format(courtDurationResponseDTO.getCourtDuration())));
        }
        if (courtDurationResponseDTO.getAvgDuration() != null) {
            courtDurationResponseDTO.setAvgDuration(Double.valueOf(df.format(courtDurationResponseDTO.getAvgDuration())));
        }
        if (courtDurationResponseDTO.getMaxDuration() != null) {
            courtDurationResponseDTO.setMaxDuration(Double.valueOf(df.format(courtDurationResponseDTO.getMaxDuration())));
        }
        return courtDurationResponseDTO;
    }

    @Override
    public List<JudgeNumResponseDTO> getJudgeCourtNumList(DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        if (dataStatisticsRequestDto.getSortType() != null) {
            if ("desc".equals(dataStatisticsRequestDto.getSortType())) {
                params.put("desc", dataStatisticsRequestDto.getSortType());
            }
            if ("asc".equals(dataStatisticsRequestDto.getSortType())) {
                params.put("asc", dataStatisticsRequestDto.getSortType());
            }
        }
        List<Object> judgeNumList = new ArrayList<JudgeNumResponseDTO>();
        DubboResult dubbo = this.dataStatisticsCourtApi.getJudgeInfoList(params);
        ArrayList judgeInfoResList = (ArrayList)dubbo.getData();
        for (JudgeInfoResDTO judgeInfoResDto : judgeInfoResList) {
            params.put("judgeId", judgeInfoResDto.getJudgeId());
            DubboResult dubboResult = this.dataStatisticsServiceApi.getJudgeCourtNumList(params);
            log.info("\u7ed3\u679c\uff1a" + dubboResult);
            JudgeNumResponseDTO judgeNumResponseDto = (JudgeNumResponseDTO)dubboResult.getData();
            judgeNumResponseDto.setJudgeId(judgeInfoResDto.getJudgeId());
            judgeNumResponseDto.setJudgeName(judgeInfoResDto.getJudgeName());
            if (judgeNumResponseDto.getCourtDuration() == null) {
                judgeNumResponseDto.setCourtDuration(Double.valueOf(0.0));
            }
            judgeNumList.add(judgeNumResponseDto);
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        for (JudgeNumResponseDTO judgeNumResponseDTO : judgeNumList) {
            judgeNumResponseDTO.setCourtDuration(Double.valueOf(Double.parseDouble(df.format(judgeNumResponseDTO.getCourtDuration()))));
            log.info("\u5355\u4e2a\u7ed3\u679c\uff1a" + judgeNumResponseDTO.toString());
        }
        if (dataStatisticsRequestDto.getSortType() != null) {
            judgeNumList = SortUtil.sortJudge((String)dataStatisticsRequestDto.getSortType(), judgeNumList);
        }
        return judgeNumList;
    }

    @Override
    public PageInfo<MeetingResponseDTO> getCourtMeetingList(DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        params.put("pageNum", dataStatisticsRequestDto.getPageNum());
        params.put("pageSize", dataStatisticsRequestDto.getPageSize());
        log.info("\u53c2\u6570\uff1a" + params);
        DubboResult dubbo = this.dataStatisticsServiceApi.getCourtMeetingList(params);
        log.info("\u7ed3\u679c\uff1a" + dubbo);
        PageInfo meetingList = (PageInfo)dubbo.getData();
        log.info("\u7ed3\u679c\uff1a" + meetingList);
        return meetingList;
    }

    public List<MeetingResponseDTO> getCourtMeetingAllList(DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        DubboResult dubbo = this.dataStatisticsServiceApi.getCourtMeetingAllList(params);
        List meetingList = (List)((Object)dubbo.getData());
        return meetingList;
    }

    @Override
    public void dataStatisticsExport(DataStatisticsRequestDto dataStatisticsRequestDto, HttpServletRequest request, HttpServletResponse response) throws IOException, GeneralSecurityException, ParseException {
        CourtNumResponseDTO courtNumResponseDto = this.getNumOfCourtSessions(dataStatisticsRequestDto);
        ArrayList<String> firstSheetOne = new ArrayList<String>();
        firstSheetOne.add(courtNumResponseDto.getOrgName() != null ? courtNumResponseDto.getOrgName() : "");
        firstSheetOne.add(courtNumResponseDto.getCourtNum() != null ? courtNumResponseDto.getCourtNum().toString() : "");
        ArrayList<Object> firstSheetTwo = new ArrayList<Object>();
        List<CourtNumResponseDTO> courtNumResponseDtoList = this.getCourtNumList(dataStatisticsRequestDto);
        Long orgId = dataStatisticsRequestDto.getOrgId();
        if (courtNumResponseDtoList != null && courtNumResponseDtoList.size() > 0) {
            for (CourtNumResponseDTO courtNumResponse : courtNumResponseDtoList) {
                ArrayList<Object> childCourts = new ArrayList<Object>();
                childCourts.add(courtNumResponse.getOrgName());
                childCourts.add(courtNumResponse.getCourtNum().toString());
                dataStatisticsRequestDto.setOrgId(Long.valueOf(Long.valueOf(courtNumResponse.getOrgId())));
                List<CourtNumResponseDTO> courtNumChildList = this.getCourtNumList(dataStatisticsRequestDto);
                if (courtNumChildList != null && courtNumChildList.size() > 0) {
                    ArrayList childList2 = new ArrayList();
                    for (CourtNumResponseDTO courtNumChild : courtNumChildList) {
                        ArrayList<String> childList = new ArrayList<String>();
                        childList.add(courtNumChild.getOrgName());
                        childList.add(courtNumChild.getCourtNum().toString());
                        childList2.add(childList);
                    }
                    childCourts.add(childList2);
                }
                firstSheetTwo.add(childCourts);
            }
        } else {
            ArrayList<String> childCourts = new ArrayList<String>();
            childCourts.add("");
            childCourts.add("");
            firstSheetTwo.add(childCourts);
        }
        dataStatisticsRequestDto.setOrgId(orgId);
        CourtNumResponseDTO courtNumResponseDTO = this.getCourtsNum(dataStatisticsRequestDto);
        ArrayList<String> secondSheet = new ArrayList<String>();
        secondSheet.add(courtNumResponseDTO.getCourtNum() != null ? courtNumResponseDTO.getCourtNum().toString() : "0");
        secondSheet.add(courtNumResponseDTO.getRoomNum() != null ? courtNumResponseDTO.getRoomNum().toString() : "0");
        CourtDurationResponseDTO courtDurationResponseDTO = this.getCourtDuration(dataStatisticsRequestDto);
        ArrayList<String> secondSheet2 = new ArrayList<String>();
        secondSheet2.add(courtDurationResponseDTO.getCourtDuration() != null ? courtDurationResponseDTO.getCourtDuration().toString() : "0.0");
        secondSheet2.add(courtDurationResponseDTO.getAvgDuration() != null ? courtDurationResponseDTO.getAvgDuration().toString() : "0.0");
        secondSheet2.add(courtDurationResponseDTO.getMaxDuration() != null ? courtDurationResponseDTO.getMaxDuration().toString() : "0.0");
        List<MeetingResponseDTO> meetingList = this.getCourtMeetingAllList(dataStatisticsRequestDto);
        ArrayList<Object> secondSheet3 = new ArrayList<Object>();
        if (meetingList != null && meetingList.size() > 0) {
            DecimalFormat df = new DecimalFormat("#0.00");
            for (MeetingResponseDTO meetingResponseDTO : meetingList) {
                ArrayList<String> meetingSheet = new ArrayList<String>();
                meetingSheet.add(meetingResponseDTO.getName());
                meetingSheet.add(meetingResponseDTO.getCaseName());
                meetingSheet.add(meetingResponseDTO.getJudgeNames());
                meetingSheet.add(meetingResponseDTO.getStartTime());
                if (meetingResponseDTO.getEndTime() != null) {
                    meetingSheet.add(meetingResponseDTO.getEndTime());
                } else {
                    meetingSheet.add("\u2014\u2014");
                }
                if (meetingResponseDTO.getMeetingDuration() != null) {
                    meetingSheet.add(df.format(meetingResponseDTO.getMeetingDuration()));
                } else {
                    meetingSheet.add(" ");
                }
                secondSheet3.add(meetingSheet);
            }
        } else {
            ArrayList<String> meetingSheet = new ArrayList<String>();
            for (int i = 0; i < 6; ++i) {
                meetingSheet.add("");
            }
            secondSheet3.add(meetingSheet);
        }
        List<JudgeNumResponseDTO> judgeNumList = this.getJudgeCourtNumList(dataStatisticsRequestDto);
        ArrayList<Object> thirdSheet = new ArrayList<Object>();
        if (judgeNumList != null && judgeNumList.size() > 0) {
            for (JudgeNumResponseDTO judgeNumResponseDTO : judgeNumList) {
                ArrayList<String> judgeList = new ArrayList<String>();
                judgeList.add(judgeNumResponseDTO.getJudgeName());
                judgeList.add(judgeNumResponseDTO.getCourtNum().toString());
                judgeList.add(judgeNumResponseDTO.getCourtDuration().toString());
                thirdSheet.add(judgeList);
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            thirdSheet.add(arrayList);
        }
        this.send(request, response, firstSheetOne, firstSheetTwo, secondSheet, secondSheet2, secondSheet3, thirdSheet);
    }

    public void send(HttpServletRequest request, HttpServletResponse response, List<String> firstSheetOne, List<Object> firstSheetTwo, List<String> secondSheet, List<String> secondSheet2, List<Object> secondSheet3, List<Object> thirdSheet) throws IOException, GeneralSecurityException {
        URL url = this.getClass().getClassLoader().getResource("object_collection_output.xlsx");
        Workbook workbok = ExcelUtil.getWorkbok((File)new File(url.getFile()));
        workbok = ExcelUtil.setSheet1((Workbook)workbok, firstSheetOne, firstSheetTwo);
        Sheet sheet2 = workbok.getSheetAt(1);
        Row row2 = sheet2.getRow(1);
        row2.getCell(0).setCellValue(secondSheet.get(0));
        row2.getCell(1).setCellValue(secondSheet.get(1));
        Row row3 = sheet2.getRow(4);
        row3.getCell(0).setCellValue(secondSheet2.get(0));
        row3.getCell(1).setCellValue(secondSheet2.get(1));
        row3.getCell(2).setCellValue(secondSheet2.get(2));
        for (int i = 0; i < secondSheet3.size(); ++i) {
            int j;
            Row row;
            List list = (List)secondSheet3.get(i);
            Row rowStyle = sheet2.getRow(7);
            CellStyle styleCell = rowStyle.getCell(0).getCellStyle();
            if (i > 8) {
                row = sheet2.createRow(i + 7);
                row.setHeight(rowStyle.getHeight());
                for (j = 0; j < 6; ++j) {
                    row.createCell(j).setCellStyle(styleCell);
                    row.getCell(j).setCellValue((String)list.get(j));
                }
                continue;
            }
            row = sheet2.getRow(i + 7);
            for (j = 0; j < 6; ++j) {
                row.getCell(j).setCellValue(((String)list.get(j)).toString());
            }
        }
        sheet2.setForceFormulaRecalculation(true);
        Sheet sheet3 = workbok.getSheetAt(2);
        for (int i = 0; i < thirdSheet.size(); ++i) {
            Row row;
            List list = (List)thirdSheet.get(i);
            Row rowStyle = sheet3.getRow(1);
            CellStyle styleCell = rowStyle.getCell(0).getCellStyle();
            if (i > 17) {
                row = sheet3.createRow(i + 1);
                row.setHeight(rowStyle.getHeight());
                for (int j = 0; j < 3; ++j) {
                    row.createCell(j).setCellStyle(styleCell);
                    row.getCell(j).setCellValue((String)list.get(j));
                }
                continue;
            }
            row = sheet3.getRow(i + 1);
            row.getCell(0).setCellValue((String)list.get(0));
            row.getCell(1).setCellValue((String)list.get(1));
            row.getCell(2).setCellValue((String)list.get(2));
        }
        sheet3.setForceFormulaRecalculation(true);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            workbok.write((OutputStream)os);
            byte[] bytes = os.toByteArray();
            String fileName = "\u5bfc\u51fa\u8868.xlsx";
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
            response.addHeader("Content-Length", "" + bytes.length);
            response.setHeader("Content-Disposition", "inline;filename=" + new String(fileName.getBytes("utf-8"), "iso8859-1"));
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ((OutputStream)toClient).write(bytes);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.in.read();
    }

    @Override
    public ArrayList<CourtInfoResDTO> getCourtsList(DataStatisticsRequestDto dataStatisticsRequestDto) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgName", dataStatisticsRequestDto.getOrgName());
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        DubboResult dubbo = this.dataStatisticsCourtApi.getCourtsList(params);
        ArrayList resultList = (ArrayList)dubbo.getData();
        return resultList;
    }

    @Override
    public boolean getUserAuth(Long userId, Long orgId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("userId", userId);
        params.put("orgId", orgId);
        DubboResult dubbo = this.dataStatisticsCourtApi.getUserOrgId(params);
        CourtInfoResDTO courtInfoResDto = (CourtInfoResDTO)dubbo.getData();
        return courtInfoResDto != null && courtInfoResDto.getOrgId() != null;
    }

    public Map<String, Object> getMapParam(DataStatisticsRequestDto dataStatisticsRequestDto) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (dataStatisticsRequestDto.getTimeType() != null) {
            Map dateMap = DateUtil.setTime((Integer)dataStatisticsRequestDto.getTimeType());
            params.put("startTime", dateMap.get("startTime"));
            params.put("endTime", dateMap.get("endTime"));
        }
        if (dataStatisticsRequestDto.getStartTime() != null && dataStatisticsRequestDto.getEndTime() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            params.put("startTime", sdf.format(dataStatisticsRequestDto.getStartTime()));
            params.put("endTime", sdf.format(dataStatisticsRequestDto.getEndTime()));
        }
        return params;
    }
}

