/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.statistics.service.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.peace.domain.dto.ExcelInfoDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DataStatisticsRequestDto;
import com.beiming.odr.peace.statistics.common.enums.ExcelTypeEnum;
import com.beiming.odr.peace.statistics.service.ExcelDataService;
import com.beiming.odr.peace.statistics.service.HuBeiDataStatisticsService;
import com.beiming.odr.peace.statistics.service.util.ExcelExportUtil;
import com.beiming.odr.referee.api.DataStatisticsServiceApi;
import com.beiming.odr.referee.dto.CauseMeetingNumResDTO;
import com.beiming.odr.referee.dto.responsedto.CourtDurationResponseDTO;
import com.beiming.odr.referee.dto.responsedto.CourtNumResponseDTO;
import com.beiming.odr.referee.dto.responsedto.CourtTimeResponseDTO;
import com.beiming.odr.referee.dto.responsedto.JudgeNumResponseDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingInitNumResDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingResponseDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingTypeNumResDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingWaitScheduleResDTO;
import com.beiming.odr.referee.dto.responsedto.SourceCountResDTO;
import com.beiming.odr.user.api.auth.dto.responsedto.CourtRoomPersonResponseDTO;
import com.beiming.odr.user.api.auth.dto.responsedto.CourtRoomResponseDTO;
import com.beiming.odr.user.api.auth.dto.responsedto.CourtUserNumResDTO;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExcelDataServiceImpl
implements ExcelDataService {
    private static final Logger log = LoggerFactory.getLogger(ExcelDataServiceImpl.class);
    @Resource
    private HuBeiDataStatisticsService huBeiDataStatisticsService;
    @Resource
    private DataStatisticsServiceApi dataStatisticsServiceApi;

    @Override
    public void dataStatisticsExport(DataStatisticsRequestDto dataStatisticsRequestDto, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.info("\u4e0b\u8f7dexcel\u5165\u53c2\uff1a{}", (Object)dataStatisticsRequestDto.toString());
        if (ExcelTypeEnum.ALL_DATA.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.allDataExport(dataStatisticsRequestDto, request, response);
        }
        if (ExcelTypeEnum.PROVINCE_DATA.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u5168\u7701\u5730\u56fe", this.provinceDataTitle(), this.provinceDataExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.COURT_NUM_DATA.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u6570\u636e\u6982\u89c8", this.courtNumDataTitle(), this.courtNumDataExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.COURT_DAY_DATA.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u5f00\u5ead\u8d8b\u52bf", this.courtDayDataTitle(), this.courtDayDataExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.MEETING_TYPE_DATA.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u6848\u4ef6\u7c7b\u578b", this.meetingTypeDataTitle(), this.meetingTypeDataExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.CAUSE_DATA.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u6848\u7531\u5360\u6bd4", this.causeDataTitle(), this.causeDataExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.SOURCE_DATA.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u6848\u4ef6\u6765\u6e90", this.sourceDataTitle(), this.sourceDataExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.INIT_DATA.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u5f85\u5f00\u5ead\u6848\u4ef6", this.initDataTitle(), this.initDataExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.SCHEDULE_DATA.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u5f85\u6392\u671f\u6848\u4ef6", this.scheduleDataTitle(), this.scheduleDataExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.COURTS_NUM.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u5f00\u5ead\u6b21\u6570", this.courtsNumTitle(), this.courtsNumExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.DURATION_DATA.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u5f00\u5ead\u65f6\u957f", this.durationDataTitle(), this.durationDataExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.JUDGE_DATA.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u6cd5\u5b98\u6570\u636e", this.judgeDataTitle(), this.judgeDataExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.COURT_ROOM_NUM.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u5ead\u5ba4\u6570\u636e", this.courtRoomNumTitle(), this.courtRoomNumExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.COURT_MEETING.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u5728\u7ebf\u5ead\u5ba1\u6570\u636e", this.courtMeetingTitle(), this.courtMeetingExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.COURT_USER.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u6cd5\u9662\u4eba\u5458", this.courtUserTitle(), this.courtUserExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.COURT_ROOM_USER.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u5ead\u5ba4\u4eba\u5458", this.courtRoomUserTitle(), this.courtRoomUserExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.PROVINCE_COURT_TIME_DATA.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u5168\u7701\u5404\u5e02\u5f00\u5ead\u603b\u65f6\u957f", this.eachCityCourtTimeDataTitle(), this.eachCityCourtTImeDataExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.COURT_ROOM.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u5ead\u5ba4\u6570\u636e", this.courtRoomTitle(), this.courtRoomExport(dataStatisticsRequestDto), request, response);
        }
        if (ExcelTypeEnum.COURT_ROOM_PERSON.desc().equals(dataStatisticsRequestDto.getExcelType())) {
            this.excelExport("\u5ead\u5ba4\u4eba\u5458", this.courtRoomPersonTitle(), this.courtRoomPersonExport(dataStatisticsRequestDto), request, response);
        }
    }

    public void allDataExport(DataStatisticsRequestDto dataStatisticsRequestDto, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<ExcelInfoDTO> excelInfoList = new ArrayList<ExcelInfoDTO>();
        excelInfoList.add(new ExcelInfoDTO("\u5168\u7701\u5730\u56fe", this.provinceDataTitle(), this.provinceDataExport(dataStatisticsRequestDto)));
        excelInfoList.add(new ExcelInfoDTO("\u6570\u636e\u6982\u89c8", this.courtNumDataTitle(), this.courtNumDataExport(dataStatisticsRequestDto)));
        excelInfoList.add(new ExcelInfoDTO("\u5f00\u5ead\u8d8b\u52bf", this.courtDayDataTitle(), this.courtDayDataExport(dataStatisticsRequestDto)));
        excelInfoList.add(new ExcelInfoDTO("\u6848\u4ef6\u7c7b\u578b", this.meetingTypeDataTitle(), this.meetingTypeDataExport(dataStatisticsRequestDto)));
        excelInfoList.add(new ExcelInfoDTO("\u6848\u7531\u5360\u6bd4", this.causeDataTitle(), this.causeDataExport(dataStatisticsRequestDto)));
        excelInfoList.add(new ExcelInfoDTO("\u6848\u4ef6\u6765\u6e90", this.sourceDataTitle(), this.sourceDataExport(dataStatisticsRequestDto)));
        excelInfoList.add(new ExcelInfoDTO("\u5f85\u5f00\u5ead\u6848\u4ef6", this.initDataTitle(), this.initDataExport(dataStatisticsRequestDto)));
        excelInfoList.add(new ExcelInfoDTO("\u5f85\u6392\u671f\u6848\u4ef6", this.scheduleDataTitle(), this.scheduleDataExport(dataStatisticsRequestDto)));
        excelInfoList.add(new ExcelInfoDTO("\u5f00\u5ead\u6b21\u6570", this.courtsNumTitle(), this.courtsNumExport(dataStatisticsRequestDto)));
        excelInfoList.add(new ExcelInfoDTO("\u5f00\u5ead\u65f6\u957f", this.durationDataTitle(), this.durationDataExport(dataStatisticsRequestDto)));
        excelInfoList.add(new ExcelInfoDTO("\u6cd5\u5b98\u6570\u636e", this.judgeDataTitle(), this.judgeDataExport(dataStatisticsRequestDto)));
        excelInfoList.add(new ExcelInfoDTO("\u5728\u7ebf\u5ead\u5ba1\u6570\u636e", this.courtMeetingTitle(), this.courtMeetingExport(dataStatisticsRequestDto)));
        excelInfoList.add(new ExcelInfoDTO("\u6cd5\u9662\u4eba\u5458", this.courtUserTitle(), this.courtUserExport(dataStatisticsRequestDto)));
        excelInfoList.add(new ExcelInfoDTO("\u5168\u7701\u5404\u5e02\u5f00\u5ead\u603b\u65f6\u957f", this.eachCityCourtTimeDataTitle(), this.eachCityCourtTImeDataExport(dataStatisticsRequestDto)));
        excelInfoList.add(new ExcelInfoDTO("\u5ead\u5ba4\u6570\u636e", this.courtRoomTitle(), this.courtRoomExport(dataStatisticsRequestDto)));
        excelInfoList.add(new ExcelInfoDTO("\u5ead\u5ba4\u4eba\u5458", this.courtRoomPersonTitle(), this.courtRoomPersonExport(dataStatisticsRequestDto)));
        this.excelExports(excelInfoList, request, response);
    }

    public List<Object> provinceDataExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<CourtNumResponseDTO> list = this.huBeiDataStatisticsService.getProvinceMapData(dataStatisticsRequestDto);
        for (int i = 0; i < list.size(); ++i) {
            CourtNumResponseDTO courtNumResponse = list.get(i);
            ArrayList<String> data = new ArrayList<String>();
            data.add(i + 1 + "");
            data.add(courtNumResponse.getCityName() + "");
            data.add(courtNumResponse.getCourtNum() + "");
            result.add(data);
        }
        return result;
    }

    public List<String> provinceDataTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u6392\u540d");
        result.add("\u57ce\u5e02");
        result.add("\u5f00\u5ead\u91cf");
        return result;
    }

    public List<String> eachCityCourtTimeDataTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u6392\u540d");
        result.add("\u57ce\u5e02");
        result.add("\u5f00\u5ead\u65f6\u957f\uff08\u5c0f\u65f6\uff09");
        return result;
    }

    public List<String> courtRoomTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u5ead\u5ba4\u540d\u79f0");
        result.add("\u5f00\u5ead\u6b21\u6570");
        return result;
    }

    public List<Object> eachCityCourtTImeDataExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<CourtTimeResponseDTO> list = this.huBeiDataStatisticsService.listCourtTimeByOrgId(dataStatisticsRequestDto);
        for (int i = 0; i < list.size(); ++i) {
            CourtTimeResponseDTO courtTimeResponseDTO = list.get(i);
            ArrayList<String> data = new ArrayList<String>();
            data.add(i + 1 + "");
            data.add(courtTimeResponseDTO.getCityName() + "");
            data.add(courtTimeResponseDTO.getCourtDuration() + "");
            result.add(data);
        }
        return result;
    }

    public List<Object> courtRoomExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<CourtRoomResponseDTO> courtRoomData = this.huBeiDataStatisticsService.getCourtRoomData(dataStatisticsRequestDto);
        for (int i = 0; i < courtRoomData.size(); ++i) {
            CourtRoomResponseDTO courtRoomResponseDTO = courtRoomData.get(i);
            ArrayList<String> data = new ArrayList<String>();
            data.add(courtRoomResponseDTO.getCourtRoom());
            data.add(String.valueOf(courtRoomResponseDTO.getCaseNum()));
            result.add(data);
        }
        return result;
    }

    public List<Object> courtRoomPersonExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<CourtRoomPersonResponseDTO> courtRoomPersonData = this.huBeiDataStatisticsService.getCourtRoomPersonData(dataStatisticsRequestDto);
        for (int i = 0; i < courtRoomPersonData.size(); ++i) {
            CourtRoomPersonResponseDTO courtRoomPersonResponseDTO = courtRoomPersonData.get(i);
            ArrayList<String> data = new ArrayList<String>();
            data.add(courtRoomPersonResponseDTO.getPersonType());
            data.add(String.valueOf(courtRoomPersonResponseDTO.getPersonNum()));
            result.add(data);
        }
        return result;
    }

    public List<Object> courtNumDataExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        CourtNumResponseDTO courtNumResponse = this.huBeiDataStatisticsService.getNumOfCourtSessions(dataStatisticsRequestDto);
        ArrayList<String> numOfCourt = new ArrayList<String>();
        numOfCourt.add(courtNumResponse.getOrgName());
        numOfCourt.add(courtNumResponse.getCourtNum().toString());
        numOfCourt.add("\u2014\u2014");
        result.add(numOfCourt);
        List<CourtNumResponseDTO> list = this.huBeiDataStatisticsService.getCourtNumList(dataStatisticsRequestDto);
        for (CourtNumResponseDTO courtNumRes : list) {
            ArrayList<String> dataList = new ArrayList<String>();
            dataList.add(courtNumRes.getOrgName());
            dataList.add(courtNumRes.getCourtNum().toString());
            dataList.add(courtNumRes.getChildCourtNum().toString());
            result.add(dataList);
        }
        return result;
    }

    public List<String> courtNumDataTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u6cd5\u9662\u540d\u79f0");
        result.add("\u5f00\u5ead\u6b21\u6570");
        result.add("\u8f96\u533a\u6cd5\u9662\u5f00\u5ead\u6b21\u6570");
        return result;
    }

    public List<Object> courtDayDataExport(DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        ArrayList<Object> result = new ArrayList<Object>();
        Map<String, Object> map = this.huBeiDataStatisticsService.meetingCountByDay(dataStatisticsRequestDto);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            ArrayList<String> data = new ArrayList<String>();
            data.add(entry.getKey());
            data.add(entry.getValue().toString());
            result.add(data);
        }
        return result;
    }

    public List<String> courtDayDataTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u65f6\u95f4");
        result.add("\u5f00\u5ead\u91cf");
        return result;
    }

    public List<Object> meetingTypeDataExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        Map<String, Object> map = this.huBeiDataStatisticsService.getMeetingTypeNum(dataStatisticsRequestDto);
        List msaj = (List)map.get("msaj");
        List xsaj = (List)map.get("xsaj");
        List xzaj = (List)map.get("xzaj");
        ArrayList<String> first = new ArrayList<String>();
        first.add("\u6c11\u4e8b\u6848\u4ef6");
        for (Object meetingTypeNumRes : msaj) {
            first.add(meetingTypeNumRes.getMeetingNum().toString());
        }
        result.add(first);
        ArrayList<String> second = new ArrayList<String>();
        second.add("\u5211\u4e8b\u6848\u4ef6");
        for (MeetingTypeNumResDTO meetingTypeNumRes : xsaj) {
            second.add(meetingTypeNumRes.getMeetingNum().toString());
        }
        result.add(second);
        ArrayList<String> third = new ArrayList<String>();
        third.add("\u884c\u653f\u6848\u4ef6");
        for (MeetingTypeNumResDTO meetingTypeNumRes : xzaj) {
            third.add(meetingTypeNumRes.getMeetingNum().toString());
        }
        result.add(third);
        return result;
    }

    public List<String> meetingTypeDataTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u6848\u4ef6\u7c7b\u578b");
        result.add("\u7b2c\u4e00\u5ba1\u7a0b\u5e8f");
        result.add("\u7b2c\u4e8c\u5ba1\u7a0b\u5e8f");
        result.add("\u5ba1\u5224\u76d1\u7763\u7a0b\u5e8f");
        return result;
    }

    public List<Object> causeDataExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<CauseMeetingNumResDTO> list = this.huBeiDataStatisticsService.getCauseNumList(dataStatisticsRequestDto);
        for (CauseMeetingNumResDTO causeMeetingNumRes : list) {
            ArrayList<String> data = new ArrayList<String>();
            data.add(causeMeetingNumRes.getCauseName());
            data.add(causeMeetingNumRes.getMeetingNum().toString());
            result.add(data);
        }
        return result;
    }

    public List<String> causeDataTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u6848\u7531\u540d\u79f0");
        result.add("\u6848\u4ef6\u6570\u91cf");
        return result;
    }

    public List<Object> sourceDataExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        SourceCountResDTO sourceCountRes = this.huBeiDataStatisticsService.getSourceNum(dataStatisticsRequestDto);
        ArrayList<String> data = new ArrayList<String>();
        data.add(sourceCountRes.getExtranetNum().toString());
        data.add(sourceCountRes.getIntranetNum().toString());
        result.add(data);
        return result;
    }

    public List<String> sourceDataTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u5e73\u53f0\u521b\u5efa");
        result.add("\u5185\u7f51\u6848\u4ef6");
        return result;
    }

    public List<Object> initDataExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        DubboResult dubbo = this.dataStatisticsServiceApi.meetingInitNumList(params);
        MeetingInitNumResDTO meetingInitNumRes = (MeetingInitNumResDTO)dubbo.getData();
        ArrayList<String> data = new ArrayList<String>();
        data.add(meetingInitNumRes.getTotal().toString());
        data.add(meetingInitNumRes.getToday().toString());
        data.add(meetingInitNumRes.getTomorrow().toString());
        data.add(meetingInitNumRes.getAfterTomorrow().toString());
        data.add(meetingInitNumRes.getFuture().toString());
        result.add(data);
        return result;
    }

    public List<String> initDataTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u6848\u4ef6\u6570\u91cf");
        result.add("\u4eca\u5929\u5f00\u5ead");
        result.add("\u660e\u5929\u5f00\u5ead");
        result.add("\u540e\u5929\u5f00\u5ead");
        result.add("\u672a\u6765\u5f00\u5ead");
        return result;
    }

    public List<Object> scheduleDataExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        dataStatisticsRequestDto.setPageSize(Integer.valueOf(1));
        PageInfo<MeetingWaitScheduleResDTO> lista = this.huBeiDataStatisticsService.meetingScheduleNumList(dataStatisticsRequestDto);
        dataStatisticsRequestDto.setPageSize(Integer.valueOf(lista.getTotalRows()));
        dataStatisticsRequestDto.setPageNum(Integer.valueOf(1));
        PageInfo<MeetingWaitScheduleResDTO> list = this.huBeiDataStatisticsService.meetingScheduleNumList(dataStatisticsRequestDto);
        List dataList = list.getList();
        for (MeetingWaitScheduleResDTO meetingWaitScheduleRes : dataList) {
            ArrayList<String> data = new ArrayList<String>();
            data.add(meetingWaitScheduleRes.getName());
            data.add(meetingWaitScheduleRes.getCauseName());
            data.add(meetingWaitScheduleRes.getJudgeNames());
            result.add(data);
        }
        return result;
    }

    public List<String> scheduleDataTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u6848\u53f7");
        result.add("\u6848\u7531");
        result.add("\u5ba1\u5224\u7ec4\u7ec7");
        return result;
    }

    public List<Object> courtsNumExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        CourtNumResponseDTO map = this.huBeiDataStatisticsService.getCourtsNum(dataStatisticsRequestDto);
        ArrayList<String> data = new ArrayList<String>();
        data.add(map.getCourtNum().toString());
        data.add(map.getRoomNum().toString());
        result.add(data);
        return result;
    }

    public List<String> courtsNumTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u5f00\u5ead\u6b21\u6570");
        result.add("\u6848\u4ef6\u7a7a\u95f4\u53d1\u8d77");
        return result;
    }

    public List<Object> durationDataExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        CourtDurationResponseDTO map = this.huBeiDataStatisticsService.getCourtDuration(dataStatisticsRequestDto);
        ArrayList<String> data = new ArrayList<String>();
        if (map != null) {
            data.add(map.getCourtDuration() != null ? map.getCourtDuration().toString() : "");
            data.add(map.getAvgDuration() != null ? map.getAvgDuration().toString() : "");
            data.add(map.getMaxDuration() != null ? map.getMaxDuration().toString() : "");
            result.add(data);
        }
        return result;
    }

    public List<String> durationDataTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u5f00\u5ead\u65f6\u957f");
        result.add("\u5e73\u5747\u65f6\u957f");
        result.add("\u5355\u6b21\u6700\u957f");
        return result;
    }

    public List<Object> judgeDataExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<JudgeNumResponseDTO> list = this.huBeiDataStatisticsService.getJudgeCourtNumList(dataStatisticsRequestDto);
        for (JudgeNumResponseDTO judgeNumResponse : list) {
            ArrayList<String> data = new ArrayList<String>();
            data.add(judgeNumResponse.getJudgeName());
            data.add(judgeNumResponse.getCourtNum().toString());
            data.add(judgeNumResponse.getCourtDuration().toString());
            result.add(data);
        }
        return result;
    }

    public List<String> judgeDataTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u6cd5\u5b98");
        result.add("\u5f00\u5ead\u6b21\u6570\uff08\u6b21\uff09");
        result.add("\u5f00\u5ead\u65f6\u957f\uff08\u5c0f\u65f6\uff09");
        return result;
    }

    public List<Object> courtRoomNumExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<String> list = new ArrayList<String>();
        list.add(" ");
        list.add(" ");
        result.add(list);
        return result;
    }

    public List<String> courtRoomNumTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(" ");
        result.add(" ");
        return result;
    }

    public List<Object> courtMeetingExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        dataStatisticsRequestDto.setPageSize(Integer.valueOf(1));
        PageInfo<MeetingResponseDTO> lista = this.huBeiDataStatisticsService.getCourtMeetingList(dataStatisticsRequestDto);
        dataStatisticsRequestDto.setPageSize(Integer.valueOf(lista.getTotalRows()));
        dataStatisticsRequestDto.setPageNum(Integer.valueOf(1));
        PageInfo<MeetingResponseDTO> list = this.huBeiDataStatisticsService.getCourtMeetingList(dataStatisticsRequestDto);
        List meetingResponseList = list.getList();
        for (MeetingResponseDTO meetingResponse : meetingResponseList) {
            ArrayList<String> data = new ArrayList<String>();
            data.add(meetingResponse.getName());
            data.add(meetingResponse.getCaseName());
            data.add(meetingResponse.getJudgeNames());
            data.add(meetingResponse.getStartTime());
            data.add(meetingResponse.getEndTime());
            data.add(meetingResponse.getMeetingDuration().toString());
            result.add(data);
        }
        return result;
    }

    public List<String> courtMeetingTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u6848\u53f7");
        result.add("\u6848\u7531");
        result.add("\u5ba1\u5224\u7ec4\u7ec7");
        result.add("\u5f00\u5ead\u65f6\u95f4");
        result.add("\u95ed\u5ead\u65f6\u95f4");
        result.add("\u5f00\u5ead\u65f6\u957f\uff08\u5206\u949f\uff09");
        return result;
    }

    public List<Object> courtUserExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<CourtUserNumResDTO> userNumList = this.huBeiDataStatisticsService.getCourtUserNum(dataStatisticsRequestDto);
        for (CourtUserNumResDTO courtUserNumRes : userNumList) {
            ArrayList<String> data = new ArrayList<String>();
            data.add(courtUserNumRes.getRoleName());
            data.add(courtUserNumRes.getUserNum().toString());
            result.add(data);
        }
        return result;
    }

    public List<String> courtUserTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u89d2\u8272\u540d\u79f0");
        result.add("\u4eba\u5458\u6570\u91cf");
        return result;
    }

    public List<Object> courtRoomUserExport(DataStatisticsRequestDto dataStatisticsRequestDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<String> list = new ArrayList<String>();
        list.add(" ");
        list.add(" ");
        result.add(list);
        return result;
    }

    public List<String> courtRoomUserTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(" ");
        result.add(" ");
        return result;
    }

    public List<String> courtRoomPersonTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u4eba\u5458\u7c7b\u578b");
        result.add("\u4eba\u5458\u6570\u91cf");
        return result;
    }

    public void excelExport(String excelName, List<String> titleMap, List<Object> excelContent, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] title = new String[titleMap.size()];
        for (int i = 0; i < titleMap.size(); ++i) {
            title[i] = titleMap.get(i).toString();
        }
        HSSFWorkbook wbook = ExcelExportUtil.getHSSFWorkbook(excelName, title, excelContent);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wbook.write((OutputStream)os);
            byte[] bytes = os.toByteArray();
            String fileName = excelName + ".xls";
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
            response.addHeader("Content-Length", "" + bytes.length);
            response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setHeader("Content-Disposition", "inline;filename=" + new String(fileName.getBytes("utf-8"), "iso8859-1"));
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ((OutputStream)toClient).write(bytes);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.in.read();
    }

    public void excelExports(List<ExcelInfoDTO> excelInfoList, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.info("\u5f00\u59cb\u5904\u7406\u6570\u636e");
        HSSFWorkbook wbook = ExcelExportUtil.getHSSFWorkbookSheets(excelInfoList);
        log.info("excel\u6570\u636e\u5904\u7406\u5b8c");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wbook.write((OutputStream)os);
            byte[] bytes = os.toByteArray();
            String fileName = "\u6570\u636e\u6c47\u603b.xls";
            log.info("\u5bfc\u51fa\uff1a{}", (Object)fileName);
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
            response.addHeader("Content-Length", "" + bytes.length);
            response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setHeader("Content-Disposition", "inline;filename=" + new String(fileName.getBytes("utf-8"), "iso8859-1"));
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ((OutputStream)toClient).write(bytes);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.in.read();
    }
}

