/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.statistics.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.MapUtils;
import com.beiming.odr.alexstrasza.api.AlexSaasPlatformApi;
import com.beiming.odr.peace.domain.dto.requestdto.DataStatisticsRequestDto;
import com.beiming.odr.peace.domain.dto.responsedto.MeetingInitNumResponseDTO;
import com.beiming.odr.peace.statistics.common.enums.ErrorCode;
import com.beiming.odr.peace.statistics.common.utils.DateUtil;
import com.beiming.odr.peace.statistics.common.utils.SortUtil;
import com.beiming.odr.peace.statistics.service.HuBeiDataStatisticsService;
import com.beiming.odr.peace.statistics.service.util.ExcelExportUtil;
import com.beiming.odr.referee.api.DataStatisticsServiceApi;
import com.beiming.odr.referee.dto.CauseMeetingNumResDTO;
import com.beiming.odr.referee.dto.requestdto.DurationStatisticsRequestDto;
import com.beiming.odr.referee.dto.responsedto.CourtDurationResponseDTO;
import com.beiming.odr.referee.dto.responsedto.CourtNumResponseDTO;
import com.beiming.odr.referee.dto.responsedto.CourtRoomResDTO;
import com.beiming.odr.referee.dto.responsedto.CourtTimeResponseDTO;
import com.beiming.odr.referee.dto.responsedto.DurationStatisticsResVO;
import com.beiming.odr.referee.dto.responsedto.JudgeNumResponseDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingCountDaysResDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingInitNumResDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingResponseDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingTypeNumResDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingWaitScheduleResDTO;
import com.beiming.odr.referee.dto.responsedto.SourceCountResDTO;
import com.beiming.odr.user.api.DataStatisticsCourtApi;
import com.beiming.odr.user.api.OrganizationSecondServiceApi;
import com.beiming.odr.user.api.auth.dto.responsedto.CourtInfoResDTO;
import com.beiming.odr.user.api.auth.dto.responsedto.CourtRoomPersonResponseDTO;
import com.beiming.odr.user.api.auth.dto.responsedto.CourtRoomResponseDTO;
import com.beiming.odr.user.api.auth.dto.responsedto.CourtUserNumResDTO;
import com.beiming.odr.user.api.auth.dto.responsedto.DepartResDTO;
import com.beiming.odr.user.api.auth.dto.responsedto.StaffResDTO;
import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HuBeiDataStatisticsServiceImpl
implements HuBeiDataStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(HuBeiDataStatisticsServiceImpl.class);
    @Resource
    private DataStatisticsServiceApi dataStatisticsServiceApi;
    @Resource
    private AlexSaasPlatformApi alexSaasPlatformApi;
    @Resource
    private OrganizationSecondServiceApi organizationSecondServiceApi;
    @Resource
    private DataStatisticsCourtApi dataStatisticsCourtApi;

    @Override
    public boolean getUserAuth(Long userId, Long orgId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("userId", userId);
        params.put("orgId", orgId);
        DubboResult dubbo = this.dataStatisticsCourtApi.getUserOrgId(params);
        CourtInfoResDTO courtInfoResDto = (CourtInfoResDTO)dubbo.getData();
        return courtInfoResDto != null && courtInfoResDto.getOrgId() != null;
    }

    @Override
    public List<CourtNumResponseDTO> getProvinceMapData(DataStatisticsRequestDto dataStatisticsRequestDto) {
        DataStatisticsRequestDto tempDto = new DataStatisticsRequestDto();
        tempDto.setUserId(dataStatisticsRequestDto.getUserId());
        tempDto.setOrgId(dataStatisticsRequestDto.getOrgId());
        tempDto.setOrgName(dataStatisticsRequestDto.getOrgName());
        tempDto.setDepartId(dataStatisticsRequestDto.getDepartId());
        tempDto.setDepartName(dataStatisticsRequestDto.getDepartName());
        tempDto.setStartTime(dataStatisticsRequestDto.getStartTime());
        tempDto.setEndTime(dataStatisticsRequestDto.getEndTime());
        tempDto.setTimeType(dataStatisticsRequestDto.getTimeType());
        tempDto.setPageNum(dataStatisticsRequestDto.getPageNum());
        tempDto.setPageSize(dataStatisticsRequestDto.getPageSize());
        tempDto.setSortType(dataStatisticsRequestDto.getSortType());
        tempDto.setSortField(dataStatisticsRequestDto.getSortField());
        tempDto.setExcelType(dataStatisticsRequestDto.getExcelType());
        tempDto.setKtStartTime(dataStatisticsRequestDto.getKtStartTime());
        tempDto.setKtEndTime(dataStatisticsRequestDto.getKtEndTime());
        tempDto.setBtStartTime(dataStatisticsRequestDto.getBtStartTime());
        tempDto.setBtEndTime(dataStatisticsRequestDto.getBtEndTime());
        tempDto.setSortStr(dataStatisticsRequestDto.getSortStr());
        tempDto.setOrgId(Long.valueOf(2907L));
        Map<String, Object> params = this.getMapParam(tempDto);
        params.put("orgId", "2907");
        List<Object> courtNumResponseDtoList = new ArrayList<CourtNumResponseDTO>();
        DubboResult courtDubbo = this.dataStatisticsCourtApi.findCourtById("2907");
        CourtInfoResDTO court = (CourtInfoResDTO)courtDubbo.getData();
        CourtNumResponseDTO courtNumResponseDTO = new CourtNumResponseDTO();
        courtNumResponseDTO.setOrgId(court.getOrgId());
        courtNumResponseDTO.setOrgName(court.getOrgName());
        courtNumResponseDTO.setCityName(court.getOrgName());
        courtNumResponseDTO.setCourtNum(Integer.valueOf(0));
        courtNumResponseDtoList.add(courtNumResponseDTO);
        DubboResult courtsNumDubbo = this.dataStatisticsServiceApi.getAllCourtsNum(params);
        ArrayList data = (ArrayList)courtsNumDubbo.getData();
        if (!CollectionUtils.isEmpty((Collection)data)) {
            block0: for (CourtNumResponseDTO datum : data) {
                for (CourtNumResponseDTO courtNumResponseDTO2 : courtNumResponseDtoList) {
                    String orgId = datum.getOrgId();
                    Integer courtNum = null == datum.getCourtNum() ? 0 : datum.getCourtNum();
                    String orgId1 = courtNumResponseDTO2.getOrgId();
                    if (!orgId.equals(orgId1)) continue;
                    courtNumResponseDTO2.setCourtNum(courtNum);
                    continue block0;
                }
            }
        }
        if (!CollectionUtils.isEmpty(courtNumResponseDtoList)) {
            courtNumResponseDtoList = SortUtil.sort((String)"desc", courtNumResponseDtoList);
        }
        return courtNumResponseDtoList;
    }

    @Override
    public CourtNumResponseDTO getNumOfCourtSessions(DataStatisticsRequestDto dataStatisticsRequestDto) {
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        DubboResult dubbo = this.dataStatisticsServiceApi.getNumOfCourtSessions(params);
        CourtNumResponseDTO courtNumResponseDto = (CourtNumResponseDTO)dubbo.getData();
        if (dataStatisticsRequestDto.getOrgName() != null) {
            courtNumResponseDto.setOrgName(dataStatisticsRequestDto.getOrgName());
        }
        return courtNumResponseDto;
    }

    @Override
    public List<CourtNumResponseDTO> getCourtNumList(DataStatisticsRequestDto dataStatisticsRequestDto) {
        log.info("param is {}", (Object)dataStatisticsRequestDto);
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        DubboResult dubbo = this.dataStatisticsCourtApi.findCourtsByParentIdAndId(dataStatisticsRequestDto.getOrgId().toString());
        ArrayList courtsList = (ArrayList)dubbo.getData();
        ArrayList<CourtNumResponseDTO> courtNumResponseDtoList = new ArrayList<CourtNumResponseDTO>();
        if (courtsList != null && courtsList.size() > 0) {
            for (CourtInfoResDTO courtsInfoResDto : courtsList) {
                params.put("orgId", courtsInfoResDto.getOrgId());
                DubboResult dubbo2 = this.dataStatisticsServiceApi.getCourtNumList(params);
                CourtNumResponseDTO courtNumResponseDTO = (CourtNumResponseDTO)dubbo2.getData();
                if (Objects.nonNull(courtNumResponseDTO) && courtNumResponseDTO.getOrgId() == null && courtNumResponseDTO.getOrgName() == null) {
                    courtNumResponseDTO.setOrgId(courtsInfoResDto.getOrgId());
                    courtNumResponseDTO.setOrgName(courtsInfoResDto.getOrgName());
                    courtNumResponseDtoList.add(courtNumResponseDTO);
                    continue;
                }
                if (Objects.isNull(courtNumResponseDTO)) {
                    CourtNumResponseDTO courtNumResponseDTO1 = new CourtNumResponseDTO();
                    courtNumResponseDTO1.setOrgId(courtsInfoResDto.getOrgId());
                    courtNumResponseDTO1.setOrgName(courtsInfoResDto.getOrgName());
                    courtNumResponseDTO1.setCourtNum(Integer.valueOf(0));
                    courtNumResponseDtoList.add(courtNumResponseDTO1);
                    continue;
                }
                courtNumResponseDtoList.add(courtNumResponseDTO);
            }
        }
        for (CourtNumResponseDTO courtNumResponseDto : courtNumResponseDtoList) {
            DubboResult dubboChild = this.dataStatisticsCourtApi.findCourtsByParentId(courtNumResponseDto.getOrgId());
            if (dubboChild.getCode() != 200) continue;
            ArrayList list = (ArrayList)dubboChild.getData();
            ArrayList<String> orgIds = new ArrayList<String>();
            for (CourtInfoResDTO courtsInfoResDto : list) {
                orgIds.add(courtsInfoResDto.getOrgId());
            }
            if (orgIds != null && orgIds.size() > 0) {
                params.put("orgId", null);
                params.put("courts", orgIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
                Integer childCourtNum = (Integer)this.dataStatisticsServiceApi.getChildCourtsNum(params).getData();
                courtNumResponseDto.setChildCourtNum(childCourtNum);
                courtNumResponseDto.setHaveChildCourt(Integer.valueOf(1));
                continue;
            }
            courtNumResponseDto.setChildCourtNum(Integer.valueOf(0));
            courtNumResponseDto.setHaveChildCourt(Integer.valueOf(0));
        }
        String sortType = StringUtils.isBlank((CharSequence)dataStatisticsRequestDto.getSortType()) ? "desc" : dataStatisticsRequestDto.getSortType();
        String sortField = StringUtils.isBlank((CharSequence)dataStatisticsRequestDto.getSortField()) ? "courtNum" : dataStatisticsRequestDto.getSortField();
        SortUtil.sortList(courtNumResponseDtoList, (String)sortField, (String)sortType);
        return courtNumResponseDtoList;
    }

    @Override
    public CourtNumResponseDTO getCourtsNum(DataStatisticsRequestDto dataStatisticsRequestDto) {
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        DubboResult dubbo = this.dataStatisticsServiceApi.getCourtsNum(params);
        CourtNumResponseDTO courtNumResponseDTO = (CourtNumResponseDTO)dubbo.getData();
        return courtNumResponseDTO;
    }

    @Override
    public CourtDurationResponseDTO getCourtDuration(DataStatisticsRequestDto dataStatisticsRequestDto) {
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        DubboResult dubbo = this.dataStatisticsServiceApi.getCourtDuration(params);
        CourtDurationResponseDTO courtDurationResponseDTO = new CourtDurationResponseDTO();
        if (dubbo.getCode() == 200) {
            courtDurationResponseDTO = (CourtDurationResponseDTO)dubbo.getData();
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        if (courtDurationResponseDTO.getCourtDuration() != null) {
            courtDurationResponseDTO.setCourtDuration(Double.valueOf(df.format(courtDurationResponseDTO.getCourtDuration())));
        }
        if (courtDurationResponseDTO.getAvgDuration() != null) {
            courtDurationResponseDTO.setAvgDuration(Double.valueOf(df.format(courtDurationResponseDTO.getAvgDuration())));
        }
        if (courtDurationResponseDTO.getMaxDuration() != null) {
            courtDurationResponseDTO.setMaxDuration(Double.valueOf(df.format(courtDurationResponseDTO.getMaxDuration())));
        }
        return courtDurationResponseDTO;
    }

    @Override
    public List<JudgeNumResponseDTO> getJudgeCourtNumList(DataStatisticsRequestDto dataStatisticsRequestDto) {
        String sortField;
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        if (dataStatisticsRequestDto.getSortType() != null) {
            if ("desc".equals(dataStatisticsRequestDto.getSortType())) {
                params.put("desc", dataStatisticsRequestDto.getSortType());
            }
            if ("asc".equals(dataStatisticsRequestDto.getSortType())) {
                params.put("asc", dataStatisticsRequestDto.getSortType());
            }
        }
        ArrayList<JudgeNumResponseDTO> judgeNumList = new ArrayList<JudgeNumResponseDTO>();
        DubboResult dubbo = this.dataStatisticsCourtApi.getJudgeInfoList(params);
        ArrayList judgeInfoResList = (ArrayList)dubbo.getData();
        for (Object judgeInfoResDto : judgeInfoResList) {
            params.put("judgeId", judgeInfoResDto.getJudgeId());
            DubboResult dubbo2 = this.dataStatisticsServiceApi.getJudgeCourtNumList(params);
            log.info("\u7ed3\u679c\uff1a" + dubbo2);
            JudgeNumResponseDTO judgeNumResponseDto = (JudgeNumResponseDTO)dubbo2.getData();
            judgeNumResponseDto.setJudgeId(judgeInfoResDto.getJudgeId());
            judgeNumResponseDto.setJudgeName(judgeInfoResDto.getJudgeName());
            if (judgeNumResponseDto.getCourtDuration() == null) {
                judgeNumResponseDto.setCourtDuration(Double.valueOf(0.0));
            }
            judgeNumList.add(judgeNumResponseDto);
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        for (JudgeNumResponseDTO judgeNumResponse : judgeNumList) {
            judgeNumResponse.setCourtDuration(Double.valueOf(Double.parseDouble(df.format(judgeNumResponse.getCourtDuration()))));
            log.info("\u5355\u4e2a\u7ed3\u679c\uff1a" + judgeNumResponse.toString());
        }
        String sortType = StringUtils.isBlank((CharSequence)dataStatisticsRequestDto.getSortType()) ? "desc" : dataStatisticsRequestDto.getSortType();
        String string = sortField = StringUtils.isBlank((CharSequence)dataStatisticsRequestDto.getSortField()) ? "courtNum" : dataStatisticsRequestDto.getSortField();
        if ("courtNum".equals(sortField)) {
            SortUtil.sortList(judgeNumList, (String)sortField, (String)sortType);
        }
        if ("courtDuration".equals(sortField)) {
            SortUtil.sortDoubleDataList(judgeNumList, (String)sortField, (String)sortType);
        }
        return judgeNumList;
    }

    @Override
    public PageInfo<MeetingResponseDTO> getCourtMeetingList(DataStatisticsRequestDto dataStatisticsRequestDto) {
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        params.put("pageNum", dataStatisticsRequestDto.getPageNum());
        params.put("pageSize", dataStatisticsRequestDto.getPageSize());
        params.put("sortStr", dataStatisticsRequestDto.getSortStr());
        log.info("\u53c2\u6570\uff1a" + params);
        DubboResult dubbo = this.dataStatisticsServiceApi.getCourtMeetingList(params);
        log.info("\u7ed3\u679c\uff1a" + dubbo);
        PageInfo meetingList = (PageInfo)dubbo.getData();
        log.info("\u7ed3\u679c\uff1a" + meetingList);
        return meetingList;
    }

    @Override
    public Map<String, Object> meetingCountByDay(DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        String dateStr;
        DataStatisticsRequestDto targetDataStatisticsRequestDto = new DataStatisticsRequestDto();
        targetDataStatisticsRequestDto.setStartTime(dataStatisticsRequestDto.getStartTime());
        targetDataStatisticsRequestDto.setEndTime(dataStatisticsRequestDto.getEndTime());
        targetDataStatisticsRequestDto.setOrgId(dataStatisticsRequestDto.getOrgId());
        targetDataStatisticsRequestDto.setOrgName(dataStatisticsRequestDto.getOrgName());
        targetDataStatisticsRequestDto.setKtEndTime(dataStatisticsRequestDto.getKtEndTime());
        targetDataStatisticsRequestDto.setKtStartTime(dataStatisticsRequestDto.getKtStartTime());
        targetDataStatisticsRequestDto.setBtStartTime(dataStatisticsRequestDto.getBtStartTime());
        targetDataStatisticsRequestDto.setBtEndTime(dataStatisticsRequestDto.getBtEndTime());
        targetDataStatisticsRequestDto.setDepartId(dataStatisticsRequestDto.getDepartId());
        targetDataStatisticsRequestDto.setDepartName(dataStatisticsRequestDto.getDepartName());
        targetDataStatisticsRequestDto.setExcelType(dataStatisticsRequestDto.getExcelType());
        targetDataStatisticsRequestDto.setPageSize(dataStatisticsRequestDto.getPageSize());
        targetDataStatisticsRequestDto.setPageNum(dataStatisticsRequestDto.getPageNum());
        targetDataStatisticsRequestDto.setSortStr(dataStatisticsRequestDto.getSortStr());
        targetDataStatisticsRequestDto.setSortType(dataStatisticsRequestDto.getSortType());
        targetDataStatisticsRequestDto.setSortField(dataStatisticsRequestDto.getSortField());
        targetDataStatisticsRequestDto.setUserId(dataStatisticsRequestDto.getUserId());
        targetDataStatisticsRequestDto.setTimeType(dataStatisticsRequestDto.getTimeType());
        log.info("targetDataStatisticsRequestDto is {}", (Object)targetDataStatisticsRequestDto);
        List dateList = new ArrayList();
        if (Objects.isNull(targetDataStatisticsRequestDto.getKtStartTime()) || Objects.isNull(targetDataStatisticsRequestDto.getKtEndTime())) {
            LocalDate currentDate = LocalDate.now();
            LocalDate oneWeekAgo = currentDate.minusDays(7L);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String formattedOneWeekAgo = oneWeekAgo.format(formatter);
            String formattedOneNow = currentDate.format(formatter);
            dateList = DateUtil.getDays((String)formattedOneWeekAgo, (String)formattedOneNow);
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = oneWeekAgo.atStartOfDay().atZone(zone).toInstant();
            Instant instant2 = currentDate.atStartOfDay().atZone(zone).toInstant();
            Date start = Date.from(instant);
            Date end = Date.from(instant2);
            targetDataStatisticsRequestDto.setKtStartTime(start);
            targetDataStatisticsRequestDto.setKtEndTime(end);
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateList = DateUtil.getDays((String)sdf.format(targetDataStatisticsRequestDto.getKtStartTime()), (String)sdf.format(targetDataStatisticsRequestDto.getKtEndTime()));
            targetDataStatisticsRequestDto.setKtEndTime(DateUtil.tomorrowDateStr());
        }
        log.info("dateList : {}", dateList);
        Map<String, Object> params = this.getMapParamSecond(targetDataStatisticsRequestDto);
        params.put("orgId", targetDataStatisticsRequestDto.getOrgId());
        log.info("params : {}", params);
        DubboResult dubboResult = this.dataStatisticsServiceApi.meetingCountByDay(params);
        log.info("result : {}", (Object)dubboResult.getData());
        ArrayList countDays = (ArrayList)dubboResult.getData();
        SimpleDateFormat sdfDay = new SimpleDateFormat("yyyy-MM-dd");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Date date : dateList) {
            dateStr = sdfDay.format(date);
            map.put(dateStr, 0);
        }
        for (MeetingCountDaysResDTO meetingCountDaysRes : countDays) {
            dateStr = sdfDay.format(meetingCountDaysRes.getOneDay());
            if (map.get(dateStr) == null) continue;
            map.put(dateStr, meetingCountDaysRes.getMeetingNum());
        }
        return map;
    }

    @Override
    public List<CauseMeetingNumResDTO> getCauseNumList(DataStatisticsRequestDto dataStatisticsRequestDto) {
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        DubboResult dubboResult = this.dataStatisticsServiceApi.getCauseNumList(params);
        ArrayList list = (ArrayList)dubboResult.getData();
        return list;
    }

    @Override
    public SourceCountResDTO getSourceNum(DataStatisticsRequestDto dataStatisticsRequestDto) {
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        DubboResult result = this.dataStatisticsServiceApi.getSourceNum(params);
        return (SourceCountResDTO)result.getData();
    }

    @Override
    public Map<String, Object> getMeetingTypeNum(DataStatisticsRequestDto dataStatisticsRequestDto) {
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        HashMap<String, Object> result = new HashMap<String, Object>();
        DubboResult dubbo = this.dataStatisticsServiceApi.getMeetingTypeNum(params);
        ArrayList<String> meetingTypeList = new ArrayList<String>();
        meetingTypeList.add("\u6c11\u4e8b\u6848\u4ef6");
        meetingTypeList.add("\u5211\u4e8b\u6848\u4ef6");
        meetingTypeList.add("\u884c\u653f\u6848\u4ef6");
        ArrayList numList = (ArrayList)dubbo.getData();
        ArrayList<MeetingTypeNumResDTO> msaj = new ArrayList<MeetingTypeNumResDTO>();
        ArrayList<MeetingTypeNumResDTO> xsaj = new ArrayList<MeetingTypeNumResDTO>();
        ArrayList<MeetingTypeNumResDTO> xzaj = new ArrayList<MeetingTypeNumResDTO>();
        for (MeetingTypeNumResDTO meetingTypeNumRes : numList) {
            if ("\u6c11\u4e8b\u6848\u4ef6".equals(meetingTypeNumRes.getMeetingType())) {
                msaj.add(meetingTypeNumRes);
            }
            if ("\u5211\u4e8b\u6848\u4ef6".equals(meetingTypeNumRes.getMeetingType())) {
                xsaj.add(meetingTypeNumRes);
            }
            if (!"\u884c\u653f\u6848\u4ef6".equals(meetingTypeNumRes.getMeetingType())) continue;
            xzaj.add(meetingTypeNumRes);
        }
        result.put("list", meetingTypeList);
        result.put("msaj", msaj);
        result.put("xsaj", xsaj);
        result.put("xzaj", xzaj);
        return result;
    }

    @Override
    public Map<String, Object> meetingInitNumList(DataStatisticsRequestDto dataStatisticsRequestDto) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        HashMap<String, Object> result = new HashMap<String, Object>();
        DubboResult dubbo = this.dataStatisticsServiceApi.meetingInitNumList(params);
        MeetingInitNumResDTO meetingInitNumRes = (MeetingInitNumResDTO)dubbo.getData();
        log.info("\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)dubbo.toString());
        ArrayList<MeetingInitNumResponseDTO> list = new ArrayList<MeetingInitNumResponseDTO>();
        list.add(new MeetingInitNumResponseDTO("\u4eca\u5929\u5f00\u5ead", meetingInitNumRes.getToday()));
        list.add(new MeetingInitNumResponseDTO("\u660e\u5929\u5f00\u5ead", meetingInitNumRes.getTomorrow()));
        list.add(new MeetingInitNumResponseDTO("\u540e\u5929\u5f00\u5ead", meetingInitNumRes.getAfterTomorrow()));
        list.add(new MeetingInitNumResponseDTO("\u672a\u6765\u5f00\u5ead", meetingInitNumRes.getFuture()));
        result.put("total", meetingInitNumRes.getTotal());
        result.put("list", list);
        return result;
    }

    @Override
    public PageInfo<MeetingWaitScheduleResDTO> meetingScheduleNumList(DataStatisticsRequestDto dataStatisticsRequestDto) {
        Map<String, Object> params = this.getMapParam(dataStatisticsRequestDto);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        params.put("pageNum", dataStatisticsRequestDto.getPageNum());
        params.put("pageSize", dataStatisticsRequestDto.getPageSize());
        log.info("\u53c2\u6570\uff1a" + params);
        DubboResult dubbo = this.dataStatisticsServiceApi.meetingScheduleNumList(params);
        log.info("\u7ed3\u679c\uff1a" + dubbo);
        PageInfo meetingList = (PageInfo)dubbo.getData();
        log.info("\u7ed3\u679c\uff1a" + meetingList);
        return meetingList;
    }

    @Override
    public void getCourtroomNum(DataStatisticsRequestDto dataStatisticsRequestDto) {
    }

    @Override
    public List<CourtUserNumResDTO> getCourtUserNum(DataStatisticsRequestDto dataStatisticsRequestDto) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        DubboResult dubbo = this.dataStatisticsCourtApi.getCourtUserNum(params);
        return (List)((Object)dubbo.getData());
    }

    @Override
    public void getCourtroomUserNum(DataStatisticsRequestDto dataStatisticsRequestDto) {
    }

    @Override
    public PageInfo<DurationStatisticsResVO> trialDurationStatistics(DurationStatisticsRequestDto dto) {
        String appName = AppNameContextHolder.getAppName();
        if ("1".equals(dto.getAuthorityLevel())) {
            String queryColumn = "weitingshenhubeizz".equals(appName) ? "area_code" : "province_code";
            DubboResult dubboAreaCode = this.alexSaasPlatformApi.getAreaCode(appName);
            String provinceCode = (String)((Object)dubboAreaCode.getData());
            AssertUtils.assertTrue((!StringUtils.isBlank((CharSequence)provinceCode) ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u4e0d\u5b58\u5728\u8be5\u79df\u6237\u7684\u914d\u7f6e");
            DubboResult allOrgId = this.organizationSecondServiceApi.queryOrgIdByAreaCode(provinceCode, queryColumn);
            dto.setOrgIdList((List)((Object)allOrgId.getData()));
        } else if ("2".equals(dto.getAuthorityLevel())) {
            DubboResult dtoDubboResult = this.dataStatisticsCourtApi.userLoginInfo(dto.getCurrentUserId());
            LoginInfoResDTO userLogInfo = (LoginInfoResDTO)dtoDubboResult.getData();
            List userRoles = userLogInfo.getUserRoles();
            UserRoleInfoDTO userInfo = userRoles.stream().filter(x -> RoleTypeEnum.ORG_MANAGE.name().equals(x.getRoleCode())).findFirst().orElseThrow(RuntimeException::new);
            dto.setOrgIdList(Collections.singletonList(userInfo.getOrganizationId()));
        }
        DubboResult dubboResult = this.dataStatisticsServiceApi.trialDurationStatistics(dto);
        return (PageInfo)dubboResult.getData();
    }

    @Override
    public void meetingDataExport(DurationStatisticsRequestDto dto, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.excelExport("\u5f00\u5ead\u65f6\u957f\u7edf\u8ba1", this.courtDataTitle(), this.courtDataExport(dto), request, response);
    }

    @Override
    public List<CourtTimeResponseDTO> listCourtTimeByOrgId(DataStatisticsRequestDto dataStatisticsRequestDto) {
        log.info("\u5206\u5e03requestParam is {}", (Object)dataStatisticsRequestDto);
        Map<String, Object> mapParam = this.getMapParam(dataStatisticsRequestDto);
        DubboResult provincialCourtDubbo = this.dataStatisticsCourtApi.findProvincialCourt(dataStatisticsRequestDto.getOrgId().toString());
        log.info("dataStatisticsCourtApi.findProvincialCourt data {}" + provincialCourtDubbo.getData());
        DubboResult dubbo = this.dataStatisticsCourtApi.findCourtsByParentId(provincialCourtDubbo.getData() == null ? dataStatisticsRequestDto.getOrgId().toString() : ((CourtInfoResDTO)provincialCourtDubbo.getData()).getOrgId());
        log.info(" \u4e2d\u7ea7\u6cd5\u9662 dataStatisticsCourtApi.findCourtsByParentId data {}" + dubbo.getData());
        ArrayList courtsList = (ArrayList)dubbo.getData();
        ArrayList<CourtTimeResponseDTO> courtTimeResponseDtoList = new ArrayList<CourtTimeResponseDTO>();
        if (courtsList.size() == 0) {
            DubboResult dubboTest = this.dataStatisticsCourtApi.findCourtById(dataStatisticsRequestDto.getOrgId().toString());
            CourtInfoResDTO courtInfoResDTO = (CourtInfoResDTO)dubboTest.getData();
            String cityName = StringUtils.isNotBlank((CharSequence)courtInfoResDTO.getCityName()) ? courtInfoResDTO.getCityName() : courtInfoResDTO.getOrgName();
            courtInfoResDTO.setCityName(cityName);
            courtsList.add(courtInfoResDTO);
        }
        if ("weitingshenhainan".equals(AppNameContextHolder.getAppName())) {
            DubboResult courtDubbo = this.dataStatisticsCourtApi.findCourtById("2907");
            CourtInfoResDTO court = (CourtInfoResDTO)courtDubbo.getData();
            CourtTimeResponseDTO courtTimeResponseDTO = new CourtTimeResponseDTO();
            courtTimeResponseDTO.setOrgId(court.getOrgId());
            courtTimeResponseDTO.setOrgName(court.getOrgName());
            courtTimeResponseDTO.setCityName(court.getOrgName());
            courtTimeResponseDTO.setCourtDuration(Double.valueOf(0.0));
            courtTimeResponseDtoList.add(courtTimeResponseDTO);
            mapParam.put("orgId", 2907);
            DubboResult dubboResult = this.dataStatisticsServiceApi.listCourtTimeByOrgIds(mapParam);
            ArrayList data = (ArrayList)dubboResult.getData();
            if (!CollectionUtils.isEmpty((Collection)data)) {
                for (CourtTimeResponseDTO datum : data) {
                    for (CourtTimeResponseDTO responseDTO : courtTimeResponseDtoList) {
                        String orgId = datum.getOrgId();
                        Double courtDuration = Objects.isNull(datum.getCourtDuration()) ? 0.0 : datum.getCourtDuration();
                        String orgId1 = responseDTO.getOrgId();
                        if (!orgId.equals(orgId1)) continue;
                        responseDTO.setCourtDuration(courtDuration);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(courtTimeResponseDtoList)) {
                SortUtil.sortDoubleDataList(courtTimeResponseDtoList, (String)"courtDuration", (String)"desc");
            }
            return courtTimeResponseDtoList;
        }
        if (courtsList != null && courtsList.size() > 0) {
            for (CourtInfoResDTO courtsInfoResDto : courtsList) {
                mapParam.put("orgId", courtsInfoResDto.getOrgId());
                DubboResult dubbo2 = this.dataStatisticsServiceApi.listCourtTimeByOrgId(mapParam);
                CourtTimeResponseDTO courtNumResponseDTO = (CourtTimeResponseDTO)dubbo2.getData();
                log.info("{}\u4e2d\u7ea7\u6cd5\u9662\u6848\u4ef6\u6570\u91cf\uff1a{}", (Object)courtsInfoResDto.getCityName(), (Object)courtNumResponseDTO.getCourtDuration());
                courtNumResponseDTO.setOrgId(courtsInfoResDto.getOrgId());
                courtNumResponseDTO.setOrgName(courtsInfoResDto.getOrgName());
                courtNumResponseDTO.setCityName(courtsInfoResDto.getCityName());
                courtTimeResponseDtoList.add(courtNumResponseDTO);
            }
        }
        for (CourtTimeResponseDTO courtTimeResponseDto : courtTimeResponseDtoList) {
            DubboResult dubboChild = this.dataStatisticsCourtApi.findCourtsByParentId(courtTimeResponseDto.getOrgId());
            log.info(" \u4e2d\u9662\u4e0b\u7ea7 dataStatisticsCourtApi.findCourtsByParentId data {}" + dubboChild.getData());
            Double childCourtNum = 0.0;
            if (dubboChild.getCode() != 200) continue;
            ArrayList list = (ArrayList)dubboChild.getData();
            ArrayList<String> orgIds = new ArrayList<String>();
            for (CourtInfoResDTO courtsInfoResDto : list) {
                orgIds.add(courtsInfoResDto.getOrgId());
            }
            if (orgIds != null && orgIds.size() > 0) {
                mapParam.put("orgId", null);
                mapParam.put("courts", orgIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
                childCourtNum = (Double)this.dataStatisticsServiceApi.getCourtTimeList(mapParam).getData();
                log.info("{}\u4e0b\u7ea7\u6cd5\u9662\u6848\u4ef6\u65f6\u957f\u4e3a\uff1a{}, \u4e0a\u7ea7\u6cd5\u9662{}\u6848\u4ef6\u65f6\u957f\u4e3a{}", new Object[]{courtTimeResponseDto.getCityName(), childCourtNum, courtTimeResponseDto.getOrgName(), courtTimeResponseDto.getCourtDuration()});
            }
            Double childCourtNum1 = childCourtNum == null ? 0.0 : childCourtNum;
            double sum = childCourtNum1 + courtTimeResponseDto.getCourtDuration();
            double result = BigDecimal.valueOf(sum).divide(BigDecimal.valueOf(60L), 2, RoundingMode.HALF_UP).doubleValue();
            DecimalFormat df = new DecimalFormat("#0.00");
            courtTimeResponseDto.setCourtDuration(Double.valueOf(Double.parseDouble(df.format(result))));
        }
        SortUtil.sortDoubleDataList(courtTimeResponseDtoList, (String)"courtDuration", (String)"desc");
        return courtTimeResponseDtoList;
    }

    @Override
    public List<CourtRoomResponseDTO> getCourtRoomData(DataStatisticsRequestDto courtRoomRequestDto) {
        ArrayList courtRoomResponseDTOS = new ArrayList();
        DubboResult courtRoomData = this.dataStatisticsCourtApi.getCourtRoomData(courtRoomRequestDto.getOrgId());
        AssertUtils.assertTrue((boolean)courtRoomData.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)courtRoomData.getMessage());
        ArrayList data = (ArrayList)courtRoomData.getData();
        HashMap<Long, CourtRoomResponseDTO> respMap = new HashMap<Long, CourtRoomResponseDTO>();
        if (CollectionUtils.isEmpty((Collection)data) && data.size() <= 0) {
            return new ArrayList<CourtRoomResponseDTO>();
        }
        this.convertCourtRoomResDTO(respMap, data);
        log.info("init data is {}", (Object)JSONObject.toJSONString(respMap));
        List orgIds = data.stream().map(DepartResDTO::getDepartId).collect(Collectors.toList());
        DubboResult staffData = this.dataStatisticsCourtApi.listStaffData(orgIds);
        AssertUtils.assertTrue((boolean)staffData.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)staffData.getMessage());
        ArrayList persons = (ArrayList)staffData.getData();
        if (CollectionUtils.isEmpty((Collection)persons) && persons.size() <= 0) {
            return new ArrayList<CourtRoomResponseDTO>();
        }
        Map<Long, List<StaffResDTO>> collect = persons.stream().collect(Collectors.groupingBy(StaffResDTO::getDepartId));
        if (!MapUtils.isEmpty(collect)) {
            for (Map.Entry<Long, List<StaffResDTO>> entry : collect.entrySet()) {
                Long departId = entry.getKey();
                List<StaffResDTO> staffPersons = entry.getValue();
                Map<String, Object> requestParams = this.getMapParamThird(courtRoomRequestDto, staffPersons, departId);
                log.info("requestParams is {}", (Object)JSONObject.toJSONString(requestParams));
                DubboResult countResult = this.dataStatisticsServiceApi.listCourtRoomData(requestParams);
                AssertUtils.assertTrue((boolean)countResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)countResult.getMessage());
                CourtRoomResDTO countData = (CourtRoomResDTO)countResult.getData();
                log.info("courtRoomData is {}", (Object)countData);
                CourtRoomResponseDTO orDefault = (CourtRoomResponseDTO)respMap.get(departId);
                orDefault.setCaseNum(countData.getCaseNum());
                respMap.put(departId, orDefault);
            }
        }
        courtRoomResponseDTOS = Lists.newArrayList(respMap.values());
        log.info("result is {}", (Object)JSONObject.toJSONString((Object)courtRoomResponseDTOS));
        if (StringUtils.isNotBlank((CharSequence)courtRoomRequestDto.getSortType())) {
            SortUtil.sortList((List)courtRoomResponseDTOS, (String)"caseNum", (String)courtRoomRequestDto.getSortType());
        }
        return courtRoomResponseDTOS;
    }

    @Override
    public List<CourtRoomPersonResponseDTO> getCourtRoomPersonData(DataStatisticsRequestDto courtRoomPersonRequestDto) {
        DubboResult dubboResult = this.dataStatisticsCourtApi.getCourtRoomPersonData(courtRoomPersonRequestDto.getOrgId(), courtRoomPersonRequestDto.getDepartId());
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboResult.getMessage());
        List result = (List)((Object)dubboResult.getData());
        return result;
    }

    public List<Object> courtDataExport(DurationStatisticsRequestDto requestDTO) {
        ArrayList<Object> result = new ArrayList<Object>();
        requestDTO.setPageIndex(Integer.valueOf(1));
        requestDTO.setPageSize(Integer.valueOf(1000));
        PageInfo<DurationStatisticsResVO> lists = this.trialDurationStatistics(requestDTO);
        List list = lists.getList();
        if (lists.getTotalRows() > 1000) {
            int totalRows = lists.getTotalRows();
            int total = lists.getTotalRows() % 1000 == 0 ? totalRows / 1000 : totalRows / 1000 + 1;
            for (int i = 2; i <= total; ++i) {
                requestDTO.setPageIndex(Integer.valueOf(i));
                requestDTO.setPageSize(Integer.valueOf(1000));
                PageInfo<DurationStatisticsResVO> partList = this.trialDurationStatistics(requestDTO);
                List list2 = partList.getList();
                list.addAll(list2);
            }
        }
        for (DurationStatisticsResVO meetingInfoRes : list) {
            ArrayList<String> data = new ArrayList<String>();
            data.add(meetingInfoRes.getOrgCode());
            data.add(meetingInfoRes.getOrgName());
            data.add(meetingInfoRes.getCaseCode());
            data.add(meetingInfoRes.getCaseName());
            data.add(meetingInfoRes.getUserName());
            data.add(meetingInfoRes.getOrderTime());
            data.add(meetingInfoRes.getStartTime());
            data.add(meetingInfoRes.getEndTime());
            data.add(String.valueOf(meetingInfoRes.getTrialTime()));
            result.add(data);
        }
        return result;
    }

    public List<String> courtDataTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u6cd5\u9662\u4ee3\u7801");
        result.add("\u6cd5\u9662\u540d\u79f0");
        result.add("\u6848\u4ef6\u4ee3\u7801");
        result.add("\u6848\u4ef6\u540d\u79f0");
        result.add("\u627f\u529e\u4eba");
        result.add("\u5f00\u5ead\u9884\u7ea6\u65f6\u95f4");
        result.add("\u5f00\u5ead\u5f00\u59cb\u65f6\u95f4");
        result.add("\u5f00\u5ead\u7ed3\u675f\u65f6\u95f4");
        result.add("\u5f00\u5ead\u65f6\u957f\uff08\u5206\u949f\uff09");
        return result;
    }

    public void excelExport(String excelName, List<String> titleMap, List<Object> excelContent, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] title = new String[titleMap.size()];
        for (int i = 0; i < titleMap.size(); ++i) {
            title[i] = titleMap.get(i).toString();
        }
        HSSFWorkbook wbook = ExcelExportUtil.getHSSFWorkbook(excelName, title, excelContent);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wbook.write((OutputStream)os);
            byte[] bytes = os.toByteArray();
            String fileName = excelName + ".xls";
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
            response.addHeader("Content-Length", "" + bytes.length);
            response.setHeader("Content-Disposition", "inline;filename=" + new String(fileName.getBytes("utf-8"), "iso8859-1"));
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ((OutputStream)toClient).write(bytes);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.in.read();
    }

    public Map<String, Object> getMapParam(DataStatisticsRequestDto dataStatisticsRequestDto) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (dataStatisticsRequestDto.getTimeType() != null) {
            Map dateMap = DateUtil.setTime((Integer)dataStatisticsRequestDto.getTimeType());
            params.put("startTime", dateMap.get("startTime"));
            params.put("endTime", dateMap.get("endTime"));
        }
        if (dataStatisticsRequestDto.getStartTime() != null && dataStatisticsRequestDto.getEndTime() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat sdfEnd = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
            params.put("startTime", sdf.format(dataStatisticsRequestDto.getStartTime()));
            params.put("endTime", sdfEnd.format(dataStatisticsRequestDto.getEndTime()));
        }
        if (null != dataStatisticsRequestDto.getKtStartTime()) {
            SimpleDateFormat sdfKtStart = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            params.put("ktStartTime", sdfKtStart.format(dataStatisticsRequestDto.getKtStartTime()));
        }
        if (null != dataStatisticsRequestDto.getKtEndTime()) {
            SimpleDateFormat sdfKtEnd = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
            params.put("ktEndTime", sdfKtEnd.format(dataStatisticsRequestDto.getKtEndTime()));
        }
        if (null != dataStatisticsRequestDto.getBtStartTime()) {
            SimpleDateFormat sdfBtStart = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            params.put("btStartTime", sdfBtStart.format(dataStatisticsRequestDto.getBtStartTime()));
        }
        if (null != dataStatisticsRequestDto.getBtEndTime()) {
            SimpleDateFormat sdfBtEnd = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
            params.put("btEndTime", sdfBtEnd.format(dataStatisticsRequestDto.getBtEndTime()));
        }
        return params;
    }

    public Map<String, Object> getMapParamSecond(DataStatisticsRequestDto dataStatisticsRequestDto) {
        SimpleDateFormat sdf;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (dataStatisticsRequestDto.getTimeType() != null) {
            Map dateMap = DateUtil.setTime((Integer)dataStatisticsRequestDto.getTimeType());
            params.put("startTime", dateMap.get("startTime"));
            params.put("endTime", dateMap.get("endTime"));
        }
        SimpleDateFormat endSdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        if (dataStatisticsRequestDto.getStartTime() != null && dataStatisticsRequestDto.getEndTime() != null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            params.put("startTime", sdf.format(dataStatisticsRequestDto.getStartTime()));
            params.put("endTime", endSdf.format(dataStatisticsRequestDto.getEndTime()));
        }
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (null != dataStatisticsRequestDto.getKtStartTime()) {
            params.put("ktStartTime", sdf.format(dataStatisticsRequestDto.getKtStartTime()));
        }
        if (null != dataStatisticsRequestDto.getKtEndTime()) {
            params.put("ktEndTime", endSdf.format(dataStatisticsRequestDto.getKtEndTime()));
        }
        if (null != dataStatisticsRequestDto.getBtStartTime()) {
            params.put("btStartTime", sdf.format(dataStatisticsRequestDto.getBtStartTime()));
        }
        if (null != dataStatisticsRequestDto.getBtEndTime()) {
            params.put("btEndTime", endSdf.format(dataStatisticsRequestDto.getBtEndTime()));
        }
        return params;
    }

    public Map<String, Object> getMapParamThird(DataStatisticsRequestDto dataStatisticsRequestDto, List<StaffResDTO> persons, Long departId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (dataStatisticsRequestDto.getTimeType() != null) {
            Map dateMap = DateUtil.setTime((Integer)dataStatisticsRequestDto.getTimeType());
            params.put("startTime", dateMap.get("startTime"));
            params.put("endTime", dateMap.get("endTime"));
        }
        if (dataStatisticsRequestDto.getStartTime() != null && dataStatisticsRequestDto.getEndTime() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat sdfEnd = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
            params.put("startTime", sdf.format(dataStatisticsRequestDto.getStartTime()));
            params.put("endTime", sdfEnd.format(dataStatisticsRequestDto.getEndTime()));
        }
        if (null != dataStatisticsRequestDto.getKtStartTime()) {
            SimpleDateFormat sdfKtStart = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            params.put("ktStartTime", sdfKtStart.format(dataStatisticsRequestDto.getKtStartTime()));
        }
        if (null != dataStatisticsRequestDto.getKtEndTime()) {
            SimpleDateFormat sdfKtEnd = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
            params.put("ktEndTime", sdfKtEnd.format(dataStatisticsRequestDto.getKtEndTime()));
        }
        if (null != dataStatisticsRequestDto.getBtStartTime()) {
            SimpleDateFormat sdfBtStart = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            params.put("btStartTime", sdfBtStart.format(dataStatisticsRequestDto.getBtStartTime()));
        }
        if (null != dataStatisticsRequestDto.getBtEndTime()) {
            SimpleDateFormat sdfBtEnd = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
            params.put("btEndTime", sdfBtEnd.format(dataStatisticsRequestDto.getBtEndTime()));
        }
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtils.isEmpty(persons) && persons.size() > 0) {
            sb.append("(");
            persons.forEach(staffResDTO -> {
                sb.append(staffResDTO.getUserId());
                sb.append(",");
            });
            sb.deleteCharAt(sb.toString().length() - 1);
            sb.append(")");
        }
        params.put("userIds", sb.toString());
        params.put("courtRoomId", departId);
        params.put("orgId", dataStatisticsRequestDto.getOrgId());
        return params;
    }

    public void convertCourtRoomResDTO(Map<Long, CourtRoomResponseDTO> list, List<DepartResDTO> data) {
        if (!CollectionUtils.isEmpty(data) && data.size() > 0) {
            for (DepartResDTO departResDTO : data) {
                CourtRoomResponseDTO courtRoomResponseDTO = new CourtRoomResponseDTO();
                courtRoomResponseDTO.setCourtRoom(departResDTO.getDepartName());
                courtRoomResponseDTO.setCaseNum(Integer.valueOf(0));
                courtRoomResponseDTO.setCourtRoomId(departResDTO.getDepartId());
                list.put(courtRoomResponseDTO.getCourtRoomId(), courtRoomResponseDTO);
            }
        }
    }
}

