/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.statistics.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.domain.dto.requestdto.MeetingRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MeetingInfoResponseDTO;
import com.beiming.odr.peace.statistics.common.enums.ColumnEnums;
import com.beiming.odr.peace.statistics.common.enums.ErrorCode;
import com.beiming.odr.peace.statistics.service.HubeiMeetingService;
import com.beiming.odr.peace.statistics.service.util.ExcelExportUtil;
import com.beiming.odr.referee.api.CaseRoomMicroApi;
import com.beiming.odr.referee.api.DataStatisticsServiceApi;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.requestdto.MyBusinessReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseListMicroResponseDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HubeiMeetingServiceImpl
implements HubeiMeetingService {
    private static final Logger log = LoggerFactory.getLogger(HubeiMeetingServiceImpl.class);
    @Resource
    private DataStatisticsServiceApi dataStatisticsServiceApi;
    @Resource
    private CaseRoomMicroApi caseRoomMicroApi;
    @Resource
    private MediationRoomApi mediationRoomApi;

    @Override
    public PageInfo<MeetingInfoResponseDTO> meetingList(MeetingRequestDTO requestDTO) {
        MyBusinessReqDTO reqDTO = new MyBusinessReqDTO();
        reqDTO.setOrgId(requestDTO.getOrgId());
        reqDTO.setOrgName(requestDTO.getOrgName());
        reqDTO.setCourtName(requestDTO.getCourtName());
        reqDTO.setCaseStatus(requestDTO.getCaseStatus());
        reqDTO.setPageIndex(requestDTO.getPageIndex());
        reqDTO.setPageSize(requestDTO.getPageSize());
        reqDTO.setSign(requestDTO.getSign());
        reqDTO.setKtOrder(requestDTO.getKtOrder());
        reqDTO.setBtOrder(requestDTO.getBtOrder());
        reqDTO.setDurationOrder(requestDTO.getDurationOrder());
        if (requestDTO.getStartTime() != null && requestDTO.getEndTime() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat sdfEnd = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
            reqDTO.setStartTime(sdf.format(requestDTO.getStartTime()));
            reqDTO.setEndTime(sdfEnd.format(requestDTO.getEndTime()));
        }
        log.info("\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)reqDTO.getStartTime(), (Object)reqDTO.getEndTime());
        DubboResult dubboResult = this.caseRoomMicroApi.meetingList(reqDTO);
        PageInfo pageInfoResult = (PageInfo)dubboResult.getData();
        AssertUtils.assertNotNull((Object)pageInfoResult, (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        List resultList = pageInfoResult.getList();
        ArrayList<MeetingInfoResponseDTO> myBusinessResponseList = new ArrayList<MeetingInfoResponseDTO>();
        DecimalFormat df = new DecimalFormat("#0.00");
        if (!CollectionUtils.isEmpty((Collection)resultList)) {
            for (CaseListMicroResponseDTO one : resultList) {
                MeetingInfoResponseDTO myBusinessResponseDTO = new MeetingInfoResponseDTO();
                myBusinessResponseDTO.setBizRoomId(one.getBizRoomId());
                myBusinessResponseDTO.setCauseName(one.getCauseName());
                myBusinessResponseDTO.setEndTime(one.getEndTime());
                myBusinessResponseDTO.setMeetingDuration(Double.valueOf(df.format(one.getMeetingDuration())));
                myBusinessResponseDTO.setName(one.getName());
                myBusinessResponseDTO.setOrgName(one.getOrgName());
                myBusinessResponseDTO.setRoomStatus(one.getMediationStatus());
                myBusinessResponseDTO.setRoomType(one.getMediationMeetingType());
                myBusinessResponseDTO.setStartTime(one.getStartTime());
                myBusinessResponseDTO.setCourtRoomName(one.getCourtRoomName());
                DubboResult mediationUserInfoRes = this.mediationRoomApi.getMediationRoomUserInfoAllList(one.getBizRoomId());
                ArrayList mediationUserInfoList = (ArrayList)mediationUserInfoRes.getData();
                HubeiMeetingServiceImpl.buildParticipants(myBusinessResponseDTO, mediationUserInfoList);
                myBusinessResponseList.add(myBusinessResponseDTO);
            }
        }
        return new PageInfo(myBusinessResponseList, pageInfoResult.getTotalRows(), pageInfoResult.getPageIndex(), pageInfoResult.getPageSize());
    }

    public static void buildParticipants(MeetingInfoResponseDTO myBusinessResponseDTO, ArrayList<MediationRoomUserInfoResDTO> mediationUserInfoList) {
        if (CollectionUtils.isEmpty(mediationUserInfoList)) {
            myBusinessResponseDTO.setStaff("");
            return;
        }
        String staff = "";
        String litigant = "";
        HashSet<Long> userIdSet = new HashSet<Long>();
        for (MediationRoomUserInfoResDTO member : mediationUserInfoList) {
            if (userIdSet.contains(member.getUserId())) continue;
            userIdSet.add(member.getUserId());
            String type = member.getMeetingUserType();
            JSONObject json = new JSONObject();
            String userName = "";
            String unitName = "";
            if (member.getExpandAttribute() != null) {
                json = JSONObject.parseObject((String)member.getExpandAttribute());
                unitName = json.getString(ColumnEnums.UNIT_NAME.desc());
            }
            userName = StringUtils.isNotEmpty((CharSequence)unitName) ? unitName + "(" + HubeiMeetingServiceImpl.getUserIdentity(HubeiMeetingServiceImpl.getType(type, json)) + ")" : member.getUserName() + "(" + HubeiMeetingServiceImpl.getUserIdentity(HubeiMeetingServiceImpl.getType(type, json)) + ")";
            if ("MEDIATOR".equals(type) || "ASSISTANT_JUDGE".equals(type) || "CLERK".equals(type) || "JUROR".equals(type)) {
                staff = StringUtils.isBlank((String)staff) ? userName : staff + "," + userName;
                continue;
            }
            litigant = StringUtils.isBlank((String)litigant) ? userName : litigant + "," + userName;
        }
        myBusinessResponseDTO.setStaff(staff);
    }

    public static String getType(String type, JSONObject json) {
        if (json.get((Object)ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc()) != null && "APPLICANT".equals(type)) {
            type = "SECOND_APPLICANT";
        }
        if (json.get((Object)ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc()) != null && "RESPONDENT".equals(type)) {
            type = "SECOND_RESPONDENT";
        }
        return type;
    }

    public static String getUserIdentity(String value) {
        switch (value) {
            case "CLERK": {
                return "\u4e66\u8bb0\u5458";
            }
            case "JUROR": {
                return "\u966a\u5ba1\u5458";
            }
            case "MEDIATOR": {
                return "\u5ba1\u5224\u5458";
            }
            case "MEDIATOR_HELP_TEMPORARY": {
                return "\u534f\u52a9\u6cd5\u5b98";
            }
            case "MEDIATOR_HELP": {
                return "\u534f\u52a9\u6cd5\u5b98";
            }
            case "ASSISTANT_JUDGE": {
                return "\u6cd5\u5b98\u52a9\u7406";
            }
            case "APPLICANT": {
                return "\u539f\u544a";
            }
            case "RESPONDENT": {
                return "\u88ab\u544a";
            }
            case "LITIGANT_THIRD": {
                return "\u7b2c\u4e09\u4eba";
            }
            case "APPLICANT_AGENT": {
                return "\u539f\u544a\u4ee3\u7406\u4eba";
            }
            case "RESPONDENT_AGENT": {
                return "\u88ab\u544a\u4ee3\u7406\u4eba";
            }
            case "PETITION_AGENT": {
                return "\u4fe1\u8bbf\u4ee3\u7406\u4eba";
            }
            case "LITIGANT": {
                return "\u5f53\u4e8b\u4eba";
            }
            case "LITIGANT_WITNESS": {
                return "\u8bc1\u4eba";
            }
            case "SECOND_APPLICANT": {
                return "\u4e0a\u8bc9\u4eba";
            }
            case "SECOND_RESPONDENT": {
                return "\u88ab\u4e0a\u8bc9\u4eba";
            }
            case "LITIGANT_SURVEYOR": {
                return "\u9274\u5b9a\u4eba";
            }
            case "LITIGANT_TRANSLATOR": {
                return "\u7ffb\u8bd1\u5458";
            }
            case "LITIGANT_THIRD_AGENT": {
                return "\u7b2c\u4e09\u4eba\u4ee3\u7406\u4eba";
            }
            case "OTHER": {
                return "\u4e34\u65f6\u5165\u4f1a\u4eba\u5458";
            }
        }
        return "";
    }

    @Override
    public void meetingDataExport(MeetingRequestDTO requestDTO, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)requestDTO.getSign()) && "1".equals(requestDTO.getSign())) {
            this.excelExport("\u6cd5\u5ead\u5f00\u5ead\u6570\u636e", this.courtDataTitle2(), this.courtDataExport(requestDTO), request, response);
        } else {
            this.excelExport("\u6cd5\u9662\u5f00\u5ead\u6570\u636e", this.courtDataTitle(), this.courtDataExport(requestDTO), request, response);
        }
    }

    public List<String> courtDataTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u6cd5\u9662");
        result.add("\u6848\u53f7");
        result.add("\u5f00\u5ead\u72b6\u6001");
        result.add("\u6848\u7531");
        result.add("\u5ba1\u5224\u7ec4\u7ec7");
        result.add("\u5f00\u5ead\u65f6\u95f4");
        result.add("\u95ed\u5ead\u65f6\u95f4");
        result.add("\u5f00\u5ead\u65f6\u957f\uff08\u5c0f\u65f6\uff09");
        return result;
    }

    public List<String> courtDataTitle2() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u6cd5\u5ead\u540d\u79f0");
        result.add("\u6cd5\u9662");
        result.add("\u6848\u53f7");
        result.add("\u5f00\u5ead\u72b6\u6001");
        result.add("\u6848\u7531");
        result.add("\u5ba1\u5224\u7ec4\u7ec7");
        result.add("\u5f00\u5ead\u65f6\u95f4");
        result.add("\u95ed\u5ead\u65f6\u95f4");
        result.add("\u5f00\u5ead\u65f6\u957f\uff08\u5c0f\u65f6\uff09");
        return result;
    }

    public List<Object> courtDataExport(MeetingRequestDTO requestDTO) {
        ArrayList<Object> result = new ArrayList<Object>();
        requestDTO.setPageIndex(Integer.valueOf(1));
        requestDTO.setPageSize(Integer.valueOf(1));
        PageInfo<MeetingInfoResponseDTO> page = this.meetingList(requestDTO);
        requestDTO.setPageSize(Integer.valueOf(page.getTotalRows()));
        PageInfo<MeetingInfoResponseDTO> pageAll = this.meetingList(requestDTO);
        List list = pageAll.getList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (MeetingInfoResponseDTO meetingInfoRes : list) {
            ArrayList<String> data = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)requestDTO.getSign()) && "1".equals(requestDTO.getSign())) {
                data.add(meetingInfoRes.getCourtRoomName());
            }
            data.add(meetingInfoRes.getOrgName());
            data.add(meetingInfoRes.getName());
            if ("INIT".equals(meetingInfoRes.getRoomStatus())) {
                data.add("\u5f85\u5f00\u5ead");
            } else if ("RUNNING".equals(meetingInfoRes.getRoomStatus())) {
                data.add("\u8fdb\u884c\u4e2d");
            } else if ("END".equals(meetingInfoRes.getRoomStatus())) {
                data.add("\u5df2\u7ed3\u675f");
            }
            data.add(meetingInfoRes.getCauseName());
            data.add(meetingInfoRes.getStaff());
            data.add(meetingInfoRes.getStartTime() == null ? null : sdf.format(meetingInfoRes.getStartTime()));
            data.add(meetingInfoRes.getEndTime() == null ? null : sdf.format(meetingInfoRes.getEndTime()));
            data.add(meetingInfoRes.getMeetingDuration().toString());
            result.add(data);
        }
        return result;
    }

    public void excelExport(String excelName, List<String> titleMap, List<Object> excelContent, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] title = new String[titleMap.size()];
        for (int i = 0; i < titleMap.size(); ++i) {
            title[i] = titleMap.get(i).toString();
        }
        HSSFWorkbook wbook = ExcelExportUtil.getHSSFWorkbook(excelName, title, excelContent);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wbook.write((OutputStream)os);
            byte[] bytes = os.toByteArray();
            String fileName = excelName + ".xls";
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
            response.addHeader("Content-Length", "" + bytes.length);
            response.setHeader("Content-Disposition", "inline;filename=" + new String(fileName.getBytes("utf-8"), "iso8859-1"));
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ((OutputStream)toClient).write(bytes);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.in.read();
    }
}

