/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.statistics.service.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.statistics.common.enums.ErrorCode;
import com.beiming.odr.peace.statistics.service.UserService;
import com.beiming.odr.user.api.DataStatisticsCourtApi;
import com.beiming.odr.user.api.DictionaryServiceApi;
import com.beiming.odr.user.api.dto.DictionaryInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.DictionaryReqDTO;
import com.beiming.odr.user.api.dto.responsedto.DictionaryResDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    @Resource
    private DataStatisticsCourtApi dataStatisticsCourtApi;
    @Resource
    DictionaryServiceApi dictionaryServiceApi;

    @Override
    public LoginInfoResDTO userLoginInfo(Long userId) {
        DubboResult result = this.dataStatisticsCourtApi.userLoginInfo(userId.toString());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (LoginInfoResDTO)result.getData();
    }

    @Override
    public boolean isShowInnerCase(Long orgId, Long userId) {
        String type = this.dictionaryServiceApi.getUserRole(userId);
        if ("JUROR".equals(type)) {
            return false;
        }
        DictionaryReqDTO req = new DictionaryReqDTO();
        req.setParentCode("TDH_WEBSERVICE_URL");
        DubboResult dictionaryInfo = this.dictionaryServiceApi.searchDictionaryInfo(req);
        if (Objects.isNull(dictionaryInfo)) {
            return false;
        }
        List list = ((DictionaryResDTO)dictionaryInfo.getData()).getData();
        Optional<DictionaryInfoDTO> dictionary = list.stream().filter(dic -> StringUtils.isNotBlank((CharSequence)dic.getImgUrl()) && dic.getImgUrl().contains(String.format(",%s,", orgId))).findFirst();
        return dictionary.isPresent();
    }
}

