/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.statistics.service.util;

import com.beiming.odr.peace.domain.dto.ExcelInfoDTO;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelExportUtil.class);

    public static HSSFWorkbook getHSSFWorkbook(String sheetName, String[] title, String[][] values) {
        int i;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        HSSFCell cell = null;
        cell = row.createCell(0);
        cell.setCellValue(sheetName);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, title.length - 1));
        cell.setCellStyle(style);
        System.out.println(title.length);
        row = sheet.createRow(1);
        for (i = 0; i < title.length; ++i) {
            cell = row.createCell(i);
            cell.setCellValue(title[i]);
            cell.setCellStyle(style);
        }
        for (i = 0; i < values.length; ++i) {
            row = sheet.createRow(i + 2);
            for (int j = 0; j < values[i].length; ++j) {
                row.createCell(j).setCellValue(values[i][j]);
            }
        }
        return wb;
    }

    public static HSSFWorkbook getHSSFWorkbook(String sheetName, String[] title, List<Object> excelContent) {
        int i;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setBold(true);
        style.setFont(font);
        HSSFCell cell = null;
        cell = row.createCell(0);
        cell.setCellValue(sheetName);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, title.length - 1));
        cell.setCellStyle(style);
        row = sheet.createRow(1);
        for (i = 0; i < title.length; ++i) {
            cell = row.createCell(i);
            cell.setCellValue(title[i]);
            cell.setCellStyle(style);
        }
        for (i = 0; i < excelContent.size(); ++i) {
            int j;
            List values = (List)excelContent.get(i);
            for (j = 0; j < values.size(); ++j) {
                if (values.get(j) == null || values.get(j).toString().length() <= 10) continue;
                sheet.setColumnWidth(j, 252 * values.get(j).toString().length() + 323);
            }
            row = sheet.createRow(i + 2);
            if (values == null || values.size() <= 0) continue;
            for (j = 0; j < values.size(); ++j) {
                String data = " ";
                if (values.get(j) != null) {
                    data = values.get(j).toString();
                }
                row.createCell(j).setCellValue(data);
                if (data.length() <= 30) continue;
                HSSFCellStyle cellStyle = wb.createCellStyle();
                cellStyle.setWrapText(true);
                row.getCell(j).setCellStyle(cellStyle);
            }
        }
        return wb;
    }

    public static HSSFWorkbook getHSSFWorkbookSheets(List<ExcelInfoDTO> excelInfoList) {
        HSSFWorkbook wb = new HSSFWorkbook();
        for (ExcelInfoDTO excelInfoDTO : excelInfoList) {
            String sheetName = excelInfoDTO.getExcelName();
            List titleMap = excelInfoDTO.getTitleMap();
            List excelContent = excelInfoDTO.getExcelContent();
            String[] title = new String[titleMap.size()];
            for (int i = 0; i < titleMap.size(); ++i) {
                title[i] = ((String)titleMap.get(i)).toString();
            }
            ExcelExportUtil.getHSSFWorkbookSheet(wb, sheetName, title, excelContent);
        }
        return wb;
    }

    public static HSSFWorkbook getHSSFWorkbookSheet(HSSFWorkbook wb, String sheetName, String[] title, List<Object> excelContent) {
        int i;
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setBold(true);
        style.setFont(font);
        HSSFCell cell = null;
        cell = row.createCell(0);
        cell.setCellValue(sheetName);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, title.length - 1));
        cell.setCellStyle(style);
        row = sheet.createRow(1);
        for (i = 0; i < title.length; ++i) {
            cell = row.createCell(i);
            cell.setCellValue(title[i]);
            cell.setCellStyle(style);
        }
        for (i = 0; i < excelContent.size(); ++i) {
            int j;
            List values = (List)excelContent.get(i);
            for (j = 0; j < values.size(); ++j) {
                if (values.get(j) == null || values.get(j).toString().length() <= 10) continue;
                sheet.setColumnWidth(j, 252 * values.get(j).toString().length() + 323);
            }
            row = sheet.createRow(i + 2);
            if (values == null || values.size() <= 0) continue;
            log.info("\u4fe1\u606f\uff1a{}", (Object)values);
            for (j = 0; j < values.size(); ++j) {
                String data = " ";
                if (values.get(j) != null) {
                    data = values.get(j).toString();
                }
                row.createCell(j).setCellValue(data);
                if (data.length() <= 30) continue;
                HSSFCellStyle cellStyle = wb.createCellStyle();
                cellStyle.setWrapText(true);
                row.getCell(j).setCellStyle(cellStyle);
            }
        }
        return wb;
    }
}

