/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.statistics.config;

import com.beiming.framework.log.PlatformFilter;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.Sampler;
import com.github.kristofa.brave.SpanCollector;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

@Configuration
@ImportResource(value={"classpath:spring-web.xml"})
public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);

    @Bean
    public FilterRegistrationBean filterRegistration() {
        log.info("init filter......");
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter(this.getPlatformFilter());
        registration.addUrlPatterns(new String[]{"/dataStatistics/*"});
        registration.setName("platformFilter");
        return registration;
    }

    @Bean(name={"platformFilter"})
    public Filter getPlatformFilter() {
        return new PlatformFilter();
    }

    @Bean
    public Brave brave(SpanCollector spanCollector) {
        Brave.Builder builder = new Brave.Builder("peace-statistics");
        builder.spanCollector(spanCollector);
        builder.traceSampler(Sampler.create((float)1.0f));
        return builder.build();
    }
}

