/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.statistics.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.domain.dto.requestdto.DataStatisticsRequestDto;
import com.beiming.odr.peace.domain.dto.responsedto.LoginTokenResponseDTO;
import com.beiming.odr.peace.statistics.common.enums.ErrorCode;
import com.beiming.odr.peace.statistics.service.DataStatisticsService;
import com.beiming.odr.peace.statistics.service.UserService;
import com.beiming.odr.referee.dto.responsedto.CourtDurationResponseDTO;
import com.beiming.odr.referee.dto.responsedto.CourtNumResponseDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="\u798f\u5efa\u5f00\u5ead\u6570\u636e\u7edf\u8ba1", tags={"\u798f\u5efa\u5f00\u5ead\u6570\u636e\u7edf\u8ba1"})
@RequestMapping(value={"/dataStatistics"})
public class DataStatisticsController {
    @Resource
    private DataStatisticsService dataStatisticsService;
    @Resource
    private UserService userService;

    @RequestMapping(value={"numOfCourtSessions"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5f00\u5ead\u6b21\u6570", notes="\u5f00\u5ead\u6b21\u6570")
    public APIResult numOfCourtSessions(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) {
        if (!this.dataStatisticsService.getUserAuth(dataStatisticsRequestDto.getUserId(), dataStatisticsRequestDto.getOrgId())) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ACCESS_DENIED, (String)APIResultCodeEnums.ACCESS_DENIED.desc());
        }
        try {
            CourtNumResponseDTO map = this.dataStatisticsService.getNumOfCourtSessions(dataStatisticsRequestDto);
            return APIResult.success((Object)map);
        }
        catch (Exception e) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6570\u636e\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"courtNumList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6cd5\u9662\u5f00\u5ead\u6b21\u6570\u5217\u8868", notes="\u6cd5\u9662\u5f00\u5ead\u6b21\u6570\u5217\u8868")
    public APIResult getCourtNumList(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        if (!this.dataStatisticsService.getUserAuth(dataStatisticsRequestDto.getUserId(), dataStatisticsRequestDto.getOrgId())) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ACCESS_DENIED, (String)APIResultCodeEnums.ACCESS_DENIED.desc());
        }
        List list = this.dataStatisticsService.getCourtNumList(dataStatisticsRequestDto);
        return APIResult.success((Object)list);
    }

    @RequestMapping(value={"courtsNum"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6cd5\u9662\u5f00\u5ead\u6b21\u6570", notes="\u6cd5\u9662\u5f00\u5ead\u6b21\u6570")
    public APIResult getCourtsNum(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) {
        if (!this.dataStatisticsService.getUserAuth(dataStatisticsRequestDto.getUserId(), dataStatisticsRequestDto.getOrgId())) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ACCESS_DENIED, (String)APIResultCodeEnums.ACCESS_DENIED.desc());
        }
        try {
            CourtNumResponseDTO map = this.dataStatisticsService.getCourtsNum(dataStatisticsRequestDto);
            return APIResult.success((Object)map);
        }
        catch (Exception e) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6570\u636e\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"courtDuration"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6cd5\u9662\u5f00\u5ead\u65f6\u957f", notes="\u6cd5\u9662\u5f00\u5ead\u65f6\u957f")
    public APIResult getCourtDuration(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) {
        if (!this.dataStatisticsService.getUserAuth(dataStatisticsRequestDto.getUserId(), dataStatisticsRequestDto.getOrgId())) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ACCESS_DENIED, (String)APIResultCodeEnums.ACCESS_DENIED.desc());
        }
        try {
            CourtDurationResponseDTO map = this.dataStatisticsService.getCourtDuration(dataStatisticsRequestDto);
            return APIResult.success((Object)map);
        }
        catch (Exception e) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6570\u636e\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"judgeCourtNumList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6cd5\u5b98\u5f00\u5ead\u5217\u8868", notes="\u6cd5\u5b98\u5f00\u5ead\u5217\u8868")
    public APIResult getJudgeCourtNumList(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) {
        if (!this.dataStatisticsService.getUserAuth(dataStatisticsRequestDto.getUserId(), dataStatisticsRequestDto.getOrgId())) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ACCESS_DENIED, (String)APIResultCodeEnums.ACCESS_DENIED.desc());
        }
        try {
            List list = this.dataStatisticsService.getJudgeCourtNumList(dataStatisticsRequestDto);
            return APIResult.success((Object)list);
        }
        catch (Exception e) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6570\u636e\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"courtMeetingList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5ead\u5ba1\u6570\u636e\u5217\u8868", notes="\u5ead\u5ba1\u6570\u636e\u5217\u8868")
    public APIResult getCourtMeetingList(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) {
        if (!this.dataStatisticsService.getUserAuth(dataStatisticsRequestDto.getUserId(), dataStatisticsRequestDto.getOrgId())) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ACCESS_DENIED, (String)APIResultCodeEnums.ACCESS_DENIED.desc());
        }
        try {
            PageInfo list = this.dataStatisticsService.getCourtMeetingList(dataStatisticsRequestDto);
            return APIResult.success((Object)list);
        }
        catch (Exception e) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6570\u636e\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"dataStatisticsExport"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6570\u636e\u7edf\u8ba1\u7ed3\u679c\u5bfc\u51fa", notes="\u6570\u636e\u7edf\u8ba1\u7ed3\u679c\u5bfc\u51fa")
    public void dataStatisticsExport(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto, HttpServletRequest request, HttpServletResponse response) throws IOException, GeneralSecurityException, ParseException {
        if (this.dataStatisticsService.getUserAuth(dataStatisticsRequestDto.getUserId(), dataStatisticsRequestDto.getOrgId())) {
            this.dataStatisticsService.dataStatisticsExport(dataStatisticsRequestDto, request, response);
        }
    }

    @RequestMapping(value={"getCourtsList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u83b7\u53d6\u6cd5\u9662", notes="\u67e5\u8be2\u83b7\u53d6\u6cd5\u9662")
    public APIResult getCourtsList(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) {
        try {
            ArrayList courtList = this.dataStatisticsService.getCourtsList(dataStatisticsRequestDto);
            return APIResult.success((Object)courtList);
        }
        catch (Exception e) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6570\u636e\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"getUserLogin"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7528\u6237\u767b\u5f55")
    public LoginTokenResponseDTO userLoginByMobile(HttpServletRequest request) {
        LoginTokenResponseDTO responseDTO = new LoginTokenResponseDTO();
        if (request.getHeader("JWTToken") != null) {
            String authToken = request.getHeader("JWTToken");
            Long userId = Long.parseLong(JWTContextUtil.getCurrentUserId());
            LoginInfoResDTO loginInfoResDTO = this.userService.userLoginInfo(userId);
            responseDTO.setLoginInfo(loginInfoResDTO);
            responseDTO.setAuthToken(authToken);
            responseDTO.setMediationInfoDTO(null);
            return responseDTO;
        }
        AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.USER_NOT_LOGIN, (String)ErrorCode.USER_NOT_LOGIN.desc());
        return responseDTO;
    }
}

