/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.statistics.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.odr.peace.domain.dto.requestdto.DataStatisticsRequestDto;
import com.beiming.odr.peace.domain.dto.responsedto.CaseTypeNumResDTO;
import com.beiming.odr.peace.domain.dto.responsedto.CourtNumByDayResponseDTO;
import com.beiming.odr.peace.statistics.service.ExcelDataService;
import com.beiming.odr.peace.statistics.service.HuBeiDataStatisticsService;
import com.beiming.odr.referee.dto.requestdto.DurationStatisticsRequestDto;
import com.beiming.odr.referee.dto.responsedto.CourtDurationResponseDTO;
import com.beiming.odr.referee.dto.responsedto.CourtNumResponseDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingTypeNumResDTO;
import com.beiming.odr.referee.dto.responsedto.SourceCountResDTO;
import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="\u6e56\u5317\u5f00\u5ead\u6570\u636e\u7edf\u8ba1", tags={"\u6e56\u5317\u5f00\u5ead\u6570\u636e\u7edf\u8ba1"})
@RequestMapping(value={"/dataStatistics/hubei"})
public class HuBeiDataStatisticsController {
    private static final Logger log = LoggerFactory.getLogger(HuBeiDataStatisticsController.class);
    @Resource
    private HuBeiDataStatisticsService huBeiDataStatisticsService;
    @Resource
    private ExcelDataService excelDataService;

    @RequestMapping(value={"courtRoomData"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5ead\u5ba4\u6570\u636e", notes="\u5ead\u5ba4\u6570\u636e")
    public APIResult courtRoomData(@RequestBody @Valid DataStatisticsRequestDto courtRoomRequestDto) {
        try {
            List map = this.huBeiDataStatisticsService.getCourtRoomData(courtRoomRequestDto);
            return APIResult.success((Object)map);
        }
        catch (Exception e) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6570\u636e\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"courtRoomPersonData"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5ead\u5ba4\u4eba\u5458\u6570\u636e", notes="\u5ead\u5ba4\u4eba\u5458\u6570\u636e")
    public APIResult courtRoomPersonData(@RequestBody @Valid DataStatisticsRequestDto courtRoomPersonRequestDto) {
        try {
            List map = this.huBeiDataStatisticsService.getCourtRoomPersonData(courtRoomPersonRequestDto);
            return APIResult.success((Object)map);
        }
        catch (Exception e) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6570\u636e\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"provinceMapData"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5168\u7701\u5730\u56fe", notes="\u5168\u7701\u5730\u56fe")
    public APIResult provinceMapData(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) {
        try {
            List map = this.huBeiDataStatisticsService.getProvinceMapData(dataStatisticsRequestDto);
            return APIResult.success((Object)map);
        }
        catch (Exception e) {
            e.printStackTrace();
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6570\u636e\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"numOfCourtSessions"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6570\u636e\u6982\u89c8\uff08\u5f00\u5ead\u6b21\u6570\uff09", notes="\u6570\u636e\u6982\u89c8\uff08\u5f00\u5ead\u6b21\u6570\uff09")
    public APIResult numOfCourtSessions(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) {
        try {
            CourtNumResponseDTO map = this.huBeiDataStatisticsService.getNumOfCourtSessions(dataStatisticsRequestDto);
            return APIResult.success((Object)map);
        }
        catch (Exception e) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6570\u636e\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"courtNumList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6570\u636e\u6982\u89c8", notes="\u6570\u636e\u6982\u89c8")
    public APIResult getCourtNumList(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        List list = this.huBeiDataStatisticsService.getCourtNumList(dataStatisticsRequestDto);
        return APIResult.success((Object)list);
    }

    @RequestMapping(value={"meetingCountByDay"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5f00\u5ead\u8d8b\u52bf", notes="\u5f00\u5ead\u8d8b\u52bf")
    public APIResult meetingCountByDay(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        ArrayList<CourtNumByDayResponseDTO> result = new ArrayList<CourtNumByDayResponseDTO>();
        Map map = this.huBeiDataStatisticsService.meetingCountByDay(dataStatisticsRequestDto);
        for (Map.Entry entry : map.entrySet()) {
            CourtNumByDayResponseDTO courtNumByDayResponse = new CourtNumByDayResponseDTO();
            courtNumByDayResponse.setOpenNum(Integer.valueOf(Integer.parseInt(entry.getValue().toString())));
            courtNumByDayResponse.setTime((String)entry.getKey());
            result.add(courtNumByDayResponse);
        }
        return APIResult.success(result);
    }

    @RequestMapping(value={"meetingTypeNum"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6848\u4ef6\u7c7b\u578b", notes="\u6848\u4ef6\u7c7b\u578b")
    public APIResult meetingTypeNum(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        Map map = this.huBeiDataStatisticsService.getMeetingTypeNum(dataStatisticsRequestDto);
        ArrayList<CaseTypeNumResDTO> result = new ArrayList<CaseTypeNumResDTO>();
        List msaj = (List)map.get("msaj");
        List xsaj = (List)map.get("xsaj");
        List xzaj = (List)map.get("xzaj");
        CaseTypeNumResDTO ms = new CaseTypeNumResDTO();
        for (Object meetingTypeNumRes : msaj) {
            ms.setCaseType(meetingTypeNumRes.getMeetingType());
            if ("\u7b2c\u4e00\u5ba1\u7a0b\u5e8f".equals(meetingTypeNumRes.getMeetingTypeInfo())) {
                ms.setFirstCase(meetingTypeNumRes.getMeetingNum());
            }
            if ("\u7b2c\u4e8c\u5ba1\u7a0b\u5e8f".equals(meetingTypeNumRes.getMeetingTypeInfo())) {
                ms.setMonitorCase(meetingTypeNumRes.getMeetingNum());
            }
            if (!"\u5ba1\u5224\u76d1\u7763\u7a0b\u5e8f".equals(meetingTypeNumRes.getMeetingTypeInfo())) continue;
            ms.setSecondCase(meetingTypeNumRes.getMeetingNum());
        }
        result.add(ms);
        CaseTypeNumResDTO xs = new CaseTypeNumResDTO();
        for (MeetingTypeNumResDTO meetingTypeNumRes : xsaj) {
            xs.setCaseType(meetingTypeNumRes.getMeetingType());
            if ("\u7b2c\u4e00\u5ba1\u7a0b\u5e8f".equals(meetingTypeNumRes.getMeetingTypeInfo())) {
                xs.setFirstCase(meetingTypeNumRes.getMeetingNum());
            }
            if ("\u7b2c\u4e8c\u5ba1\u7a0b\u5e8f".equals(meetingTypeNumRes.getMeetingTypeInfo())) {
                xs.setMonitorCase(meetingTypeNumRes.getMeetingNum());
            }
            if (!"\u5ba1\u5224\u76d1\u7763\u7a0b\u5e8f".equals(meetingTypeNumRes.getMeetingTypeInfo())) continue;
            xs.setSecondCase(meetingTypeNumRes.getMeetingNum());
        }
        result.add(xs);
        CaseTypeNumResDTO xz = new CaseTypeNumResDTO();
        for (MeetingTypeNumResDTO meetingTypeNumRes : xzaj) {
            xz.setCaseType(meetingTypeNumRes.getMeetingType());
            if ("\u7b2c\u4e00\u5ba1\u7a0b\u5e8f".equals(meetingTypeNumRes.getMeetingTypeInfo())) {
                xz.setFirstCase(meetingTypeNumRes.getMeetingNum());
            }
            if ("\u7b2c\u4e8c\u5ba1\u7a0b\u5e8f".equals(meetingTypeNumRes.getMeetingTypeInfo())) {
                xz.setMonitorCase(meetingTypeNumRes.getMeetingNum());
            }
            if (!"\u5ba1\u5224\u76d1\u7763\u7a0b\u5e8f".equals(meetingTypeNumRes.getMeetingTypeInfo())) continue;
            xz.setSecondCase(meetingTypeNumRes.getMeetingNum());
        }
        result.add(xz);
        return APIResult.success(result);
    }

    @RequestMapping(value={"causeNumList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6848\u7531\u5360\u6bd4", notes="\u6848\u7531\u5360\u6bd4")
    public APIResult causeNumList(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        List list = this.huBeiDataStatisticsService.getCauseNumList(dataStatisticsRequestDto);
        return APIResult.success((Object)list);
    }

    @RequestMapping(value={"sourceNum"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6848\u4ef6\u6765\u6e90", notes="\u6848\u4ef6\u6765\u6e90")
    public APIResult sourceNum(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        SourceCountResDTO data = this.huBeiDataStatisticsService.getSourceNum(dataStatisticsRequestDto);
        return APIResult.success((Object)data);
    }

    @RequestMapping(value={"meetingInitNumList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5f85\u5f00\u5ead\u6848\u4ef6", notes="\u5f85\u5f00\u5ead\u6848\u4ef6")
    public APIResult meetingInitNumList(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        Map map = this.huBeiDataStatisticsService.meetingInitNumList(dataStatisticsRequestDto);
        return APIResult.success((Object)map);
    }

    @RequestMapping(value={"meetingScheduleNumList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5f85\u6392\u671f\u6848\u4ef6", notes="\u5f85\u6392\u671f\u6848\u4ef6")
    public APIResult meetingScheduleNumList(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        PageInfo list = this.huBeiDataStatisticsService.meetingScheduleNumList(dataStatisticsRequestDto);
        return APIResult.success((Object)list);
    }

    @RequestMapping(value={"courtsNum"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6cd5\u9662\u5f00\u5ead\u6b21\u6570", notes="\u6cd5\u9662\u5f00\u5ead\u6b21\u6570")
    public APIResult getCourtsNum(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) {
        try {
            CourtNumResponseDTO map = this.huBeiDataStatisticsService.getCourtsNum(dataStatisticsRequestDto);
            return APIResult.success((Object)map);
        }
        catch (Exception e) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6570\u636e\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"courtDuration"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6cd5\u9662\u5f00\u5ead\u65f6\u957f", notes="\u6cd5\u9662\u5f00\u5ead\u65f6\u957f")
    public APIResult getCourtDuration(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) {
        try {
            CourtDurationResponseDTO map = this.huBeiDataStatisticsService.getCourtDuration(dataStatisticsRequestDto);
            return APIResult.success((Object)map);
        }
        catch (Exception e) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6570\u636e\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"judgeCourtNumList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6cd5\u5b98\u5f00\u5ead\u5217\u8868", notes="\u6cd5\u5b98\u5f00\u5ead\u5217\u8868")
    public APIResult getJudgeCourtNumList(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) {
        try {
            List list = this.huBeiDataStatisticsService.getJudgeCourtNumList(dataStatisticsRequestDto);
            return APIResult.success((Object)list);
        }
        catch (Exception e) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6570\u636e\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"getCourtroomNum"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5ead\u5ba4\u6570\u636e", notes="\u5ead\u5ba4\u6570\u636e")
    public APIResult getCourtroomNum(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        this.huBeiDataStatisticsService.getCourtroomNum(dataStatisticsRequestDto);
        return APIResult.success();
    }

    @RequestMapping(value={"courtMeetingList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5ead\u5ba1\u6570\u636e\u5217\u8868", notes="\u5ead\u5ba1\u6570\u636e\u5217\u8868")
    public APIResult getCourtMeetingList(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) {
        try {
            PageInfo list = this.huBeiDataStatisticsService.getCourtMeetingList(dataStatisticsRequestDto);
            return APIResult.success((Object)list);
        }
        catch (Exception e) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6570\u636e\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"getCourtUserNum"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6cd5\u9662\u4eba\u5458", notes="\u6cd5\u9662\u4eba\u5458")
    public APIResult getCourtUserNum(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        List userNumList = this.huBeiDataStatisticsService.getCourtUserNum(dataStatisticsRequestDto);
        return APIResult.success((Object)userNumList);
    }

    @RequestMapping(value={"getCourtroomUserNum"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5ead\u5ba4\u4eba\u5458", notes="\u5ead\u5ba4\u4eba\u5458")
    public APIResult getCourtroomUserNum(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) throws ParseException {
        this.huBeiDataStatisticsService.getCourtroomUserNum(dataStatisticsRequestDto);
        return APIResult.success();
    }

    @RequestMapping(value={"dataStatisticsExport"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6570\u636e\u7edf\u8ba1\u7ed3\u679c\u5bfc\u51fa", notes="\u6570\u636e\u7edf\u8ba1\u7ed3\u679c\u5bfc\u51fa")
    public void dataStatisticsExport(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.excelDataService.dataStatisticsExport(dataStatisticsRequestDto, request, response);
    }

    @RequestMapping(value={"/trialDurationStatistics"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5f00\u5ead\u65f6\u957f\u7edf\u8ba1", notes="\u5f00\u5ead\u65f6\u957f\u7edf\u8ba1")
    public APIResult trialDurationStatistics(@RequestBody @Valid DurationStatisticsRequestDto dto) {
        List roles = JWTContextUtil.getRoles();
        dto.setCurrentUserId(JWTContextUtil.getCurrentUserId());
        log.info("trialDurationStatistics roles is:\u67e5\u8be2\u5f00\u5ead\u65f6\u957f\u7684\u7528\u6237\u89d2\u8272:" + roles);
        if (roles.contains(RoleTypeEnum.SUPER_ADMIN.name())) {
            dto.setAuthorityLevel("1");
        } else if (roles.contains(RoleTypeEnum.ORG_MANAGE.name())) {
            dto.setAuthorityLevel("2");
        } else {
            dto.setAuthorityLevel("3");
        }
        PageInfo list = this.huBeiDataStatisticsService.trialDurationStatistics(dto);
        return APIResult.success((Object)list);
    }

    @RequestMapping(value={"/exportTrialDuration"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5f00\u5ead\u65f6\u957f\u7edf\u8ba1\u5bfc\u51fa", notes="\u5f00\u5ead\u65f6\u957f\u7edf\u8ba1\u5bfc\u51fa")
    public void exportTrialDuration(@RequestBody DurationStatisticsRequestDto dto, HttpServletRequest request, HttpServletResponse response) {
        List roles = JWTContextUtil.getRoles();
        dto.setCurrentUserId(JWTContextUtil.getCurrentUserId());
        log.info("trialDurationStatistics roles is:\u67e5\u8be2\u5f00\u5ead\u65f6\u957f\u7684\u7528\u6237\u89d2\u8272:" + roles);
        if (roles.contains(RoleTypeEnum.SUPER_ADMIN.name())) {
            dto.setAuthorityLevel("1");
        } else if (roles.contains(RoleTypeEnum.ORG_MANAGE.name())) {
            dto.setAuthorityLevel("2");
        } else {
            dto.setAuthorityLevel("3");
        }
        try {
            this.huBeiDataStatisticsService.meetingDataExport(dto, request, response);
        }
        catch (Exception e) {
            log.info("trialDurationStatistics error is:{}", (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/courtDurationList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5f00\u5ead\u603b\u65f6\u957f\u5206\u5e03\u60c5\u51b5", notes="\u5f00\u5ead\u603b\u65f6\u957f\u5206\u5e03\u60c5\u51b5")
    public APIResult courtDurationList(@RequestBody @Valid DataStatisticsRequestDto dataStatisticsRequestDto) {
        try {
            return APIResult.success((Object)this.huBeiDataStatisticsService.listCourtTimeByOrgId(dataStatisticsRequestDto));
        }
        catch (Exception e) {
            e.printStackTrace();
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)e.getMessage());
        }
    }
}

