/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.MyHttpClientUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.utils.HttpClientResult;
import com.beiming.odr.peace.common.utils.HttpClientUtil;
import com.beiming.odr.peace.common.utils.RSAUtil;
import com.beiming.odr.peace.common.utils.sm4.SM4Utils;
import com.beiming.odr.peace.domain.dto.LoginMediationRoomInfoDTO;
import com.beiming.odr.peace.domain.dto.RedisMediationRoomInfoDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AllInOneUserLogin;
import com.beiming.odr.peace.domain.dto.requestdto.AuthenticationReuestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CheckValidCodeRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonUserLoginByMobileRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonUserResetPasswordRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.GMDto;
import com.beiming.odr.peace.domain.dto.requestdto.GetMobilePhoneByCodeRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LoginEWMRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.RealNameAuthenticationRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.RefreshTokenRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SMSCodeRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SendMessageRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UpdatePwdReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UserLoginByAppIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UserLoginByMicroCourtRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UserLoginBySxMicroCourtRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UserLoginNotPasswordRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.CommonUserInfoResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.LoginTokenResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.RefreshTokenResponseDTO;
import com.beiming.odr.peace.security.TokenGenerator;
import com.beiming.odr.peace.service.UserService;
import com.beiming.odr.peace.service.backend.user.VerificationCodeService;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.peace.service.util.Base64Utils;
import com.beiming.odr.peace.service.util.LoginErrorCountUtil;
import com.beiming.odr.peace.service.util.Md5Utils;
import com.beiming.odr.peace.service.util.RSACoderUtil;
import com.beiming.odr.peace.util.GMCertUtil;
import com.beiming.odr.user.api.DictionaryServiceApi;
import com.beiming.odr.user.api.common.enums.UserLoginNotPasswordEnum;
import com.beiming.odr.user.api.common.enums.UserLoginTypeEnum;
import com.beiming.odr.user.api.common.utils.CommonPasswordValidateUtil;
import com.beiming.odr.user.api.dto.DictionaryInfoDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.DictionaryReqDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.mortbay.log.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="\u7528\u6237", tags={"\u7528\u6237"})
@RequestMapping(value={"/peace/user"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    @Resource
    private UserService userService;
    @Resource
    private TokenGenerator tokenGenerator;
    @Autowired
    private RedisService redisService;
    @Resource
    private RSACoderUtil rsaCoderUtil;
    @Resource
    private LoginErrorCountUtil loginErrorCountUtil;
    @Resource
    private VerificationCodeService verificationCodeService;
    @Resource
    private DictionaryServiceApi dictionaryServiceApi;
    private static final String URL = "https://uasp.odrcloud.cn/uasp";
    private static final String PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCRnIjhXaIwPynguW3253X7W04BK9ck0TizTSt+OXHDCKEPbHOr8fqjg6CBQmQz1rteGJ1Aqk0Hw3PXoi5QRb+XGpMktEsP99RMb1JMyrZbP2hoGiMbgHtokBqDIfDFOmT5VimiXf+SJv9DnDYML2YPayMdtG40jUZjXayIcwNT2wIDAQAB";
    @Value(value="${hainan.mp.agwUrl}")
    private String agwUrl;
    public static long timeout = 10L;
    public static TimeUnit unit = TimeUnit.MINUTES;

    @RequestMapping(value={"getSMSCode"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u77ed\u4fe1\u9a8c\u8bc1\u7801", notes="\u83b7\u53d6\u77ed\u4fe1\u9a8c\u8bc1\u7801")
    public void getSMSCode(@RequestBody @Valid SMSCodeRequestDTO smsCodeRequestDTO) {
        this.userService.getSMSCode(smsCodeRequestDTO);
    }

    @RequestMapping(value={"checkValidCode"}, method={RequestMethod.POST})
    @ApiOperation(value="\u9a8c\u8bc1\u624b\u673a\u9a8c\u8bc1\u7801\u662f\u5426\u6b63\u786e", notes="\u9a8c\u8bc1\u624b\u673a\u9a8c\u8bc1\u7801\u662f\u5426\u6b63\u786e")
    public void checkValidCode(@RequestBody @Valid CheckValidCodeRequestDTO checkValidCodeRequestDTO) {
        this.userService.checkValidCode(checkValidCodeRequestDTO);
    }

    @RequestMapping(value={"delUserLoginError"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6e05\u9664\u7528\u6237\u767b\u5f55\u9519\u8bef\u8bb0\u5f55", notes="\u6e05\u9664\u7528\u6237\u767b\u5f55\u9519\u8bef\u8bb0\u5f55")
    public void delUserLoginError(@RequestBody @Valid CommonUserLoginByMobileRequestDTO requestDTO) {
        this.loginErrorCountUtil.deleteUserLoginErrorCount(requestDTO.getMobilePhone(), requestDTO.getLoginType().name());
    }

    @RequestMapping(value={"validateCertGenRandom"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6821\u9a8c\u8bc1\u4e66\u5e76\u751f\u6210\u968f\u673a\u6570")
    public APIResult validateCertGenRandom(GMDto gmDto, HttpServletRequest req, HttpServletResponse res) {
        GMCertUtil gmcu = new GMCertUtil();
        Map map = gmcu.validateCertGenRandom(this.agwUrl, gmDto.getUserSignCertB64(), gmDto.getContainer(), req, res);
        return APIResult.success((Object)map);
    }

    @RequestMapping(value={"userLoginByCert"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7528\u6237\u767b\u5f55\u901a\u8fc7\u8bc1\u4e66")
    public APIResult userLoginByCert(@RequestBody @Valid CommonUserLoginByMobileRequestDTO requestDTO, HttpServletRequest request, HttpServletResponse res) {
        try {
            GMCertUtil gmcu = new GMCertUtil();
            Map map = gmcu.verifySignedDataGetCertInfo(this.agwUrl, requestDTO.getSignedDataB64(), requestDTO.getUserSignCert(), requestDTO.getRandomData(), request, res);
            String certSn = map.get("sn").toString();
            requestDTO.setPassword(Base64Utils.decodeBase64String((String)Base64Utils.decodeBase64String((String)requestDTO.getPassword())));
            LoginInfoResDTO loginInfoResDTO = this.userService.userLoginByCert(requestDTO.getMobilePhone(), certSn, requestDTO.getPassword(), requestDTO.getLoginType(), requestDTO.getPublicKey(), request.getHeader("deviceId"));
            LoginTokenResponseDTO responseDTO = this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), null);
            Long orgId = ((UserRoleInfoDTO)loginInfoResDTO.getUserRoles().get(0)).getOrganizationId();
            Long userId = loginInfoResDTO.getUserInfo().getUserId();
            responseDTO.setShowInnerCaseFlag(Boolean.valueOf(this.userService.isShowInnerCase(orgId, userId)));
            this.userService.checkAppNameAndProvinceCode(orgId);
            if (responseDTO != null) {
                this.checkLoginOk(requestDTO.getMobilePhone(), requestDTO.getLoginType().name());
            }
            responseDTO.setScreenLayout(this.userService.screenLayout(orgId));
            responseDTO.setIsStrong(Boolean.valueOf(true));
            JSONObject json = new JSONObject();
            json.put("token", (Object)responseDTO.getAuthToken());
            responseDTO.setAuthToken("");
            responseDTO.setRefreshToken("");
            String jsonString = JSON.toJSONString((Object)responseDTO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            JSON.toJSONString((Object)jsonString, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            json.put("info", (Object)SM4Utils.encryptDataCbc((String)jsonString));
            return APIResult.success((Object)json.toJSONString());
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)e.getMessage());
            return null;
        }
    }

    @RequestMapping(value={"userLoginByMobileNew"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7528\u6237\u767b\u5f55\u901a\u8fc7\u624b\u673a\u53f7\u7801")
    public APIResult userLoginByMobileNew(@RequestBody @Valid CommonUserLoginByMobileRequestDTO requestDTO, HttpServletRequest request) {
        this.checkLoginError(requestDTO.getMobilePhone(), requestDTO.getLoginType().name());
        try {
            requestDTO.setPassword(Base64Utils.decodeBase64String((String)Base64Utils.decodeBase64String((String)requestDTO.getPassword())));
            LoginInfoResDTO loginInfoResDTO = this.userService.userLogin(requestDTO.getMobilePhone(), null, requestDTO.getPassword(), requestDTO.getLoginType(), requestDTO.getPublicKey(), request.getHeader("deviceId"));
            Boolean isStrong = CommonPasswordValidateUtil.checkRegexFormatNew((String)requestDTO.getPassword(), (String)"\u8d26\u53f7\u6216\u5bc6\u7801\u4e0d\u6b63\u786e\uff01", (String)"^(?![a-zA-Z]+$)(?![A-Z0-9]+$)(?![A-Z\\W_!@#$%^&*`~()-+=]+$)(?![a-z0-9]+$)(?![a-z\\W_!@#$%^&*`~()-+=]+$)(?![0-9\\W_!@#$%^&*`~()-+=]+$)(?![a-zA-Z0-9]+$)(?![a-zA-Z\\W_!@#$%^&*`~()-+=]+$)(?![a-z0-9\\W_!@#$%^&*`~()-+=]+$)(?![0-9A-Z\\W_!@#$%^&*`~()-+=]+$)[a-zA-Z0-9\\W_!@#$%^&*`~()-+=]{8,16}$");
            LoginTokenResponseDTO responseDTO = this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), null);
            Long orgId = ((UserRoleInfoDTO)loginInfoResDTO.getUserRoles().get(0)).getOrganizationId();
            Long userId = loginInfoResDTO.getUserInfo().getUserId();
            responseDTO.setShowInnerCaseFlag(Boolean.valueOf(this.userService.isShowInnerCase(orgId, userId)));
            this.userService.checkAppNameAndProvinceCode(orgId);
            if (responseDTO != null) {
                this.checkLoginOk(requestDTO.getMobilePhone(), requestDTO.getLoginType().name());
            }
            responseDTO.setScreenLayout(this.userService.screenLayout(orgId));
            responseDTO.setIsStrong(isStrong);
            JSONObject json = new JSONObject();
            json.put("token", (Object)responseDTO.getAuthToken());
            responseDTO.setAuthToken("");
            responseDTO.setRefreshToken("");
            String jsonString = JSON.toJSONString((Object)responseDTO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            JSON.toJSONString((Object)jsonString, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            json.put("info", (Object)SM4Utils.encryptDataCbc((String)jsonString));
            return APIResult.success((Object)json.toJSONString());
        }
        catch (Exception e) {
            this.loginErrorCountUtil.saveUserLoginErrorCount(requestDTO.getMobilePhone(), requestDTO.getLoginType().name());
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)e.getMessage());
            return null;
        }
    }

    @RequestMapping(value={"userLoginByMobile"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7528\u6237\u767b\u5f55\u901a\u8fc7\u624b\u673a\u53f7\u7801")
    public LoginTokenResponseDTO userLoginByMobile(@RequestBody @Valid CommonUserLoginByMobileRequestDTO requestDTO, HttpServletRequest request) {
        this.checkLoginError(requestDTO.getMobilePhone(), requestDTO.getLoginType().name());
        try {
            requestDTO.setPassword(Base64Utils.decodeBase64String((String)Base64Utils.decodeBase64String((String)requestDTO.getPassword())));
            LoginInfoResDTO loginInfoResDTO = this.userService.userLogin(requestDTO.getMobilePhone(), null, requestDTO.getPassword(), requestDTO.getLoginType(), requestDTO.getPublicKey(), request.getHeader("deviceId"));
            Boolean isStrong = CommonPasswordValidateUtil.checkRegexFormatNew((String)requestDTO.getPassword(), (String)"\u5bc6\u7801\u5f3a\u5ea6\u4e0d\u591f", (String)"^(?![a-zA-Z]+$)(?![A-Z0-9]+$)(?![A-Z\\W_!@#$%^&*`~()-+=]+$)(?![a-z0-9]+$)(?![a-z\\W_!@#$%^&*`~()-+=]+$)(?![0-9\\W_!@#$%^&*`~()-+=]+$)(?![a-zA-Z0-9]+$)(?![a-zA-Z\\W_!@#$%^&*`~()-+=]+$)(?![a-z0-9\\W_!@#$%^&*`~()-+=]+$)(?![0-9A-Z\\W_!@#$%^&*`~()-+=]+$)[a-zA-Z0-9\\W_!@#$%^&*`~()-+=]{8,16}$");
            LoginTokenResponseDTO responseDTO = this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), null);
            Long orgId = ((UserRoleInfoDTO)loginInfoResDTO.getUserRoles().get(0)).getOrganizationId();
            Long userId = loginInfoResDTO.getUserInfo().getUserId();
            responseDTO.setShowInnerCaseFlag(Boolean.valueOf(this.userService.isShowInnerCase(orgId, userId)));
            this.userService.checkAppNameAndProvinceCode(orgId);
            if (responseDTO != null) {
                this.checkLoginOk(requestDTO.getMobilePhone(), requestDTO.getLoginType().name());
            }
            responseDTO.setScreenLayout(this.userService.screenLayout(orgId));
            responseDTO.setIsStrong(isStrong);
            return responseDTO;
        }
        catch (Exception e) {
            this.loginErrorCountUtil.saveUserLoginErrorCount(requestDTO.getMobilePhone(), requestDTO.getLoginType().name());
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)e.getMessage());
            return null;
        }
    }

    public void checkLoginError(String mobile, String loginType) {
        int count;
        String mobileBak = (String)this.redisService.get((RedisKey)RedisKeyEnums.USER_FIRST_LOGIN_ERROR, mobile + loginType);
        int n = count = this.redisService.get((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType) == null ? 0 : (Integer)this.redisService.get((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType);
        if (StringUtils.isNotEmpty((CharSequence)mobileBak) && count >= 5) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.POPUP_FIRST_ERROR_CODE, (String)"\u9519\u8bef\u8d85\u8fc75\u6b21\uff0c\u8bf712\u5c0f\u65f6\u540e\u91cd\u8bd5");
        }
    }

    public void checkLoginOk(String mobile, String loginType) {
        int count;
        String mobileBak = (String)this.redisService.get((RedisKey)RedisKeyEnums.USER_FIRST_LOGIN_ERROR, mobile + loginType);
        int n = count = this.redisService.get((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType) == null ? 0 : (Integer)this.redisService.get((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType);
        if (StringUtils.isNotEmpty((CharSequence)mobileBak) && count < 5) {
            this.loginErrorCountUtil.deleteUserLoginErrorCount(mobile, loginType);
        }
    }

    @RequestMapping(value={"refreshToken"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5237\u65b0token", notes="\u5237\u65b0token")
    public RefreshTokenResponseDTO refreshToken(@RequestBody RefreshTokenRequestDTO dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getRefreshToken())) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)APIResultCodeEnums.USER_NOT_LOGIN, (String)APIResultCodeEnums.USER_NOT_LOGIN.desc());
        }
        return this.tokenGenerator.refreshToken(dto.getRefreshToken());
    }

    @RequestMapping(value={"updatePwd"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801", notes="\u4fee\u6539\u5bc6\u7801")
    public APIResult updatePwd(@RequestBody @Valid UpdatePwdReqDTO dto) {
        String currentUserId = JWTContextUtil.getCurrentUserId();
        if (!currentUserId.equals(String.valueOf(dto.getUserId()))) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ACCESS_DENIED, (String)"\u4e0d\u80fd\u4fee\u6539\u4ed6\u4eba\u5bc6\u7801");
        }
        DubboResult result = this.userService.updatePassword(dto);
        return APIResult.success((Object)result.getData());
    }

    @RequestMapping(value={"resetUserPassWord"}, method={RequestMethod.POST})
    @ApiOperation(value="\u627e\u56de\u5bc6\u7801", notes="\u627e\u56de\u5bc6\u7801")
    public void resetUserPassWord(@RequestBody @Valid CommonUserResetPasswordRequestDTO commonUserResetPasswordDTO) {
        this.userService.resetUserPassword(commonUserResetPasswordDTO);
    }

    @RequestMapping(value={"setFacialVerify"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4eba\u8138\u8bc6\u522b\u901a\u8fc7", notes="\u4eba\u8138\u8bc6\u522b\u901a\u8fc7")
    public void setFacialVerify() {
        Long userId = Long.parseLong(JWTContextUtil.getCurrentUserId());
        this.userService.setFacialVerify(userId);
    }

    @RequestMapping(value={"setRealNameAuthentication"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5b9e\u540d\u8ba4\u8bc1", notes="\u5b9e\u540d\u8ba4\u8bc1")
    public void setRealNameAuthentication(@RequestBody @Valid RealNameAuthenticationRequestDTO realNameAuthenticationRequestDTO) {
        Long userId = Long.parseLong(JWTContextUtil.getCurrentUserId());
        this.userService.setRealNameAuthentication(userId, realNameAuthenticationRequestDTO);
    }

    @RequestMapping(value={"searchCommonUser"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u666e\u901a\u7528\u6237", notes="\u67e5\u8be2\u666e\u901a\u7528\u6237")
    public CommonUserInfoResponseDTO searchCommonUser() {
        Long userId = Long.parseLong(JWTContextUtil.getCurrentUserId());
        return this.userService.searchCommonUser(userId);
    }

    @RequestMapping(value={"getPublicKey"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u79d8\u94a5\u4fe1\u606f", notes="\u83b7\u53d6\u79d8\u94a5\u4fe1\u606f")
    public String getPublicKey() {
        return this.rsaCoderUtil.getRandomPublicKey();
    }

    @RequestMapping(value={"addPublicKey"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u79d8\u94a5\u4fe1\u606f", notes="\u83b7\u53d6\u79d8\u94a5\u4fe1\u606f")
    public APIResult addPublicKey() {
        this.rsaCoderUtil.initRSAKey(100);
        return APIResult.success();
    }

    @RequestMapping(value={"loginOut"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7528\u6237\u9000\u51fa\u767b\u5f55", notes="\u7528\u6237\u9000\u51fa\u767b\u5f55")
    public void loginOut(HttpServletRequest request) {
        this.tokenGenerator.loginOut(request.getHeader("JWTToken"));
    }

    @RequestMapping(value={"userLoginByCodeNew"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7528\u6237\u901a\u8fc7\u9a8c\u8bc1\u7801\u767b\u5f55", notes="\u7528\u6237\u901a\u8fc7\u9a8c\u8bc1\u7801\u767b\u5f55")
    public APIResult userLoginByCodeNew(HttpServletRequest request, @RequestBody @Valid UserLoginNotPasswordRequestDTO requestDTO) {
        String loginType = UserLoginTypeEnum.COMMON_USER_LOGIN_TYPE.name();
        String cType = request.getHeader("cType");
        String appName = AppNameContextHolder.getAppName();
        LoginInfoResDTO infoResDTO = this.userService.userLoginByMobileAndTypes(requestDTO.getMobilePhone(), requestDTO.getPersonType());
        if (infoResDTO == null) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u8be5\u624b\u673a\u53f7\u7801\u672a\u6ce8\u518c\uff01");
        }
        Boolean isexit = this.verificationCodeService.getIsExitPhoneAndCode(requestDTO.getMobilePhone(), requestDTO.getCode(), appName);
        try {
            AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)requestDTO.getCode()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            LoginMediationRoomInfoDTO loginMediationRoomInfo = this.verificationCodeService.getMediationRoomInfoByCode(requestDTO.getCode(), cType);
            RedisMediationRoomInfoDTO resultObj = loginMediationRoomInfo.getRedisMediationRoomInfo();
            AssertUtils.assertFalse((StringUtils.isBlank((CharSequence)resultObj.getMobilePhone()) || StringUtils.isNotBlank((CharSequence)requestDTO.getMobilePhone()) && resultObj.equals((Object)resultObj.getMobilePhone()) ? 1 : 0) != 0, (ResultCode)ErrorCode.ERROR_CODE, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
            requestDTO.setMobilePhone(resultObj.getMobilePhone());
            LoginInfoResDTO loginInfoResDTO = this.userService.userLoginNotPassword(requestDTO, UserLoginNotPasswordEnum.LOGIN_BY_CODE);
            LoginTokenResponseDTO loginTokenResponse = this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), resultObj);
            loginTokenResponse.setLoginMediationRoomInfo(loginMediationRoomInfo);
            JSONObject json = new JSONObject();
            json.put("token", (Object)loginTokenResponse.getAuthToken());
            loginTokenResponse.setAuthToken("");
            loginTokenResponse.setRefreshToken("");
            if ("weitingshenhubeizz".equals(appName)) {
                Long meetingId = loginTokenResponse.getMediationInfoDTO().getMediationRoomId();
                Long userId = loginTokenResponse.getLoginInfo().getUserInfo().getUserId();
                loginTokenResponse.setMeetingUserType(this.userService.getMeetingUserType(meetingId, userId));
            }
            String jsonString = JSON.toJSONString((Object)loginTokenResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            JSON.toJSONString((Object)jsonString, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            log.info("===============s=========================" + jsonString);
            json.put("info", (Object)SM4Utils.encryptDataCbc((String)jsonString));
            log.info(loginTokenResponse.toString());
            return APIResult.success((Object)json.toJSONString());
        }
        catch (AssertUtils.AssertionException e) {
            if (StringUtils.isNotBlank((CharSequence)requestDTO.getMobilePhone()) && ErrorCode.ERROR_CODE.getValue() == e.getResultCode().value()) {
                this.loginErrorCountUtil.saveUserLoginErrorCount(requestDTO.getMobilePhone(), loginType);
            }
            throw e;
        }
    }

    @RequestMapping(value={"userLoginByCode"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7528\u6237\u901a\u8fc7\u9a8c\u8bc1\u7801\u767b\u5f55", notes="\u7528\u6237\u901a\u8fc7\u9a8c\u8bc1\u7801\u767b\u5f55")
    public LoginTokenResponseDTO userLoginByCode(HttpServletRequest request, @RequestBody @Valid UserLoginNotPasswordRequestDTO requestDTO) {
        String loginType = UserLoginTypeEnum.COMMON_USER_LOGIN_TYPE.name();
        String cType = request.getHeader("cType");
        String appName = AppNameContextHolder.getAppName();
        LoginInfoResDTO infoResDTO = this.userService.userLoginByMobileAndTypes(requestDTO.getMobilePhone(), requestDTO.getPersonType());
        if (infoResDTO == null) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u8be5\u624b\u673a\u53f7\u7801\u672a\u6ce8\u518c\uff01");
        }
        Boolean isexit = this.verificationCodeService.getIsExitPhoneAndCode(requestDTO.getMobilePhone(), requestDTO.getCode(), appName);
        try {
            AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)requestDTO.getCode()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            LoginMediationRoomInfoDTO loginMediationRoomInfo = this.verificationCodeService.getMediationRoomInfoByCode(requestDTO.getCode(), cType);
            RedisMediationRoomInfoDTO resultObj = loginMediationRoomInfo.getRedisMediationRoomInfo();
            requestDTO.setMobilePhone(resultObj.getMobilePhone());
            LoginInfoResDTO loginInfoResDTO = this.userService.userLoginNotPassword(requestDTO, UserLoginNotPasswordEnum.LOGIN_BY_CODE);
            LoginTokenResponseDTO loginTokenResponse = this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), resultObj);
            loginTokenResponse.setLoginMediationRoomInfo(loginMediationRoomInfo);
            if ("weitingshenhubeizz".equals(appName)) {
                Long meetingId = loginTokenResponse.getMediationInfoDTO().getMediationRoomId();
                Long userId = loginTokenResponse.getLoginInfo().getUserInfo().getUserId();
                loginTokenResponse.setMeetingUserType(this.userService.getMeetingUserType(meetingId, userId));
            }
            return loginTokenResponse;
        }
        catch (AssertUtils.AssertionException e) {
            if (StringUtils.isNotBlank((CharSequence)requestDTO.getMobilePhone()) && ErrorCode.ERROR_CODE.getValue() == e.getResultCode().value()) {
                this.loginErrorCountUtil.saveUserLoginErrorCount(requestDTO.getMobilePhone(), loginType);
            }
            throw e;
        }
    }

    @RequestMapping(value={"userLoginByBindingWechat"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7528\u6237\u901a\u8fc7\u5fae\u4fe1\u7ed1\u5b9a\u767b\u5f55-\u7528\u6237\u9996\u6b21\u901a\u8fc7\u5fae\u4fe1\u767b\u5f55", notes="\u7528\u6237\u9996\u6b21\u901a\u8fc7\u5fae\u4fe1\u767b\u5f55")
    public LoginTokenResponseDTO userLoginByBindingWechat(HttpServletRequest request, @RequestBody @Valid UserLoginNotPasswordRequestDTO requestDTO) {
        LoginInfoResDTO loginInfoResDTO = this.userService.userLoginNotPassword(requestDTO, UserLoginNotPasswordEnum.LOGIN_BY_WECHAT_FIRST);
        return this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), null);
    }

    @RequestMapping(value={"userLoginByWechat"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7528\u6237\u901a\u8fc7\u5fae\u4fe1\u767b\u5f55-\u7528\u6237\u975e\u9996\u6b21\u767b\u5f55", notes="\u7528\u6237\u975e\u9996\u6b21\u767b\u5f55,\u8fd4\u56de\u9519\u8bef\u7801\u4e3a \u30102001\u3011 \u8868\u793a\u3010\u8be5\u7528\u6237\u4ece\u672a\u7ed1\u5b9a\u5fae\u4fe1\u3011")
    public LoginTokenResponseDTO userLoginByWechat(HttpServletRequest request, @RequestBody @Valid UserLoginNotPasswordRequestDTO requestDTO) {
        LoginInfoResDTO loginInfoResDTO = this.userService.userLoginNotPassword(requestDTO, UserLoginNotPasswordEnum.LOGIN_BY_WECHAT_NOT_FIRST);
        return this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), null);
    }

    @RequestMapping(value={"getWechatMobilePhoneByCode"}, method={RequestMethod.POST})
    @ApiOperation(value="\u901a\u8fc7code\u83b7\u53d6\u5fae\u4fe1\u7ed1\u5b9a\u7684\u624b\u673a\u53f7\u7801", notes="\u901a\u8fc7code\u83b7\u53d6\u5fae\u4fe1\u7ed1\u5b9a\u7684\u624b\u673a\u53f7\u7801")
    public String getWechatMobilePhoneByCode(@RequestBody @Valid GetMobilePhoneByCodeRequestDTO requestDTO) {
        return this.userService.getMobilePhoneByCode(requestDTO);
    }

    @RequestMapping(value={"setRealNameAndFacialVerify"}, method={RequestMethod.POST})
    @ApiOperation(value="\u8bbe\u7f6e\u5b9e\u540d\u8ba4\u8bc1\u548c\u4eba\u8138\u8bc6\u522b", notes="\u8bbe\u7f6e\u5b9e\u540d\u8ba4\u8bc1\u548c\u4eba\u8138\u8bc6\u522b")
    public void setRealNameAndFacialVerify(@RequestBody @Valid RealNameAuthenticationRequestDTO realNameAuthenticationRequestDTO) {
        Long userId = Long.parseLong(JWTContextUtil.getCurrentUserId());
        this.userService.setRealNameAndFacialVerify(userId, realNameAuthenticationRequestDTO);
    }

    @RequestMapping(value={"userLoginByMicroCourt"}, method={RequestMethod.POST})
    @ApiOperation(value="\u901a\u8fc7\u5409\u6797\u5fae\u6cd5\u9662\u76f4\u63a5\u767b\u5f55")
    public LoginTokenResponseDTO userLoginByMicroCourt(@RequestBody @Valid UserLoginByMicroCourtRequestDTO requestDTO, HttpServletRequest request) {
        LoginInfoResDTO loginInfoResDTO = this.userService.userLoginByMicroCourt(requestDTO);
        return this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), null);
    }

    @RequestMapping(value={"userLoginBySxMicroCourt"}, method={RequestMethod.POST})
    @ApiOperation(value="\u901a\u8fc7\u9655\u897f\u5fae\u6cd5\u9662\u76f4\u63a5\u767b\u5f55")
    public LoginTokenResponseDTO userLoginBySxMicroCourt(@RequestBody @Valid UserLoginBySxMicroCourtRequestDTO requestDTO, HttpServletRequest request) {
        LoginInfoResDTO loginInfoResDTO = this.userService.userLoginBySxMicroCourt(requestDTO);
        return this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), null);
    }

    @RequestMapping(value={"singlePointLogin"}, method={RequestMethod.POST})
    @ApiOperation(value="\u901a\u8fc7\u5fae\u6cd5\u9662\u76f4\u63a5\u767b\u5f55\uff08\u5fae\u6cd5\u9662\u5355\u70b9\u767b\u5f55\uff09")
    public LoginTokenResponseDTO singlePointLogin(@RequestBody @Valid UserLoginBySxMicroCourtRequestDTO requestDTO, HttpServletRequest request) {
        LoginInfoResDTO loginInfoResDTO = this.userService.userLoginBySxMicroCourt(requestDTO);
        return this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), null);
    }

    @RequestMapping(value={"sendSms"}, method={RequestMethod.POST})
    @ApiOperation(value="\u53d1\u9001\u77ed\u4fe1", notes="\u53d1\u9001\u77ed\u4fe1")
    public void sendSms(@RequestBody @Valid SendMessageRequestDTO dto) {
        this.userService.sendMsg(dto);
    }

    @RequestMapping(value={"getUserLogin"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7528\u6237\u767b\u5f55")
    public LoginTokenResponseDTO userLoginByMobile(HttpServletRequest request) {
        LoginTokenResponseDTO responseDTO = new LoginTokenResponseDTO();
        if (request.getHeader("JWTToken") != null) {
            String authToken = request.getHeader("JWTToken");
            Long userId = Long.parseLong(JWTContextUtil.getCurrentUserId());
            LoginInfoResDTO loginInfoResDTO = this.userService.userLoginInfo(userId);
            responseDTO.setLoginInfo(loginInfoResDTO);
            responseDTO.setAuthToken(authToken);
            responseDTO.setMediationInfoDTO(null);
            Long orgId = ((UserRoleInfoDTO)loginInfoResDTO.getUserRoles().get(0)).getOrganizationId();
            responseDTO.setShowInnerCaseFlag(Boolean.valueOf(this.userService.isShowInnerCase(orgId, userId)));
            return responseDTO;
        }
        AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.USER_NOT_LOGIN, (String)ErrorCode.USER_NOT_LOGIN.desc());
        return responseDTO;
    }

    @RequestMapping(value={"setRegisterOrigin"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6211\u77e5\u9053\u4e86")
    public void setRegisterOrigin(HttpServletRequest request) {
        Long userId = Long.parseLong(JWTContextUtil.getCurrentUserId());
        this.userService.setRegisterOrigin(userId);
    }

    @RequestMapping(value={"userLoginByMobileTwo"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7528\u6237\u767b\u5f55\u901a\u8fc7\u624b\u673a\u53f7\u7801")
    public LoginTokenResponseDTO userLoginByMobileTwo(@RequestBody @Valid CommonUserLoginByMobileRequestDTO requestDTO, HttpServletRequest request) {
        LoginInfoResDTO loginInfoResDTO = this.userService.userLoginTwo(requestDTO.getMobilePhone());
        LoginTokenResponseDTO responseDTO = this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), null);
        return responseDTO;
    }

    @RequestMapping(value={"staffLoginByPhone"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7528\u6237\u767b\u5f55\u901a\u8fc7\u624b\u673a\u53f7\u7801")
    public LoginTokenResponseDTO userLoginByPhone(@RequestBody @Valid CommonUserLoginByMobileRequestDTO requestDTO, HttpServletRequest request) {
        LoginInfoResDTO loginInfoResDTO = this.userService.userLoginByMobileAndType(requestDTO.getMobilePhone(), UserLoginTypeEnum.WORK_USER_LOGIN_TYPE);
        LoginTokenResponseDTO responseDTO = this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), null);
        Long orgId = ((UserRoleInfoDTO)loginInfoResDTO.getUserRoles().get(0)).getOrganizationId();
        Long userId = loginInfoResDTO.getUserInfo().getUserId();
        responseDTO.setShowInnerCaseFlag(Boolean.valueOf(this.userService.isShowInnerCase(orgId, userId)));
        this.userService.checkAppNameAndProvinceCode(orgId);
        responseDTO.setScreenLayout(this.userService.screenLayout(orgId));
        return responseDTO;
    }

    @RequestMapping(value={"userIdCard"}, method={RequestMethod.POST})
    public List<String> userIdCard(@RequestBody @Valid LoginEWMRequestDTO loginEWMRequestDTO) {
        List loginInfoResDTO = this.userService.userIdCard(loginEWMRequestDTO.getIdCard());
        return loginInfoResDTO;
    }

    @RequestMapping(value={"allInOneUserInfo"}, method={RequestMethod.POST})
    public String allInOneUserInfo(@RequestBody AllInOneUserLogin dto) {
        List loginInfos = this.userService.userIdCard(dto.getIdCard());
        if (loginInfos == null || loginInfos.size() == 0) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u7528\u6237\u5728\u4e92\u8054\u7f51\u5f00\u5ead\u65e0\u8d26\u53f7");
        }
        JSONObject json = new JSONObject();
        json.put("userName", (Object)dto.getUserName());
        json.put("idCard", (Object)dto.getIdCard());
        String miStr = Md5Utils.md5Encode((String)json.toJSONString());
        String userBak = (String)this.redisService.get((RedisKey)RedisKeyEnums.ALLINONE_USER_LOGIN, miStr);
        Log.info((String)"\u5df2\u5b58\u5728:{}", (Object)userBak);
        if (userBak == null || StringUtils.isEmpty((CharSequence)userBak) || "".equals(userBak)) {
            this.redisService.set((RedisKey)RedisKeyEnums.ALLINONE_USER_LOGIN, miStr, (Object)dto.getIdCard(), timeout, unit);
            Log.info((String)"\u4fdd\u5b58\u7f13\u5b58");
        }
        return miStr;
    }

    @RequestMapping(value={"allInOneLogin"}, method={RequestMethod.POST})
    public List<LoginTokenResponseDTO> allInOneLogin(@RequestBody @Valid AllInOneUserLogin dto, HttpServletRequest request) {
        Log.info((String)"\u53c2\u6570\uff1a{}", (Object)dto.toString());
        ArrayList<LoginTokenResponseDTO> loginTokenResList = new ArrayList<LoginTokenResponseDTO>();
        String mCode = dto.getContent();
        String idCard = (String)this.redisService.get((RedisKey)RedisKeyEnums.ALLINONE_USER_LOGIN, mCode);
        Log.info((String)"\u4fe1\u606f\uff1a{}", (Object)idCard);
        if (StringUtils.isNotEmpty((CharSequence)idCard)) {
            List loginInfos = this.userService.userIdCard(idCard);
            for (int i = 0; i < loginInfos.size(); ++i) {
                LoginInfoResDTO loginInfoResDTO = this.userService.userLoginTwo((String)loginInfos.get(i));
                LoginTokenResponseDTO responseDTO = this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), null);
                loginTokenResList.add(responseDTO);
            }
            this.redisService.delete((RedisKey)RedisKeyEnums.ALLINONE_USER_LOGIN, mCode);
            return loginTokenResList;
        }
        return loginTokenResList;
    }

    @RequestMapping(value={"userLoginByAppId"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7528\u6237\u767b\u5f55\u901a\u8fc7\u624b\u673a\u53f7\u7801\u548cappId")
    public LoginTokenResponseDTO userLoginByAppId(@RequestBody @Valid UserLoginByAppIdRequestDTO requestDTO, HttpServletRequest request) {
        DictionaryReqDTO dictionaryReqDTO = new DictionaryReqDTO();
        dictionaryReqDTO.setParentCode("APPID_WHITE_LIST");
        DubboResult dubboDic = this.dictionaryServiceApi.listDictionaryList(dictionaryReqDTO);
        AssertUtils.assertTrue((boolean)dubboDic.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u7a0b\u5e8fid\u5b57\u5178\u67e5\u8be2\u9519\u8bef");
        ArrayList dicList = (ArrayList)dubboDic.getData();
        ArrayList<String> appIds = new ArrayList<String>();
        for (DictionaryInfoDTO dictionaryInfo : dicList) {
            appIds.add(dictionaryInfo.getValue());
        }
        AssertUtils.assertTrue((boolean)appIds.contains(requestDTO.getAppId()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u7a0b\u5e8f\u65e0\u767b\u5f55\u6743\u9650");
        LoginInfoResDTO loginInfoResDTO = this.userService.userLoginByMobileAndType(requestDTO.getMobilePhone(), requestDTO.getLoginType());
        if (!requestDTO.getUserName().equals(loginInfoResDTO.getUserInfo().getUserName())) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u7528\u6237\u540d\u548c\u624b\u673a\u53f7\u4e0d\u5339\u914d");
        }
        LoginTokenResponseDTO responseDTO = this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), null);
        return responseDTO;
    }

    @PostMapping(value={"/oauth/token"})
    @ApiOperation(value="\u83b7\u53d6token", notes="\u83b7\u53d6token")
    public APIResult getToken() {
        String pathUrl = "https://uasp.odrcloud.cn/uasp/oauth/token";
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("grant_type", "password");
        json.put("username", "internetcourt");
        json.put("password", "MVqw4LSk0jECt8mPqY55xO/kziW4NTRedbCoxc2TQAaPw4nbFnHywJ4kXw4lA/E/fw2pc+SSDo4fDC5eg8LpV+SNm9SFDZIqOt/+H37YirTXFmBMvUtQFclX8hwTrrpuI2fWkereac66u/5YH0wtZvw9OtqSdUH2mt+vvZ6Z7co=");
        HashMap<String, String> map = new HashMap<String, String>();
        String appID = "basic";
        String appSecret = "dY855G3!sFBUM74pyecTqg@mwTpdj8Zx";
        String s = RSAUtil.publicEncrypt((String)appSecret, (String)PUBLIC_KEY);
        String auth = appID + ":" + s;
        String s1 = Base64Utils.encodeBase64String((byte[])auth.getBytes(StandardCharsets.UTF_8));
        String authorization = "Basic " + s1;
        map.put("Authorization", authorization);
        map.put("Content-Type", "application/x-www-form-urlencoded");
        HttpClientResult httpClientResult = null;
        String accessToken = "";
        try {
            httpClientResult = HttpClientUtil.doPost((String)pathUrl, map, json);
            String content = httpClientResult.getContent();
            JSONObject jsonObject = JSONObject.parseObject((String)content);
            accessToken = (String)jsonObject.get((Object)"access_token");
        }
        catch (Exception e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        this.verificationCodeService.setAccessToken(accessToken);
        return APIResult.success((Object)httpClientResult.getContent());
    }

    @PostMapping(value={"/api/v1/internet/unifed/judgeCardId"})
    @ApiOperation(value="\u5224\u65ad\u8eab\u4efd\u8bc1\u53f7\u662f\u5426\u6ce8\u518c\u8fc7", notes="\u5224\u65ad\u8eab\u4efd\u8bc1\u53f7\u662f\u5426\u6ce8\u518c\u8fc7")
    public String judgeCardId(@RequestBody AuthenticationReuestDTO dto) {
        String pathUrl = "https://uasp.odrcloud.cn/uasp/api/v1/internet/unifed/judgeCardId";
        JSONObject json = new JSONObject();
        json.put("cardId", (Object)dto.getCardId());
        HashMap<String, String> map = new HashMap<String, String>();
        String accessToken = this.verificationCodeService.getAccessToken();
        map.put("Authorization", "Bearer " + accessToken);
        String result = null;
        try {
            result = MyHttpClientUtils.sendHttpPost((String)pathUrl, (String)json.toString(), map);
        }
        catch (Exception e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return result;
    }

    @PostMapping(value={"/api/v1/internet/unifed/getCode"})
    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u7801 ", notes="\u83b7\u53d6\u9a8c\u8bc1\u7801 ")
    public String getCode(@RequestBody AuthenticationReuestDTO dto) {
        String pathUrl = "https://uasp.odrcloud.cn/uasp/api/v1/internet/unifed/getCode";
        JSONObject json = new JSONObject();
        json.put("phone", (Object)dto.getPhone());
        HashMap<String, String> map = new HashMap<String, String>();
        String accessToken = this.verificationCodeService.getAccessToken();
        map.put("Authorization", "Bearer " + accessToken);
        String result = null;
        try {
            result = MyHttpClientUtils.sendHttpPost((String)pathUrl, (String)json.toString(), map);
        }
        catch (Exception e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/v1/internet/unifed/judgeVerCode"})
    @ApiOperation(value="\u68c0\u67e5\u9a8c\u8bc1\u7801 ", notes="\u68c0\u67e5\u9a8c\u8bc1\u7801 ")
    public String judgeVerCode(@RequestBody AuthenticationReuestDTO dto) {
        Boolean hasKey = this.redisService.getRedisTemplate().hasKey((Object)("TONFYIRENGZHENG_CODE_COUNT_" + dto.getPhone()));
        if (hasKey.booleanValue()) {
            Integer count1 = (Integer)this.redisService.getRedisTemplate().opsForValue().get((Object)("TONFYIRENGZHENG_CODE_COUNT_" + dto.getPhone()));
            if (count1 >= 5) {
                AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ERROR_CODE_LIMIT, (String)"\u9519\u8bef\u8d85\u8fc75\u6b21\uff0c\u8bf712\u5c0f\u65f6\u540e\u91cd\u8bd5");
            }
            String pathUrl = "https://uasp.odrcloud.cn/uasp/api/v1/internet/unifed/judgeVerCode";
            JSONObject json = new JSONObject();
            json.put("phone", (Object)dto.getPhone());
            json.put("code", (Object)dto.getCode());
            HashMap<String, String> map = new HashMap<String, String>();
            String accessToken = this.verificationCodeService.getAccessToken();
            map.put("Authorization", "Bearer " + accessToken);
            String result = null;
            Integer code = 1;
            try {
                result = MyHttpClientUtils.sendHttpPost((String)pathUrl, (String)json.toString(), map);
                log.info("==================result======================" + result);
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                code = (Integer)jsonObject.get((Object)"code");
            }
            catch (Exception e) {
                AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            }
            UserController userController = this;
            synchronized (userController) {
                Integer count;
                Integer value = (Integer)this.redisService.getRedisTemplate().opsForValue().get((Object)("TONFYIRENGZHENG_CODE_COUNT_" + dto.getPhone()));
                if (code != 0) {
                    this.redisService.getRedisTemplate().opsForValue().set((Object)("TONFYIRENGZHENG_CODE_COUNT_" + dto.getPhone()), (Object)(value + 1), 12L, TimeUnit.HOURS);
                }
                if ((count = (Integer)this.redisService.getRedisTemplate().opsForValue().get((Object)("TONFYIRENGZHENG_CODE_COUNT_" + dto.getPhone()))) >= 5) {
                    AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ERROR_CODE_LIMIT, (String)"\u9519\u8bef\u8d85\u8fc75\u6b21\uff0c\u8bf712\u5c0f\u65f6\u540e\u91cd\u8bd5");
                }
            }
            return result;
        }
        String pathUrl = "https://uasp.odrcloud.cn/uasp/api/v1/internet/unifed/judgeVerCode";
        JSONObject json = new JSONObject();
        json.put("phone", (Object)dto.getPhone());
        json.put("code", (Object)dto.getCode());
        HashMap<String, String> map = new HashMap<String, String>();
        String accessToken = this.verificationCodeService.getAccessToken();
        map.put("Authorization", "Bearer " + accessToken);
        String result = null;
        Integer code = 1;
        try {
            result = MyHttpClientUtils.sendHttpPost((String)pathUrl, (String)json.toString(), map);
            log.info("==================result======================" + result);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            log.info("==================jsonObject======================" + jsonObject);
            code = (Integer)jsonObject.get((Object)"code");
            log.info("==================code======================" + code);
            if (code != 0) {
                this.redisService.getRedisTemplate().opsForValue().set((Object)("TONFYIRENGZHENG_CODE_COUNT_" + dto.getPhone()), (Object)0, 12L, TimeUnit.HOURS);
            }
        }
        catch (Exception e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return result;
    }

    @PostMapping(value={"/api/v1/internet/unifed/register"})
    @ApiOperation(value="\u6ce8\u518c\u63a5\u53e3 ", notes="\u6ce8\u518c\u63a5\u53e3 ")
    public String register(@RequestBody AuthenticationReuestDTO dto) {
        String pathUrl = "https://uasp.odrcloud.cn/uasp/api/v1/internet/unifed/register";
        JSONObject json = new JSONObject();
        json.put("phone", (Object)dto.getPhone());
        json.put("name", (Object)dto.getName());
        json.put("idCard", (Object)dto.getIdCard());
        json.put("password", (Object)dto.getPassword());
        HashMap<String, String> map = new HashMap<String, String>();
        String accessToken = this.verificationCodeService.getAccessToken();
        map.put("Authorization", "Bearer " + accessToken);
        String result = null;
        try {
            result = MyHttpClientUtils.sendHttpPost((String)pathUrl, (String)json.toString(), map);
        }
        catch (Exception e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return result;
    }

    @PostMapping(value={"/api/v1/internet/userInfo/login/loginByCardId"})
    @ApiOperation(value="\u8eab\u4efd\u8bc1\u767b\u5f55\u63a5\u53e3 ", notes="\u8eab\u4efd\u8bc1\u767b\u5f55\u63a5\u53e3 ")
    public String loginByCardId(@RequestBody AuthenticationReuestDTO dto) {
        String pathUrl = "https://uasp.odrcloud.cn/uasp/api/v1/internet/userInfo/login/loginByCardId";
        JSONObject json = new JSONObject();
        json.put("name", (Object)dto.getName());
        json.put("idCard", (Object)dto.getIdCard());
        HashMap<String, String> map = new HashMap<String, String>();
        String accessToken = this.verificationCodeService.getAccessToken();
        map.put("Authorization", "Bearer " + accessToken);
        String result = null;
        try {
            result = MyHttpClientUtils.sendHttpPost((String)pathUrl, (String)json.toString(), map);
        }
        catch (Exception e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return result;
    }

    @PostMapping(value={"/api/v1/internet/userInfo/getInfo/getUserInfoByToken"})
    @ApiOperation(value="\u6839\u636etoken\u67e5\u8be2\u7528\u6237\u4fe1\u606f ", notes="\u6839\u636etoken\u67e5\u8be2\u7528\u6237\u4fe1\u606f ")
    public String getUserInfoByToken(@RequestBody AuthenticationReuestDTO dto) {
        String pathUrl = "https://uasp.odrcloud.cn/uasp/api/v1/internet/userInfo/getInfo/getUserInfoByToken";
        HashMap<String, String> map = new HashMap<String, String>();
        String accessToken = this.verificationCodeService.getAccessToken();
        map.put("Authorization", "Bearer " + accessToken);
        map.put("token", dto.getToken());
        String result = null;
        log.info("----------map------------------" + map);
        try {
            result = MyHttpClientUtils.sendHttpGet((String)pathUrl, map);
        }
        catch (Exception e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return result;
    }

    @PostMapping(value={"/api/v1/internet/userInfo/modify/updatePhone"})
    @ApiOperation(value="\u66f4\u6539\u7528\u6237\u624b\u673a\u53f7 ", notes="\u66f4\u6539\u7528\u6237\u624b\u673a\u53f7 ")
    public String updatePhone(@RequestBody AuthenticationReuestDTO dto) {
        String pathUrl = "https://uasp.odrcloud.cn/uasp/api/v1/internet/userInfo/modify/updatePhone";
        HashMap<String, String> map = new HashMap<String, String>();
        String accessToken = this.verificationCodeService.getAccessToken();
        map.put("Authorization", "Bearer " + accessToken);
        map.put("token", dto.getToken());
        String result = null;
        JSONObject json = new JSONObject();
        json.put("phone", (Object)dto.getPhone());
        try {
            result = MyHttpClientUtils.sendHttpPost((String)pathUrl, (String)json.toString(), map);
        }
        catch (Exception e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return result;
    }

    @PostMapping(value={"/api/v1/upms/app/noticeOut/customerPopNotice"})
    @ApiOperation(value="\u5f39\u6846\u516c\u544a \u5f53\u4e8b\u4eba ", notes="\u5f39\u6846\u516c\u544a \u5f53\u4e8b\u4eba ")
    public String customerPopNotice(@RequestBody AuthenticationReuestDTO dto) {
        String pathUrl = "https://uasp.odrcloud.cn/uasp/api/v1/upms/app/noticeOut/customerPopNotice";
        HashMap<String, String> map = new HashMap<String, String>();
        String accessToken = this.verificationCodeService.getAccessToken();
        map.put("Authorization", "Bearer " + accessToken);
        map.put("token", dto.getToken());
        String result = null;
        JSONObject json = new JSONObject();
        ArrayList<String> list = new ArrayList<String>();
        list.add(dto.getLabel());
        json.put("label", list);
        try {
            result = MyHttpClientUtils.sendHttpPost((String)pathUrl, (String)json.toString(), map);
        }
        catch (Exception e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return result;
    }

    @PostMapping(value={"/api/v1/upms/app/noticeOut/customerRollNotice"})
    @ApiOperation(value="\u5e38\u89c4\u516c\u544a\u7684\u6eda\u52a8\u5217\u8868 \u5f53\u4e8b\u4eba ", notes="\u5e38\u89c4\u516c\u544a\u7684\u6eda\u52a8\u5217\u8868 \u5f53\u4e8b\u4eba")
    public String customerRollNotice(@RequestBody AuthenticationReuestDTO dto) {
        String pathUrl = "https://uasp.odrcloud.cn/uasp/api/v1/upms/app/noticeOut/customerRollNotice";
        HashMap<String, String> map = new HashMap<String, String>();
        String accessToken = this.verificationCodeService.getAccessToken();
        map.put("Authorization", "Bearer " + accessToken);
        map.put("token", dto.getToken());
        String result = null;
        JSONObject json = new JSONObject();
        ArrayList<String> list = new ArrayList<String>();
        list.add(dto.getLabel());
        json.put("label", list);
        try {
            result = MyHttpClientUtils.sendHttpPost((String)pathUrl, (String)json.toString(), map);
        }
        catch (Exception e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return result;
    }

    @PostMapping(value={"/api/v1/upms/app/noticeOut/customerMark"})
    @ApiOperation(value=" \u516c\u544a\u6807\u8bb0\u5df2\u8bfb \u5f53\u4e8b\u4eba ", notes="\u516c\u544a\u6807\u8bb0\u5df2\u8bfb \u5f53\u4e8b\u4eba")
    public APIResult customerMark(@RequestBody AuthenticationReuestDTO dto) {
        String pathUrl = "https://uasp.odrcloud.cn/uasp/api/v1/upms/app/noticeOut/customerRollNotice";
        HashMap<String, String> map = new HashMap<String, String>();
        String accessToken = this.verificationCodeService.getAccessToken();
        map.put("Authorization", "Bearer " + accessToken);
        map.put("token", dto.getToken());
        HttpClientResult result = null;
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("id", dto.getId());
        try {
            result = HttpClientUtil.doPost((String)pathUrl, map, json);
        }
        catch (Exception e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return APIResult.success((Object)result.getContent());
    }

    @PostMapping(value={"/api/v1/upms/app/noticeOut/customerPage"})
    @ApiOperation(value="\u516c\u544a\u5386\u53f2 \u5f53\u4e8b\u4eba", notes="\u516c\u544a\u5386\u53f2 \u5f53\u4e8b\u4eba")
    public String customerRollNotice(@RequestParam(value="current", defaultValue="1") Integer current, @RequestParam(value="size", defaultValue="10") Integer size, @RequestBody AuthenticationReuestDTO dto) {
        String pathUrl = "https://uasp.odrcloud.cn/uasp/api/v1/upms/app/noticeOut/customerPage";
        HashMap<String, String> map = new HashMap<String, String>();
        String accessToken = this.verificationCodeService.getAccessToken();
        map.put("Authorization", "Bearer " + accessToken);
        map.put("token", dto.getToken());
        String result = null;
        JSONObject json = new JSONObject();
        ArrayList<String> list = new ArrayList<String>();
        list.add(dto.getLabel());
        json.put("label", list);
        json.put("current", (Object)current);
        json.put("size", (Object)size);
        try {
            result = MyHttpClientUtils.sendHttpPost((String)pathUrl, (String)json.toString(), map);
        }
        catch (Exception e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return result;
    }

    @RequestMapping(value={"verifyService"}, method={RequestMethod.POST})
    @ApiOperation(value="\u63a5\u53e3\u9a8c\u8bc1\u662f\u5426\u79df\u8d41\u5230\u671f", notes="\u63a5\u53e3\u9a8c\u8bc1\u662f\u5426\u79df\u8d41\u5230\u671f")
    public APIResult verifyService() {
        return APIResult.success((Object)"\u9a8c\u8bc1\u901a\u8fc7");
    }
}

