/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.interceptor;

import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.annotation.ExtrAccessAnnotation;
import com.beiming.odr.peace.common.utils.SHAUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class ExtAccessInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(ExtAccessInterceptor.class);
    @Resource
    private RedisService redisService;
    private final String secretKey = "tdhqdhnc@*smupad";
    private final String secretAppid = "900978";
    private final String hbSecretKey = "hbsjzx@*zldj";
    private final String hbSecretAppid = "900979";
    private final String gsSecretKey = "hngs@*HLWKT#2024";
    private final String gsSecretAppid = "900980";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.info("\u7b2c\u4e09\u65b9\u8bf7\u6c42\u8fdb\u5165\u9a8c\u8bc1.................");
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            headers.put(key, request.getHeader(key));
        }
        log.info("request header = {}", headers);
        response.setStatus(200);
        response.setContentType("application/json;charset=UTF-8");
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            ExtrAccessAnnotation access = Optional.ofNullable(method.getAnnotation(ExtrAccessAnnotation.class)).orElseGet(() -> handlerMethod.getClass().getAnnotation(ExtrAccessAnnotation.class));
            if (access == null) {
                return true;
            }
            if (access.verifyAppId()) {
                String appId = (String)headers.get("appid");
                log.info("===============secretAppid.equals(appId)=========================" + "900978".equals(appId));
                log.info("===============hbSecretAppid.equals(appId)=========================" + "900979".equals(appId));
                log.info("===============gsSecretAppid.equals(appId)=========================" + "900980".equals(appId));
                if (!("900978".equals(appId) || "900979".equals(appId) || "900980".equals(appId))) {
                    AssertUtils.assertTrue((boolean)false, (ResultCode)APIResultCodeEnums.ACCESS_DENIED, (String)APIResultCodeEnums.ACCESS_DENIED.desc());
                }
            }
            if (access.verifySign()) {
                this.verifySign(headers);
            }
            if (access.verifyToken()) {
                this.verifyToken(headers);
            }
        }
        return true;
    }

    private void verifyToken(Map<String, String> request) {
        String appId = request.get("appid");
        String accessToken = request.get("token");
        String token = (String)this.redisService.getRedisTemplate().opsForValue().get((Object)("THIRD_PARTY_TOKEN_" + appId));
        log.info(accessToken + "=================token=======================" + token);
        AssertUtils.assertTrue((StringUtils.isNotBlank((CharSequence)accessToken) && StringUtils.isEquals((String)accessToken, (String)token) ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.AUTH_TOKEN_EXPIRE, (String)APIResultCodeEnums.AUTH_TOKEN_EXPIRE.desc());
    }

    private void verifySign(Map<String, String> request) {
        String appId = request.get("appid");
        String timestamp = request.get("timestamp");
        String signature = request.get("signature");
        StringBuffer sb1 = new StringBuffer();
        log.info("tdhSign timestamp:{},appId:{},signature:{}", new Object[]{timestamp, appId, "tdhqdhnc@*smupad"});
        sb1.append(timestamp).append("900978").append("tdhqdhnc@*smupad");
        String tdhSign = sb1.toString();
        StringBuffer sb2 = new StringBuffer();
        log.info("hbSign timestamp:{},appId:{},signature:{}", new Object[]{timestamp, appId, "hbsjzx@*zldj"});
        sb2.append(timestamp).append("900979").append("hbsjzx@*zldj");
        String hbSign = sb2.toString();
        StringBuffer sb3 = new StringBuffer();
        log.info("hbSign timestamp:{},appId:{},signature:{}", new Object[]{timestamp, appId, "hngs@*HLWKT#2024"});
        sb3.append(timestamp).append("900980").append("hngs@*HLWKT#2024");
        String gsSign = sb3.toString();
        ArrayList<String> signList = new ArrayList<String>();
        signList.add(SHAUtil.getSHA256Str((String)tdhSign));
        signList.add(SHAUtil.getSHA256Str((String)hbSign));
        signList.add(SHAUtil.getSHA256Str((String)gsSign));
        AssertUtils.assertTrue((boolean)signList.contains(signature), (ResultCode)APIResultCodeEnums.ACCESS_DENIED, (String)APIResultCodeEnums.ACCESS_DENIED.desc());
    }
}

