/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.odr.peace.domain.dto.requestdto.ClerkConfirmAgainRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ClerkConfirmRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ClientClerkConfirmRequestDTO;
import com.beiming.odr.peace.service.client.ClerkOpinionService;
import com.beiming.odr.peace.service.client.ClientClerkOpinionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(value="\u6587\u4e66\u7b7e\u540dAPI", tags={"\u6587\u4e66\u7b7e\u540d"})
@RequestMapping(value={"/peace/clerkOpinion"})
public class ClerkOpinionController {
    @Resource
    private ClerkOpinionService clerkOpinionService;
    @Resource
    private ClientClerkOpinionService clientClerkOpinionService;

    @ApiOperation(value="\u6587\u4e66\u786e\u8ba4\u63a5\u53e3", notes="\u6587\u4e66\u786e\u8ba4\u63a5\u53e3", response=String.class)
    @RequestMapping(value={"/clerkConfirm"}, method={RequestMethod.POST})
    public APIResult clerkConfirm(@Valid ClerkConfirmRequestDTO requestDTO, @RequestParam(value="signFile") MultipartFile signFile) {
        return APIResult.success((Object)this.clerkOpinionService.confirmSignature(requestDTO, signFile));
    }

    @ApiOperation(value="\u6587\u4e66\u7b7e\u540d\u91cd\u7b7e\u63a5\u53e3", notes="\u6587\u4e66\u7b7e\u540d\u91cd\u7b7e\u63a5\u53e3", response=String.class)
    @RequestMapping(value={"/againClerkConfirm"}, method={RequestMethod.POST})
    public APIResult againClerkConfirm(@RequestBody @Valid ClerkConfirmAgainRequestDTO clerkConfirmAgainRequestDTO) {
        String userName = JWTContextUtil.getCurrentUserName();
        return APIResult.success((Object)this.clerkOpinionService.againClerkConfirm(clerkConfirmAgainRequestDTO, userName));
    }

    @ApiOperation(value="\u5ba2\u6237\u7aef\u6587\u4e66\u786e\u8ba4\u63a5\u53e3", notes="\u5ba2\u6237\u7aef\u6587\u4e66\u786e\u8ba4\u63a5\u53e3", response=String.class)
    @RequestMapping(value={"/client/clerkConfirm"}, method={RequestMethod.POST})
    public APIResult clientClerkConfirm(@RequestBody @Valid ClientClerkConfirmRequestDTO reqDTO) {
        return APIResult.success((Object)this.clientClerkOpinionService.confirmSignature(reqDTO));
    }
}

