/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.beiming.basic.chat.api.dto.request.RevokeMsgDto;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.ChatMsgRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CheckFileDataPermissionRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.EditEvidencePermissionRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.EvidencePermissionRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.InductionEvidenceRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.IntoMediationRoomUserRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.InductionEvidenceResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.IntoRoomMediationResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MessageResponseDTO;
import com.beiming.odr.peace.service.ChatService;
import com.beiming.odr.peace.service.UserService;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.mortbay.log.Log;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Api(value="\u804a\u5929\u8bb0\u5f55", tags={"\u804a\u5929\u8bb0\u5f55"})
@RequestMapping(value={"/peace/chat"})
public class ChatController {
    @Resource
    private ChatService chatService;
    @Resource
    private UserService userService;

    @RequestMapping(value={"/oneToOneMsg"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u5355\u804a\u8bb0\u5f55", notes="\u67e5\u8be2\u5355\u804a\u8bb0\u5f55", responseContainer="List", response=MessageResponseDTO.class)
    public APIResult oneToOneMsg(@RequestBody @Valid ChatMsgRequestDTO dto) {
        this.userService.authenticationByRoomId(dto.getRoomId());
        dto.setReceiverId(JWTContextUtil.getCurrentUserId());
        return APIResult.success((Object)this.chatService.listAllMessage(dto));
    }

    @RequestMapping(value={"/roomMsg"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u804a\u5929\u8bb0\u5f55", notes="\u67e5\u8be2\u804a\u5929\u8bb0\u5f55", responseContainer="List", response=MessageResponseDTO.class)
    public APIResult roomMsg(@RequestBody @Valid ChatMsgRequestDTO dto) {
        this.userService.authenticationByRoomId(dto.getRoomId());
        if (StringUtils.isBlank((CharSequence)dto.getReceiverId())) {
            dto.setReceiverId(JWTContextUtil.getCurrentUserId());
        } else {
            dto.setSender(JWTContextUtil.getCurrentUserId());
        }
        return APIResult.success((Object)this.chatService.listAllMessage(dto));
    }

    @RequestMapping(value={"/revokeMsg"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u64a4\u56de\u6d88\u606f", notes="\u64a4\u56de\u6d88\u606f")
    public APIResult revokeMsg(@RequestBody @Valid RevokeMsgDto dto) {
        AssertUtils.assertTrue((dto.getMsgId() != null ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u6d88\u606fID\u4e0d\u80fd\u4e3a\u7a7a");
        this.userService.authenticationByRoomId(dto.getRoomId());
        dto.setSenderId(JWTContextUtil.getCurrentUserId());
        int num = this.chatService.revokeMsg(dto);
        if (num >= 1) {
            return APIResult.success((Object)"\u64a4\u56de\u6210\u529f");
        }
        return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ACCESS_DENIED, (String)"\u53ea\u80fd\u64a4\u56de\u81ea\u5df1\u53d1\u9001\u7684\u6d88\u606f");
    }

    @RequestMapping(value={"/intoMediationRoom"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u8fdb\u5165\u8c03\u89e3\u5ba4", notes="\u8fdb\u5165\u8c03\u89e3\u5ba4", response=IntoRoomMediationResponseDTO.class)
    public APIResult intoMediationRoom(@RequestBody @Valid IntoMediationRoomUserRequestDTO dto) {
        this.userService.authentication(Long.valueOf(dto.getBizRoomId()));
        dto.setMemberId(JWTContextUtil.getCurrentUserId());
        Log.info((String)("\u8fdb\u5165\u8c03\u89e3\u5ba4 \u7528\u6237\u89d2\u8272:" + JWTContextUtil.getRoles()));
        if (JWTContextUtil.getRoles().contains(RoleTypeEnum.MEDIATOR.name())) {
            dto.setMaster(Boolean.valueOf(true));
        } else if (AppNameContextHolder.getAppName().contains("weitingshen")) {
            List intersection = JWTContextUtil.getRoles().stream().filter(item -> MeetingUserTypeEnum.getMediatorUserEnumName().contains(item)).collect(Collectors.toList());
            if (!intersection.isEmpty()) {
                dto.setMaster(Boolean.valueOf(true));
            } else {
                dto.setMaster(Boolean.valueOf(false));
            }
        } else {
            dto.setMaster(Boolean.valueOf(false));
        }
        Log.info((String)("\u8fdb\u5165\u8c03\u89e3\u5ba4 setMaster:" + dto.getMaster()));
        return APIResult.success((Object)this.chatService.intoMediationRoom(dto));
    }

    @RequestMapping(value={"/inductionEvidence"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u5f52\u7eb3\u8bc1\u636e", notes="\u5f52\u7eb3\u8bc1\u636e", response=InductionEvidenceResponseDTO.class)
    public APIResult inductionEvidence(@RequestBody @Valid InductionEvidenceRequestDTO dto) {
        this.userService.authentication(Long.valueOf(dto.getBizRoomId()));
        return APIResult.success((Object)this.chatService.inductionEvidence(dto));
    }

    @RequestMapping(value={"/checkEvidencePermission"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u6848\u4ef6\u7a7a\u95f4\u8bc1\u636e\u6743\u9650\u6821\u9a8c", notes="\u6848\u4ef6\u7a7a\u95f4\u8bc1\u636e\u6743\u9650\u6821\u9a8c")
    public APIResult checkDataPermission(@RequestBody @Valid CheckFileDataPermissionRequestDTO dto) {
        this.userService.authentication(Long.valueOf(dto.getBizRoomId()));
        return APIResult.success((Object)this.chatService.checkDataPermission(dto));
    }

    @RequestMapping(value={"/evidenceReviewPermissionList"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u8bc1\u636e\u6750\u6599\u5ba1\u6838\u6743\u9650\u4e0b\u62c9", notes="\u8bc1\u636e\u6750\u6599\u5ba1\u6838\u6743\u9650\u4e0b\u62c9")
    public APIResult evidenceReviewPermissions(@RequestBody @Valid EvidencePermissionRequestDTO dto) {
        this.userService.authentication(Long.valueOf(dto.getBizRoomId()));
        return APIResult.success((Object)this.chatService.evidenceReviewPermissions(dto));
    }

    @RequestMapping(value={"/evidenceProviderList"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u8bc1\u636e\u63d0\u4f9b\u65b9\u4e0b\u62c9", notes="\u8bc1\u636e\u63d0\u4f9b\u65b9\u4e0b\u62c9")
    public APIResult evidenceProviders(@RequestBody @Valid EvidencePermissionRequestDTO dto) {
        this.userService.authentication(Long.valueOf(dto.getBizRoomId()));
        return APIResult.success((Object)this.chatService.evidenceProviders(dto));
    }

    @RequestMapping(value={"/editEvidencePermission"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u7f16\u8f91\u8bc1\u636e\u6750\u6599\u53ef\u89c1\u6743\u9650", notes="\u7f16\u8f91\u8bc1\u636e\u6750\u6599\u53ef\u89c1\u6743\u9650")
    public APIResult editEvidencePermission(@RequestBody @Valid EditEvidencePermissionRequestDTO dto) {
        this.userService.authentication(Long.valueOf(dto.getBizRoomId()));
        return APIResult.success((Object)this.chatService.editEvidencePermission(dto));
    }
}

