/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.beiming.basic.storage.api.dto.response.FileInfoResponseDTO;
import com.beiming.basic.storage.api.dto.response.SaveFileResponseDTO;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.document.api.AttachmentApi;
import com.beiming.odr.document.api.DocumentApi;
import com.beiming.odr.document.api.PdfAttachMentApi;
import com.beiming.odr.document.dto.requestdto.PdfAttachmentReqDTO;
import com.beiming.odr.document.dto.responsedto.DocAttachmentResDTO;
import com.beiming.odr.document.dto.responsedto.DocumentResDTO;
import com.beiming.odr.peace.annotation.ExtrAccessAnnotation;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.enums.ThirdPartyEnum;
import com.beiming.odr.peace.common.utils.WeitingshenUtil;
import com.beiming.odr.peace.domain.dto.requestdto.BatchDocDownloadRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonFileInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonMaterialsRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DelAttachmentRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DocExamineRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DocumentRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.QueryAttachmentListReqDTO;
import com.beiming.odr.peace.domain.dto.responsedto.DocumentResponseDTO;
import com.beiming.odr.peace.service.UserService;
import com.beiming.odr.peace.service.backend.document.AttachmentDubboService;
import com.beiming.odr.peace.service.backend.storage.StorageDubboService;
import com.beiming.odr.peace.service.util.ConvertUtil;
import com.beiming.odr.referee.api.MediationRoomApi;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/peace/file"})
@Api(value="\u6587\u4ef6Controller", tags={"\u6587\u4ef6"})
public class FileController {
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    @Resource
    private AttachmentDubboService attachmentDubboService;
    @Resource
    private StorageDubboService storageDubboService;
    @Resource
    private UserService userService;
    @Resource
    private DocumentApi documentApi;
    @Resource
    private StorageDubboService storageDubboServiceImpl;
    @Resource
    private AttachmentApi attachmentApi;
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Resource
    private PdfAttachMentApi pdfAttachMentApi;

    @ApiOperation(value="\u6587\u4e66\u9644\u4ef6\u5217\u8868", notes="\u6587\u4e66\u9644\u4ef6\u5217\u8868")
    @RequestMapping(value={"/docAttachmentList"}, method={RequestMethod.POST})
    public APIResult queryAttachmentList(@RequestBody @Valid DocumentRequestDTO request) {
        ArrayList resLst = this.attachmentDubboService.queryAttachmentList(request);
        return APIResult.success((Object)resLst);
    }

    @ApiOperation(value="\u6587\u4ef6\u7b14\u5f55\u5217\u8868", response=DocumentResponseDTO.class, responseContainer="List")
    @RequestMapping(value={"/documentList"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult documentList(@RequestBody @Valid QueryAttachmentListReqDTO dto, HttpServletRequest request) {
        return APIResult.success((Object)this.attachmentDubboService.queryAttachmentList(dto, request));
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @RequestMapping(value={"/getTemplateDocument"}, method={RequestMethod.GET})
    @ResponseBody
    public APIResult documentList(Long bizRoomId) {
        return APIResult.success((Object)this.attachmentDubboService.getTemplate(bizRoomId));
    }

    @ApiOperation(value="\u9644\u4ef6\u5220\u9664", notes="\u9644\u4ef6\u5220\u9664")
    @RequestMapping(value={"/delAttachment"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult delAttachment(@RequestBody @Valid CommonIdRequestDTO dto) {
        this.attachmentDubboService.delAttachment(dto);
        return APIResult.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4e0b\u8f7d", notes="\u4e0b\u8f7d")
    @RequestMapping(value={"/downloadAttachment"}, method={RequestMethod.POST, RequestMethod.GET})
    public APIResult downloadAttachment(@Valid CommonFileInfoRequestDTO dto, HttpServletResponse response) {
        String filename = null;
        String fileId = null;
        response.setContentType("application/force-download");
        if (StringUtils.isNotBlank((CharSequence)dto.getSign()) && ThirdPartyEnum.TDHYAOHAO.getCode().equals(dto.getSign())) {
            DubboResult result = this.pdfAttachMentApi.getPdfAttachmentByObjectId(dto.getId());
            AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
            PdfAttachmentReqDTO pdfAttachmentReqDTO = (PdfAttachmentReqDTO)result.getData();
            filename = pdfAttachmentReqDTO.getPdfName();
            fileId = pdfAttachmentReqDTO.getPdfId();
        } else if (StringUtils.isNotBlank((CharSequence)dto.getDocFileId()) && StringUtils.isNotBlank((CharSequence)dto.getDocName())) {
            filename = dto.getDocName();
            fileId = dto.getDocFileId();
        } else {
            DocAttachmentResDTO docAttachmentResDTO = this.attachmentDubboService.getAttachment(dto);
            filename = docAttachmentResDTO.getFileName();
            fileId = docAttachmentResDTO.getFileId();
        }
        InputStream fis = null;
        InputStream bis = null;
        try {
            Object filenameIso = null;
            String suffix = filename.substring(filename.lastIndexOf(".") + 1);
            if (suffix.contains("doc") && (WeitingshenUtil.appNameEqualWeitingshenHuBei().booleanValue() || WeitingshenUtil.appNameEqualWeitingshenHaiNan().booleanValue() || WeitingshenUtil.appNameEqualWeitingshenHuBeiZz().booleanValue())) {
                String str = filename.substring(0, filename.lastIndexOf("."));
                filename = str + ".pdf";
            }
            log.info("filename is {}", (Object)filename);
            String filenameUtf8 = URLEncoder.encode(filename, "UTF-8");
            response.addHeader("Content-Disposition", "attachment;fileName=" + filenameUtf8);
            FileInfoResponseDTO data = this.storageDubboService.getFileInfo(fileId);
            ServletOutputStream outputStream = response.getOutputStream();
            if (suffix.contains("doc") && (WeitingshenUtil.appNameEqualWeitingshenHuBei().booleanValue() || WeitingshenUtil.appNameEqualWeitingshenHaiNan().booleanValue() || WeitingshenUtil.appNameEqualWeitingshenHuBeiZz().booleanValue())) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(data.getFileByte());
                byte[] pdfByte = ConvertUtil.doc2pdfByte((InputStream)inputStream);
                outputStream.write(pdfByte);
            } else {
                outputStream.write(data.getFileByte());
            }
        }
        catch (Exception e) {
            log.error("dossierDownload error {}", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(bis);
            IOUtils.closeQuietly(fis);
        }
        return null;
    }

    @ApiOperation(value="\u4e0b\u8f7d", notes="\u4e0b\u8f7d")
    @RequestMapping(value={"/test"}, method={RequestMethod.POST, RequestMethod.GET})
    public APIResult test(@RequestParam(value="docId") String docId) throws IOException {
        DubboResult document = this.documentApi.queryDocumentByDocId(Long.valueOf(Long.parseLong(docId)));
        DubboResult fileIdResult = this.documentApi.queryDocumentAttByfileId(((DocumentResDTO)document.getData()).getFileId());
        Long fileId = (Long)fileIdResult.getData();
        Long objectId = ((DocumentResDTO)document.getData()).getObjectId();
        FileInfoResponseDTO fileInfo = this.storageDubboServiceImpl.getFileInfo(((DocumentResDTO)document.getData()).getFileId());
        InputStream docxInputStream = fileInfo.getInputStream();
        byte[] pdfBytes = ConvertUtil.doc2pdfByte((InputStream)docxInputStream);
        String pdfFileName = "\u7b14\u5f55.pdf";
        DubboResult save = this.storageDubboServiceImpl.save(pdfFileName, pdfBytes);
        SaveFileResponseDTO data = (SaveFileResponseDTO)save.getData();
        String pdfFileId = data.getFileId();
        PdfAttachmentReqDTO pdfAttachmentReqDTO = new PdfAttachmentReqDTO();
        pdfAttachmentReqDTO.setObjectId(((DocumentResDTO)document.getData()).getObjectId());
        pdfAttachmentReqDTO.setDocId(((DocumentResDTO)document.getData()).getFileId());
        pdfAttachmentReqDTO.setDocAttachmentId(fileId);
        pdfAttachmentReqDTO.setDocName(((DocumentResDTO)document.getData()).getDocName());
        pdfAttachmentReqDTO.setPdfId(pdfFileId);
        pdfAttachmentReqDTO.setPdfName(pdfFileName);
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        pdfAttachmentReqDTO.setCreateTime(localDateTime.format(df));
        this.pdfAttachMentApi.insertPdfAttachment(pdfAttachmentReqDTO);
        if (docxInputStream != null) {
            try {
                docxInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                log.info("clerkOpinionServiceImpl\u7c7b\u4e2ddocx\u6d41\u5173\u95ed\u5931\u8d25{}", (Object)e.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5bf9\u63a5\u7b14\u5f55\u548c\u8bc1\u636e\u6750\u6599\u4e0b\u8f7d", notes="\u5bf9\u63a5\u7b14\u5f55\u548c\u8bc1\u636e\u6750\u6599\u4e0b\u8f7d")
    @ExtrAccessAnnotation(verifySign=false)
    @RequestMapping(value={"/downloadMaterials"}, method={RequestMethod.GET})
    public APIResult downloadMaterials(@Valid CommonMaterialsRequestDTO dto, HttpServletResponse response, HttpServletRequest request) {
        AppNameContextHolder.setAppName((String)"weitingshenhubei");
        String filename = dto.getFileName();
        String fileId = dto.getFileId();
        response.setContentType("application/force-download");
        InputStream fis = null;
        InputStream bis = null;
        try {
            Object filenameIso = null;
            String suffix = filename.substring(filename.lastIndexOf(".") + 1);
            if (suffix.contains("doc") && (WeitingshenUtil.appNameEqualWeitingshenHuBei().booleanValue() || WeitingshenUtil.appNameEqualWeitingshenHaiNan().booleanValue() || WeitingshenUtil.appNameEqualWeitingshenHuBeiZz().booleanValue())) {
                String str = filename.substring(0, filename.lastIndexOf("."));
                filename = str + ".pdf";
            }
            log.info("filename is {}", (Object)filename);
            String filenameUtf8 = URLEncoder.encode(filename, "UTF-8");
            response.addHeader("Content-Disposition", "attachment;fileName=" + filenameUtf8);
            FileInfoResponseDTO data = this.storageDubboService.getFileInfo(fileId);
            ServletOutputStream outputStream = response.getOutputStream();
            if (suffix.contains("doc") && (WeitingshenUtil.appNameEqualWeitingshenHuBei().booleanValue() || WeitingshenUtil.appNameEqualWeitingshenHaiNan().booleanValue() || WeitingshenUtil.appNameEqualWeitingshenHuBeiZz().booleanValue())) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(data.getFileByte());
                byte[] pdfByte = ConvertUtil.doc2pdfByte((InputStream)inputStream);
                outputStream.write(pdfByte);
            } else {
                outputStream.write(data.getFileByte());
            }
        }
        catch (Exception e) {
            log.error("dossierDownload error {}", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(bis);
            IOUtils.closeQuietly(fis);
        }
        return null;
    }

    @ApiOperation(value="\u5185\u7f51\u6750\u6599\u5220\u9664", notes="\u5185\u7f51\u6750\u6599\u5220\u9664")
    @RequestMapping(value={"/delIntranetAttachment"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult delIntranetAttachment(@RequestBody @Valid DelAttachmentRequestDTO dto) {
        this.attachmentDubboService.delIntranetAttachment(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u5185\u7f51\u6750\u6599\u5217\u8868\u67e5\u8be2", response=DocumentResponseDTO.class, responseContainer="List")
    @RequestMapping(value={"/intranetAttachmentList"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult intranetAttachmentList(@RequestBody @Valid CommonIdRequestDTO dto, HttpServletRequest request) {
        return APIResult.success((Object)this.attachmentDubboService.queryIntranetAttachmentList(dto, request));
    }

    @ApiOperation(value="\u6750\u6599\u5ba1\u6838")
    @RequestMapping(value={"/docExamine"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult docExamine(@RequestBody @Valid DocExamineRequestDTO dto, HttpServletRequest request) {
        if ("INTRANET".equals(dto.getFlag())) {
            this.mediationRoomApi.updateExamineFlagById(dto.getId(), dto.getExamineFlag());
        } else if ("INTERNET".equals(dto.getFlag())) {
            this.attachmentApi.updateExamineFlagById(dto.getId(), dto.getExamineFlag());
        }
        return APIResult.success((Object)"ok");
    }

    @ApiOperation(value="\u591a\u7b14\u5f55\u6279\u91cf\u5bfc\u51fazip\u5305\u538b\u7f29", notes="\u591a\u7b14\u5f55\u6279\u91cf\u5bfc\u51fazip\u5305\u538b\u7f29")
    @RequestMapping(value={"/downloadAttachmentZip"}, method={RequestMethod.POST})
    public APIResult downloadAttachmentzip(@RequestBody BatchDocDownloadRequestDTO dto, HttpServletResponse response) {
        ArrayList docIdList = dto.getDocIdList();
        AssertUtils.assertFalse((boolean)CollectionUtils.isEmpty((Collection)docIdList), (ResultCode)ErrorCode.DOC_DOWNLOAD_ID_IS_NULL, (String)ErrorCode.DOC_DOWNLOAD_ID_IS_NULL.desc());
        DubboResult docAttachmentDubboResult = this.attachmentApi.getAttachmentByDocIds(docIdList);
        AssertUtils.assertTrue((boolean)docAttachmentDubboResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)docAttachmentDubboResult.getMessage());
        ArrayList data = (ArrayList)docAttachmentDubboResult.getData();
        AssertUtils.assertFalse((boolean)CollectionUtils.isEmpty((Collection)data), (ResultCode)ErrorCode.DOC_FILE_NOT_EXISTS, (String)ErrorCode.DOC_FILE_NOT_EXISTS.desc());
        Map<String, List<DocAttachmentResDTO>> groupData = data.stream().collect(Collectors.groupingBy(DocAttachmentResDTO::getFileName));
        for (Map.Entry<String, List<DocAttachmentResDTO>> entry : groupData.entrySet()) {
            String fileName = entry.getKey();
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            if (suffix.contains("doc") && (WeitingshenUtil.appNameEqualWeitingshenHuBei().booleanValue() || WeitingshenUtil.appNameEqualWeitingshenHaiNan().booleanValue() || WeitingshenUtil.appNameEqualWeitingshenHuBeiZz().booleanValue())) {
                String str = fileName.substring(0, fileName.lastIndexOf("."));
                fileName = str + ".pdf";
            }
            String tempName = fileName.substring(0, fileName.lastIndexOf("."));
            List<DocAttachmentResDTO> value = entry.getValue();
            if (CollectionUtils.isEmpty(value)) continue;
            if (value.size() > 1) {
                for (int i = 0; i < value.size(); ++i) {
                    if (i > 0) {
                        value.get(i).setFileName(tempName + i + fileName.substring(fileName.lastIndexOf(".")));
                        continue;
                    }
                    value.get(i).setFileName(fileName);
                }
                continue;
            }
            value.get(0).setFileName(fileName);
        }
        log.info("docAttachment data is {}", (Object)data);
        try (ServletOutputStream bos = response.getOutputStream();
             ZipOutputStream out = new ZipOutputStream((OutputStream)bos);){
            String filenameUtf8 = URLEncoder.encode("\u7b14\u5f55.zip", "UTF-8");
            response.setContentType("application/zip");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filenameUtf8 + "\"");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            for (DocAttachmentResDTO datum : data) {
                ZipEntry zipEntry;
                String fileName = datum.getFileName();
                String fileId = datum.getFileId();
                FileInfoResponseDTO fileInfo = this.storageDubboService.getFileInfo(fileId);
                log.info("fileInfo is {}, fileName is {}", (Object)fileInfo.getFileByte().length, (Object)fileInfo.getFileName());
                String tempName = fileInfo.getFileName();
                String suffix = tempName.substring(tempName.lastIndexOf("."));
                if (null == fileInfo.getFileByte()) continue;
                if (suffix.contains("doc") && (WeitingshenUtil.appNameEqualWeitingshenHuBei().booleanValue() || WeitingshenUtil.appNameEqualWeitingshenHaiNan().booleanValue() || WeitingshenUtil.appNameEqualWeitingshenHuBeiZz().booleanValue())) {
                    log.info("zipEntry fileName is {}", (Object)fileName);
                    zipEntry = new ZipEntry(fileName);
                    out.putNextEntry(zipEntry);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(fileInfo.getFileByte());
                    log.info("---------doc to pdf------------------");
                    byte[] pdfByte = ConvertUtil.doc2pdfByte((InputStream)inputStream);
                    log.info("----pdf convert finish-----");
                    log.info("pdfByte length is {}", (Object)pdfByte.length);
                    out.write(pdfByte);
                } else {
                    zipEntry = new ZipEntry(tempName);
                    out.putNextEntry(zipEntry);
                    out.write(fileInfo.getFileByte());
                }
                out.closeEntry();
            }
            out.finish();
            out.flush();
            response.flushBuffer();
            log.info("\u538b\u7f29\u5b8c\u6210");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("batch download document error {}", (Throwable)e);
        }
        return null;
    }

    @ApiOperation(value="test")
    @RequestMapping(value={"/test1"}, method={RequestMethod.POST})
    public APIResult test1(HttpServletRequest request, HttpServletResponse response) {
        LinkedHashMap<String, byte[]> files = new LinkedHashMap<String, byte[]>();
        files.put("file1.txt", "\u5185\u5bb91".getBytes(StandardCharsets.UTF_8));
        files.put("file2.txt", "\u5185\u5bb92".getBytes(StandardCharsets.UTF_8));
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=\"download.zip\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        try (ServletOutputStream out = response.getOutputStream();
             ZipOutputStream zipOut = new ZipOutputStream((OutputStream)out);){
            for (Map.Entry entry : files.entrySet()) {
                ZipEntry zipEntry = new ZipEntry((String)entry.getKey());
                zipOut.putNextEntry(zipEntry);
                zipOut.write((byte[])entry.getValue());
                zipOut.closeEntry();
            }
            zipOut.finish();
            zipOut.flush();
            response.flushBuffer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

