/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.document.api.DocRecordApi;
import com.beiming.odr.document.dto.DockingDocMqDTO;
import com.beiming.odr.document.enums.DockingSysEnum;
import com.beiming.odr.peace.domain.dto.CreateDocMqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomUserRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonCloseIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UpdateMediationRoomPersonRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationRoomUserInfoResponseDTO;
import com.beiming.odr.peace.service.MediationRoomService;
import com.beiming.odr.peace.service.UserService;
import com.beiming.odr.peace.service.client.ClerkRecordService;
import com.beiming.odr.peace.service.producer.impl.CreateProducerImpl;
import com.beiming.odr.referee.api.MediationMeetingRoomApi;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingRoomListReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseRoomInfoResDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/peace/mediationRoom"})
@RestController
@Api(value="\u8c03\u89e3\u5ba4controller", tags={"\u8c03\u89e3\u5ba4controller"})
public class MediationRoomController {
    @Resource
    private MediationRoomService mediationRoomService;
    @Resource
    private MediationMeetingRoomApi mediationMeetingRoomApi;
    @Resource
    private UserService userService;
    @Resource
    private ClerkRecordService clerkRecordService;
    @Resource
    private CreateProducerImpl createProducerImpl;
    @Resource
    private DocRecordApi docRecordApi;
    @Value(value="${thirdparty.sync.ajjbxx-url}")
    private String ajjbxxUrl;

    @ApiOperation(value="\u65b0\u5efa\u8c03\u89e3\u5ba4", notes="\u65b0\u5efa\u8c03\u89e3\u5ba4")
    @RequestMapping(value={"/addMediationRoom"}, method={RequestMethod.POST})
    public APIResult addMediationRoom(@RequestBody @Valid AddMediationRoomRequestDTO dto) {
        this.mediationRoomService.addMediationRoom(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u6dfb\u52a0\u8c03\u89e3\u5ba4\u7528\u6237", notes="\u6dfb\u52a0\u8c03\u89e3\u5ba4\u7528\u6237")
    @RequestMapping(value={"/addMediationRoomUser"}, method={RequestMethod.POST})
    public APIResult addMediationRoomUser(@RequestBody @Valid AddMediationRoomUserRequestDTO dto) {
        this.mediationRoomService.addMediationRoomUser(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u5173\u95ed\u8c03\u89e3\u5ba4", notes="\u5173\u95ed\u8c03\u89e3\u5ba4")
    @RequestMapping(value={"/closeMediationRoom"}, method={RequestMethod.POST})
    public APIResult closeMediationRoom(@RequestBody @Valid CommonCloseIdRequestDTO dto, HttpServletRequest request) {
        String userId = JWTContextUtil.getCurrentUserId();
        Long bizRoomId = dto.getId();
        MediationMeetingRoomListReqDTO mediationMeetingRoomListReqDTO = new MediationMeetingRoomListReqDTO();
        List roomInfos = this.mediationMeetingRoomApi.queryType(userId, String.valueOf(bizRoomId));
        if (roomInfos.size() < 1) {
            return APIResult.success((Object)"NO$\u60a8\u4e0d\u662f\u8be5\u6848\u4ef6\u7684\u521b\u5efa\u4eba\uff0c\u4e0d\u80fd\u7ed3\u675f\u8be5\u6848\u4ef6");
        }
        for (CaseRoomInfoResDTO caseRoomInfoResDTO : roomInfos) {
            if (!caseRoomInfoResDTO.getRoomStatus().equals("START")) continue;
            mediationMeetingRoomListReqDTO.setMediationStatus("RUNNING");
            mediationMeetingRoomListReqDTO.setParentId(dto.getId());
            mediationMeetingRoomListReqDTO.setUserId(Long.valueOf(userId));
            DubboResult resulta = this.mediationMeetingRoomApi.getMediationMeetingRoomList(mediationMeetingRoomListReqDTO);
            AssertUtils.assertTrue((boolean)resulta.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)resulta.getMessage());
            if (((ArrayList)resulta.getData()).size() <= 0) continue;
            return APIResult.success((Object)"NO$\u5ead\u5ba1\u8fdb\u884c\u4e2d\uff0c\u4e0d\u53ef\u7ed3\u675f");
        }
        this.mediationRoomService.closeMediationRoom(dto.getId());
        if (StringUtils.isNotBlank((CharSequence)dto.getSign()) && (request.getHeader("Appname").equals("weitingshenhubei") || request.getHeader("Appname").equals("weitingshenhubeizz"))) {
            CreateDocMqDTO createDocMqDTO = new CreateDocMqDTO();
            createDocMqDTO.setAppName(request.getHeader("Appname"));
            createDocMqDTO.setJwtToken(request.getHeader("Jwttoken"));
            createDocMqDTO.setCreateTime(new Date());
            createDocMqDTO.setObjectId(bizRoomId);
            this.createProducerImpl.createDoc(createDocMqDTO);
        }
        if (request.getHeader("Appname").equals("weitingshenhubei") || request.getHeader("Appname").equals("weitingshenhubeizz")) {
            AppNameContextHolder.setAppName((String)request.getHeader("Appname"));
            DockingDocMqDTO dockingDocMqDTO = new DockingDocMqDTO();
            dockingDocMqDTO.setAppName(request.getHeader("Appname"));
            dockingDocMqDTO.setCreateTime(new Date());
            dockingDocMqDTO.setObjectId(bizRoomId);
            dockingDocMqDTO.setMethod("POST");
            dockingDocMqDTO.setThirdName("\u6e56\u5317\u6570\u636e\u4e2d\u5fc3");
            dockingDocMqDTO.setUrl(this.ajjbxxUrl);
            dockingDocMqDTO.setSign(DockingSysEnum.SEND_All_MATERIALS_TDH_NEW.name());
            this.docRecordApi.sendAllMaterialsTdhNew(dockingDocMqDTO);
        }
        return APIResult.success((Object)"OK$\u6848\u4ef6\u7ed3\u675f\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u8c03\u89e3\u5ba4\u7528\u6237\u4fe1\u606f\u5217\u8868", notes="\u83b7\u53d6\u8c03\u89e3\u5ba4\u7528\u6237\u4fe1\u606f\u5217\u8868", response=MediationRoomUserInfoResponseDTO.class)
    @RequestMapping(value={"/getMediationRoomUserInfoList"}, method={RequestMethod.POST})
    public APIResult getMediationRoomUserInfoList(@RequestBody @Valid CommonIdRequestDTO dto) {
        List list = this.mediationRoomService.getMediationRoomUserInfoList(dto.getId());
        return APIResult.success((Object)list);
    }

    @ApiOperation(value="\u83b7\u53d6\u8c03\u89e3\u5ba4\u4eba\u5458", notes="\u83b7\u53d6\u8c03\u89e3\u5ba4\u4eba\u5458\u578b")
    @RequestMapping(value={"/getMediationRoomPerson"}, method={RequestMethod.POST})
    public APIResult getMediationRoomPerson(@RequestBody @Valid CommonIdRequestDTO dto) {
        return APIResult.success((Object)this.mediationRoomService.getMediationRoomPerson(dto.getId()));
    }

    @ApiOperation(value="\u66f4\u65b0\u8c03\u89e3\u5ba4\u4eba\u5458\u7c7b\u578b", notes="\u66f4\u65b0\u8c03\u89e3\u5ba4\u4eba\u5458\u7c7b\u578b")
    @RequestMapping(value={"/updateMediationRoomPersonType"}, method={RequestMethod.POST})
    public APIResult updateMediationRoomPersonType(@RequestBody @Valid UpdateMediationRoomPersonRequestDTO dto) {
        this.mediationRoomService.updateMediationRoomPersonType(dto);
        return APIResult.success();
    }
}

