/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.enums.CTypeEnums;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.domain.dto.requestdto.CommonIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CourtInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.GetSchemeCodeRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.MyMediationRoomPageListRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.MyVideoMeetingPageListRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.RescheduleDto;
import com.beiming.odr.peace.domain.dto.requestdto.WaitHandlePageListRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationAndVideoCountResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MyMediationRoomPageListResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.VideoAndMediationRoomStatisticsResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.WaitHandlePageListResponseDTO;
import com.beiming.odr.peace.service.PersonalService;
import com.beiming.odr.peace.service.PersonalServiceDemo;
import com.beiming.odr.peace.service.SMSHubeiService;
import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="\u4e2a\u4eba\u4e2d\u5fc3", tags={"\u4e2a\u4eba\u4e2d\u5fc3"})
@RequestMapping(value={"/peace/personal"})
public class PersonalController {
    @Resource
    private PersonalService personalService;
    @Resource
    private PersonalServiceDemo personalServiceDemo;
    @Resource
    private SMSHubeiService smsHubeiService;

    @RequestMapping(value={"getVideoAndMediationRoomStatistics"}, method={RequestMethod.POST})
    @ApiOperation(value="\u9996\u9875\u8c03\u89e3\u89c6\u9891\u548c\u8c03\u89e3\u5ba4\u6570\u91cf\u7edf\u8ba1", notes="\u9996\u9875\u8c03\u89e3\u89c6\u9891\u548c\u8c03\u89e3\u5ba4\u6570\u91cf\u7edf\u8ba1")
    public VideoAndMediationRoomStatisticsResponseDTO getVideoAndMediationRoomStatistics(HttpServletRequest request) {
        String userId = JWTContextUtil.getCurrentUserId();
        return this.personalService.getVideoAndMediationRoomStatistics(userId);
    }

    @RequestMapping(value={"getMyMediationRoomPageList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6211\u7684\u8c03\u89e3\u5ba4\u5217\u8868", notes="\u6211\u7684\u8c03\u89e3\u5ba4\u5217\u8868")
    public APIResult getMyMediationRoomPageList(@RequestBody @Valid MyMediationRoomPageListRequestDTO listRequestDTO) {
        String userId = JWTContextUtil.getCurrentUserId();
        String roleType = RoleTypeEnum.COMMON.name();
        List roles = JWTContextUtil.getRoles();
        if (!CollectionUtils.isEmpty((Collection)roles)) {
            roleType = (String)roles.get(0);
        }
        if (listRequestDTO.getPageIndex() != null && listRequestDTO.getPageSize() != null) {
            PageInfo result = this.personalService.getMyMediationRoomPageInfo(listRequestDTO, userId, roleType);
            return APIResult.success((Object)result);
        }
        List result = this.personalService.getMyMediationRoomPageList(listRequestDTO, userId, roleType);
        return APIResult.success((Object)result);
    }

    @RequestMapping(value={"/readNotification"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5df2\u8bfb\u6b64\u6848\u4ef6\u7684\u6743\u529b\u4e49\u52a1\u901a\u77e5\u4e66", notes="\u4fee\u6539\u7528\u6237\u5df2\u8bfb\u6b64\u6848\u4ef6\u7684\u6743\u529b\u4e49\u52a1\u901a\u77e5\u4e66")
    public String readNotification(@RequestBody @Valid CommonIdRequestDTO dto) {
        String userId = JWTContextUtil.getCurrentUserId();
        return this.personalService.readNotification(dto.getId(), userId);
    }

    @RequestMapping(value={"getMyMediationRoomByUserPageList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6211\u7684\u8c03\u89e3\u5ba4\u5217\u8868", notes="\u6211\u7684\u8c03\u89e3\u5ba4\u5217\u8868")
    public List<MyMediationRoomPageListResponseDTO> getMyMediationRoomByUserPageList(@RequestBody @Valid MyMediationRoomPageListRequestDTO listRequestDTO, HttpServletRequest request) {
        String userId = null;
        userId = listRequestDTO.getUserId() != null ? listRequestDTO.getUserId() : JWTContextUtil.getCurrentUserId();
        String roleType = RoleTypeEnum.COMMON.name();
        List roles = JWTContextUtil.getRoles();
        if (!CollectionUtils.isEmpty((Collection)roles)) {
            roleType = (String)roles.get(0);
        }
        return this.personalService.getMyMediationRoomPageList(listRequestDTO, userId, roleType);
    }

    @RequestMapping(value={"getMyVideoMeetingPageList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6211\u7684\u89c6\u9891\u4f1a\u8bae\u5217\u8868", notes="\u6211\u7684\u89c6\u9891\u4f1a\u8bae\u5217\u8868")
    public APIResult getMyVideoMeetingPageList(@RequestBody @Valid MyVideoMeetingPageListRequestDTO listRequestDTO) {
        String userId = JWTContextUtil.getCurrentUserId();
        if (listRequestDTO.getPageIndex() != null && listRequestDTO.getPageSize() != null) {
            PageInfo result = this.personalService.getMyVideoMeetingPageList(listRequestDTO, Long.valueOf(userId));
            return APIResult.success((Object)result);
        }
        List result = this.personalService.getMyVideoMeetingList(listRequestDTO, Long.valueOf(userId));
        return APIResult.success((Object)result);
    }

    @RequestMapping(value={"/closePopUupReminder"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5173\u95ed\u95ed\u5ead\u5f39\u7a97\u63d0\u9192", notes="\u5173\u95ed\u95ed\u5ead\u5f39\u7a97\u63d0\u9192")
    public APIResult closePopUupReminder(@RequestBody RescheduleDto dto) {
        this.personalService.closePopUupReminder(dto);
        return APIResult.success();
    }

    @RequestMapping(value={"getMediationAndVideoCount"}, method={RequestMethod.POST})
    @ApiOperation(value="\u89c6\u9891\u4f1a\u8bae\u6570\u91cf\u548c\u8c03\u89e3\u5ba4\u6570\u91cf", notes="\u89c6\u9891\u4f1a\u8bae\u6570\u91cf\u548c\u8c03\u89e3\u5ba4\u6570\u91cf")
    public MediationAndVideoCountResponseDTO getMediationAndVideoCount(HttpServletRequest request) {
        String userId = JWTContextUtil.getCurrentUserId();
        String roleType = RoleTypeEnum.COMMON.name();
        List roles = JWTContextUtil.getRoles();
        if (!CollectionUtils.isEmpty((Collection)roles)) {
            roleType = (String)roles.get(0);
        }
        return this.personalService.getMediationAndVideoCount(userId, roleType);
    }

    @RequestMapping(value={"getWaitHandlePageList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4eca\u65e5\u5f85\u529e\u5217\u8868", notes="\u4eca\u65e5\u5f85\u529e\u5217\u8868")
    public List<WaitHandlePageListResponseDTO> getWaitHandlePageList(@RequestBody @Valid WaitHandlePageListRequestDTO requestDTO, HttpServletRequest request) {
        String userId = JWTContextUtil.getCurrentUserId();
        String cType = request.getHeader("cType");
        AssertUtils.assertFalse((CTypeEnums.PC.name().equalsIgnoreCase(cType) && StringUtils.isBlank((String)requestDTO.getMediationMeetingType()) ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)"\u4f1a\u8bae\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        String roleType = RoleTypeEnum.COMMON.name();
        List roles = JWTContextUtil.getRoles();
        if (!CollectionUtils.isEmpty((Collection)roles)) {
            roleType = (String)roles.get(0);
        }
        return this.personalService.getWaitHandlePageList(requestDTO, cType, userId, roleType);
    }

    @RequestMapping(value={"getSchemeCode"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u5c0f\u7a0b\u5e8fscheme\u7801", notes="\u83b7\u53d6\u5c0f\u7a0b\u5e8fscheme\u7801")
    public String getSchemeCode(@RequestBody @Valid GetSchemeCodeRequestDTO reqDtO, HttpServletRequest request, HttpServletResponse response) {
        return this.smsHubeiService.getSchemeCode(reqDtO.getTempKey());
    }

    @RequestMapping(value={"getCourtPayment"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u6cd5\u9662\u7f34\u8d39\u60c5\u51b5", notes="\u83b7\u53d6\u6cd5\u9662\u7f34\u8d39\u60c5\u51b5")
    public APIResult getCourtPayment(@RequestBody @Valid CourtInfoRequestDTO reqDtO) {
        String userId = JWTContextUtil.getCurrentUserId();
        reqDtO.setUserId(userId);
        return APIResult.success((Object)this.personalService.getCourtPayment(reqDtO));
    }
}

