/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.UUIDUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.enums.PeaceRedisKeyEnums;
import com.beiming.odr.peace.controller.UserController;
import com.beiming.odr.peace.domain.dto.LoginMediationRoomInfoDTO;
import com.beiming.odr.peace.domain.dto.RedisMediationRoomInfoDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LoginEWMDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LoginEWMRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UserLoginNotPasswordRequestDTO;
import com.beiming.odr.peace.service.UserService;
import com.beiming.odr.peace.service.backend.user.VerificationCodeService;
import com.beiming.odr.user.api.common.enums.UserLoginNotPasswordEnum;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="\u7b7e\u540d\u4e8c\u7ef4\u7801controller", tags={"\u7b7e\u540d\u4e8c\u7ef4\u7801controller"})
@RequestMapping(value={"/peace/signature"})
public class SignatureController
extends UserController {
    private static final Logger log = LoggerFactory.getLogger(SignatureController.class);
    @Resource
    private RedisService redisService;
    private RedisTemplate redisTemplate;
    @Resource
    private VerificationCodeService verificationCodeService;
    @Resource
    private UserService userService;

    @ApiOperation(value="\u663e\u793a\u4e8c\u7ef4\u7801\u63a5\u53e3", notes="\u663e\u793a\u4e8c\u7ef4\u7801\u63a5\u53e3")
    @RequestMapping(value={"/show/{shortQrCodeUrl}/{appName}"}, method={RequestMethod.GET})
    public void showQRCode(HttpServletResponse response, @PathVariable String shortQrCodeUrl, @PathVariable String appName) {
        log.info("showQRCode appName {}", (Object)appName);
        AppNameContextHolder.setAppName((String)appName);
        try {
            ServletOutputStream out = response.getOutputStream();
            response.setHeader("Content-Type", "image/png");
            HashMap<EncodeHintType, Object> config = new HashMap<EncodeHintType, Object>();
            config.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            config.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            config.put(EncodeHintType.MARGIN, 0);
            String longUrl = (String)this.redisService.hGet((RedisKey)PeaceRedisKeyEnums.SHORT_URL, shortQrCodeUrl);
            BitMatrix bitMatrix = new MultiFormatWriter().encode(longUrl, BarcodeFormat.QR_CODE, 300, 300, config);
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)out);
            log.info("\u4e8c\u7ef4\u7801\u751f\u6210\u5b8c\u6bd5\uff0c\u5df2\u7ecf\u8f93\u51fa\u5230\u9875\u9762\u4e2d\u3002");
        }
        catch (WriterException e) {
            log.error("showQRCode WriterException, {}", (Throwable)e);
        }
        catch (IOException e) {
            log.error("showQRCode IOException, {}", (Throwable)e);
        }
    }

    @RequestMapping(value={"/getLoginEWM"}, method={RequestMethod.POST})
    public LoginEWMDTO getLoginEWM(@Valid @RequestBody LoginEWMRequestDTO loginEWMRequestDTO) throws WriterException, IOException {
        LoginEWMDTO loginEWMDTO = new LoginEWMDTO();
        this.redisTemplate = this.redisService.getRedisTemplate();
        String appName = AppNameContextHolder.getAppName();
        String suffix = appName + loginEWMRequestDTO.getYzm() + UUIDUtils.fullUUID();
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode("https://internetcourt.odrcloud.cn/peace/preview/userLogin/login/?id=" + suffix, BarcodeFormat.QR_CODE, 600, 600);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)outputStream);
        Base64.Encoder encoder = Base64.getEncoder();
        String text = encoder.encodeToString(outputStream.toByteArray());
        loginEWMDTO.setUrl("data:image/png;base64," + text);
        loginEWMDTO.setUuid(suffix);
        this.redisTemplate.opsForValue().set((Object)suffix, (Object)"0", 2L, TimeUnit.HOURS);
        this.redisTemplate.opsForValue().set((Object)(suffix + "1&"), (Object)loginEWMRequestDTO.getYzm(), 2L, TimeUnit.HOURS);
        log.info("\u9610\u8ff0" + this.redisTemplate.opsForValue().get((Object)suffix));
        log.info("\u4e8c\u7ef4\u7801uuid" + suffix);
        return loginEWMDTO;
    }

    @RequestMapping(value={"/queryYanz"}, method={RequestMethod.POST})
    public LoginEWMDTO queryYanz(HttpServletRequest request, @Valid @RequestBody LoginEWMRequestDTO loginEWMRequestDTO) {
        UserLoginNotPasswordRequestDTO requestDTO = new UserLoginNotPasswordRequestDTO();
        requestDTO.setCode(this.redisTemplate.opsForValue().get((Object)(loginEWMRequestDTO.getUuid() + "1&")).toString());
        requestDTO.setPersonType(loginEWMRequestDTO.getPersonType());
        LoginEWMDTO loginEWMDTO = new LoginEWMDTO();
        LoginInfoResDTO loginTokenResponseDTO = this.userLoginByCodeTwo(request, requestDTO);
        loginEWMDTO.setSfSmrz(loginTokenResponseDTO.getUserInfo().getIsRealName());
        loginEWMDTO.setSfSbrl(loginTokenResponseDTO.getUserInfo().getIsFacialVerify());
        loginEWMDTO.setUserId(loginTokenResponseDTO.getUserInfo().getUserId());
        loginEWMDTO.setUserName(loginTokenResponseDTO.getUserInfo().getUserName());
        loginEWMDTO.setIdCard(loginTokenResponseDTO.getUserInfo().getIdCard());
        loginEWMDTO.setStatus(this.redisTemplate.opsForValue().get((Object)loginEWMRequestDTO.getUuid()).toString());
        loginEWMDTO.setMobilePhone(loginTokenResponseDTO.getUserInfo().getMobilePhone());
        return loginEWMDTO;
    }

    @RequestMapping(value={"/updateYanz"}, method={RequestMethod.POST})
    public void updateYanz(@Valid @RequestBody LoginEWMRequestDTO loginEWMRequestDTO) {
        String a = loginEWMRequestDTO.getUuid();
        String b = loginEWMRequestDTO.getStatus();
        this.redisTemplate.opsForValue().set((Object)a, (Object)b, 2L, TimeUnit.HOURS);
    }

    public LoginInfoResDTO userLoginByCodeTwo(HttpServletRequest request, @RequestBody @Valid UserLoginNotPasswordRequestDTO requestDTO) {
        String cType = request.getHeader("cType");
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)requestDTO.getCode()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LoginMediationRoomInfoDTO loginMediationRoomInfo = this.verificationCodeService.getMediationRoomInfoByCode(requestDTO.getCode(), cType);
        RedisMediationRoomInfoDTO resultObj = loginMediationRoomInfo.getRedisMediationRoomInfo();
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)resultObj.getMobilePhone()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        requestDTO.setMobilePhone(resultObj.getMobilePhone());
        LoginInfoResDTO loginInfoResDTO = this.userService.userLoginNotPassword(requestDTO, UserLoginNotPasswordEnum.LOGIN_BY_CODE);
        return loginInfoResDTO;
    }
}

