/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.redis.RedisService;
import com.beiming.odr.peace.domain.dto.PreviewUserLoginInfoDTO;
import com.beiming.odr.peace.domain.dto.RedisMediationRoomInfoDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UserLoginNotPasswordRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.LoginTokenResponseDTO;
import com.beiming.odr.peace.security.TokenGenerator;
import com.beiming.odr.peace.service.UserService;
import com.beiming.odr.peace.service.demonstration.DemonstrationService;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import com.beiming.odr.user.api.common.enums.UserLoginNotPasswordEnum;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/peace/wuhu"})
@Api(value="\u829c\u6e56controller", tags={"\u829c\u6e56controller"})
public class WuhuController {
    @Resource
    private TokenGenerator tokenGenerator;
    @Resource
    private DemonstrationService demonstrationService;
    @Resource
    private UserService userService;
    private final String key = "wuhu";
    @Resource
    private RedisService redisService;
    private RedisTemplate redisTemplate;

    @ApiOperation(value="\u521b\u5efa\u4f1a\u8bae", notes="\u521b\u5efa\u4f1a\u8bae")
    @RequestMapping(value={"/createMeeting"}, method={RequestMethod.POST})
    public APIResult createMeeting() {
        return APIResult.success((Object)this.demonstrationService.createMeeting("wuhu"));
    }

    @ApiOperation(value="\u7528\u6237\u767b\u5f55", notes="\u7528\u6237\u767b\u5f55")
    @RequestMapping(value={"/userLogin"}, method={RequestMethod.POST})
    public LoginTokenResponseDTO userLogin(HttpServletRequest request) {
        PreviewUserLoginInfoDTO preview = this.demonstrationService.userLogin("wuhu");
        RedisMediationRoomInfoDTO resultObj = preview.getMediationRoomInfo();
        UserLoginNotPasswordRequestDTO requestDTO = new UserLoginNotPasswordRequestDTO();
        requestDTO.setMobilePhone(resultObj.getMobilePhone());
        requestDTO.setCode(preview.getVerificationCode());
        requestDTO.setPersonType(PersonTypeEnum.COMMON);
        LoginInfoResDTO loginInfoResDTO = this.userService.userLoginNotPassword(requestDTO, UserLoginNotPasswordEnum.LOGIN_BY_CODE);
        return this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), resultObj);
    }

    @ApiOperation(value="\u5927\u5c4f\u89c6\u9891\u5217\u8868", notes="\u5927\u5c4f\u89c6\u9891\u5217\u8868")
    @RequestMapping(value={"/meetingList"}, method={RequestMethod.POST})
    public APIResult meetingList(HttpServletRequest request) {
        return APIResult.success((Object)this.demonstrationService.meetingList("wuhu"));
    }

    @ApiOperation(value="\u67e5\u8be2redis\u7f13\u5b58\u67e5\u8be2\u4f1a\u8bae\u9a8c\u8bc1\u7801", notes="\u67e5\u8be2redis\u7f13\u5b58\u67e5\u8be2\u4f1a\u8bae\u9a8c\u8bc1\u7801")
    @RequestMapping(value={"/searchVerificationCodeFromRedis"}, method={RequestMethod.POST})
    public APIResult searchVerificationCodeFromRedis(HttpServletRequest request, @RequestParam String redisKey) {
        this.redisTemplate = this.redisService.getRedisTemplate();
        RedisMediationRoomInfoDTO redisMediationRoomInfoDTO = (RedisMediationRoomInfoDTO)this.redisTemplate.opsForValue().get((Object)redisKey);
        return APIResult.success((Object)redisMediationRoomInfoDTO);
    }

    @ApiOperation(value="\u5220\u9664redis\u7f13\u5b58\u67e5\u8be2\u4f1a\u8bae\u9a8c\u8bc1\u7801", notes="\u5220\u9664redis\u7f13\u5b58\u67e5\u8be2\u4f1a\u8bae\u9a8c\u8bc1\u7801")
    @RequestMapping(value={"/deleteVerificationCodeFromRedis"}, method={RequestMethod.POST})
    public APIResult deleteVerificationCodeFromRedis(HttpServletRequest request, @RequestParam String redisKeyString) {
        String[] redisKeys;
        this.redisTemplate = this.redisService.getRedisTemplate();
        for (String redisKey : redisKeys = redisKeyString.split(",")) {
            this.redisTemplate.delete((Object)redisKey);
        }
        return APIResult.success();
    }
}

