/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.odr.peace.domain.dto.requestdto.CommonIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DocumentConfirmRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.MediationSchemeRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ObjectTypeRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.OfflineDocumentRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ProtocolBookRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SavePromiseBookRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SaveProtocolBookRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationPromiseGetResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.SendProtocolBookResponseDTO;
import com.beiming.odr.peace.service.DocumentService;
import com.beiming.odr.peace.service.UserService;
import com.beiming.odr.peace.service.client.RefuseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/peace/document"})
@Api(value="\u6587\u4e66controller", tags={"\u6587\u4e66controller"})
public class DocumentController {
    @Resource
    private DocumentService documentService;
    @Resource
    private RefuseService refuseService;
    @Resource
    private UserService userService;

    @ApiOperation(value="\u83b7\u53d6\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4\u3001\u7528\u6237\u7aef\u83b7\u53d6\u8c03\u89e3\u65b9\u6848)", notes="\u83b7\u53d6\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4\u3001\u7528\u6237\u7aef\u83b7\u53d6\u8c03\u89e3\u65b9\u6848)")
    @RequestMapping(value={"/getProtocolBook"}, method={RequestMethod.POST})
    public APIResult getProtocolBook(@Valid @RequestBody ProtocolBookRequestDTO dto) {
        return APIResult.success((Object)this.documentService.getProtocolBook(dto));
    }

    @ApiOperation(value="\u8c03\u89e3\u5458\u83b7\u53d6\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848", notes="\u8c03\u89e3\u5458\u83b7\u53d6\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848")
    @RequestMapping(value={"/getMediationSchemeByMediator"}, method={RequestMethod.POST})
    public APIResult getMediationSchemeByMediator(@Valid @RequestBody MediationSchemeRequestDTO dto) {
        return APIResult.success((Object)this.documentService.getMediationSchemeByMediator(dto));
    }

    @ApiOperation(value="\u4fdd\u5b58\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4)", notes="\u4fdd\u5b58\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4)")
    @RequestMapping(value={"/saveProtocolBook"}, method={RequestMethod.POST})
    public APIResult saveProtocolBook(@Valid @RequestBody SaveProtocolBookRequestDTO dto) {
        Long protocolId = this.documentService.saveProtocolBook(dto);
        return APIResult.success((Object)protocolId);
    }

    @ApiOperation(value="\u53d1\u9001\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4)", notes="\u53d1\u9001\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4)", response=SendProtocolBookResponseDTO.class)
    @RequestMapping(value={"/sendProtocolBook"}, method={RequestMethod.POST})
    public APIResult sendProtocolBook(@Valid @RequestBody SaveProtocolBookRequestDTO dto) {
        return APIResult.success((Object)this.documentService.sendProtocolBook(dto));
    }

    @ApiOperation(value="\u62d2\u7edd\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4\u3001\u627f\u8bfa\u4e66\u3001\u7b14\u5f55)", notes="\u62d2\u7edd\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4\u3001\u627f\u8bfa\u4e66\u3001\u7b14\u5f55)", response=Long.class)
    @RequestMapping(value={"/refuseProtocolBook"}, method={RequestMethod.POST})
    public APIResult refuseProtocolBook(@Valid @RequestBody CommonIdRequestDTO dto) {
        return APIResult.success((Object)this.refuseService.refuseProtocolBook(dto.getId()));
    }

    @ApiOperation(value="\u4fdd\u5b58\u627f\u8bfa\u4e66", notes="\u4fdd\u5b58\u627f\u8bfa\u4e66")
    @RequestMapping(value={"/savePromiseBook"}, method={RequestMethod.POST})
    public APIResult savePromiseBook(@Valid @RequestBody SavePromiseBookRequestDTO dto) {
        this.documentService.savePromiseBook(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u83b7\u53d6\u627f\u8bfa\u4e66\u63a5\u53e3", response=MediationPromiseGetResponseDTO.class)
    @RequestMapping(value={"/viewMediationPromise"}, method={RequestMethod.POST})
    public APIResult viewMediationPromise(@RequestBody @Valid ObjectTypeRequestDTO reqDTO) {
        return APIResult.success((Object)this.documentService.viewMediationPromise(reqDTO));
    }

    @ApiOperation(value="\u540c\u610f\u6587\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4\u3001\u627f\u8bfa\u4e66\u3001\u7b14\u5f55)", notes="\u540c\u610f\u6587\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4\u3001\u627f\u8bfa\u4e66\u3001\u7b14\u5f55)", response=String.class)
    @RequestMapping(value={"/agreeProtocolBook"}, method={RequestMethod.POST})
    public APIResult agreeProtocolBook(@Valid @RequestBody DocumentConfirmRequestDTO dto) {
        this.userService.authentication(Long.valueOf(dto.getBizId()));
        String launchSign = this.documentService.launchSignMicro(dto.getDocumentId(), JWTContextUtil.getCurrentUserId(), dto.getIsResign());
        return APIResult.success((Object)launchSign);
    }

    @ApiOperation(value="\u7b14\u5f55\u7ebf\u4e0b\u7b7e\u5b57", notes="\u7b14\u5f55\u7ebf\u4e0b\u7b7e\u5b57", response=Long.class)
    @RequestMapping(value={"/offline"}, method={RequestMethod.POST})
    public APIResult offlineDocument(@Valid @RequestBody OfflineDocumentRequestDTO dto) {
        return APIResult.success((Object)this.refuseService.offlineDocument(dto));
    }
}

