/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.alibaba.fastjson.JSON;
import com.beiming.framework.domain.APIResult;
import com.beiming.odr.peace.domain.dto.requestdto.AddMeetingIntranetRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DownloadRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.IntranetCommonRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.IntranetSendClerkRecordRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SendRtmpRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UpdateMeetingYanChengRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ClerkRecordGetResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.IntranetGetClerkRecordResDTO;
import com.beiming.odr.peace.service.IntranetJiangBeiService;
import com.beiming.odr.peace.service.IntranetService;
import com.beiming.odr.peace.service.IntranetYanChengService;
import com.beiming.odr.user.api.common.utils.SpringContextUtil;
import io.swagger.annotations.Api;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/peace/intranet"})
@RestController
@Api(value="\u5bf9\u63a5\u5185\u7f51controller", tags={"\u5bf9\u63a5\u5185\u7f51"})
public class IntranetController {
    private static final Logger log = LoggerFactory.getLogger(IntranetController.class);
    @Resource
    private IntranetService intranetService;
    @Resource
    private IntranetYanChengService intranetYanChengService;
    @Resource
    private IntranetJiangBeiService intranetJiangBeiService;

    @PostMapping(value={"getClerkRecord"})
    public APIResult getClerkRecordMicro(@RequestBody @Valid IntranetCommonRequestDTO dto) {
        IntranetGetClerkRecordResDTO resultDto = new IntranetGetClerkRecordResDTO();
        ClerkRecordGetResponseDTO result = this.intranetService.getClerkRecord(dto);
        if (result == null) {
            resultDto.setContent(null);
        } else {
            resultDto.setContent(result.getContent());
        }
        return APIResult.success((Object)resultDto);
    }

    @PostMapping(value={"sendClerkRecord"})
    public APIResult sendClerkRecord(@RequestBody @Valid IntranetSendClerkRecordRequestDTO dto) {
        return APIResult.success((Object)this.intranetService.sendClerkRecord(dto));
    }

    @PostMapping(value={"download"})
    public APIResult download(@RequestBody @Valid DownloadRequestDTO dto) {
        log.info("\u5185\u7f51\u4e0b\u8f7d\u7b14\u5f55\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dto));
        return APIResult.success((Object)this.intranetService.download(dto));
    }

    @PostMapping(value={"getLitigantInfo"})
    public APIResult getLitigantInfo(@RequestBody @Valid IntranetCommonRequestDTO dto) {
        String activeProfile = SpringContextUtil.getApplicationContext().getEnvironment().getActiveProfiles()[0];
        return APIResult.success((Object)this.intranetService.getLitigantInfo(dto));
    }

    @PostMapping(value={"signPic"})
    public APIResult signPic(@RequestBody @Valid IntranetCommonRequestDTO dto) {
        return APIResult.success((Object)this.intranetService.signPic(dto));
    }

    @PostMapping(value={"createMediationMeeting"})
    public APIResult createMediationMeeting(@RequestBody AddMeetingIntranetRequestDTO dto) {
        log.info("\u521b\u5efa\u6392\u671f\u5165\u53c2\uff1a{}", (Object)dto.toString());
        this.intranetYanChengService.checkHasCreateIntranetMeeting(dto);
        this.intranetService.createMediationMeeting(dto);
        return APIResult.success();
    }

    @PostMapping(value={"createMediationMeetingYanCheng"})
    public APIResult createMediationMeetingYanCheng(@RequestBody AddMeetingIntranetRequestDTO dto) {
        dto.setRemark("YAN_CHENG");
        this.intranetYanChengService.checkHasCreateMeeting(dto);
        this.intranetService.createMediationMeeting(dto);
        return APIResult.success();
    }

    @PostMapping(value={"getCourtVideotape"})
    public APIResult getCourtVideotape(@RequestBody SendRtmpRequestDTO dto) {
        return APIResult.success((Object)this.intranetYanChengService.getCourtVideotape(dto));
    }

    @PostMapping(value={"sendMsg"})
    public APIResult sendMsg(@RequestBody SendRtmpRequestDTO dto) {
        this.intranetYanChengService.sendMsg(dto);
        return APIResult.success();
    }

    @PostMapping(value={"updateMediationMeeting"})
    public APIResult updateMediationMeeting(@RequestBody UpdateMeetingYanChengRequestDTO dto) {
        return this.intranetYanChengService.updateMediationMeeting(dto);
    }
}

