/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingUserRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomMeetingRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomMeetingUserRequstDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CaseNameRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CheckCaseInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CloseMediationMeetingRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.MediationMeetingListRequestDTO;
import com.beiming.odr.peace.service.MediationMeetingSecondService;
import com.beiming.odr.peace.service.MediationMeetingService;
import com.beiming.odr.peace.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/peace/mediationMeeting"})
@RestController
@Api(value="\u8c03\u89e3\u89c6\u9891controller", tags={"\u8c03\u89e3\u89c6\u9891controller"})
public class MediationMeetingController {
    @Resource
    private MediationMeetingService mediationMeetingService;
    @Resource
    private MediationMeetingSecondService mediationMeetingSecondService;
    @Resource
    private UserService userService;

    @ApiOperation(value="\u65b0\u5efa\u8c03\u89e3\u4f1a\u8bae", notes="\u65b0\u5efa\u8c03\u89e3\u4f1a\u8bae")
    @RequestMapping(value={"/createMediationMeeting"}, method={RequestMethod.POST})
    public APIResult createMediationMeeting(@RequestBody @Valid AddMediationMeetingRequestDTO dto) {
        this.mediationMeetingService.createMediationMeeting(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u6dfb\u52a0\u8c03\u89e3\u89c6\u9891\u4eba\u5458", notes="\u6dfb\u52a0\u8c03\u89e3\u89c6\u9891\u4eba\u5458")
    @RequestMapping(value={"/addMediationMeetingUser"}, method={RequestMethod.POST})
    public APIResult addMediationMeetingUser(@RequestBody @Valid AddMediationMeetingUserRequestDTO dto) {
        this.mediationMeetingService.addMediationMeetingUser(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u5173\u95ed\u89c6\u9891", notes="\u5173\u95ed\u89c6\u9891")
    @RequestMapping(value={"/closeMediationMeeting"}, method={RequestMethod.POST})
    public APIResult closeMediationMeeting(@RequestBody @Valid CloseMediationMeetingRequestDTO dto) {
        this.userService.authentication(Long.valueOf(dto.getMediationRoomId()));
        this.mediationMeetingService.closeMediationMeeting(dto);
        return APIResult.success();
    }

    public APIResult ok(@RequestBody @Valid MediationMeetingListRequestDTO dto) {
        return APIResult.success((Object)this.mediationMeetingService.getMediationMeetingList(dto));
    }

    @ApiOperation(value="\u83b7\u53d6\u8c03\u89e3\u89c6\u9891\u67e5\u770b\u8be6\u60c5", notes="\u83b7\u53d6\u8c03\u89e3\u89c6\u9891\u67e5\u770b\u8be6\u60c5")
    @RequestMapping(value={"/getMediationRoomUserInfoList"}, method={RequestMethod.POST})
    public APIResult getMediationRoomUserInfoList(@RequestBody @Valid CommonIdRequestDTO dto) {
        return APIResult.success((Object)this.mediationMeetingService.getMediationRoomUserInfoList(dto));
    }

    @ApiOperation(value="\u521b\u5efa\u8c03\u89e3\u5ba4\u89c6\u9891\u4f1a\u8bae", notes="\u521b\u5efa\u8c03\u89e3\u5ba4\u89c6\u9891\u4f1a\u8bae")
    @RequestMapping(value={"/addMediationRoomMeeting"}, method={RequestMethod.POST})
    public APIResult addMediationRoomMeeting(@RequestBody @Valid AddMediationRoomMeetingRequestDTO dto) {
        return APIResult.success((Object)this.mediationMeetingService.addMediationRoomMeeting(dto));
    }

    @ApiOperation(value="\u6dfb\u52a0\u8c03\u89e3\u5ba4\u89c6\u9891\u4f1a\u8bae\u4eba\u5458", notes="\u6dfb\u52a0\u8c03\u89e3\u5ba4\u89c6\u9891\u4f1a\u8bae\u4eba\u5458")
    @RequestMapping(value={"/addMediationRoomMeetingUser"}, method={RequestMethod.POST})
    public APIResult addMediationRoomMeetingUser(@RequestBody @Valid AddMediationRoomMeetingUserRequstDTO dto) {
        this.mediationMeetingService.addMediationRoomMeetingUser(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u89c6\u9891\u8bb0\u5f55", notes="\u89c6\u9891\u8bb0\u5f55")
    @RequestMapping(value={"/getVideoList"}, method={RequestMethod.POST})
    public APIResult getVideoList(@RequestBody @Valid CommonIdRequestDTO dto) {
        this.userService.authentication(Long.valueOf(dto.getId()));
        return APIResult.success((Object)this.mediationMeetingService.getVideoList(dto));
    }

    @ApiOperation(value="\u8bed\u97f3\u901a\u8bdd\u8bb0\u5f55", notes="\u8bed\u97f3\u901a\u8bdd\u8bb0\u5f55")
    @RequestMapping(value={"/getVoiceList"}, method={RequestMethod.POST})
    public APIResult getVoiceList(@RequestBody @Valid CommonIdRequestDTO dto) {
        this.userService.authentication(dto.getId());
        return APIResult.success((Object)this.mediationMeetingService.getVoiceList(dto));
    }

    @RequestMapping(value={"getRoomName"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u6848\u4ef6\u540d\u79f0\u662f\u5426\u76f8\u540c", notes="\u67e5\u8be2\u6848\u4ef6\u540d\u79f0\u662f\u5426\u76f8\u540c")
    public APIResult getRoomName(@RequestBody @Valid CaseNameRequestDTO requestDTO, HttpServletRequest request) {
        String userId = JWTContextUtil.getCurrentUserId();
        String type = null;
        Integer name = this.mediationMeetingService.getRoomName(requestDTO, userId);
        if (name > 0) {
            type = "1";
            return APIResult.success((Object)type);
        }
        type = "0";
        return APIResult.success((Object)type);
    }

    @RequestMapping(value={"checkNameAndScheduleId"}, method={RequestMethod.POST})
    @ApiOperation(value="\u68c0\u67e5\u6848\u53f7\u548c\u5ead\u6b21\u662f\u5426\u521b\u5efa\u8fc7\u5ead\u5ba1", notes="\u68c0\u67e5\u6848\u53f7\u548c\u5ead\u6b21\u662f\u5426\u521b\u5efa\u8fc7\u5ead\u5ba1")
    public APIResult checkNameAndScheduleId(@RequestBody @Valid CheckCaseInfoRequestDTO dto) {
        this.mediationMeetingSecondService.checkNameAndScheduleId(dto);
        return APIResult.success();
    }
}

