/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.alibaba.fastjson.JSON;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.FunctionConfigDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingUserRequestMicroDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DeleteMediationMeetingMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.GetCaseInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SendSMAgainRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.AddMediationRoomMeetingResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.GetCaseInfoResponseDTO;
import com.beiming.odr.peace.service.MediationMeetingService;
import com.beiming.odr.peace.service.SendSMAgainService;
import com.beiming.odr.peace.service.UserService;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.referee.api.MediationMeetingRoomApi;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingRoomListReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseRoomInfoResDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/peace/mediationMeetingMicro"})
@RestController
@Api(value="\u5728\u7ebf\u5ead\u5ba1controller", tags={"\u5728\u7ebf\u5ead\u5ba1controller"})
public class MediationMeetingMicroController {
    @Resource
    private MediationMeetingService mediationMeetingService;
    @Resource
    private MediationMeetingRoomApi mediationMeetingRoomApi;
    @Resource
    private SendSMAgainService sendSMAgainService;
    @Resource
    private UserService userService;
    @Resource
    private RedisService redisService;

    @ApiOperation(value="\u65b0\u5efa\u5728\u7ebf\u5ead\u5ba1", notes="\u65b0\u5efa\u5728\u7ebf\u5ead\u5ba1", response=AddMediationRoomMeetingResponseDTO.class)
    @RequestMapping(value={"/createMediationMeetingMicro"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult createMediationMeeting(@RequestBody @Valid AddMediationMeetingMicroRequestDTO dto) {
        AddMediationRoomMeetingResponseDTO responseDTO = this.mediationMeetingService.createMediationMeetingMicro(dto);
        return APIResult.success((Object)responseDTO);
    }

    @ApiOperation(value="\u5728\u7ebf\u5ead\u5ba1\u6dfb\u52a0\u4eba\u5458", notes="\u5728\u7ebf\u5ead\u5ba1\u6dfb\u52a0\u4eba\u5458")
    @RequestMapping(value={"/addMediationMeetingUserMicro"}, method={RequestMethod.POST})
    public APIResult addMediationMeetingUser(@RequestBody @Valid AddMediationMeetingUserRequestMicroDTO dto) {
        this.userService.authentication(dto.getMediationRoomId());
        this.mediationMeetingService.addMediationMeetingUserMicro(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u5728\u7ebf\u5ead\u5ba1", notes="\u903b\u8f91\u5220\u9664\u5728\u7ebf\u5ead\u5ba1")
    @RequestMapping(value={"/deleteMediationMeetingMicro"}, method={RequestMethod.POST})
    public APIResult deleteMediationMeetingMicro(@RequestBody @Valid DeleteMediationMeetingMicroRequestDTO dto) {
        List roomInfos;
        String userName = JWTContextUtil.getCurrentUserName();
        String userId = JWTContextUtil.getCurrentUserId();
        Date holdCourtTime = null;
        MediationMeetingRoomListReqDTO mediationMeetingRoomListReqDTO = new MediationMeetingRoomListReqDTO();
        mediationMeetingRoomListReqDTO.setUserId(Long.valueOf(userId));
        if (userName != null) {
            dto.setUserName(userName);
        }
        if ((roomInfos = this.mediationMeetingRoomApi.queryType("", dto.getBizRoomId())).size() < 1) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.UNEXCEPTED, (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        for (CaseRoomInfoResDTO caseRoomInfoResDTO : roomInfos) {
            if (Long.parseLong(userId) != caseRoomInfoResDTO.getCreatorId()) {
                AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.UNEXCEPTED, (String)"\u60a8\u4e0d\u662f\u8be5\u5ead\u5ba1\u6848\u4ef6\u7684\u521b\u5efa\u4eba\uff0c\u4e0d\u80fd\u5220\u9664\u8be5\u6848\u4ef6");
            }
            if (caseRoomInfoResDTO.getRoomStatus().equals("RUNNING")) {
                AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.UNEXCEPTED, (String)"\u5ead\u5ba1\u8fdb\u884c\u4e2d\uff0c\u4e0d\u53ef\u5220\u9664");
            }
            if (caseRoomInfoResDTO.getRoomStatus().equals("INIT")) {
                if (caseRoomInfoResDTO.getOrderTime() != null) {
                    holdCourtTime = caseRoomInfoResDTO.getOrderTime();
                }
                if (caseRoomInfoResDTO.getLastMessageTime() != null) {
                    holdCourtTime = caseRoomInfoResDTO.getLastMessageTime();
                }
                if (holdCourtTime.getTime() < System.currentTimeMillis()) {
                    AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.UNEXCEPTED, (String)"\u5ead\u5ba1\u8fdb\u884c\u4e2d\uff0c\u4e0d\u53ef\u5220\u9664");
                }
            }
            if (!caseRoomInfoResDTO.getRoomStatus().equals("START")) continue;
            mediationMeetingRoomListReqDTO.setMediationStatus("RUNNING");
            mediationMeetingRoomListReqDTO.setParentId(Long.valueOf(dto.getBizRoomId()));
            DubboResult resulta = this.mediationMeetingRoomApi.getMediationMeetingRoomList(mediationMeetingRoomListReqDTO);
            AssertUtils.assertTrue((boolean)resulta.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)resulta.getMessage());
            if (((ArrayList)resulta.getData()).size() <= 0) continue;
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.UNEXCEPTED, (String)"\u5ead\u5ba1\u8fdb\u884c\u4e2d\uff0c\u4e0d\u53ef\u5220\u9664");
        }
        this.mediationMeetingService.deleteMediationRoomMeeting(dto);
        return APIResult.success((Object)"OK$\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u6848\u4ef6\u4fe1\u606f", notes="\u83b7\u53d6\u6848\u4ef6\u4fe1\u606f", response=GetCaseInfoResponseDTO.class)
    @RequestMapping(value={"/getCaseInfo"}, method={RequestMethod.POST})
    public APIResult getCaseInfo(@RequestBody @Valid GetCaseInfoRequestDTO dto) {
        return APIResult.success((Object)this.mediationMeetingService.getCaseInfo(dto));
    }

    @ApiOperation(value="\u83b7\u53d6\u4e8c\u7ef4\u7801", notes="\u83b7\u53d6\u4e8c\u7ef4\u7801")
    @RequestMapping(value={"/queryEwm"}, method={RequestMethod.POST})
    public String queryEwm(HttpServletRequest request) {
        String appName = request.getHeader("appName");
        return this.mediationMeetingService.queryEwm(appName);
    }

    @ApiOperation(value="\u91cd\u53d1\u5728\u7ebf\u5ead\u5ba1\u9a8c\u8bc1\u7801", notes="\u91cd\u53d1\u5728\u7ebf\u5ead\u5ba1\u9a8c\u8bc1\u7801", response=SendSMAgainRequestDTO.class)
    @RequestMapping(value={"/sendSMAgain"}, method={RequestMethod.POST})
    public APIResult sendSMAgain(@RequestBody @Valid SendSMAgainRequestDTO dto) {
        this.userService.authentication(dto.getBizRoomId());
        return APIResult.success((Object)this.sendSMAgainService.sendMediationMeetingSmS(dto));
    }

    @ApiOperation(value="\u8bbe\u7f6e\u6392\u671f\u529f\u80fd\u5f00\u542f\u914d\u7f6e\uff08\u5185\u90e8\u4f7f\u7528\uff09", notes="\u83b7\u53d6\u6392\u671f\u529f\u80fd\u5f00\u542f\u914d\u7f6e\uff08\u5185\u90e8\u4f7f\u7528\uff09")
    @RequestMapping(value={"/setFunctionConfig"}, method={RequestMethod.POST})
    public APIResult setFunctionConfig(@RequestBody @Valid FunctionConfigDTO reqDTO) {
        this.redisService.set((RedisKey)RedisKeyEnums.FUNCTION_CONFIG, (Object)JSON.toJSONString((Object)reqDTO));
        return APIResult.success();
    }

    @ApiOperation(value="\u83b7\u53d6\u6392\u671f\u529f\u80fd\u5f00\u542f\u914d\u7f6e", notes="\u83b7\u53d6\u6392\u671f\u529f\u80fd\u5f00\u542f\u914d\u7f6e")
    @RequestMapping(value={"/getFunctionConfig"}, method={RequestMethod.GET})
    public APIResult getFunctionConfig() {
        String configStr = (String)this.redisService.get((RedisKey)RedisKeyEnums.FUNCTION_CONFIG);
        FunctionConfigDTO respDTO = null;
        if (StringUtils.isEmpty((CharSequence)configStr)) {
            respDTO = new FunctionConfigDTO();
            respDTO.setCreateCase(Integer.valueOf(1));
            respDTO.setCreateMeeting(Integer.valueOf(1));
        } else {
            respDTO = (FunctionConfigDTO)JSON.parseObject((String)configStr, FunctionConfigDTO.class);
        }
        return APIResult.success((Object)respDTO);
    }
}

