/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.odr.peace.common.enums.PeaceRedisKeyEnums;
import com.beiming.odr.peace.comparator.CaseObj;
import com.beiming.odr.peace.comparator.CaseObjComparetor;
import com.beiming.odr.peace.controller.RandomValue;
import com.beiming.odr.peace.controller.UpdateTemplateDataRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MessageResponseDTO;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/peace/templateData"})
@Api(value="\u6a21\u677f\u6570\u636econtroller", tags={"\u6a21\u677f\u6570\u636econtroller"})
public class TemplateDataController {
    @Resource
    RedisService redis;
    private String hashkey = "hashkey";

    @RequestMapping(value={"/queryData"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u6570\u636e", notes="\u67e5\u8be2\u6570\u636e", responseContainer="List", response=CaseObj.class)
    public Object queryData(@RequestBody CaseObj request) {
        HashMap map = (HashMap)this.redis.hGet((RedisKey)PeaceRedisKeyEnums.SHORT_URL1, this.hashkey);
        Collection values = map.values();
        ArrayList list2 = Lists.newArrayList(values);
        String id = request.getId();
        String status = request.getStatus();
        String caseStatus = request.getCaseStatus();
        if (StringUtils.isNotBlank((CharSequence)request.getId())) {
            return APIResult.success(map.get(id));
        }
        ArrayList list = this.queryByStatus(list2, status);
        list = this.queryByCaseStatus(list, caseStatus);
        list = this.queryByRole(list, request.getRole());
        list = this.queryByCo(list, request.getCo());
        list = this.queryByAcceptCo(list, request.getAcceptCo());
        list = this.queryByMediator(list, request.getMediator());
        this.sort(list);
        return APIResult.success((Object)list);
    }

    private void sort(ArrayList<CaseObj> list) {
        if (list.isEmpty()) {
            return;
        }
        list.sort((Comparator<CaseObj>)new CaseObjComparetor());
        Collections.reverse(list);
    }

    private ArrayList<CaseObj> queryByMediator(ArrayList<CaseObj> values, String mediator) {
        ArrayList newList = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)mediator)) {
            return values;
        }
        for (CaseObj caseObj : values) {
            if (!StringUtils.isNotBlank((CharSequence)mediator) || !mediator.equals(caseObj.getMediator())) continue;
            newList.add(caseObj);
        }
        return newList;
    }

    private ArrayList<CaseObj> queryByRole(ArrayList<CaseObj> values, String role) {
        ArrayList newList = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)role)) {
            return values;
        }
        for (CaseObj caseObj : values) {
            if (!StringUtils.isNotBlank((CharSequence)role) || !role.equals(caseObj.getRole())) continue;
            newList.add(caseObj);
        }
        return newList;
    }

    private ArrayList<CaseObj> queryByStatus(ArrayList<CaseObj> values, String status) {
        ArrayList newList = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)status)) {
            return values;
        }
        for (CaseObj caseObj : values) {
            if (!StringUtils.isNotBlank((CharSequence)status) || !status.equals(caseObj.getStatus())) continue;
            newList.add(caseObj);
        }
        return newList;
    }

    private ArrayList<CaseObj> queryByCaseStatus(ArrayList<CaseObj> values, String caseStatus) {
        ArrayList newList = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)caseStatus)) {
            return values;
        }
        for (CaseObj caseObj : values) {
            if (!StringUtils.isNotBlank((CharSequence)caseStatus) || !caseStatus.equals(caseObj.getCaseStatus())) continue;
            newList.add(caseObj);
        }
        return newList;
    }

    private ArrayList<CaseObj> queryByAcceptCo(ArrayList<CaseObj> values, String acceptCo) {
        ArrayList newList = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)acceptCo)) {
            return values;
        }
        for (CaseObj caseObj : values) {
            if (!StringUtils.isNotBlank((CharSequence)acceptCo) || !acceptCo.equals(caseObj.getAcceptCo())) continue;
            newList.add(caseObj);
        }
        return newList;
    }

    private ArrayList<CaseObj> queryByCo(ArrayList<CaseObj> values, String co) {
        ArrayList newList = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)co)) {
            return values;
        }
        for (CaseObj caseObj : values) {
            if (!StringUtils.isNotBlank((CharSequence)co) || !co.equals(caseObj.getCo())) continue;
            newList.add(caseObj);
        }
        return newList;
    }

    @RequestMapping(value={"/updateData"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u66f4\u65b0", notes="\u66f4\u65b0")
    public Object updateData(@RequestBody @Valid UpdateTemplateDataRequestDTO dto) {
        HashMap map = (HashMap)this.redis.hGet((RedisKey)PeaceRedisKeyEnums.SHORT_URL1, this.hashkey);
        List list = dto.getCases();
        for (CaseObj caseObj : list) {
            map.put(caseObj.getId(), caseObj);
        }
        this.redis.hSet((RedisKey)PeaceRedisKeyEnums.SHORT_URL1, this.hashkey, (Object)map);
        return APIResult.success();
    }

    @RequestMapping(value={"/initData"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u5355\u804a\u8bb0\u5f551", notes="\u67e5\u8be2\u5355\u804a\u8bb0\u5f551", responseContainer="List", response=MessageResponseDTO.class)
    public Object initData() {
        HashMap<String, CaseObj> map = new HashMap<String, CaseObj>();
        int startId = 1001;
        int startNo = 18276001;
        for (int i = 0; i < 11; ++i) {
            String id = startId + "";
            CaseObj caseObj1 = new CaseObj(id, startNo + "", this.getCo(), "", "\u5e7f\u5dde\u4e92\u8054\u7f51\u6cd5\u9662", this.getName(), this.getDate(), "\u5e73\u53f0\u7ba1\u7406\u5458", "\u5f85\u5206\u914d", "\u672a\u5f00\u59cb", this.getCaseType(), "", "", "");
            ++startId;
            ++startNo;
            map.put(id, caseObj1);
        }
        CaseObj caseObj1 = new CaseObj(++startId + "", ++startNo + "", "\u817e\u8baf", "", "\u5e7f\u5dde\u4e92\u8054\u7f51\u6cd5\u9662", "\u6797\u5146\u56e2", this.getDate(), "\u5e73\u53f0\u8c03\u89e3\u5458", "\u59d4\u6258\u8c03\u89e3", "\u6b63\u5728\u8c03\u89e3", "\u6d88\u8d39\u7ef4\u6743", "\u738b\u745e\u76c8", "", "");
        map.put(startId + "", caseObj1);
        CaseObj caseObj2 = new CaseObj(++startId + "", ++startNo + "", "\u817e\u8baf", "", "\u5e7f\u5dde\u4e92\u8054\u7f51\u6cd5\u9662", "\u6797\u5146\u56e2", this.getDate(), "\u5e73\u53f0\u8c03\u89e3\u5458", "\u59d4\u6258\u8c03\u89e3", "\u6b63\u5728\u8c03\u89e3", "\u6d88\u8d39\u7ef4\u6743", "\u738b\u745e\u76c8", "", "");
        map.put(startId + "", caseObj2);
        CaseObj caseObj3 = new CaseObj(++startId + "", ++startNo + "", "\u817e\u8baf", "", "\u5e7f\u5dde\u4e92\u8054\u7f51\u6cd5\u9662", this.getName(), this.getDate(), "\u5e73\u53f0\u7ba1\u7406\u5458", "\u8fd4\u56de\u6cd5\u9662", "\u8c03\u89e3\u6210\u529f", "\u6d88\u8d39\u7ef4\u6743", "", "", "");
        map.put(startId + "", caseObj3);
        CaseObj caseObj4 = new CaseObj(++startId + "", ++startNo + "", "\u4eac\u4e1c", "", "\u5e7f\u5dde\u4e92\u8054\u7f51\u6cd5\u9662", this.getName(), this.getDate(), "\u5e73\u53f0\u7ba1\u7406\u5458", "\u8fd4\u56de\u6cd5\u9662", "\u8c03\u89e3\u6210\u529f", "\u6d88\u8d39\u7ef4\u6743", "", "", "");
        map.put(startId + "", caseObj4);
        this.redis.hSet((RedisKey)PeaceRedisKeyEnums.SHORT_URL1, this.hashkey, map);
        return map;
    }

    private String getName() {
        return RandomValue.getChineseName();
    }

    private String getCo() {
        return RandomValue.getCo();
    }

    private String getDate() {
        return RandomValue.getRandomDate();
    }

    private String getCaseStatus() {
        return RandomValue.getRandomCaseStatus();
    }

    private String getCaseType() {
        return RandomValue.getRandomCaseType();
    }

    private String getStatus() {
        return RandomValue.getRandomStatus();
    }
}

