/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.MyHttpClientUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.service.backend.user.DictionaryService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/peace/weChat"})
public class TestWeChatController {
    private static final Logger log = LoggerFactory.getLogger(TestWeChatController.class);
    @Resource
    private RedisService redisService;
    @Resource
    private DictionaryService dictionaryService;
    private RedisTemplate redisTemplate;
    private static final String TEST_REDIS_KEY = "WEITINGSHEN_TEST_REDIS_KEY";

    @RequestMapping(value={"/getAccessToken"}, method={RequestMethod.POST})
    public String getAccessToken() {
        this.redisTemplate = this.redisService.getRedisTemplate();
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)TEST_REDIS_KEY);
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            return accessToken;
        }
        String appName = AppNameContextHolder.getAppName();
        String appId = this.dictionaryService.getDictionaryValue(appName + ".appId");
        String secret = this.dictionaryService.getDictionaryValue(appName + ".appSecret");
        try {
            String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + appId + "&secret=" + secret;
            log.info("\u8c03\u7528\u63a5\u53e3\u5730\u5740{}", (Object)url);
            String jsonStr = MyHttpClientUtils.sendHttpsGet((String)url);
            log.info("access_token\u63a5\u53e3\u8fd4\u56de{}", (Object)jsonStr);
            JSONObject json = JSONObject.parseObject((String)jsonStr);
            if (json != null && StringUtils.isNotBlank((CharSequence)json.getString("access_token"))) {
                accessToken = json.getString("access_token");
                this.redisTemplate.opsForValue().set((Object)TEST_REDIS_KEY, (Object)accessToken, 115L, TimeUnit.MINUTES);
            } else {
                AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u83b7\u53d6Access_Token\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u83b7\u53d6Access_Token\u5f02\u5e38");
        }
        return accessToken;
    }
}

