/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.odr.peace.annotation.ExtrAccessAnnotation;
import com.beiming.odr.peace.domain.dto.requestdto.ThirdPartyAhRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ThirdPartyGetUserIdEequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ThirdPartyJoinRoomRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ThirdPartyLitigantRtcInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ThirdPartyRTCInfoResquestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ThirdPartyThirdCaseIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ThirdPatryCommonRoomIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ThirdPendScheduleCaseNumRequestDTO;
import com.beiming.odr.peace.im.api.dto.request.RecordLiveRequestDTO;
import com.beiming.odr.peace.service.ThirdPartyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/peace/thirdParty"})
@Api(value="\u7b2c\u4e09\u65b9\u63a5\u53e3controller", tags={"\u7b2c\u4e09\u65b9\u63a5\u53e3controller"})
public class ThirdPartyController {
    @Resource
    private ThirdPartyService thirdPartyService;

    @ApiOperation(value="\u83b7\u53d6\u623f\u95f4id\u63a5\u53e3(\u5bf9\u63a5\u534e\u590f)", notes="\u83b7\u53d6\u623f\u95f4id\u63a5\u53e3(\u6682\u65f6\u4e0d\u7528)")
    @RequestMapping(value={"/getRoomId"}, method={RequestMethod.POST})
    public APIResult getRoomId(@Valid @RequestBody ThirdPartyAhRequestDTO dto) {
        return APIResult.success((Object)this.thirdPartyService.thirdPartyGetRoomId(dto.getAh()));
    }

    @ApiOperation(value="\u83b7\u53d6\u521b\u5efa\u6cd5\u5b98RTC\u4fe1\u606f\u63a5\u53e3(\u5bf9\u63a5\u534e\u590f)", notes="\u83b7\u53d6\u521b\u5efa\u6cd5\u5b98RTC\u4fe1\u606f\u63a5\u53e3")
    @RequestMapping(value={"/getRtcInfo"}, method={RequestMethod.POST})
    public APIResult getRTCInfo(@Valid @RequestBody ThirdPartyRTCInfoResquestDTO dto) {
        return APIResult.success((Object)this.thirdPartyService.thirdPartyRTCInfo(dto));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u4e8b\u4ebaRTC\u4fe1\u606f\u63a5\u53e3(\u5bf9\u63a5\u534e\u590f)", notes="\u83b7\u53d6\u5f53\u4e8b\u4ebaRTC\u4fe1\u606f\u63a5\u53e3")
    @RequestMapping(value={"/getLitigantRtcInfo"}, method={RequestMethod.POST})
    public APIResult getLitigantRtcInfo(@Valid @RequestBody ThirdPartyLitigantRtcInfoRequestDTO dto) {
        return APIResult.success((Object)this.thirdPartyService.thirdPartyLitigantRtcInfo(dto));
    }

    @ApiOperation(value="\u6839\u636e\u623f\u95f4id\u83b7\u53d6\u6210\u5458\u4fe1\u606f\u63a5\u53e3(\u5bf9\u63a5\u534e\u590f)", notes="\u6839\u636e\u623f\u95f4id\u83b7\u53d6\u6210\u5458\u4fe1\u606f\u63a5\u53e3")
    @RequestMapping(value={"/getMemberInfo"}, method={RequestMethod.POST})
    public APIResult getMemberInfo(@Valid @RequestBody ThirdPatryCommonRoomIdRequestDTO dto) {
        return APIResult.success((Object)this.thirdPartyService.thirdPartygetUsers(dto));
    }

    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u83b7\u53d6userId\u63a5\u53e3(\u5bf9\u63a5\u534e\u590f)", notes="\u6839\u636e\u624b\u673a\u53f7\u83b7\u53d6userId\u63a5\u53e3")
    @RequestMapping(value={"/getUserId"}, method={RequestMethod.POST})
    public APIResult getUserId(@Valid @RequestBody ThirdPartyGetUserIdEequestDTO dto) {
        return APIResult.success((Object)this.thirdPartyService.thirdPartyGetUserId(dto));
    }

    @ApiOperation(value="\u6839\u636e\u771f\u5b9e\u623f\u95f4id\u83b7\u53d6\u6210\u5458\u4fe1\u606f\u63a5\u53e3(\u5bf9\u63a5\u6d77\u5eb7)", notes="\u6839\u636e\u771f\u5b9e\u623f\u95f4id\u83b7\u53d6\u6210\u5458\u4fe1\u606f\u63a5\u53e3")
    @RequestMapping(value={"/getLitigantInfo"}, method={RequestMethod.POST})
    public APIResult getLitigantInfo(@Valid @RequestBody ThirdPatryCommonRoomIdRequestDTO dto) {
        return APIResult.success((Object)this.thirdPartyService.thirdPartyGetRoomMembers(dto));
    }

    @ApiOperation(value="\u51c6\u5907\u89c6\u9891\u5ead\u5ba1\u63a5\u53e3\u63a5\u53e3(\u5bf9\u63a5\u9655\u897f)", notes="\u751f\u6210\u623f\u95f4\u63a8\u62c9\u6d41\u4fe1\u606f\u63a5\u53e3")
    @RequestMapping(value={"/readyForCourtById"}, method={RequestMethod.POST})
    public APIResult readyForCourtById(@Valid @RequestBody ThirdPartyThirdCaseIdRequestDTO dto) {
        return APIResult.success((Object)this.thirdPartyService.thirdPartyLiveUrl(dto));
    }

    @ApiOperation(value="\u7b2c\u4e09\u65b9\u7528\u6237\u52a0\u5165\u623f\u95f4\u63a5\u53e3(\u5bf9\u63a5\u9655\u897f)", notes="\u7b2c\u4e09\u65b9\u7528\u6237\u52a0\u5165\u623f\u95f4\u63a5\u53e3")
    @RequestMapping(value={"/join"}, method={RequestMethod.POST})
    public APIResult thirdPartyJoinRoom(@Valid @RequestBody ThirdPartyJoinRoomRequestDTO dto) {
        this.thirdPartyService.joinRoom(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u623f\u95f4\u5728\u7ebf\u6210\u5458\u63a5\u53e3(\u5bf9\u63a5\u9655\u897f)", notes="\u67e5\u8be2\u623f\u95f4\u5728\u7ebf\u6210\u5458\u63a5\u53e3")
    @RequestMapping(value={"/onLineMember"}, method={RequestMethod.POST})
    public APIResult getOnLineMember(@Valid @RequestBody ThirdPatryCommonRoomIdRequestDTO dto) {
        return APIResult.success((Object)this.thirdPartyService.getOnLineMember(dto));
    }

    @ApiOperation(value="rtmp\u6df7\u6d41\u63a5\u53e3(\u5bf9\u63a5\u9655\u897f)", notes="rtmp\u6df7\u6d41\u63a5\u53e3")
    @RequestMapping(value={"/startMixedFlow"}, method={RequestMethod.POST})
    public APIResult startMixedFlow(@RequestBody RecordLiveRequestDTO dto) {
        return APIResult.success((Object)this.thirdPartyService.startMixedFlow(dto));
    }

    @ApiOperation(value="\u7b2c\u4e09\u65b9\u83b7\u53d6token", notes="\u7b2c\u4e09\u65b9\u83b7\u53d6token")
    @GetMapping(value={"/token"})
    @ResponseBody
    @ExtrAccessAnnotation(verifyToken=false)
    public APIResult getThirdPartyToken(HttpServletRequest request) {
        String appId = request.getHeader("appid");
        return APIResult.success((Object)this.thirdPartyService.getToken(appId));
    }

    @ApiOperation(value="\u6d77\u5357\u56fd\u5546\u5bf9\u63a5", notes="\u6d77\u5357\u56fd\u5546\u5bf9\u63a5")
    @RequestMapping(value={"obtainCertificate"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    @ExtrAccessAnnotation(verifySign=false)
    public APIResult obtainCertificate(String params, HttpServletRequest request) {
        return APIResult.success((Object)this.thirdPartyService.obtainCertificate(params, request));
    }

    @ApiOperation(value="\u6d77\u5357\u56fd\u5546\u5c0f\u7a0b\u5e8f\u5bf9\u63a5", notes="\u6d77\u5357\u56fd\u5546\u5c0f\u7a0b\u5e8f\u5bf9\u63a5")
    @RequestMapping(value={"obtainCertificateWeChat"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    @ExtrAccessAnnotation(verifySign=false)
    public APIResult obtainCertificateWeChat(String params, HttpServletRequest request) {
        return APIResult.success((Object)this.thirdPartyService.obtainCertificateWeChat(params, request));
    }

    @ApiOperation(value="\u6d77\u5357\u56fd\u5546\u5bf9\u63a5\u5ead\u5ba1\u5f85\u6392\u671f\u6848\u4ef6\u6570\u91cf", notes="\u6d77\u5357\u56fd\u5546\u5bf9\u63a5\u5ead\u5ba1\u5f85\u6392\u671f\u6848\u4ef6\u6570\u91cf")
    @RequestMapping(value={"/pendScheduleCaseNum"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public APIResult pendScheduleCaseNum(@RequestBody @Valid ThirdPendScheduleCaseNumRequestDTO dto) {
        return APIResult.success((Object)this.thirdPartyService.pendScheduleCaseNum(dto));
    }

    public ThirdPartyService getThirdPartyService() {
        return this.thirdPartyService;
    }

    public void setThirdPartyService(ThirdPartyService thirdPartyService) {
        this.thirdPartyService = thirdPartyService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThirdPartyController)) {
            return false;
        }
        ThirdPartyController other = (ThirdPartyController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ThirdPartyService this$thirdPartyService = this.getThirdPartyService();
        ThirdPartyService other$thirdPartyService = other.getThirdPartyService();
        return !(this$thirdPartyService == null ? other$thirdPartyService != null : !this$thirdPartyService.equals(other$thirdPartyService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThirdPartyController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ThirdPartyService $thirdPartyService = this.getThirdPartyService();
        result = result * 59 + ($thirdPartyService == null ? 43 : $thirdPartyService.hashCode());
        return result;
    }

    public String toString() {
        return "ThirdPartyController(thirdPartyService=" + this.getThirdPartyService() + ")";
    }
}

