/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.utils.sm4.SM4Utils;
import com.beiming.odr.peace.domain.dto.requestdto.AddVisitSystemAppointmentRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddVisitSystemJudgeRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AppointDetailReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AppointManagementListReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AppointOrgJudgeReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AppointRefusedReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonUserLoginByMobileRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.RealNameAuthenticationRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.RefreshTokenRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.VisitSystemCancelAppointmentReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.VisitSystemJudgeStatusReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.VisitSystemJudgeUserReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.VisitSystemMyAppointmentReqDTO;
import com.beiming.odr.peace.domain.dto.responsedto.LoginTokenResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.RefreshTokenResponseDTO;
import com.beiming.odr.peace.security.TokenGenerator;
import com.beiming.odr.peace.service.VisitorSystemService;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.peace.service.util.Base64Utils;
import com.beiming.odr.peace.service.util.LoginErrorCountUtil;
import com.beiming.odr.user.api.UserServiceApi;
import com.beiming.odr.user.api.common.utils.CommonPasswordValidateUtil;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.VisitorSystemUserLoginReqDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/peace/visitorSystem"})
@RestController
@Api(value="\u4e1c\u6e56\u8bbf\u5ba2\u9884\u7ea6\u7cfb\u7edfcontroller", tags={"\u4e1c\u6e56\u8bbf\u5ba2\u9884\u7ea6\u7cfb\u7edfcontroller"})
public class VisitorSystemController {
    private static final Logger log = LoggerFactory.getLogger(VisitorSystemController.class);
    @Resource
    private VisitorSystemService visitorSystemService;
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private TokenGenerator tokenGenerator;
    @Resource
    private RedisService redisService;
    @Resource
    private LoginErrorCountUtil loginErrorCountUtil;

    @ApiOperation(value="\u65b0\u589e\u9884\u7ea6\u7533\u8bf7", notes="\u65b0\u589e\u9884\u7ea6\u7533\u8bf7")
    @RequestMapping(value={"/addApplyCaseUser"}, method={RequestMethod.POST})
    public APIResult addApplyCaseUser(@RequestBody @Valid AddVisitSystemAppointmentRequestDTO dto) {
        try {
            return APIResult.success((Object)this.visitorSystemService.addVisitorSystemCase(dto));
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u9884\u7ea6\u7533\u8bf7\u529f\u80fd\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/setRealNameAndFacialVerify"}, method={RequestMethod.POST})
    @ApiOperation(value="\u8bbe\u7f6e\u5b9e\u540d\u8ba4\u8bc1\u548c\u4eba\u8138\u8bc6\u522b", notes="\u8bbe\u7f6e\u5b9e\u540d\u8ba4\u8bc1\u548c\u4eba\u8138\u8bc6\u522b")
    public APIResult setRealNameAndFacialVerify(@RequestBody @Valid RealNameAuthenticationRequestDTO realNameAuthenticationRequestDTO, HttpServletRequest request) {
        try {
            String cType = request.getHeader("cType");
            log.info("cType\u503c\u4e3a{}", (Object)cType);
            UserInfoDTO userInfoDTO = this.visitorSystemService.setRealNameAndFacialVerify(realNameAuthenticationRequestDTO);
            VisitorSystemUserLoginReqDTO reqDTO = new VisitorSystemUserLoginReqDTO();
            reqDTO.setUserId(userInfoDTO.getUserId().toString());
            DubboResult loginResult = this.userServiceApi.visitorSystemLoginInfo(reqDTO);
            AssertUtils.assertTrue((boolean)loginResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)loginResult.getMessage());
            LoginInfoResDTO data = (LoginInfoResDTO)loginResult.getData();
            log.info("LoginInfoResDTO\u503c\u4e3a{}", (Object)data);
            LoginTokenResponseDTO loginTokenResponseDTO = this.tokenGenerator.visitorSystemGenerateLoginToken(data, cType);
            JSONObject json = new JSONObject();
            json.put("token", (Object)loginTokenResponseDTO.getAuthToken());
            loginTokenResponseDTO.setAuthToken("");
            loginTokenResponseDTO.setRefreshToken("");
            String jsonString = JSON.toJSONString((Object)loginTokenResponseDTO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            JSON.toJSONString((Object)jsonString, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            log.info("===============s=========================" + jsonString);
            json.put("info", (Object)SM4Utils.encryptDataCbc((String)jsonString));
            log.info(loginTokenResponseDTO.toString());
            return APIResult.success((Object)json.toJSONString());
        }
        catch (Exception e) {
            log.error("\u8eab\u4efd\u8ba4\u8bc1\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/refreshToken"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5237\u65b0token", notes="\u5237\u65b0token")
    public RefreshTokenResponseDTO refreshToken(@RequestBody @Valid RefreshTokenRequestDTO dto) {
        return this.tokenGenerator.visitorSystemRefreshToken(dto.getRefreshToken());
    }

    @RequestMapping(value={"/verifyExpiration"}, method={RequestMethod.POST})
    @ApiOperation(value="\u662f\u5426\u9a8c\u8bc1")
    public APIResult verifyExpiration(@RequestBody @Valid RealNameAuthenticationRequestDTO realNameAuthenticationRequestDTO) {
        try {
            Long userId = Long.parseLong(JWTContextUtil.getCurrentUserId());
            return APIResult.success((Object)this.visitorSystemService.verifyExpiration(userId, realNameAuthenticationRequestDTO));
        }
        catch (Exception e) {
            log.error("\u786e\u8ba4\u9a8c\u8bc1\u529f\u80fd\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/caseList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6848\u4ef6\u67e5\u8be2(\u5305\u542b\u6848\u4ef6\u4fe1\u606f\u3001\u5ead\u5ba1\u6392\u671f\u3001\u7ebf\u4e0b\u8c03\u89e3)")
    public APIResult caseList(@RequestBody @Valid RealNameAuthenticationRequestDTO realNameAuthenticationRequestDTO) {
        try {
            return APIResult.success((Object)this.visitorSystemService.caseList(realNameAuthenticationRequestDTO));
        }
        catch (Exception e) {
            log.error("\u8bbf\u5ba2\u9884\u7ea6\u7cfb\u7edf\u5f53\u4e8b\u4eba\u6848\u4ef6\u67e5\u8be2\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/caseScheduleList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5ead\u5ba1\u6392\u671f\u5217\u8868")
    public APIResult caseScheduleList(@RequestBody @Valid RealNameAuthenticationRequestDTO realNameAuthenticationRequestDTO) {
        try {
            return APIResult.success((Object)this.visitorSystemService.caseScheduleList(realNameAuthenticationRequestDTO));
        }
        catch (Exception e) {
            log.error("\u8bbf\u5ba2\u9884\u7ea6\u7cfb\u7edf\u5ead\u5ba1\u6392\u671f\u5217\u8868\u67e5\u8be2\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/caseMediationList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7ebf\u4e0b\u8c03\u89e3\u5217\u8868")
    public APIResult caseMediationList(@RequestBody @Valid RealNameAuthenticationRequestDTO realNameAuthenticationRequestDTO) {
        try {
            return APIResult.success((Object)this.visitorSystemService.caseMediationList(realNameAuthenticationRequestDTO));
        }
        catch (Exception e) {
            log.error("\u8bbf\u5ba2\u9884\u7ea6\u7cfb\u7edf\u7ebf\u4e0b\u8c03\u89e3\u5217\u8868\u67e5\u8be2\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/caseInfoList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6848\u4ef6\u4fe1\u606f\u5217\u8868")
    public APIResult caseInfoList(@RequestBody @Valid RealNameAuthenticationRequestDTO realNameAuthenticationRequestDTO) {
        try {
            return APIResult.success((Object)this.visitorSystemService.caseInfoList(realNameAuthenticationRequestDTO));
        }
        catch (Exception e) {
            log.error("\u8bbf\u5ba2\u9884\u7ea6\u7cfb\u7edf\u6848\u4ef6\u4fe1\u606f\u67e5\u8be2\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/myAppointmentList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6211\u7684\u9884\u7ea6\u5217\u8868")
    public APIResult myAppointmentList(@RequestBody @Valid VisitSystemMyAppointmentReqDTO reqDTO) {
        try {
            String userId = JWTContextUtil.getJWTAuthentication().getUserId();
            return APIResult.success((Object)this.visitorSystemService.myAppointList(userId, reqDTO));
        }
        catch (Exception e) {
            log.error("\u6211\u7684\u9884\u7ea6\u5217\u8868\u67e5\u8be2\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/cancelAppointment"}, method={RequestMethod.POST})
    @ApiOperation(value="\u53d6\u6d88\u9884\u7ea6")
    public APIResult cancelAppointment(@RequestBody @Valid VisitSystemCancelAppointmentReqDTO reqDTO) {
        try {
            String userId = JWTContextUtil.getJWTAuthentication().getUserId();
            return APIResult.success((Object)this.visitorSystemService.cancelAppointment(userId, reqDTO));
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u540c\u884c\u4eba\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/appointManagementList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u9884\u7ea6\u7ba1\u7406\u5217\u8868")
    public APIResult appointManagementList(@RequestBody @Valid AppointManagementListReqDTO reqDTO) {
        try {
            return APIResult.success((Object)this.visitorSystemService.appointManagementList(reqDTO));
        }
        catch (Exception e) {
            log.error("\u9884\u7ea6\u7ba1\u7406\u5217\u8868\u67e5\u8be2\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/appointDetail"}, method={RequestMethod.POST})
    @ApiOperation(value="\u9884\u7ea6\u8be6\u60c5")
    public APIResult appointDetail(@RequestBody @Valid AppointDetailReqDTO reqDTO) {
        try {
            return APIResult.success((Object)this.visitorSystemService.appointDetail(reqDTO));
        }
        catch (Exception e) {
            log.error("\u9884\u7ea6\u8be6\u60c5\u67e5\u8be2\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/confirmedAppoint"}, method={RequestMethod.POST})
    @ApiOperation(value="\u51c6\u5165\u6cd5\u9662")
    public APIResult confirmedAppoint(@RequestBody @Valid AppointDetailReqDTO reqDTO) {
        try {
            return APIResult.success((Object)this.visitorSystemService.confirmedAppoint(reqDTO));
        }
        catch (Exception e) {
            log.error("\u51c6\u5165\u6cd5\u9662\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/refusedAppoint"}, method={RequestMethod.POST})
    @ApiOperation(value="\u62d2\u7edd\u6765\u8bbf")
    public APIResult refusedAppoint(@RequestBody @Valid AppointRefusedReqDTO reqDTO) {
        try {
            return APIResult.success((Object)this.visitorSystemService.refusedAppoint(reqDTO));
        }
        catch (Exception e) {
            log.error("\u62d2\u7edd\u6765\u8bbf\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/departmentList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u53d7\u8bbf\u90e8\u95e8")
    public APIResult departmentList() {
        try {
            return APIResult.success((Object)this.visitorSystemService.departmentList());
        }
        catch (Exception e) {
            log.error("\u53d7\u8bbf\u90e8\u95e8\u67e5\u8be2\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/judgeList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u53d7\u8bbf\u4eba\u5458")
    public APIResult judgeList(@RequestBody @Valid AppointOrgJudgeReqDTO dto) {
        try {
            return APIResult.success((Object)this.visitorSystemService.judgeList(dto));
        }
        catch (Exception e) {
            log.error("\u53d7\u8bbf\u4eba\u5458\u67e5\u8be2\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/judgeLogin"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6cd5\u5b98\u767b\u5f55")
    public APIResult judgeLogin(@RequestBody @Valid CommonUserLoginByMobileRequestDTO dto, HttpServletRequest request) {
        this.checkLoginError(dto.getMobilePhone(), dto.getLoginType().name());
        try {
            String password = Base64Utils.decodeBase64String((String)Base64Utils.decodeBase64String((String)dto.getPassword()));
            dto.setPassword(password);
            LoginInfoResDTO loginInfoResDTO = this.visitorSystemService.judgeLogin(dto.getMobilePhone(), null, dto.getPassword(), dto.getLoginType(), dto.getPublicKey(), request.getHeader("deviceId"));
            Boolean isStrong = CommonPasswordValidateUtil.checkRegexFormatNew((String)dto.getPassword(), (String)"\u5bc6\u7801\u5f3a\u5ea6\u4e0d\u591f", (String)"^(?![a-zA-Z]+$)(?![A-Z0-9]+$)(?![A-Z\\W_!@#$%^&*`~()-+=]+$)(?![a-z0-9]+$)(?![a-z\\W_!@#$%^&*`~()-+=]+$)(?![0-9\\W_!@#$%^&*`~()-+=]+$)(?![a-zA-Z0-9]+$)(?![a-zA-Z\\W_!@#$%^&*`~()-+=]+$)(?![a-z0-9\\W_!@#$%^&*`~()-+=]+$)(?![0-9A-Z\\W_!@#$%^&*`~()-+=]+$)[a-zA-Z0-9\\W_!@#$%^&*`~()-+=]{8,16}$");
            LoginTokenResponseDTO loginTokenResponseDTO = this.tokenGenerator.visitorSystemGenerateLoginToken(loginInfoResDTO, request.getHeader("cType"));
            loginTokenResponseDTO.setShowInnerCaseFlag(Boolean.valueOf(false));
            loginTokenResponseDTO.setLoginMediationRoomInfo(null);
            if (loginTokenResponseDTO != null) {
                this.checkLoginOk(dto.getMobilePhone(), dto.getLoginType().name());
            }
            loginTokenResponseDTO.setScreenLayout("");
            loginTokenResponseDTO.setIsStrong(isStrong);
            return APIResult.success((Object)loginTokenResponseDTO);
        }
        catch (Exception e) {
            log.error("\u6cd5\u5b98\u767b\u5f55\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/loginOut"}, method={RequestMethod.POST})
    @ApiOperation(value="\u9000\u51fa\u767b\u5f55")
    public void loginOut(HttpServletRequest request) {
        this.tokenGenerator.loginOut(request.getHeader("JWTToken"));
    }

    @RequestMapping(value={"/addJudgeUser"}, method={RequestMethod.POST})
    @ApiOperation(value="\u65b0\u589e\u6cd5\u5b98\u8d26\u6237")
    public APIResult addJudgeUser(@RequestBody @Valid AddVisitSystemJudgeRequestDTO dto) {
        try {
            return APIResult.success((Object)this.visitorSystemService.addJudgeUser(dto));
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u6cd5\u5b98\u8d26\u53f7\u65b0\u589e\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/judgeUserList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u8d26\u6237\u7ba1\u7406\u5217\u8868")
    public APIResult judgeUserList(@RequestBody @Valid VisitSystemJudgeUserReqDTO dto) {
        try {
            return APIResult.success((Object)this.visitorSystemService.judgeUserList(dto));
        }
        catch (Exception e) {
            log.error("\u8d26\u6237\u7ba1\u7406\u5217\u8868\u67e5\u8be2\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/updateJudgeUser"}, method={RequestMethod.POST})
    @ApiOperation(value="\u66f4\u65b0\u6cd5\u5b98\u8d26\u53f7\u72b6\u6001")
    public APIResult updateJudgeUser(@RequestBody @Valid VisitSystemJudgeStatusReqDTO dto) {
        try {
            return APIResult.success((Object)this.visitorSystemService.updateJudgeUser(dto));
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6cd5\u5b98\u8d26\u53f7\u72b6\u6001\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    @RequestMapping(value={"/judgeUserDetail"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u770b\u6cd5\u5b98\u8d26\u53f7\u8be6\u60c5")
    public APIResult judgeUserDetail(@RequestBody @Valid VisitSystemJudgeStatusReqDTO dto) {
        try {
            return APIResult.success((Object)this.visitorSystemService.judgeUserDetail(dto));
        }
        catch (Exception e) {
            log.error("\u67e5\u770b\u6cd5\u5b98\u8d26\u53f7\u8be6\u60c5\u5931\u8d25{}", (Throwable)e);
            return APIResult.failed((Exception)e);
        }
    }

    public void checkLoginError(String mobile, String loginType) {
        int count;
        String mobileBak = (String)this.redisService.get((RedisKey)RedisKeyEnums.USER_FIRST_LOGIN_ERROR, mobile + loginType);
        int n = count = this.redisService.get((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType) == null ? 0 : (Integer)this.redisService.get((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType);
        if (StringUtils.isNotEmpty((CharSequence)mobileBak) && count >= 5) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.POPUP_FIRST_ERROR_CODE, (String)"\u9519\u8bef\u8d85\u8fc75\u6b21\uff0c\u8bf712\u5c0f\u65f6\u540e\u91cd\u8bd5");
        }
    }

    public void checkLoginOk(String mobile, String loginType) {
        int count;
        String mobileBak = (String)this.redisService.get((RedisKey)RedisKeyEnums.USER_FIRST_LOGIN_ERROR, mobile + loginType);
        int n = count = this.redisService.get((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType) == null ? 0 : (Integer)this.redisService.get((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType);
        if (StringUtils.isNotEmpty((CharSequence)mobileBak) && count < 5) {
            this.loginErrorCountUtil.deleteUserLoginErrorCount(mobile, loginType);
        }
    }
}

