/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.schedule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.service.PeaceSmsService;
import com.beiming.odr.referee.api.VisitorSystemCaseApi;
import com.beiming.odr.referee.dto.responsedto.VisitorSystemMsgResDTO;
import com.beiming.odr.referee.enums.VisitSystemBusinessEnum;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class VisitorSystemScheduler {
    private static final Logger log = LoggerFactory.getLogger(VisitorSystemScheduler.class);
    @Resource
    private VisitorSystemCaseApi visitorSystemCaseApi;
    @Resource
    private PeaceSmsService peaceSmsService;
    @Resource
    private RedisTemplate redisTemplate;
    private static final String SENDMSGTIME = "visitor_system_send_msg_time";
    private static final String UPDATESTATUS = "visitor_system_update_status";

    public void sendMsgSchedule() {
        log.info("\u5f00\u59cb\u6267\u884c\u8bbf\u5ba2\u9884\u7ea6\u7cfb\u7edf\u53d1\u9001\u77ed\u4fe1\u5b9a\u65f6\u4efb\u52a1");
        String currentSeconds = "";
        long l = 0L;
        try {
            String currentTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
            l = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(currentTime).toInstant().atZone(ZoneId.systemDefault()).toEpochSecond();
            currentSeconds = String.valueOf(l);
        }
        catch (Exception e) {
            log.info("\u5b9a\u65f6\u4efb\u52a1\u4e2d\u5f53\u524d\u65e5\u671f\u8f6c\u6362\u5931\u8d25{}", (Throwable)e);
        }
        log.info("\u5f53\u524d\u65f6\u95f4\u6beb\u79d2\u6570{}", (Object)currentSeconds);
        AppNameContextHolder.setAppName((String)"donghufangkeyuyue");
        Boolean a = this.redisTemplate.hasKey((Object)SENDMSGTIME);
        Boolean b = this.redisTemplate.hasKey((Object)UPDATESTATUS);
        log.info("a is {}, b is {}", (Object)a, (Object)b);
        Object o = this.redisTemplate.opsForValue().get((Object)SENDMSGTIME);
        Object o1 = this.redisTemplate.opsForValue().get((Object)UPDATESTATUS);
        log.info("visitor_system_send_msg_time data is {}", o);
        log.info("visitor_system_udpate_status data is {}", o1);
        if (o != null) {
            JSONObject jsonObject = JSONObject.parseObject((String)String.valueOf(o));
            JSONObject temp = new JSONObject();
            log.info("jsonObject data is {}", (Object)jsonObject);
            Long finalL = l;
            jsonObject.forEach((k, v) -> {
                if (Long.valueOf(k) <= finalL) {
                    temp.put(k, v);
                }
            });
            log.info("sendMsgTime before now data is {}", (Object)temp);
            if (temp != null) {
                temp.forEach((k, v) -> {
                    JSONArray arr = (JSONArray)v;
                    ArrayList<String> caseUserIds = new ArrayList<String>();
                    for (Object o2 : arr) {
                        log.info("data o2 is {}", o2);
                        VisitorSystemMsgResDTO msgResDTO = (VisitorSystemMsgResDTO)JSONObject.parseObject((String)JSON.toJSONString(o2), VisitorSystemMsgResDTO.class);
                        log.info("msgResDTO is {}", (Object)msgResDTO);
                        String business = msgResDTO.getUserVisitingBusiness();
                        String address = "\u6b66\u6c49\u5e02\u6d2a\u5c71\u533a\u5357\u6e56\u5927\u9053216\u53f7";
                        String business1 = "";
                        for (VisitSystemBusinessEnum value : VisitSystemBusinessEnum.values()) {
                            String name = value.name();
                            if (!name.equals(business)) continue;
                            business1 = value.getName();
                        }
                        business1 = StringUtils.isNotBlank((CharSequence)business1) && business1.contains("\u4e1a\u52a1") ? business1.replace("\u4e1a\u52a1", "") : business1;
                        this.peaceSmsService.sendVisitorSystemSms(msgResDTO.getList(), msgResDTO.getVisitTime(), business1, address);
                        caseUserIds.add(msgResDTO.getCaseUserId());
                    }
                    DubboResult result1 = this.visitorSystemCaseApi.updateSendMsgStatus(caseUserIds);
                    AssertUtils.assertTrue((boolean)result1.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result1.getMessage());
                    jsonObject.remove(k);
                    log.info("remove data is {}", (Object)jsonObject);
                });
            }
            this.redisTemplate.opsForValue().set((Object)SENDMSGTIME, (Object)JSONObject.toJSONString((Object)jsonObject));
            if (o1 != null) {
                JSONObject jsonObject1 = JSONObject.parseObject((String)String.valueOf(o1));
                JSONObject temp1 = new JSONObject();
                log.info("jsonObject data is {}", (Object)jsonObject1);
                Long finalL1 = l;
                jsonObject1.forEach((k, v) -> {
                    if (Long.valueOf(k) <= finalL1) {
                        temp1.put(k, v);
                    }
                });
                if (temp1 != null) {
                    ArrayList ids = new ArrayList();
                    temp1.forEach((k, v) -> {
                        log.info("v is data {}", v);
                        List tempIds = (List)v;
                        ids.addAll(tempIds);
                        jsonObject1.remove(k);
                    });
                    DubboResult resultCaseIds = this.visitorSystemCaseApi.confirmedStatus(ids);
                    AssertUtils.assertTrue((boolean)resultCaseIds.isSuccess(), (ResultCode)ErrorCode.SELECT_PERSON_NULL, (String)resultCaseIds.getMessage());
                }
                this.redisTemplate.opsForValue().set((Object)UPDATESTATUS, (Object)JSONObject.toJSONString((Object)jsonObject1));
            }
        }
    }
}

