/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.odr.peace.domain.dto.requestdto.ClerkRecordGetRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ClerkRecordSaveRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SuspectReportRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ClerkRecordGetResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ClerkRecordSaveResponseDTO;
import com.beiming.odr.peace.service.UserService;
import com.beiming.odr.peace.service.client.ClerkRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="\u5fae\u5ead\u5ba1\u6587\u4e66\u7b14\u5f55controller", tags={"\u5fae\u5ead\u5ba1\u6587\u4e66\u7b14\u5f55controller"})
@RequestMapping(value={"/peace/clerkRecordMicro"})
public class ClerkRecordMicroController {
    @Resource
    ClerkRecordService clerkRecordServiceImpl;
    @Resource
    private UserService userService;

    @ApiOperation(value="\u83b7\u53d6\u7b14\u5f55\u63a5\u53e3", notes="\u83b7\u53d6\u7b14\u5f55\u63a5\u53e3", response=ClerkRecordGetResponseDTO.class)
    @RequestMapping(value={"/getClerkRecordMicro"}, method={RequestMethod.POST}, produces={"application/json"})
    public APIResult viewClerkRecord(@RequestBody @Valid ClerkRecordGetRequestDTO reqDTO) {
        this.userService.authentication(Long.valueOf(reqDTO.getMeetId()));
        reqDTO.setBizId(reqDTO.getMeetId());
        return APIResult.success((Object)this.clerkRecordServiceImpl.viewClerkRecord(reqDTO));
    }

    @ApiOperation(value="\u4fdd\u5b58\u7b14\u5f55\u63a5\u53e3", notes="\u4fdd\u5b58\u7b14\u5f55\u63a5\u53e3", response=ClerkRecordSaveResponseDTO.class)
    @RequestMapping(value={"/saveClerkRecordMicro"}, method={RequestMethod.POST}, produces={"application/json"})
    public APIResult saveClerkRecord(@RequestBody @Valid ClerkRecordSaveRequestDTO reqDTO) {
        reqDTO.setBizId(reqDTO.getMeetId());
        return APIResult.success((Object)this.clerkRecordServiceImpl.saveClerkRecordMicro(reqDTO));
    }

    @ApiOperation(value="\u53d1\u9001\u7b14\u5f55\u63a5\u53e3", notes="\u53d1\u9001\u7b14\u5f55\u63a5\u53e3", response=ClerkRecordSaveResponseDTO.class)
    @RequestMapping(value={"/sendClerkRecordMicro"}, method={RequestMethod.POST}, produces={"application/json"})
    public APIResult sendClerkRecord(@RequestBody @Valid ClerkRecordSaveRequestDTO reqDTO) {
        this.userService.authentication(Long.valueOf(reqDTO.getMeetId()));
        reqDTO.setBizId(reqDTO.getMeetId());
        return APIResult.success((Object)this.clerkRecordServiceImpl.sendClerkRecordMicro(reqDTO));
    }

    @ApiOperation(value="\u751f\u6210\u8d28\u8bc1\u62a5\u544a", notes="\u751f\u6210\u8d28\u8bc1\u62a5\u544a", response=ClerkRecordSaveResponseDTO.class)
    @RequestMapping(value={"/createSuspectReport"}, method={RequestMethod.POST})
    public APIResult createSuspectReport(@RequestBody SuspectReportRequestDTO reqDTO, HttpServletRequest request) {
        this.userService.authentication(Long.valueOf(reqDTO.getMeetId()));
        reqDTO.setBizId(reqDTO.getMeetId());
        String jwtToken = request.getHeader("Jwttoken");
        System.out.println("Jwttoken : " + jwtToken);
        this.clerkRecordServiceImpl.createSuspectReport(reqDTO, jwtToken);
        return APIResult.success((Object)"\u8d28\u8bc1\u62a5\u544a\u751f\u6210\u6210\u529f");
    }

    @ApiOperation(value="\u751f\u6210\u7535\u5b50\u9001\u8fbe\u56de\u8bc1", notes="\u751f\u6210\u7535\u5b50\u9001\u8fbe\u56de\u8bc1", response=ClerkRecordSaveResponseDTO.class)
    @RequestMapping(value={"/createElectronicReport"}, method={RequestMethod.POST})
    public APIResult createElectronicReport(@RequestBody SuspectReportRequestDTO reqDTO) {
        this.userService.authentication(reqDTO.getMeetId());
        reqDTO.setBizId(reqDTO.getMeetId());
        this.clerkRecordServiceImpl.createElectronicReport(reqDTO);
        return APIResult.success((Object)"\u7535\u5b50\u9001\u8fbe\u56de\u8bc1\u751f\u6210\u6210\u529f");
    }
}

