/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import cn.hutool.core.io.IoUtil;
import com.alibaba.fastjson.JSON;
import com.beiming.basic.storage.api.FileStorageApi;
import com.beiming.basic.storage.api.dto.response.FileInfoResponseDTO;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.odr.document.dto.requestdto.DeliveryRequestDTO;
import com.beiming.odr.document.dto.responsedto.ElectronicDeliveryResDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AreaRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DossierDeleteRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DossierRequestDTO;
import com.beiming.odr.peace.service.DocumentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Api(value="\u5377\u5b97\u6750\u6599\u548c\u7535\u5b50\u9001\u8fbe", tags={"\u5377\u5b97\u6750\u6599\u548c\u7535\u5b50\u9001\u8fbe"})
@RequestMapping(value={"/peace/dossier"})
public class DossierController {
    private static final Logger log = LoggerFactory.getLogger(DossierController.class);
    @Resource
    private DocumentService documentService;
    @Resource
    private FileStorageApi fileStorageApi;

    @RequestMapping(value={"/uploadDossier"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u4e0a\u4f20\u5377\u5b97\u6750\u6599", notes="\u4e0a\u4f20\u5377\u5b97\u6750\u6599")
    public APIResult uploadDossier(@RequestBody DossierDeleteRequestDTO dto) {
        log.info("uploadDossier enter \u4e0a\u4f20\u5377\u5b97\u6750\u6599: {}", (Object)JSON.toJSONString((Object)dto));
        dto.setUserName(JWTContextUtil.getCurrentUserName());
        dto.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        this.documentService.uploadDossier(dto);
        return APIResult.success((Object)"\u4e0a\u4f20\u6210\u529f");
    }

    @RequestMapping(value={"/dossierCatalogue"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u5377\u5b97\u6750\u6599\u76ee\u5f55", notes="\u5377\u5b97\u6750\u6599\u76ee\u5f55")
    public APIResult dossierCatalogue(@RequestBody DossierRequestDTO dto) {
        return APIResult.success((Object)this.documentService.dossierCatalogue(dto));
    }

    @RequestMapping(value={"/deleteDossier"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u5220\u9664\u5377\u5b97\u6750\u6599", notes="\u5220\u9664\u5377\u5b97\u6750\u6599")
    public APIResult deleteDossier(@RequestBody @Valid DossierDeleteRequestDTO dto) {
        dto.setUserName(JWTContextUtil.getCurrentUserName());
        this.documentService.deleteDossier(dto);
        return APIResult.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/updateDossierSort"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u4fee\u6539\u5377\u5b97\u6750\u6599\u6392\u5e8f", notes="\u4fee\u6539\u5377\u5b97\u6750\u6599\u6392\u5e8f")
    public APIResult updateDossierSort(@RequestBody @Valid DossierDeleteRequestDTO dto) {
        dto.setUserName(JWTContextUtil.getCurrentUserName());
        this.documentService.updateDossierSort(dto);
        return APIResult.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/preview"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="\u6587\u4ef6\u9884\u89c8-\u5377\u5b97\u6750\u6599", notes="\u6587\u4ef6\u9884\u89c8-\u5377\u5b97\u6750\u6599")
    public void xkPreview(HttpServletResponse response, Boolean isOnLine, String fileId) throws IOException {
        DubboResult fileInfoResult = this.fileStorageApi.getFileInfo(fileId);
        FileInfoResponseDTO fileInfo = (FileInfoResponseDTO)fileInfoResult.getData();
        if (fileInfo == null) {
            response.sendError(404, "File not found!");
            return;
        }
        ByteArrayInputStream in = IoUtil.toStream((byte[])fileInfo.getFileByte());
        String fileName = fileInfo.getFileName();
        String filePath = fileInfo.getFilePath();
        if (isOnLine.booleanValue()) {
            fileName = new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
            URL u = new URL("file:///" + filePath);
            response.setContentType(u.openConnection().getContentType());
            response.setHeader("Content-Disposition", "inline; filename=" + fileName);
        } else {
            fileName = new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
            response.reset();
            response.setContentType("application/x-msdownload");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        }
        StreamUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/signatureStatus"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u7535\u5b50\u9001\u8fbe\u6587\u4e66\u7b7e\u7f72\u60c5\u51b5", notes="\u7535\u5b50\u9001\u8fbe\u6587\u4e66\u7b7e\u7f72\u60c5\u51b5")
    public APIResult signatureStatus(@RequestBody @Valid DeliveryRequestDTO dto) {
        return APIResult.success((Object)this.documentService.signatureStatus(dto));
    }

    @RequestMapping(value={"searchAreasInfo"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u5730\u533a\u4fe1\u606f\u67e5\u8be2", notes="\u5730\u533a\u4fe1\u606f\u67e5\u8be2")
    public APIResult searchAreasInfo(@RequestBody @Valid AreaRequestDTO areaRequestDTO) {
        return APIResult.success((Object)this.documentService.searchAreasInfo(areaRequestDTO));
    }

    @RequestMapping(value={"/electronicDocInfo"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u7535\u5b50\u9001\u8fbe\u786e\u8ba4\u6587\u4e66\u4fe1\u606f", notes="\u83b7\u53d6\u7528\u6237\u7684\u7535\u5b50\u9001\u8fbe\u786e\u8ba4\u6587\u4e66\u4fe1\u606f")
    public APIResult electronicDocInfo(@RequestBody @Valid DeliveryRequestDTO dto) {
        dto.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        return APIResult.success((Object)this.documentService.electronicDocInfo(dto));
    }

    @RequestMapping(value={"/signatureConfirmInfo"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u7b7e\u540d\u786e\u8ba4\u4fe1\u606f\u67e5\u8be2", notes="\u7b7e\u7f72\u7535\u5b50\u9001\u8fbe\u786e\u8ba4\u6587\u4e66")
    public APIResult signatureConfirmInfo(@RequestBody @Valid ElectronicDeliveryResDTO dto) {
        dto.setCurrentUserId(JWTContextUtil.getCurrentUserId());
        return APIResult.success((Object)this.documentService.signatureConfirmInfo(dto));
    }

    @RequestMapping(value={"/confirmDocInfo"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u7b7e\u7f72\u7535\u5b50\u9001\u8fbe\u786e\u8ba4\u6587\u4e66", notes="\u7b7e\u7f72\u7535\u5b50\u9001\u8fbe\u786e\u8ba4\u6587\u4e66")
    public APIResult confirmDocInfo(@RequestBody @Valid ElectronicDeliveryResDTO dto) {
        dto.setCurrentUserId(JWTContextUtil.getCurrentUserId());
        return APIResult.success((Object)this.documentService.confirmDocInfo(dto));
    }
}

