/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.odr.peace.domain.dto.PreviewUserLoginInfoDTO;
import com.beiming.odr.peace.domain.dto.RedisMediationRoomInfoDTO;
import com.beiming.odr.peace.domain.dto.requestdto.PreviewUserLoginRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UserLoginNotPasswordRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.LoginTokenResponseDTO;
import com.beiming.odr.peace.security.TokenGenerator;
import com.beiming.odr.peace.service.UserService;
import com.beiming.odr.peace.service.demonstration.PreviewService;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import com.beiming.odr.user.api.common.enums.UserLoginNotPasswordEnum;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/peace/preview"})
@Api(value="\u9884\u6f14controller", tags={"\u9884\u6f14controller"})
public class PreviewController {
    @Resource
    private TokenGenerator tokenGenerator;
    @Resource
    private PreviewService previewService;
    @Resource
    private UserService userService;

    @ApiOperation(value="\u521b\u5efa\u4f1a\u8bae", notes="\u521b\u5efa\u4f1a\u8bae")
    @RequestMapping(value={"/createMeeting"}, method={RequestMethod.POST})
    public APIResult createMeeting() {
        return APIResult.success((Object)this.previewService.createMeeting());
    }

    @ApiOperation(value="\u7528\u6237\u767b\u5f55", notes="\u7528\u6237\u767b\u5f55")
    @RequestMapping(value={"/userLogin"}, method={RequestMethod.POST})
    public LoginTokenResponseDTO userLogin(HttpServletRequest request, @RequestBody @Valid PreviewUserLoginRequestDTO dto) {
        PreviewUserLoginInfoDTO preview = this.previewService.userLogin(dto.getNickname(), dto.getCode());
        RedisMediationRoomInfoDTO resultObj = preview.getMediationRoomInfo();
        UserLoginNotPasswordRequestDTO requestDTO = new UserLoginNotPasswordRequestDTO();
        requestDTO.setMobilePhone(resultObj.getMobilePhone());
        requestDTO.setCode(preview.getVerificationCode());
        requestDTO.setPersonType(PersonTypeEnum.COMMON);
        LoginInfoResDTO loginInfoResDTO = this.userService.userLoginNotPassword(requestDTO, UserLoginNotPasswordEnum.LOGIN_BY_CODE);
        return this.tokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"), resultObj);
    }

    @ApiOperation(value="\u5927\u5c4f\u89c6\u9891\u5217\u8868", notes="\u5927\u5c4f\u89c6\u9891\u5217\u8868")
    @RequestMapping(value={"/meetingList"}, method={RequestMethod.POST})
    public APIResult meetingList() {
        return APIResult.success((Object)this.previewService.meetingList());
    }
}

