/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.controller;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.utils.SM4ECBAndMACUtils;
import com.beiming.odr.peace.common.utils.sm4.hainanrequestdto.SM4ECBDecrptyRequestDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanrequestdto.SM4ECBEncryptRequestDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanrequestdto.SM4MACDecryptRequestDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanrequestdto.SM4MACEncryptRequestDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanresponsedto.SM4ECBDecryptResponseDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanresponsedto.SM4ECBEncryptResponseDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanresponsedto.SM4MACDecryptResponseDTO;
import com.beiming.odr.peace.common.utils.sm4.hainanresponsedto.SM4MACEncryptResponseDTO;
import com.beiming.odr.peace.domain.dto.requestdto.TestSm4EncryptRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.TestSm4MacRequestDTO;
import com.beiming.odr.peace.service.MediationMeetingService;
import com.beiming.odr.peace.service.UserService;
import com.beiming.odr.referee.api.MediationMeetingRoomApi;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomResponseDTO;
import com.beiming.odr.user.api.UserServiceApi;
import com.beiming.odr.user.api.dto.responsedto.CommonUserSearchResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserRoleRelationResDTO;
import io.swagger.annotations.ApiOperation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/peace/hainanSm4"})
public class TestHainanSM4Controller {
    private static final Logger log = LoggerFactory.getLogger(TestHainanSM4Controller.class);
    @Value(value="${hainanodr.sm4.sm4keycode}")
    private String sm4KeyCode;
    @Value(value="${hainanodr.sm4.mackeycode}")
    private String mackeycode;
    @Resource
    private UserService userService;
    @Resource
    private MediationMeetingService mediationMeetingService;
    @Resource
    private MediationMeetingRoomApi mediationMeetingRoomApi;
    @Resource
    private UserServiceApi userServiceApi;

    @RequestMapping(value={"/sm4Encrypt"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4SM4\u52a0\u5bc6", notes="\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4SM4\u52a0\u5bc6")
    public APIResult testSm4Encrypt(@RequestBody TestSm4EncryptRequestDTO dto) {
        SM4ECBEncryptRequestDTO sm4ECBEncryptRequestDTO = new SM4ECBEncryptRequestDTO();
        sm4ECBEncryptRequestDTO.setKeyCode(this.sm4KeyCode);
        sm4ECBEncryptRequestDTO.setAlgorithmParam("SM4/ECB/PKCS7Padding");
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)dto.getName())) {
            jsonObject.put(dto.getName(), (Object)Base64.getEncoder().encodeToString(dto.getName().getBytes(StandardCharsets.UTF_8)));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgName())) {
            jsonObject.put(dto.getOrgName(), (Object)Base64.getEncoder().encodeToString(dto.getOrgName().getBytes(StandardCharsets.UTF_8)));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getCauseName())) {
            jsonObject.put(dto.getCauseName(), (Object)Base64.getEncoder().encodeToString(dto.getCauseName().getBytes(StandardCharsets.UTF_8)));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getIdCard())) {
            jsonObject.put(dto.getIdCard(), (Object)Base64.getEncoder().encodeToString(dto.getIdCard().getBytes(StandardCharsets.UTF_8)));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getMobilePhone())) {
            jsonObject.put(dto.getMobilePhone(), (Object)Base64.getEncoder().encodeToString(dto.getMobilePhone().getBytes(StandardCharsets.UTF_8)));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getRoleCode())) {
            jsonObject.put(dto.getRoleCode(), (Object)Base64.getEncoder().encodeToString(dto.getMobilePhone().getBytes(StandardCharsets.UTF_8)));
        }
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(dto.getUserId()))) {
            jsonObject.put(String.valueOf(dto.getUserId()), (Object)Base64.getEncoder().encodeToString(String.valueOf(dto.getUserId()).getBytes(StandardCharsets.UTF_8)));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getUserName())) {
            jsonObject.put(dto.getUserName(), (Object)Base64.getEncoder().encodeToString(dto.getUserName().getBytes(StandardCharsets.UTF_8)));
        }
        sm4ECBEncryptRequestDTO.setData(jsonObject);
        log.info("\u6d4b\u8bd5\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSONObject.toJSONString((Object)sm4ECBEncryptRequestDTO));
        try {
            SM4ECBEncryptResponseDTO sm4ECBEncryptResponseDTO = SM4ECBAndMACUtils.sm4ECBEncrypt((SM4ECBEncryptRequestDTO)sm4ECBEncryptRequestDTO);
            return APIResult.success((Object)sm4ECBEncryptResponseDTO);
        }
        catch (Exception e) {
            log.info("\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4SM4\u52a0\u5bc6\u62a5\u9519{}", (Object)e.getMessage());
            return APIResult.success();
        }
    }

    @RequestMapping(value={"/sm4Decrypt"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4SM4\u89e3\u5bc6", notes="\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4SM4\u89e3\u5bc6")
    public APIResult testSm4Decrypt(@RequestBody TestSm4EncryptRequestDTO dto) {
        SM4ECBDecrptyRequestDTO sm4ECBDecrptyRequestDTO = new SM4ECBDecrptyRequestDTO();
        sm4ECBDecrptyRequestDTO.setKeyCode(this.sm4KeyCode);
        sm4ECBDecrptyRequestDTO.setAlgorithmParam("SM4/ECB/PKCS7Padding");
        sm4ECBDecrptyRequestDTO.setIv("");
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)dto.getCauseName())) {
            jsonObject.put(dto.getCauseName(), (Object)dto.getCauseNameEncrypt());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getIdCard())) {
            jsonObject.put(dto.getIdCard(), (Object)dto.getCauseNameEncrypt());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getMobilePhone())) {
            jsonObject.put(dto.getMobilePhone(), (Object)dto.getMobilePhoneEncrypt());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getName())) {
            jsonObject.put(dto.getName(), (Object)dto.getNameEncrypt());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgName())) {
            jsonObject.put(dto.getOrgName(), (Object)dto.getOrgNameEncrypt());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getRoleCode())) {
            jsonObject.put(dto.getRoleCode(), (Object)dto.getRoleCodeEncrypt());
        }
        if (Objects.nonNull(dto.getUserId())) {
            jsonObject.put(String.valueOf(dto.getUserId()), (Object)dto.getUserIdEncrypt());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getUserName())) {
            jsonObject.put(dto.getUserName(), (Object)dto.getUserNameEncrypt());
        }
        sm4ECBDecrptyRequestDTO.setEncData(jsonObject);
        log.info("\u6d4b\u8bd5\u89e3\u5bc6\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)sm4ECBDecrptyRequestDTO));
        try {
            SM4ECBDecryptResponseDTO sm4ECBDecryptResponseDTO = SM4ECBAndMACUtils.sm4ECBDecrypt((SM4ECBDecrptyRequestDTO)sm4ECBDecrptyRequestDTO);
            return APIResult.success((Object)sm4ECBDecryptResponseDTO);
        }
        catch (Exception e) {
            log.info("\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4SM4\u89e3\u5bc6\u62a5\u9519{}", (Object)e.getMessage());
            return APIResult.success();
        }
    }

    @RequestMapping(value={"/macEncrypt"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4\u83b7\u53d6mac\u503c", notes="\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4\u83b7\u53d6mac\u503c")
    public APIResult testMacEncrypt(@RequestBody TestSm4MacRequestDTO dto) {
        SM4MACEncryptRequestDTO sm4MACEncryptRequestDTO = new SM4MACEncryptRequestDTO();
        sm4MACEncryptRequestDTO.setKeyCode(this.mackeycode);
        sm4MACEncryptRequestDTO.setAlgorithmParam("SM4_MAC");
        sm4MACEncryptRequestDTO.setData(dto.getDataBase64());
        try {
            SM4MACEncryptResponseDTO sm4MACEncryptResponseDTO = SM4ECBAndMACUtils.sm4MACEncrypt((SM4MACEncryptRequestDTO)sm4MACEncryptRequestDTO);
            return APIResult.success((Object)sm4MACEncryptResponseDTO);
        }
        catch (Exception e) {
            log.info("\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4\u83b7\u53d6mac\u503c\u62a5\u9519{}", (Object)e.getMessage());
            return APIResult.success();
        }
    }

    @RequestMapping(value={"/macVerify"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4\u9a8c\u8bc1mac\u503c", notes="\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4\u9a8c\u8bc1mac\u503c")
    public APIResult testMacVerify(@RequestBody TestSm4MacRequestDTO dto) {
        SM4MACDecryptRequestDTO sm4MACDecryptRequestDTO = new SM4MACDecryptRequestDTO();
        sm4MACDecryptRequestDTO.setKeyCode(this.mackeycode);
        sm4MACDecryptRequestDTO.setAlgorithmParam("SM4_MAC");
        sm4MACDecryptRequestDTO.setIv(dto.getIv());
        sm4MACDecryptRequestDTO.setMac(dto.getMac());
        sm4MACDecryptRequestDTO.setData(dto.getDataBase64());
        try {
            SM4MACDecryptResponseDTO sm4MACDecryptResponseDTO = SM4ECBAndMACUtils.sm4MACDecrypt((SM4MACDecryptRequestDTO)sm4MACDecryptRequestDTO);
            return APIResult.success((Object)sm4MACDecryptResponseDTO);
        }
        catch (Exception e) {
            log.info("\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4\u9a8c\u8bc1mac\u503c\u62a5\u9519{}", (Object)e.getMessage());
            return APIResult.success();
        }
    }

    @RequestMapping(value={"/exDataEncrypt"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5b58\u91cf\u6570\u636eSM4\u52a0\u5bc6", notes="\u5b58\u91cf\u6570\u636eSM4\u52a0\u5bc6")
    public APIResult exDataEncrypt() {
        this.ub();
        this.urr();
        this.mmr();
        return APIResult.success();
    }

    private void mmr() {
        DubboResult results = this.mediationMeetingRoomApi.getAllMediationMeetingRoomForEncrypt();
        for (MediationMeetingRoomResponseDTO mmr : (ArrayList)results.getData()) {
            SM4ECBEncryptRequestDTO sm4ECBEncryptRequestDTO = new SM4ECBEncryptRequestDTO();
            sm4ECBEncryptRequestDTO.setKeyCode(this.sm4KeyCode);
            sm4ECBEncryptRequestDTO.setAlgorithmParam("SM4/ECB/PKCS7Padding");
            JSONObject reqJsonObject = new JSONObject();
            if (StringUtils.isNotBlank((CharSequence)mmr.getName())) {
                reqJsonObject.put(mmr.getName(), (Object)Base64.getEncoder().encodeToString(mmr.getName().getBytes(StandardCharsets.UTF_8)));
            }
            if (StringUtils.isNotBlank((CharSequence)mmr.getOrgName())) {
                reqJsonObject.put(mmr.getOrgName(), (Object)Base64.getEncoder().encodeToString(mmr.getOrgName().getBytes(StandardCharsets.UTF_8)));
            }
            if (StringUtils.isNotBlank((CharSequence)mmr.getCauseName())) {
                reqJsonObject.put(mmr.getCauseName(), (Object)Base64.getEncoder().encodeToString(mmr.getCauseName().getBytes(StandardCharsets.UTF_8)));
            }
            sm4ECBEncryptRequestDTO.setData(reqJsonObject);
            log.info("\u6d4b\u8bd5\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSONObject.toJSONString((Object)sm4ECBEncryptRequestDTO));
            SM4ECBEncryptResponseDTO sm4ECBEncryptResponseDTO = new SM4ECBEncryptResponseDTO();
            try {
                sm4ECBEncryptResponseDTO = SM4ECBAndMACUtils.sm4ECBEncrypt((SM4ECBEncryptRequestDTO)sm4ECBEncryptRequestDTO);
            }
            catch (Exception e) {
                log.error("\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4SM4\u52a0\u5bc6\u62a5\u9519{}", (Object)e.getMessage());
            }
            Map map = TestHainanSM4Controller.toMap((JSONObject)sm4ECBEncryptResponseDTO.getData().getEncData());
            String encName = map.get(mmr.getName()).toString();
            String encOrgName = map.get(mmr.getOrgName()).toString();
            String encCauseName = map.get(mmr.getCauseName()).toString();
            String id = String.valueOf(mmr.getId());
            SM4MACEncryptRequestDTO sm4MACEncryptRequestDTO = new SM4MACEncryptRequestDTO();
            sm4MACEncryptRequestDTO.setKeyCode(this.mackeycode);
            sm4MACEncryptRequestDTO.setAlgorithmParam("SM4_MAC");
            sm4MACEncryptRequestDTO.setData(mmr.getName().concat(mmr.getOrgName()).concat(mmr.getCauseName()));
            SM4MACEncryptResponseDTO sm4MACEncryptResponseDTO = new SM4MACEncryptResponseDTO();
            try {
                sm4MACEncryptResponseDTO = SM4ECBAndMACUtils.sm4MACEncrypt((SM4MACEncryptRequestDTO)sm4MACEncryptRequestDTO);
            }
            catch (Exception e) {
                log.error("\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4\u83b7\u53d6mac\u503c\u62a5\u9519{}", (Object)e.getMessage());
            }
            String mac = sm4MACEncryptResponseDTO.getData().getMac();
            String iv = sm4ECBEncryptResponseDTO.getData().getIv();
            try {
                this.mediationMeetingRoomApi.updEncryptForMrr(id, encName, encOrgName, encCauseName, iv, mac);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("updEncryptForMrr\u62a5\u9519{}", (Object)e.getMessage());
            }
        }
    }

    private void urr() {
        List allUserRoleForEncrypt = this.userService.getAllUserRoleForEncrypt();
        for (UserRoleRelationResDTO urr : allUserRoleForEncrypt) {
            SM4ECBEncryptRequestDTO sm4ECBEncryptRequestDTO = new SM4ECBEncryptRequestDTO();
            sm4ECBEncryptRequestDTO.setKeyCode(this.sm4KeyCode);
            sm4ECBEncryptRequestDTO.setAlgorithmParam("SM4/ECB/PKCS7Padding");
            JSONObject reqJsonObject = new JSONObject();
            String uid = String.valueOf(urr.getUserId());
            if (StringUtils.isNotBlank((CharSequence)uid)) {
                reqJsonObject.put(uid, (Object)Base64.getEncoder().encodeToString(uid.getBytes(StandardCharsets.UTF_8)));
            }
            if (StringUtils.isNotBlank((CharSequence)urr.getRoleCode())) {
                reqJsonObject.put(urr.getRoleCode(), (Object)Base64.getEncoder().encodeToString(urr.getRoleCode().getBytes(StandardCharsets.UTF_8)));
            }
            sm4ECBEncryptRequestDTO.setData(reqJsonObject);
            log.info("\u6d4b\u8bd5\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSONObject.toJSONString((Object)sm4ECBEncryptRequestDTO));
            SM4ECBEncryptResponseDTO sm4ECBEncryptResponseDTO = new SM4ECBEncryptResponseDTO();
            try {
                sm4ECBEncryptResponseDTO = SM4ECBAndMACUtils.sm4ECBEncrypt((SM4ECBEncryptRequestDTO)sm4ECBEncryptRequestDTO);
            }
            catch (Exception e) {
                log.error("\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4SM4\u52a0\u5bc6\u62a5\u9519{}", (Object)e.getMessage());
            }
            Map map = TestHainanSM4Controller.toMap((JSONObject)sm4ECBEncryptResponseDTO.getData().getEncData());
            String encUid = map.get(String.valueOf(urr.getUserId())).toString();
            String encRoleCode = map.get(urr.getRoleCode()).toString();
            String id = String.valueOf(urr.getUserRoleRelationId());
            SM4MACEncryptRequestDTO sm4MACEncryptRequestDTO = new SM4MACEncryptRequestDTO();
            sm4MACEncryptRequestDTO.setKeyCode(this.mackeycode);
            sm4MACEncryptRequestDTO.setAlgorithmParam("SM4_MAC");
            sm4MACEncryptRequestDTO.setData(String.valueOf(urr.getUserId()).concat(urr.getRoleCode()));
            SM4MACEncryptResponseDTO sm4MACEncryptResponseDTO = new SM4MACEncryptResponseDTO();
            try {
                sm4MACEncryptResponseDTO = SM4ECBAndMACUtils.sm4MACEncrypt((SM4MACEncryptRequestDTO)sm4MACEncryptRequestDTO);
            }
            catch (Exception e) {
                log.info("\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4\u83b7\u53d6mac\u503c\u62a5\u9519{}", (Object)e.getMessage());
            }
            String mac = sm4MACEncryptResponseDTO.getData().getMac();
            String iv = sm4ECBEncryptResponseDTO.getData().getIv();
            try {
                this.userServiceApi.updEncryptForUrr(id, encUid, encRoleCode, iv, mac);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("updEncryptForUrr\u62a5\u9519{}", (Object)e.getMessage());
            }
        }
    }

    private void ub() {
        List allUserForEncrypt = this.userService.getAllUserForEncrypt();
        for (CommonUserSearchResDTO ub : allUserForEncrypt) {
            SM4ECBEncryptRequestDTO sm4ECBEncryptRequestDTO = new SM4ECBEncryptRequestDTO();
            sm4ECBEncryptRequestDTO.setKeyCode(this.sm4KeyCode);
            sm4ECBEncryptRequestDTO.setAlgorithmParam("SM4/ECB/PKCS7Padding");
            JSONObject reqJsonObject = new JSONObject();
            if (StringUtils.isNotBlank((CharSequence)ub.getUserName())) {
                reqJsonObject.put(ub.getUserName(), (Object)Base64.getEncoder().encodeToString(ub.getUserName().getBytes(StandardCharsets.UTF_8)));
            }
            if (StringUtils.isNotBlank((CharSequence)ub.getIdCard())) {
                reqJsonObject.put(ub.getIdCard(), (Object)Base64.getEncoder().encodeToString(ub.getIdCard().getBytes(StandardCharsets.UTF_8)));
            }
            if (StringUtils.isNotBlank((CharSequence)ub.getMobilePhone())) {
                reqJsonObject.put(ub.getMobilePhone(), (Object)Base64.getEncoder().encodeToString(ub.getMobilePhone().getBytes(StandardCharsets.UTF_8)));
            }
            sm4ECBEncryptRequestDTO.setData(reqJsonObject);
            log.info("\u6d4b\u8bd5\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSONObject.toJSONString((Object)sm4ECBEncryptRequestDTO));
            SM4ECBEncryptResponseDTO sm4ECBEncryptResponseDTO = new SM4ECBEncryptResponseDTO();
            try {
                sm4ECBEncryptResponseDTO = SM4ECBAndMACUtils.sm4ECBEncrypt((SM4ECBEncryptRequestDTO)sm4ECBEncryptRequestDTO);
            }
            catch (Exception e) {
                log.error("\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4SM4\u52a0\u5bc6\u62a5\u9519{}", (Object)e.getMessage());
            }
            Map map = TestHainanSM4Controller.toMap((JSONObject)sm4ECBEncryptResponseDTO.getData().getEncData());
            String encUserName = map.get(ub.getUserName()).toString();
            String encIdCard = map.get(ub.getIdCard()).toString();
            String encMobile = map.get(ub.getMobilePhone()).toString();
            String id = String.valueOf(ub.getUserId());
            SM4MACEncryptRequestDTO sm4MACEncryptRequestDTO = new SM4MACEncryptRequestDTO();
            sm4MACEncryptRequestDTO.setKeyCode(this.mackeycode);
            sm4MACEncryptRequestDTO.setAlgorithmParam("SM4_MAC");
            sm4MACEncryptRequestDTO.setData(ub.getUserName().concat(ub.getIdCard()).concat(ub.getMobilePhone()));
            SM4MACEncryptResponseDTO sm4MACEncryptResponseDTO = new SM4MACEncryptResponseDTO();
            try {
                sm4MACEncryptResponseDTO = SM4ECBAndMACUtils.sm4MACEncrypt((SM4MACEncryptRequestDTO)sm4MACEncryptRequestDTO);
            }
            catch (Exception e) {
                log.info("\u6d4b\u8bd5\u6d77\u5357\u4e92\u8054\u7f51\u5f00\u5eadODR\u5bc6\u8bc4\u83b7\u53d6mac\u503c\u62a5\u9519{}", (Object)e.getMessage());
            }
            String mac = sm4MACEncryptResponseDTO.getData().getMac();
            String iv = sm4ECBEncryptResponseDTO.getData().getIv();
            try {
                this.userServiceApi.updEncryptForUb(id, encUserName, encIdCard, encMobile, iv, mac);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("updEncryptForUb\u62a5\u9519{}", (Object)e.getMessage());
            }
        }
    }

    public static Map<String, Object> toMap(JSONObject jsonObj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : jsonObj.keySet()) {
            map.put(key, jsonObj.get((Object)key));
        }
        return map;
    }
}

